/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.android.internal.R;

public abstract class AbsSpinner
extends AdapterView<SpinnerAdapter> {
    SpinnerAdapter mAdapter;
    private DataSetObserver mDataSetObserver;
    int mHeightMeasureSpec;
    final RecycleBin mRecycler;
    int mSelectionBottomPadding = 0;
    int mSelectionLeftPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionTopPadding = 0;
    final Rect mSpinnerPadding = new Rect();
    private Rect mTouchFrame;
    int mWidthMeasureSpec;

    public AbsSpinner(Context context) {
        super(context);
        this.mRecycler = new RecycleBin();
        this.initAbsSpinner();
    }

    public AbsSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AbsSpinner(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AbsSpinner(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mRecycler = new RecycleBin();
        this.initAbsSpinner();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AbsSpinner, n, n2);
        CharSequence[] charSequenceArray = typedArray.getTextArray(0);
        if (charSequenceArray != null) {
            ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(context, 17367048, charSequenceArray);
            arrayAdapter.setDropDownViewResource(0x1090009);
            this.setAdapter(arrayAdapter);
        }
        typedArray.recycle();
    }

    private void initAbsSpinner() {
        this.setFocusable(true);
        this.setWillNotDraw(false);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    @Override
    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    int getChildHeight(View view) {
        return view.getMeasuredHeight();
    }

    int getChildWidth(View view) {
        return view.getMeasuredWidth();
    }

    @Override
    public int getCount() {
        return this.mItemCount;
    }

    @Override
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    abstract void layout(int var1, boolean var2);

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(AbsSpinner.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AbsSpinner.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode(n);
        Rect rect = this.mSpinnerPadding;
        int n4 = this.mPaddingLeft > this.mSelectionLeftPadding ? this.mPaddingLeft : this.mSelectionLeftPadding;
        rect.left = n4;
        Rect rect2 = this.mSpinnerPadding;
        int n5 = this.mPaddingTop > this.mSelectionTopPadding ? this.mPaddingTop : this.mSelectionTopPadding;
        rect2.top = n5;
        Rect rect3 = this.mSpinnerPadding;
        int n6 = this.mPaddingRight > this.mSelectionRightPadding ? this.mPaddingRight : this.mSelectionRightPadding;
        rect3.right = n6;
        Rect rect4 = this.mSpinnerPadding;
        int n7 = this.mPaddingBottom > this.mSelectionBottomPadding ? this.mPaddingBottom : this.mSelectionBottomPadding;
        rect4.bottom = n7;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        boolean bl = true;
        int n8 = this.getSelectedItemPosition();
        int n9 = 0;
        int n10 = 0;
        if (n8 >= 0) {
            SpinnerAdapter spinnerAdapter = this.mAdapter;
            n9 = 0;
            n10 = 0;
            if (spinnerAdapter != null) {
                int n11 = this.mAdapter.getCount();
                n9 = 0;
                n10 = 0;
                if (n8 < n11) {
                    View view = this.mRecycler.get(n8);
                    if (view == null && (view = this.mAdapter.getView(n8, null, this)).getImportantForAccessibility() == 0) {
                        view.setImportantForAccessibility(1);
                    }
                    n9 = 0;
                    n10 = 0;
                    if (view != null) {
                        this.mRecycler.put(n8, view);
                        if (view.getLayoutParams() == null) {
                            this.mBlockLayoutRequests = true;
                            view.setLayoutParams(this.generateDefaultLayoutParams());
                            this.mBlockLayoutRequests = false;
                        }
                        this.measureChild(view, n, n2);
                        n9 = this.getChildHeight(view) + this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
                        n10 = this.getChildWidth(view) + this.mSpinnerPadding.left + this.mSpinnerPadding.right;
                        bl = false;
                    }
                }
            }
        }
        if (bl) {
            n9 = this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
            if (n3 == 0) {
                n10 = this.mSpinnerPadding.left + this.mSpinnerPadding.right;
            }
        }
        int n12 = Math.max(n9, this.getSuggestedMinimumHeight());
        int n13 = Math.max(n10, this.getSuggestedMinimumWidth());
        int n14 = AbsSpinner.resolveSizeAndState(n12, n2, 0);
        this.setMeasuredDimension(AbsSpinner.resolveSizeAndState(n13, n, 0), n14);
        this.mHeightMeasureSpec = n2;
        this.mWidthMeasureSpec = n;
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.selectedId >= 0L) {
            this.mDataChanged = true;
            this.mNeedSync = true;
            this.mSyncRowId = savedState.selectedId;
            this.mSyncPosition = savedState.position;
            this.mSyncMode = 0;
            this.requestLayout();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.selectedId = this.getSelectedItemId();
        if (savedState.selectedId >= 0L) {
            savedState.position = this.getSelectedItemPosition();
            return savedState;
        }
        savedState.position = -1;
        return savedState;
    }

    public int pointToPosition(int n, int n2) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            rect = this.mTouchFrame = new Rect();
        }
        for (int i = -1 + this.getChildCount(); i >= 0; --i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0) continue;
            view.getHitRect(rect);
            if (!rect.contains(n, n2)) continue;
            return i + this.mFirstPosition;
        }
        return -1;
    }

    void recycleAllViews() {
        int n = this.getChildCount();
        RecycleBin recycleBin = this.mRecycler;
        int n2 = this.mFirstPosition;
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            recycleBin.put(n2 + i, view);
        }
    }

    @Override
    public void requestLayout() {
        if (!this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.removeAllViewsInLayout();
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        int n = -1;
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.resetList();
        }
        this.mAdapter = spinnerAdapter;
        this.mOldSelectedPosition = n;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            if (this.mItemCount > 0) {
                n = 0;
            }
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.checkFocus();
            this.resetList();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    @Override
    public void setSelection(int n) {
        this.setNextSelectedPositionInt(n);
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelection(int n, boolean bl) {
        boolean bl2 = bl && this.mFirstPosition <= n && n <= -1 + (this.mFirstPosition + this.getChildCount());
        this.setSelectionInt(n, bl2);
    }

    void setSelectionInt(int n, boolean bl) {
        if (n != this.mOldSelectedPosition) {
            this.mBlockLayoutRequests = true;
            int n2 = n - this.mSelectedPosition;
            this.setNextSelectedPositionInt(n);
            this.layout(n2, bl);
            this.mBlockLayoutRequests = false;
        }
    }

    class RecycleBin {
        private final SparseArray<View> mScrapHeap = new SparseArray();

        RecycleBin() {
        }

        void clear() {
            SparseArray<View> sparseArray = this.mScrapHeap;
            int n = sparseArray.size();
            for (int i = 0; i < n; ++i) {
                View view = sparseArray.valueAt(i);
                if (view == null) continue;
                AbsSpinner.this.removeDetachedView(view, true);
            }
            sparseArray.clear();
        }

        View get(int n) {
            View view = this.mScrapHeap.get(n);
            if (view != null) {
                this.mScrapHeap.delete(n);
            }
            return view;
        }

        public void put(int n, View view) {
            this.mScrapHeap.put(n, view);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int position;
        long selectedId;

        SavedState(Parcel parcel) {
            super(parcel);
            this.selectedId = parcel.readLong();
            this.position = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " selectedId=" + this.selectedId + " position=" + this.position + "}";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeLong(this.selectedId);
            parcel.writeInt(this.position);
        }
    }
}

