/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.widget.CalendarView;
import android.widget.DatePicker;
import android.widget.DatePickerController;
import android.widget.DayPickerView;
import android.widget.LinearLayout;
import android.widget.OnDateChangedListener;
import android.widget.TextView;
import android.widget.YearPickerView;
import com.android.internal.R;
import com.android.internal.widget.AccessibleDateAnimator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

class DatePickerCalendarDelegate
extends DatePicker.AbstractDatePickerDelegate
implements View.OnClickListener,
DatePickerController {
    private static final int ANIMATION_DURATION = 300;
    private static final int DAY_INDEX = 1;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int MONTH_INDEX = 0;
    private static final int UNINITIALIZED = -1;
    private static final int USE_LOCALE = 0;
    private static final int YEAR_INDEX = 2;
    private static final int YEAR_VIEW = 1;
    private AccessibleDateAnimator mAnimator;
    private Calendar mCurrentDate;
    private int mCurrentView = -1;
    private DatePicker.OnDateChangedListener mDateChangedListener;
    private SimpleDateFormat mDayFormat;
    private TextView mDayOfWeekView;
    private String mDayPickerDescription;
    private DayPickerView mDayPickerView;
    private int mFirstDayOfWeek = 0;
    private TextView mHeaderDayOfMonthTextView;
    private TextView mHeaderMonthTextView;
    private TextView mHeaderYearTextView;
    private boolean mIsEnabled = true;
    private HashSet<OnDateChangedListener> mListeners;
    private Calendar mMaxDate;
    private Calendar mMinDate;
    private LinearLayout mMonthAndDayLayout;
    private LinearLayout mMonthDayYearLayout;
    private String mSelectDay;
    private String mSelectYear;
    private Calendar mTempDate;
    private SimpleDateFormat mYearFormat = new SimpleDateFormat("y", Locale.getDefault());
    private String mYearPickerDescription;
    private YearPickerView mYearPickerView;

    public DatePickerCalendarDelegate(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(datePicker, context);
        DayPickerView dayPickerView;
        this.mDayFormat = new SimpleDateFormat("d", Locale.getDefault());
        this.mListeners = new HashSet();
        Locale locale = Locale.getDefault();
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mTempDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
        this.mMinDate.set(1900, 1, 1);
        this.mMaxDate.set(2100, 12, 31);
        Resources resources = this.mDelegator.getResources();
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.DatePicker, n, n2);
        View view = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(typedArray.getResourceId(17, 17367132), null);
        this.mDelegator.addView(view);
        this.mDayOfWeekView = (TextView)view.findViewById(16909103);
        LinearLayout linearLayout = (LinearLayout)view.findViewById(16909102);
        this.mMonthDayYearLayout = (LinearLayout)view.findViewById(16909104);
        this.mMonthAndDayLayout = (LinearLayout)view.findViewById(16909105);
        this.mMonthAndDayLayout.setOnClickListener(this);
        this.mHeaderMonthTextView = (TextView)view.findViewById(16909106);
        this.mHeaderDayOfMonthTextView = (TextView)view.findViewById(16909107);
        this.mHeaderYearTextView = (TextView)view.findViewById(16909108);
        this.mHeaderYearTextView.setOnClickListener(this);
        int n3 = this.mHeaderYearTextView.getHighlightColor();
        int n4 = typedArray.getResourceId(9, -1);
        if (n4 != -1) {
            this.mDayOfWeekView.setTextAppearance(context, n4);
        }
        this.mDayOfWeekView.setBackground(typedArray.getDrawable(8));
        linearLayout.setBackground(typedArray.getDrawable(0));
        int n5 = typedArray.getColor(20, n3);
        int n6 = typedArray.getResourceId(10, -1);
        if (n6 != -1) {
            this.mHeaderMonthTextView.setTextAppearance(context, n6);
        }
        this.mHeaderMonthTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderMonthTextView.getTextColors(), 0x10100A1, n5));
        int n7 = typedArray.getResourceId(11, -1);
        if (n7 != -1) {
            this.mHeaderDayOfMonthTextView.setTextAppearance(context, n7);
        }
        this.mHeaderDayOfMonthTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderDayOfMonthTextView.getTextColors(), 0x10100A1, n5));
        int n8 = typedArray.getResourceId(12, -1);
        if (n8 != -1) {
            this.mHeaderYearTextView.setTextAppearance(context, n8);
        }
        this.mHeaderYearTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderYearTextView.getTextColors(), 0x10100A1, n5));
        this.mDayPickerView = dayPickerView = new DayPickerView(this.mContext, this);
        this.mYearPickerView = new YearPickerView(this.mContext);
        this.mYearPickerView.init(this);
        int n9 = typedArray.getColor(14, n3);
        this.mYearPickerView.setYearSelectedCircleColor(n9);
        ColorStateList colorStateList = typedArray.getColorStateList(15);
        int n10 = typedArray.getColor(18, n3);
        this.mDayPickerView.setCalendarTextColor(ColorStateList.addFirstIfMissing(colorStateList, 0x10100A1, n10));
        this.mDayPickerDescription = resources.getString(17041002);
        this.mSelectDay = resources.getString(17041004);
        this.mYearPickerDescription = resources.getString(17041003);
        this.mSelectYear = resources.getString(17041005);
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(16909109);
        this.mAnimator.addView(this.mDayPickerView);
        this.mAnimator.addView(this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCurrentDate.getTimeInMillis());
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(300L);
        this.mAnimator.setInAnimation(alphaAnimation);
        AlphaAnimation alphaAnimation2 = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation2.setDuration(300L);
        this.mAnimator.setOutAnimation(alphaAnimation2);
        this.updateDisplay(false);
        this.setCurrentView(0);
    }

    private void adjustDayInMonthIfNeeded(int n, int n2) {
        int n3;
        int n4 = this.mCurrentDate.get(5);
        if (n4 > (n3 = DatePickerCalendarDelegate.getDaysInMonth(n, n2))) {
            this.mCurrentDate.set(5, n3);
        }
    }

    private Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
        if (calendar == null) {
            return Calendar.getInstance(locale);
        }
        long l = calendar.getTimeInMillis();
        Calendar calendar2 = Calendar.getInstance(locale);
        calendar2.setTimeInMillis(l);
        return calendar2;
    }

    public static int getDaysInMonth(int n, int n2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid Month");
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: 
        }
        if (n2 % 4 == 0) {
            return 29;
        }
        return 28;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] getMonthDayYearIndexes(String string2) {
        int[] nArray = new int[3];
        String string3 = string2.replaceAll("'.*?'", "");
        int n = string3.indexOf(100);
        int n2 = string3.indexOf("M");
        int n3 = n2 != -1 ? n2 : string3.indexOf("L");
        if (string3.indexOf("y") < n3) {
            nArray[2] = 0;
            if (n3 < n) {
                nArray[0] = 1;
                nArray[1] = 2;
                return nArray;
            }
            nArray[0] = 2;
            nArray[1] = 1;
            return nArray;
        }
        nArray[2] = 2;
        if (n3 < n) {
            nArray[0] = 0;
            nArray[1] = 1;
            return nArray;
        }
        nArray[0] = 1;
        nArray[1] = 0;
        return nArray;
    }

    private void setCurrentView(int n) {
        long l = this.mCurrentDate.getTimeInMillis();
        switch (n) {
            default: {
                return;
            }
            case 0: {
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != n) {
                    this.mMonthAndDayLayout.setSelected(true);
                    this.mHeaderYearTextView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = n;
                }
                String string2 = DateUtils.formatDateTime(this.mContext, l, 16);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + string2);
                this.mAnimator.announceForAccessibility(this.mSelectDay);
                return;
            }
            case 1: 
        }
        this.mYearPickerView.onDateChanged();
        if (this.mCurrentView != n) {
            this.mMonthAndDayLayout.setSelected(false);
            this.mHeaderYearTextView.setSelected(true);
            this.mAnimator.setDisplayedChild(1);
            this.mCurrentView = n;
        }
        String string3 = this.mYearFormat.format(l);
        this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + string3);
        this.mAnimator.announceForAccessibility(this.mSelectYear);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDisplay(boolean bl) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText(this.mCurrentDate.getDisplayName(7, 2, Locale.getDefault()));
        }
        int[] nArray = this.getMonthDayYearIndexes(DateFormat.getBestDateTimePattern(this.mCurrentLocale, "yMMMd"));
        this.mMonthDayYearLayout.removeAllViews();
        if (nArray[2] == 0) {
            this.mMonthDayYearLayout.addView(this.mHeaderYearTextView);
            this.mMonthDayYearLayout.addView(this.mMonthAndDayLayout);
        } else {
            this.mMonthDayYearLayout.addView(this.mMonthAndDayLayout);
            this.mMonthDayYearLayout.addView(this.mHeaderYearTextView);
        }
        this.mMonthAndDayLayout.removeAllViews();
        if (nArray[0] > nArray[1]) {
            this.mMonthAndDayLayout.addView(this.mHeaderDayOfMonthTextView);
            this.mMonthAndDayLayout.addView(this.mHeaderMonthTextView);
        } else {
            this.mMonthAndDayLayout.addView(this.mHeaderMonthTextView);
            this.mMonthAndDayLayout.addView(this.mHeaderDayOfMonthTextView);
        }
        this.mHeaderMonthTextView.setText(this.mCurrentDate.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mHeaderDayOfMonthTextView.setText(this.mDayFormat.format(this.mCurrentDate.getTime()));
        this.mHeaderYearTextView.setText(this.mYearFormat.format(this.mCurrentDate.getTime()));
        long l = this.mCurrentDate.getTimeInMillis();
        this.mAnimator.setDateMillis(l);
        String string2 = DateUtils.formatDateTime(this.mContext, l, 24);
        this.mMonthAndDayLayout.setContentDescription(string2);
        if (bl) {
            String string3 = DateUtils.formatDateTime(this.mContext, l, 20);
            this.mAnimator.announceForAccessibility(string3);
        }
        this.updatePickers();
    }

    private void updatePickers() {
        Iterator<OnDateChangedListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDateChanged();
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override
    public CalendarView getCalendarView() {
        throw new UnsupportedOperationException("CalendarView does not exists for the new DatePicker");
    }

    @Override
    public boolean getCalendarViewShown() {
        return false;
    }

    @Override
    public int getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    @Override
    public int getFirstDayOfWeek() {
        if (this.mFirstDayOfWeek != 0) {
            return this.mFirstDayOfWeek;
        }
        return this.mCurrentDate.getFirstDayOfWeek();
    }

    @Override
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    @Override
    public int getMaxDay() {
        return this.mMaxDate.get(5);
    }

    @Override
    public int getMaxMonth() {
        return this.mMaxDate.get(2);
    }

    @Override
    public int getMaxYear() {
        return this.mMaxDate.get(1);
    }

    @Override
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    @Override
    public int getMinDay() {
        return this.mMinDate.get(5);
    }

    @Override
    public int getMinMonth() {
        return this.mMinDate.get(2);
    }

    @Override
    public int getMinYear() {
        return this.mMinDate.get(1);
    }

    @Override
    public int getMonth() {
        return this.mCurrentDate.get(2);
    }

    @Override
    public Calendar getSelectedDay() {
        return this.mCurrentDate;
    }

    @Override
    public boolean getSpinnersShown() {
        return false;
    }

    @Override
    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    @Override
    public void init(int n, int n2, int n3, DatePicker.OnDateChangedListener onDateChangedListener) {
        this.mDateChangedListener = onDateChangedListener;
        this.mCurrentDate.set(1, n);
        this.mCurrentDate.set(2, n2);
        this.mCurrentDate.set(5, n3);
        this.updateDisplay(false);
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        this.tryVibrate();
        if (view.getId() == 16909108) {
            this.setCurrentView(1);
            return;
        } else {
            if (view.getId() != 16909105) return;
            this.setCurrentView(0);
            return;
        }
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        this.mYearFormat = new SimpleDateFormat("y", configuration.locale);
        this.mDayFormat = new SimpleDateFormat("d", configuration.locale);
    }

    @Override
    public void onDayOfMonthSelected(int n, int n2, int n3) {
        this.mCurrentDate.set(1, n);
        this.mCurrentDate.set(2, n2);
        this.mCurrentDate.set(5, n3);
        this.updatePickers();
        this.updateDisplay(true);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        accessibilityEvent.setClassName(DatePicker.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        accessibilityNodeInfo.setClassName(DatePicker.class.getName());
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        accessibilityEvent.getText().add(this.mCurrentDate.getTime().toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        this.mCurrentDate.set(savedState.getSelectedYear(), savedState.getSelectedMonth(), savedState.getSelectedDay());
        this.mCurrentView = savedState.getCurrentView();
        this.mMinDate.setTimeInMillis(savedState.getMinDate());
        this.mMaxDate.setTimeInMillis(savedState.getMaxDate());
        this.updateDisplay(false);
        this.setCurrentView(this.mCurrentView);
        int n = savedState.getListPosition();
        if (n == -1) return;
        if (this.mCurrentView == 0) {
            this.mDayPickerView.postSetSelection(n);
            return;
        } else {
            if (this.mCurrentView != 1) return;
            this.mYearPickerView.postSetSelectionFromTop(n, savedState.getListPositionOffset());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        int n = this.mCurrentDate.get(1);
        int n2 = this.mCurrentDate.get(2);
        int n3 = this.mCurrentDate.get(5);
        int n4 = -1;
        int n5 = -1;
        if (this.mCurrentView == 0) {
            n4 = this.mDayPickerView.getMostVisiblePosition();
            return new SavedState(parcelable, n, n2, n3, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, n4, n5);
        }
        if (this.mCurrentView != 1) return new SavedState(parcelable, n, n2, n3, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, n4, n5);
        n4 = this.mYearPickerView.getFirstVisiblePosition();
        n5 = this.mYearPickerView.getFirstPositionOffset();
        return new SavedState(parcelable, n, n2, n3, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, n4, n5);
    }

    @Override
    public void onYearSelected(int n) {
        this.adjustDayInMonthIfNeeded(this.mCurrentDate.get(2), n);
        this.mCurrentDate.set(1, n);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.mListeners.add(onDateChangedListener);
    }

    @Override
    public void setCalendarViewShown(boolean bl) {
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mMonthAndDayLayout.setEnabled(bl);
        this.mHeaderYearTextView.setEnabled(bl);
        this.mAnimator.setEnabled(bl);
        this.mIsEnabled = bl;
    }

    @Override
    public void setFirstDayOfWeek(int n) {
        this.mFirstDayOfWeek = n;
    }

    @Override
    public void setMaxDate(long l) {
        this.mTempDate.setTimeInMillis(l);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.after(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(l);
            this.updatePickers();
            this.updateDisplay(false);
        }
        this.mMaxDate.setTimeInMillis(l);
        this.mDayPickerView.goTo(this.getSelectedDay(), false, true, true);
    }

    @Override
    public void setMinDate(long l) {
        this.mTempDate.setTimeInMillis(l);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.before(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(l);
            this.updatePickers();
            this.updateDisplay(false);
        }
        this.mMinDate.setTimeInMillis(l);
        this.mDayPickerView.goTo(this.getSelectedDay(), false, true, true);
    }

    @Override
    public void setSpinnersShown(boolean bl) {
    }

    @Override
    public void tryVibrate() {
        this.mDelegator.performHapticFeedback(5);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.mListeners.remove(onDateChangedListener);
    }

    @Override
    public void updateDate(int n, int n2, int n3) {
        this.mCurrentDate.set(1, n);
        this.mCurrentDate.set(2, n2);
        this.mCurrentDate.set(5, n3);
        if (this.mDateChangedListener != null) {
            this.mDateChangedListener.onDateChanged(this.mDelegator, n, n2, n3);
        }
        this.updateDisplay(false);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mCurrentView;
        private final int mListPosition;
        private final int mListPositionOffset;
        private final long mMaxDate;
        private final long mMinDate;
        private final int mSelectedDay;
        private final int mSelectedMonth;
        private final int mSelectedYear;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.mSelectedYear = parcel.readInt();
            this.mSelectedMonth = parcel.readInt();
            this.mSelectedDay = parcel.readInt();
            this.mMinDate = parcel.readLong();
            this.mMaxDate = parcel.readLong();
            this.mCurrentView = parcel.readInt();
            this.mListPosition = parcel.readInt();
            this.mListPositionOffset = parcel.readInt();
        }

        private SavedState(Parcelable parcelable, int n, int n2, int n3, long l, long l2, int n4, int n5, int n6) {
            super(parcelable);
            this.mSelectedYear = n;
            this.mSelectedMonth = n2;
            this.mSelectedDay = n3;
            this.mMinDate = l;
            this.mMaxDate = l2;
            this.mCurrentView = n4;
            this.mListPosition = n5;
            this.mListPositionOffset = n6;
        }

        public int getCurrentView() {
            return this.mCurrentView;
        }

        public int getListPosition() {
            return this.mListPosition;
        }

        public int getListPositionOffset() {
            return this.mListPositionOffset;
        }

        public long getMaxDate() {
            return this.mMaxDate;
        }

        public long getMinDate() {
            return this.mMinDate;
        }

        public int getSelectedDay() {
            return this.mSelectedDay;
        }

        public int getSelectedMonth() {
            return this.mSelectedMonth;
        }

        public int getSelectedYear() {
            return this.mSelectedYear;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.mSelectedYear);
            parcel.writeInt(this.mSelectedMonth);
            parcel.writeInt(this.mSelectedDay);
            parcel.writeLong(this.mMinDate);
            parcel.writeLong(this.mMaxDate);
            parcel.writeInt(this.mCurrentView);
            parcel.writeInt(this.mListPosition);
            parcel.writeInt(this.mListPositionOffset);
        }
    }
}

