/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.LruCache;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import android.widget.TextView;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.Locale;

public class SpellChecker
implements SpellCheckerSession.SpellCheckerSessionListener {
    public static final int AVERAGE_WORD_LENGTH = 7;
    private static final boolean DBG = false;
    public static final int MAX_NUMBER_OF_WORDS = 50;
    private static final int MIN_SENTENCE_LENGTH = 50;
    private static final int SPELL_PAUSE_DURATION = 400;
    private static final int SUGGESTION_SPAN_CACHE_SIZE = 10;
    private static final String TAG = SpellChecker.class.getSimpleName();
    private static final int USE_SPAN_RANGE = -1;
    public static final int WORD_ITERATOR_INTERVAL = 350;
    final int mCookie;
    private Locale mCurrentLocale;
    private int[] mIds;
    private boolean mIsSentenceSpellCheckSupported;
    private int mLength;
    private int mSpanSequenceCounter = 0;
    private SpellCheckSpan[] mSpellCheckSpans;
    SpellCheckerSession mSpellCheckerSession;
    private SpellParser[] mSpellParsers = new SpellParser[0];
    private Runnable mSpellRunnable;
    private final LruCache<Long, SuggestionSpan> mSuggestionSpanCache = new LruCache(10);
    private TextServicesManager mTextServicesManager;
    private final TextView mTextView;
    private WordIterator mWordIterator;

    public SpellChecker(TextView textView) {
        this.mTextView = textView;
        this.mIds = ArrayUtils.newUnpaddedIntArray(1);
        this.mSpellCheckSpans = new SpellCheckSpan[this.mIds.length];
        this.setLocale(this.mTextView.getSpellCheckerLocale());
        this.mCookie = this.hashCode();
    }

    static /* synthetic */ void access$1000(SpellChecker spellChecker) {
        spellChecker.spellCheck();
    }

    static /* synthetic */ boolean access$400(SpellChecker spellChecker) {
        return spellChecker.mIsSentenceSpellCheckSupported;
    }

    static /* synthetic */ WordIterator access$500(SpellChecker spellChecker) {
        return spellChecker.mWordIterator;
    }

    static /* synthetic */ int access$600(SpellChecker spellChecker) {
        return spellChecker.mLength;
    }

    static /* synthetic */ SpellCheckSpan[] access$700(SpellChecker spellChecker) {
        return spellChecker.mSpellCheckSpans;
    }

    static /* synthetic */ int[] access$800(SpellChecker spellChecker) {
        return spellChecker.mIds;
    }

    static /* synthetic */ void access$900(SpellChecker spellChecker, Editable editable, int n, int n2) {
        spellChecker.addSpellCheckSpan(editable, n, n2);
    }

    private void addSpellCheckSpan(Editable editable, int n, int n2) {
        int n3 = this.nextSpellCheckSpanIndex();
        SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[n3];
        editable.setSpan(spellCheckSpan, n, n2, 33);
        spellCheckSpan.setSpellCheckInProgress(false);
        int[] nArray = this.mIds;
        int n4 = this.mSpanSequenceCounter;
        this.mSpanSequenceCounter = n4 + 1;
        nArray[n3] = n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createMisspelledSuggestionSpan(Editable editable, SuggestionsInfo suggestionsInfo, SpellCheckSpan spellCheckSpan, int n, int n2) {
        String[] stringArray;
        int n3;
        int n4;
        int n5;
        int n6 = editable.getSpanStart(spellCheckSpan);
        int n7 = editable.getSpanEnd(spellCheckSpan);
        if (n6 < 0 || n7 <= n6) {
            return;
        }
        if (n != -1 && n2 != -1) {
            n5 = n6 + n;
            n4 = n5 + n2;
        } else {
            n5 = n6;
            n4 = n7;
        }
        if ((n3 = suggestionsInfo.getSuggestionsCount()) > 0) {
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = suggestionsInfo.getSuggestionAt(i);
            }
        } else {
            stringArray = ArrayUtils.emptyArray(String.class);
        }
        SuggestionSpan suggestionSpan = new SuggestionSpan(this.mTextView.getContext(), stringArray, 3);
        if (this.mIsSentenceSpellCheckSupported) {
            Long l = TextUtils.packRangeInLong(n5, n4);
            SuggestionSpan suggestionSpan2 = this.mSuggestionSpanCache.get(l);
            if (suggestionSpan2 != null) {
                editable.removeSpan(suggestionSpan2);
            }
            this.mSuggestionSpanCache.put(l, suggestionSpan);
        }
        editable.setSpan(suggestionSpan, n5, n4, 33);
        this.mTextView.invalidateRegion(n5, n4, false);
    }

    public static boolean haveWordBoundariesChanged(Editable editable, int n, int n2, int n3, int n4) {
        if (n4 != n && n3 != n2) {
            return true;
        }
        if (n4 == n && n < editable.length()) {
            return Character.isLetterOrDigit(Character.codePointAt(editable, n));
        }
        if (n3 == n2 && n2 > 0) {
            return Character.isLetterOrDigit(Character.codePointBefore(editable, n2));
        }
        return false;
    }

    private boolean isSessionActive() {
        return this.mSpellCheckerSession != null;
    }

    private int nextSpellCheckSpanIndex() {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mIds[i] >= 0) continue;
            return i;
        }
        this.mIds = GrowingArrayUtils.append(this.mIds, this.mLength, 0);
        this.mSpellCheckSpans = GrowingArrayUtils.append(this.mSpellCheckSpans, this.mLength, new SpellCheckSpan());
        this.mLength = 1 + this.mLength;
        return -1 + this.mLength;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SpellCheckSpan onGetSuggestionsInternal(SuggestionsInfo suggestionsInfo, int n, int n2) {
        if (suggestionsInfo == null) return null;
        if (suggestionsInfo.getCookie() != this.mCookie) {
            return null;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int n3 = suggestionsInfo.getSequence();
        int n4 = 0;
        while (n4 < this.mLength) {
            if (n3 == this.mIds[n4]) {
                int n5;
                int n6;
                int n7 = suggestionsInfo.getSuggestionsAttributes();
                boolean bl = (n7 & 1) > 0;
                boolean bl2 = (n7 & 2) > 0;
                SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[n4];
                if (!bl && bl2) {
                    this.createMisspelledSuggestionSpan(editable, suggestionsInfo, spellCheckSpan, n, n2);
                    return spellCheckSpan;
                }
                if (!this.mIsSentenceSpellCheckSupported) return spellCheckSpan;
                int n8 = editable.getSpanStart(spellCheckSpan);
                int n9 = editable.getSpanEnd(spellCheckSpan);
                if (n != -1 && n2 != -1) {
                    n6 = n8 + n;
                    n5 = n6 + n2;
                } else {
                    n6 = n8;
                    n5 = n9;
                }
                if (n8 < 0) return spellCheckSpan;
                if (n9 <= n8) return spellCheckSpan;
                if (n5 <= n6) return spellCheckSpan;
                Long l = TextUtils.packRangeInLong(n6, n5);
                SuggestionSpan suggestionSpan = this.mSuggestionSpanCache.get(l);
                if (suggestionSpan == null) return spellCheckSpan;
                editable.removeSpan(suggestionSpan);
                this.mSuggestionSpanCache.remove(l);
                return spellCheckSpan;
            }
            ++n4;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetSession() {
        this.closeSession();
        this.mTextServicesManager = (TextServicesManager)this.mTextView.getContext().getSystemService("textservices");
        if (!this.mTextServicesManager.isSpellCheckerEnabled() || this.mCurrentLocale == null || this.mTextServicesManager.getCurrentSpellCheckerSubtype(true) == null) {
            this.mSpellCheckerSession = null;
        } else {
            this.mSpellCheckerSession = this.mTextServicesManager.newSpellCheckerSession(null, this.mCurrentLocale, this, false);
            this.mIsSentenceSpellCheckSupported = true;
        }
        int n = 0;
        while (true) {
            if (n >= this.mLength) {
                this.mLength = 0;
                this.mTextView.removeMisspelledSpans((Editable)this.mTextView.getText());
                this.mSuggestionSpanCache.evictAll();
                return;
            }
            this.mIds[n] = -1;
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scheduleNewSpellCheck() {
        if (this.mSpellRunnable == null) {
            this.mSpellRunnable = new Runnable(){

                @Override
                public void run() {
                    int n = SpellChecker.this.mSpellParsers.length;
                    int n2 = 0;
                    while (true) {
                        block4: {
                            block3: {
                                if (n2 >= n) break block3;
                                SpellParser spellParser = SpellChecker.this.mSpellParsers[n2];
                                if (spellParser.isFinished()) break block4;
                                spellParser.parse();
                            }
                            return;
                        }
                        ++n2;
                    }
                }
            };
        } else {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
        this.mTextView.postDelayed(this.mSpellRunnable, 400L);
    }

    private void setLocale(Locale locale) {
        this.mCurrentLocale = locale;
        this.resetSession();
        if (locale != null) {
            this.mWordIterator = new WordIterator(locale);
        }
        this.mTextView.onLocaleChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void spellCheck() {
        int n;
        TextInfo[] textInfoArray;
        block7: {
            block6: {
                if (this.mSpellCheckerSession == null) break block6;
                Editable editable = (Editable)this.mTextView.getText();
                int n2 = Selection.getSelectionStart(editable);
                int n3 = Selection.getSelectionEnd(editable);
                textInfoArray = new TextInfo[this.mLength];
                n = 0;
                for (int i = 0; i < this.mLength; ++i) {
                    SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[i];
                    if (this.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
                    int n4 = editable.getSpanStart(spellCheckSpan);
                    int n5 = editable.getSpanEnd(spellCheckSpan);
                    boolean bl = n2 == n5 + 1 && editable.charAt(n5) == '\'';
                    boolean bl2 = this.mIsSentenceSpellCheckSupported ? !(bl || n3 > n4 && n2 <= n5) : !bl && (n3 < n4 || n2 > n5);
                    if (n4 < 0 || n5 <= n4 || !bl2) continue;
                    spellCheckSpan.setSpellCheckInProgress(true);
                    TextInfo textInfo = new TextInfo(editable, n4, n5, this.mCookie, this.mIds[i]);
                    int n6 = n + 1;
                    textInfoArray[n] = textInfo;
                    n = n6;
                }
                if (n > 0) break block7;
            }
            return;
        }
        if (n < textInfoArray.length) {
            TextInfo[] textInfoArray2 = new TextInfo[n];
            System.arraycopy(textInfoArray, 0, textInfoArray2, 0, n);
            textInfoArray = textInfoArray2;
        }
        if (this.mIsSentenceSpellCheckSupported) {
            this.mSpellCheckerSession.getSentenceSuggestions(textInfoArray, 5);
            return;
        }
        this.mSpellCheckerSession.getSuggestions(textInfoArray, 5, false);
    }

    public void closeSession() {
        if (this.mSpellCheckerSession != null) {
            this.mSpellCheckerSession.close();
        }
        int n = this.mSpellParsers.length;
        for (int i = 0; i < n; ++i) {
            this.mSpellParsers[i].stop();
        }
        if (this.mSpellRunnable != null) {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] var1_1) {
        var2_2 = (Editable)this.mTextView.getText();
        block0: for (var3_3 = 0; var3_3 < var1_1.length; ++var3_3) {
            var4_4 = var1_1[var3_3];
            if (var4_4 == null) lbl-1000:
            // 3 sources

            {
                continue block0;
            }
            var5_5 = null;
            block2: for (var6_6 = 0; var6_6 < var4_4.getSuggestionsCount(); ++var6_6) {
                var7_7 = var4_4.getSuggestionsInfoAt(var6_6);
                if (var7_7 == null) lbl-1000:
                // 3 sources

                {
                    continue block2;
                }
                var8_8 = this.onGetSuggestionsInternal(var7_7, var4_4.getOffsetAt(var6_6), var4_4.getLengthAt(var6_6));
                if (var5_5 != null || var8_8 == null) ** GOTO lbl-1000
                var5_5 = var8_8;
                ** continue;
            }
            if (var5_5 == null) ** GOTO lbl-1000
            var2_2.removeSpan(var5_5);
            ** continue;
        }
        this.scheduleNewSpellCheck();
    }

    @Override
    public void onGetSuggestions(SuggestionsInfo[] suggestionsInfoArray) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < suggestionsInfoArray.length; ++i) {
            SpellCheckSpan spellCheckSpan = this.onGetSuggestionsInternal(suggestionsInfoArray[i], -1, -1);
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    public void onSelectionChanged() {
        this.spellCheck();
    }

    public void onSpellCheckSpanRemoved(SpellCheckSpan spellCheckSpan) {
        int n = 0;
        while (true) {
            block4: {
                block3: {
                    if (n >= this.mLength) break block3;
                    if (this.mSpellCheckSpans[n] != spellCheckSpan) break block4;
                    this.mIds[n] = -1;
                }
                return;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spellCheck(int n, int n2) {
        Locale locale = this.mTextView.getSpellCheckerLocale();
        boolean bl = this.isSessionActive();
        if (locale == null || this.mCurrentLocale == null || !this.mCurrentLocale.equals(locale)) {
            this.setLocale(locale);
            n = 0;
            n2 = this.mTextView.getText().length();
        } else if (bl != this.mTextServicesManager.isSpellCheckerEnabled()) {
            this.resetSession();
        }
        if (!bl) {
            return;
        }
        int n3 = this.mSpellParsers.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n3) {
                SpellParser spellParser;
                SpellParser[] spellParserArray = new SpellParser[n3 + 1];
                System.arraycopy(this.mSpellParsers, 0, spellParserArray, 0, n3);
                this.mSpellParsers = spellParserArray;
                this.mSpellParsers[n3] = spellParser = new SpellParser();
                spellParser.parse(n, n2);
                return;
            }
            SpellParser spellParser = this.mSpellParsers[n4];
            if (spellParser.isFinished()) {
                spellParser.parse(n, n2);
                return;
            }
            ++n4;
        }
    }

    private class SpellParser {
        private Object mRange = new Object();

        private SpellParser() {
        }

        private void removeRangeSpan(Editable editable) {
            editable.removeSpan(this.mRange);
        }

        /*
         * Enabled aggressive block sorting
         */
        private <T> void removeSpansAt(Editable editable, int n, T[] TArray) {
            int n2 = TArray.length;
            int n3 = 0;
            while (n3 < n2) {
                T t = TArray[n3];
                if (editable.getSpanStart(t) <= n && editable.getSpanEnd(t) >= n) {
                    editable.removeSpan(t);
                }
                ++n3;
            }
            return;
        }

        private void setRangeSpan(Editable editable, int n, int n2) {
            editable.setSpan(this.mRange, n, n2, 33);
        }

        public boolean isFinished() {
            return ((Editable)SpellChecker.this.mTextView.getText()).getSpanStart(this.mRange) < 0;
        }

        /*
         * Unable to fully structure code
         */
        public void parse() {
            block30: {
                block31: {
                    block33: {
                        block32: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                var1_1 = (Editable)SpellChecker.access$200(SpellChecker.this).getText();
                                                if (SpellChecker.access$400(SpellChecker.this)) {
                                                    var2_2 = Math.max(0, -50 + var1_1.getSpanStart(this.mRange));
lbl4:
                                                    // 2 sources

                                                    while (true) {
                                                        var3_3 = var1_1.getSpanEnd(this.mRange);
                                                        var4_4 = Math.min(var3_3, 350 + var2_2);
                                                        SpellChecker.access$500(SpellChecker.this).setCharSequence(var1_1, var2_2, var4_4);
                                                        var5_5 = SpellChecker.access$500(SpellChecker.this).preceding(var2_2);
                                                        if (var5_5 != -1) break block25;
                                                        var6_6 = SpellChecker.access$500(SpellChecker.this).following(var2_2);
                                                        if (var6_6 != -1) {
                                                            var5_5 = SpellChecker.access$500(SpellChecker.this).getBeginning(var6_6);
                                                        }
lbl13:
                                                        // 4 sources

                                                        while (var6_6 == -1) {
                                                            this.removeRangeSpan(var1_1);
                                                            return;
                                                        }
                                                        break block26;
                                                        break;
                                                    }
                                                }
                                                var2_2 = var1_1.getSpanStart(this.mRange);
                                                ** while (true)
                                            }
                                            var6_6 = SpellChecker.access$500(SpellChecker.this).getEnd(var5_5);
                                            ** GOTO lbl13
                                        }
                                        var7_7 = var1_1.getSpans(var2_2 - 1, var3_3 + 1, SpellCheckSpan.class);
                                        var8_8 = var1_1.getSpans(var2_2 - 1, var3_3 + 1, SuggestionSpan.class);
                                        var9_9 = SpellChecker.access$400(SpellChecker.this);
                                        var10_10 = 0;
                                        if (!var9_9) break block31;
                                        var18_11 = var4_4;
                                        var12_12 = false;
                                        if (var18_11 < var3_3) {
                                            var12_12 = true;
                                        }
                                        if ((var19_13 = SpellChecker.access$500(SpellChecker.this).preceding(var4_4)) != -1) {
                                            var20_14 = true;
lbl34:
                                            // 2 sources

                                            while (true) {
                                                if (var20_14) {
                                                    var19_13 = SpellChecker.access$500(SpellChecker.this).getEnd(var19_13);
                                                    if (var19_13 == -1) break block27;
                                                    var20_14 = true;
                                                }
lbl39:
                                                // 4 sources

                                                while (!var20_14) {
                                                    this.removeRangeSpan(var1_1);
                                                    return;
                                                }
                                                break block28;
                                                break;
                                            }
                                        }
                                        var20_14 = false;
                                        ** while (true)
                                    }
                                    var20_14 = false;
                                    ** GOTO lbl39
                                }
                                var21_15 = var5_5;
                                var22_16 = true;
                                block4: for (var23_17 = 0; var23_17 < SpellChecker.access$600(SpellChecker.this); ++var23_17) {
                                    var25_18 = SpellChecker.access$700(SpellChecker.this)[var23_17];
                                    if (SpellChecker.access$800(SpellChecker.this)[var23_17] < 0 || var25_18.isSpellCheckInProgress()) lbl-1000:
                                    // 3 sources

                                    {
                                        continue block4;
                                    }
                                    var26_19 = var1_1.getSpanStart(var25_18);
                                    var27_20 = var1_1.getSpanEnd(var25_18);
                                    if (var27_20 < var21_15 || var19_13 < var26_19) ** GOTO lbl-1000
                                    if (var26_19 <= var21_15 && var19_13 <= var27_20) {
                                        var22_16 = false;
                                        break;
                                    }
                                    break block29;
                                }
                                if (var19_13 < var2_2) lbl-1000:
                                // 4 sources

                                {
                                    while (true) {
                                        var5_5 = var19_13;
lbl66:
                                        // 5 sources

                                        while (var12_12 && var5_5 <= var3_3) {
                                            this.setRangeSpan(var1_1, var5_5, var3_3);
lbl68:
                                            // 2 sources

                                            while (true) {
                                                SpellChecker.access$1000(SpellChecker.this);
                                                return;
                                            }
                                        }
                                        break block30;
                                        break;
                                    }
                                }
                                break block32;
                            }
                            var1_1.removeSpan(var25_18);
                            var21_15 = Math.min(var26_19, var21_15);
                            var19_13 = Math.max(var27_20, var19_13);
                            ** while (true)
                        }
                        if (var19_13 > var21_15) break block33;
                        Log.w(SpellChecker.access$300(), "Trying to spellcheck invalid region, from " + var2_2 + " to " + var3_3);
                        ** GOTO lbl-1000
                    }
                    if (!var22_16) ** GOTO lbl-1000
                    SpellChecker.access$900(SpellChecker.this, var1_1, var21_15, var19_13);
                    ** while (true)
                }
                block9: while (true) {
                    block34: {
                        var11_21 = var5_5;
                        var12_12 = false;
                        if (var11_21 > var3_3) ** GOTO lbl66
                        if (var6_6 < var2_2 || var6_6 <= var5_5) ** GOTO lbl120
                        if (var10_10 < 50) break block34;
                        var12_12 = true;
                        ** GOTO lbl66
                    }
                    if (var5_5 < var2_2 && var6_6 > var2_2) {
                        this.removeSpansAt(var1_1, var2_2, var7_7);
                        this.removeSpansAt(var1_1, var2_2, var8_8);
                    }
                    if (var5_5 < var3_3 && var6_6 > var3_3) {
                        this.removeSpansAt(var1_1, var3_3, var7_7);
                        this.removeSpansAt(var1_1, var3_3, var8_8);
                    }
                    var15_24 = true;
                    if (var6_6 != var2_2) ** GOTO lbl110
                    var17_26 = 0;
                    while (true) {
                        block36: {
                            block35: {
                                if (var17_26 >= var7_7.length) break block35;
                                if (var1_1.getSpanEnd(var7_7[var17_26]) != var2_2) break block36;
                                var15_24 = false;
                            }
                            if (var5_5 != var3_3) ** GOTO lbl117
                            var16_25 = 0;
lbl113:
                            // 2 sources

                            while (true) {
                                if (var16_25 < var7_7.length) {
                                    if (var1_1.getSpanStart(var7_7[var16_25]) != var3_3) break block9;
                                    var15_24 = false;
                                }
lbl117:
                                // 4 sources

                                if (var15_24) {
                                    SpellChecker.access$900(SpellChecker.this, var1_1, var5_5, var6_6);
                                }
                                ++var10_10;
lbl120:
                                // 2 sources

                                var13_22 = var6_6;
                                var6_6 = SpellChecker.access$500(SpellChecker.this).following(var6_6);
                                if (var4_4 < var3_3 && (var6_6 == -1 || var6_6 >= var4_4)) {
                                    var4_4 = Math.min(var3_3, var13_22 + 350);
                                    SpellChecker.access$500(SpellChecker.this).setCharSequence(var1_1, var13_22, var4_4);
                                    var6_6 = SpellChecker.access$500(SpellChecker.this).following(var13_22);
                                }
                                var14_23 = var6_6;
                                var12_12 = false;
                                if (var14_23 == -1) ** GOTO lbl66
                                var5_5 = SpellChecker.access$500(SpellChecker.this).getBeginning(var6_6);
                                if (var5_5 != -1) continue block9;
                                var12_12 = false;
                                ** GOTO lbl66
                                break;
                            }
                        }
                        ++var17_26;
                    }
                    break;
                }
                ++var16_25;
                ** while (true)
            }
            this.removeRangeSpan(var1_1);
            ** while (true)
        }

        /*
         * Enabled aggressive block sorting
         */
        public void parse(int n, int n2) {
            int n3;
            int n4 = SpellChecker.this.mTextView.length();
            if (n2 > n4) {
                Log.w(TAG, "Parse invalid region, from " + n + " to " + n2);
                n3 = n4;
            } else {
                n3 = n2;
            }
            if (n3 > n) {
                this.setRangeSpan((Editable)SpellChecker.this.mTextView.getText(), n, n3);
                this.parse();
            }
        }

        public void stop() {
            this.removeRangeSpan((Editable)SpellChecker.this.mTextView.getText());
        }
    }
}

