/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.NumberPicker;
import android.widget.TextView;
import android.widget.TimePicker;
import com.android.internal.R;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;

class TimePickerClockDelegate
extends TimePicker.AbstractTimePickerDelegate {
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private static final int HOURS_IN_HALF_DAY = 12;
    private final Button mAmPmButton;
    private final NumberPicker mAmPmSpinner;
    private final EditText mAmPmSpinnerInput;
    private final String[] mAmPmStrings;
    private final TextView mDivider;
    private char mHourFormat;
    private final NumberPicker mHourSpinner;
    private final EditText mHourSpinnerInput;
    private boolean mHourWithTwoDigit;
    private boolean mIs24HourView;
    private boolean mIsAm;
    private boolean mIsEnabled = true;
    private final NumberPicker mMinuteSpinner;
    private final EditText mMinuteSpinnerInput;
    private Calendar mTempCalendar;

    /*
     * Enabled aggressive block sorting
     */
    public TimePickerClockDelegate(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(timePicker, context);
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.TimePicker, n, n2);
        int n3 = typedArray.getResourceId(10, 17367292);
        typedArray.recycle();
        LayoutInflater.from(this.mContext).inflate(n3, (ViewGroup)this.mDelegator, true);
        this.mHourSpinner = (NumberPicker)timePicker.findViewById(16909287);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                TimePickerClockDelegate.this.updateInputState();
                if (!TimePickerClockDelegate.this.is24HourView() && (n == 11 && n2 == 12 || n == 12 && n2 == 11)) {
                    TimePickerClockDelegate timePickerClockDelegate = TimePickerClockDelegate.this;
                    boolean bl = !TimePickerClockDelegate.this.mIsAm;
                    TimePickerClockDelegate.access$102(timePickerClockDelegate, bl);
                    TimePickerClockDelegate.this.updateAmPmControl();
                }
                TimePickerClockDelegate.this.onTimeChanged();
            }
        });
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.findViewById(16909198);
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.mDelegator.findViewById(16909290);
        if (this.mDivider != null) {
            this.setDividerText();
        }
        this.mMinuteSpinner = (NumberPicker)this.mDelegator.findViewById(16909288);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                boolean bl = true;
                TimePickerClockDelegate.this.updateInputState();
                int n3 = TimePickerClockDelegate.this.mMinuteSpinner.getMinValue();
                int n4 = TimePickerClockDelegate.this.mMinuteSpinner.getMaxValue();
                if (n == n4 && n2 == n3) {
                    int n5 = 1 + TimePickerClockDelegate.this.mHourSpinner.getValue();
                    if (!TimePickerClockDelegate.this.is24HourView() && n5 == 12) {
                        TimePickerClockDelegate timePickerClockDelegate = TimePickerClockDelegate.this;
                        if (TimePickerClockDelegate.this.mIsAm) {
                            bl = false;
                        }
                        TimePickerClockDelegate.access$102(timePickerClockDelegate, bl);
                        TimePickerClockDelegate.this.updateAmPmControl();
                    }
                    TimePickerClockDelegate.this.mHourSpinner.setValue(n5);
                } else if (n == n3 && n2 == n4) {
                    int n6 = -1 + TimePickerClockDelegate.this.mHourSpinner.getValue();
                    if (!TimePickerClockDelegate.this.is24HourView() && n6 == 11) {
                        TimePickerClockDelegate timePickerClockDelegate = TimePickerClockDelegate.this;
                        if (TimePickerClockDelegate.this.mIsAm) {
                            bl = false;
                        }
                        TimePickerClockDelegate.access$102(timePickerClockDelegate, bl);
                        TimePickerClockDelegate.this.updateAmPmControl();
                    }
                    TimePickerClockDelegate.this.mHourSpinner.setValue(n6);
                }
                TimePickerClockDelegate.this.onTimeChanged();
            }
        });
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.findViewById(16909198);
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = TimePickerClockDelegate.getAmPmStrings(context);
        View view = this.mDelegator.findViewById(16909289);
        if (view instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)view;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onClick(View view) {
                    view.requestFocus();
                    TimePickerClockDelegate timePickerClockDelegate = TimePickerClockDelegate.this;
                    boolean bl = !TimePickerClockDelegate.this.mIsAm;
                    TimePickerClockDelegate.access$102(timePickerClockDelegate, bl);
                    TimePickerClockDelegate.this.updateAmPmControl();
                    TimePickerClockDelegate.this.onTimeChanged();
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)view;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                    TimePickerClockDelegate.this.updateInputState();
                    numberPicker.requestFocus();
                    TimePickerClockDelegate timePickerClockDelegate = TimePickerClockDelegate.this;
                    boolean bl = !TimePickerClockDelegate.this.mIsAm;
                    TimePickerClockDelegate.access$102(timePickerClockDelegate, bl);
                    TimePickerClockDelegate.this.updateAmPmControl();
                    TimePickerClockDelegate.this.onTimeChanged();
                }
            });
            this.mAmPmSpinnerInput = (EditText)this.mAmPmSpinner.findViewById(16909198);
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        if (this.isAmPmAtStart()) {
            ViewGroup viewGroup = (ViewGroup)timePicker.findViewById(16909286);
            viewGroup.removeView(view);
            viewGroup.addView(view, 0);
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            int n4 = marginLayoutParams.getMarginStart();
            int n5 = marginLayoutParams.getMarginEnd();
            if (n4 != n5) {
                marginLayoutParams.setMarginStart(n5);
                marginLayoutParams.setMarginEnd(n4);
            }
        }
        this.getHourFormatData();
        this.updateHourControl();
        this.updateMinuteControl();
        this.updateAmPmControl();
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
        if (this.mDelegator.getImportantForAccessibility() == 0) {
            this.mDelegator.setImportantForAccessibility(1);
        }
    }

    static /* synthetic */ boolean access$102(TimePickerClockDelegate timePickerClockDelegate, boolean bl) {
        timePickerClockDelegate.mIsAm = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] getAmPmStrings(Context context) {
        String[] stringArray = new String[2];
        LocaleData localeData = LocaleData.get((Locale)context.getResources().getConfiguration().locale);
        String string2 = localeData.amPm[0].length() > 2 ? localeData.narrowAm : localeData.amPm[0];
        stringArray[0] = string2;
        String string3 = localeData.amPm[1].length() > 2 ? localeData.narrowPm : localeData.amPm[1];
        stringArray[1] = string3;
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getHourFormatData() {
        Locale locale = this.mCurrentLocale;
        String string2 = this.mIs24HourView ? "Hm" : "hm";
        String string3 = DateFormat.getBestDateTimePattern(locale, string2);
        int n = string3.length();
        this.mHourWithTwoDigit = false;
        int n2 = 0;
        while (true) {
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    char c = string3.charAt(n2);
                    if (c != 'H' && c != 'h' && c != 'K' && c != 'k') break block6;
                    this.mHourFormat = c;
                    if (n2 + 1 < n && c == string3.charAt(n2 + 1)) {
                        this.mHourWithTwoDigit = true;
                    }
                }
                return;
            }
            ++n2;
        }
    }

    private boolean isAmPmAtStart() {
        return DateFormat.getBestDateTimePattern(this.mCurrentLocale, "hm").startsWith("a");
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void setContentDescriptions() {
        this.trySetContentDescription(this.mMinuteSpinner, 16909197, 17040754);
        this.trySetContentDescription(this.mMinuteSpinner, 16909199, 17040755);
        this.trySetContentDescription(this.mHourSpinner, 16909197, 17040756);
        this.trySetContentDescription(this.mHourSpinner, 16909199, 17040757);
        if (this.mAmPmSpinner != null) {
            this.trySetContentDescription(this.mAmPmSpinner, 16909197, 17040758);
            this.trySetContentDescription(this.mAmPmSpinner, 16909199, 17040759);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCurrentHour(Integer n, boolean bl) {
        block11: {
            block10: {
                if (n == null || n == this.getCurrentHour()) break block10;
                if (!this.is24HourView()) {
                    if (n >= 12) {
                        this.mIsAm = false;
                        if (n > 12) {
                            n = -12 + n;
                        }
                    } else {
                        this.mIsAm = true;
                        if (n == 0) {
                            n = 12;
                        }
                    }
                    this.updateAmPmControl();
                }
                this.mHourSpinner.setValue(n);
                if (bl) break block11;
            }
            return;
        }
        this.onTimeChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDividerText() {
        int n;
        String string2 = this.mIs24HourView ? "Hm" : "hm";
        String string3 = DateFormat.getBestDateTimePattern(this.mCurrentLocale, string2);
        int n2 = string3.lastIndexOf(72);
        if (n2 == -1) {
            n2 = string3.lastIndexOf(104);
        }
        String string4 = n2 == -1 ? ":" : ((n = string3.indexOf(109, n2 + 1)) == -1 ? Character.toString(string3.charAt(n2 + 1)) : string3.substring(n2 + 1, n));
        this.mDivider.setText(string4);
    }

    private void trySetContentDescription(View view, int n, int n2) {
        View view2 = view.findViewById(n);
        if (view2 != null) {
            view2.setContentDescription(this.mContext.getString(n2));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int n = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(n);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[n]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.mDelegator.sendAccessibilityEvent(4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateHourControl() {
        if (this.is24HourView()) {
            if (this.mHourFormat == 'k') {
                this.mHourSpinner.setMinValue(1);
                this.mHourSpinner.setMaxValue(24);
            } else {
                this.mHourSpinner.setMinValue(0);
                this.mHourSpinner.setMaxValue(23);
            }
        } else if (this.mHourFormat == 'K') {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(11);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
        }
        NumberPicker numberPicker = this.mHourSpinner;
        NumberPicker.Formatter formatter = this.mHourWithTwoDigit ? NumberPicker.getTwoDigitFormatter() : null;
        numberPicker.setFormatter(formatter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager == null) return;
        if (inputMethodManager.isActive(this.mHourSpinnerInput)) {
            this.mHourSpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            return;
        } else {
            if (inputMethodManager.isActive(this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                return;
            }
            if (!inputMethodManager.isActive(this.mAmPmSpinnerInput)) return;
            this.mAmPmSpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            return;
        }
    }

    private void updateMinuteControl() {
        if (this.is24HourView()) {
            this.mMinuteSpinnerInput.setImeOptions(6);
            return;
        }
        this.mMinuteSpinnerInput.setImeOptions(5);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override
    public int getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    @Override
    public Integer getCurrentHour() {
        int n = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return n;
        }
        if (this.mIsAm) {
            return n % 12;
        }
        return 12 + n % 12;
    }

    @Override
    public Integer getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    @Override
    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        this.setCurrentLocale(configuration.locale);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        accessibilityEvent.setClassName(TimePicker.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        accessibilityNodeInfo.setClassName(TimePicker.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        int n = this.mIs24HourView ? 1 | 0x80 : 1 | 0x40;
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String string2 = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), n);
        accessibilityEvent.getText().add(string2);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        this.setCurrentHour(savedState.getHour());
        this.setCurrentMinute(savedState.getMinute());
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return new SavedState(parcelable, this.getCurrentHour(), this.getCurrentMinute());
    }

    @Override
    public void setCurrentHour(Integer n) {
        this.setCurrentHour(n, true);
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    @Override
    public void setCurrentMinute(Integer n) {
        if (n == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(n);
        this.onTimeChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setEnabled(boolean bl) {
        this.mMinuteSpinner.setEnabled(bl);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(bl);
        }
        this.mHourSpinner.setEnabled(bl);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(bl);
        } else {
            this.mAmPmButton.setEnabled(bl);
        }
        this.mIsEnabled = bl;
    }

    @Override
    public void setIs24HourView(Boolean bl) {
        if (this.mIs24HourView == bl) {
            return;
        }
        int n = this.getCurrentHour();
        this.mIs24HourView = bl;
        this.getHourFormatData();
        this.updateHourControl();
        this.setCurrentHour(n, false);
        this.updateMinuteControl();
        this.updateAmPmControl();
    }

    @Override
    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mHour;
        private final int mMinute;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.mHour = parcel.readInt();
            this.mMinute = parcel.readInt();
        }

        private SavedState(Parcelable parcelable, int n, int n2) {
            super(parcelable);
            this.mHour = n;
            this.mMinute = n2;
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.mHour);
            parcel.writeInt(this.mMinute);
        }
    }
}

