/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.media.MediaRouter;
import android.util.Log;
import android.view.View;
import com.android.internal.app.MediaRouteChooserDialog;
import com.android.internal.app.MediaRouteChooserDialogFragment;
import com.android.internal.app.MediaRouteControllerDialog;
import com.android.internal.app.MediaRouteControllerDialogFragment;

public abstract class MediaRouteDialogPresenter {
    private static final String CHOOSER_FRAGMENT_TAG = "android.app.MediaRouteButton:MediaRouteChooserDialogFragment";
    private static final String CONTROLLER_FRAGMENT_TAG = "android.app.MediaRouteButton:MediaRouteControllerDialogFragment";
    private static final String TAG = "MediaRouter";

    public static Dialog createDialog(Context context, int n, View.OnClickListener onClickListener) {
        MediaRouter.RouteInfo routeInfo = ((MediaRouter)context.getSystemService("media_router")).getSelectedRoute();
        if (routeInfo.isDefault() || !routeInfo.matchesTypes(n)) {
            MediaRouteChooserDialog mediaRouteChooserDialog = new MediaRouteChooserDialog(context, 16974126);
            mediaRouteChooserDialog.setRouteTypes(n);
            mediaRouteChooserDialog.setExtendedSettingsClickListener(onClickListener);
            return mediaRouteChooserDialog;
        }
        return new MediaRouteControllerDialog(context, 16974126);
    }

    public static DialogFragment showDialogFragment(Activity activity, int n, View.OnClickListener onClickListener) {
        MediaRouter mediaRouter = (MediaRouter)activity.getSystemService("media_router");
        FragmentManager fragmentManager = activity.getFragmentManager();
        MediaRouter.RouteInfo routeInfo = mediaRouter.getSelectedRoute();
        if (routeInfo.isDefault() || !routeInfo.matchesTypes(n)) {
            if (fragmentManager.findFragmentByTag(CHOOSER_FRAGMENT_TAG) != null) {
                Log.w(TAG, "showDialog(): Route chooser dialog already showing!");
                return null;
            }
            MediaRouteChooserDialogFragment mediaRouteChooserDialogFragment = new MediaRouteChooserDialogFragment();
            mediaRouteChooserDialogFragment.setRouteTypes(n);
            mediaRouteChooserDialogFragment.setExtendedSettingsClickListener(onClickListener);
            mediaRouteChooserDialogFragment.show(fragmentManager, CHOOSER_FRAGMENT_TAG);
            return mediaRouteChooserDialogFragment;
        }
        if (fragmentManager.findFragmentByTag(CONTROLLER_FRAGMENT_TAG) != null) {
            Log.w(TAG, "showDialog(): Route controller dialog already showing!");
            return null;
        }
        MediaRouteControllerDialogFragment mediaRouteControllerDialogFragment = new MediaRouteControllerDialogFragment();
        mediaRouteControllerDialogFragment.show(fragmentManager, CONTROLLER_FRAGMENT_TAG);
        return mediaRouteControllerDialogFragment;
    }
}

