/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.content.PackageMonitor;
import com.android.internal.widget.ResolverDrawerLayout;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolverActivity
extends Activity
implements AdapterView.OnItemClickListener {
    private static final boolean DEBUG = false;
    private static final String TAG = "ResolverActivity";
    private static final long USAGE_STATS_PERIOD = 1209600000L;
    private ResolveListAdapter mAdapter;
    private Button mAlwaysButton;
    private boolean mAlwaysUseOption;
    private int mIconDpi;
    private int mIconSize;
    private int mLastSelected = -1;
    private int mLaunchedFromUid;
    private ListView mListView;
    private int mMaxColumns;
    private Button mOnceButton;
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onSomePackagesChanged() {
            ResolverActivity.this.mAdapter.handlePackagesChanged();
        }
    };
    private PackageManager mPm;
    private boolean mRegistered;
    private boolean mResolvingHome = false;
    private boolean mSafeForwardingMode;
    private boolean mShowExtended;
    private Map<String, UsageStats> mStats;
    private UsageStatsManager mUsm;

    static /* synthetic */ boolean access$202(ResolverActivity resolverActivity, boolean bl) {
        resolverActivity.mShowExtended = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        if (userManager == null) return false;
        try {
            for (UserInfo userInfo : userManager.getProfiles(this.getUserId())) {
                boolean bl;
                if (userInfo == null || !(bl = userInfo.isManagedProfile())) continue;
                return true;
            }
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(0xFF7FFFFF & intent.getFlags());
        return intent;
    }

    private void setAlwaysButtonEnabled(boolean bl, int n, boolean bl2) {
        boolean bl3 = false;
        if (bl) {
            int n2 = this.mAdapter.resolveInfoForPosition((int)n, (boolean)bl2).targetUserId;
            bl3 = false;
            if (n2 == -2) {
                bl3 = true;
            }
        }
        this.mAlwaysButton.setEnabled(bl3);
    }

    private boolean supportsManagedProfiles(ResolveInfo resolveInfo) {
        try {
            boolean bl = this.versionNumberAtLeastL(this.getPackageManager().getApplicationInfo((String)resolveInfo.activityInfo.packageName, (int)0).targetSdkVersion);
            return bl;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private boolean versionNumberAtLeastL(int n) {
        return n >= 21;
    }

    void dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    Drawable getIcon(Resources resources, int n) {
        try {
            Drawable drawable2 = resources.getDrawableForDensity(n, this.mIconDpi);
            return drawable2;
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    public Intent getReplacementIntent(String string2, Intent intent) {
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CharSequence getTitleForAction(String string2, int n) {
        ActionTitle actionTitle = this.mResolvingHome ? ActionTitle.HOME : ActionTitle.forAction(string2);
        boolean bl = this.mAdapter.hasFilteredItem();
        if (actionTitle == ActionTitle.DEFAULT && n != 0) {
            return this.getString(n);
        }
        if (bl) {
            int n2 = actionTitle.namedTitleRes;
            Object[] objectArray = new Object[]{this.mAdapter.getFilteredItem().displayLabel};
            return this.getString(n2, objectArray);
        }
        return this.getString(actionTitle.titleRes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Drawable loadIconForResolveInfo(ResolveInfo resolveInfo) {
        block6: {
            block5: {
                try {
                    Drawable drawable2;
                    if (resolveInfo.resolvePackageName == null || resolveInfo.icon == 0 || (drawable2 = this.getIcon(this.mPm.getResourcesForApplication(resolveInfo.resolvePackageName), resolveInfo.icon)) == null) break block5;
                    return drawable2;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e(TAG, "Couldn't find resources for package", nameNotFoundException);
                    return resolveInfo.loadIcon(this.mPm);
                }
            }
            int n = resolveInfo.getIconResource();
            if (n == 0) break block6;
            Drawable drawable3 = this.getIcon(this.mPm.getResourcesForApplication(resolveInfo.activityInfo.packageName), n);
            if (drawable3 != null) return drawable3;
        }
        return resolveInfo.loadIcon(this.mPm);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onButtonClick(View view) {
        int n = view.getId();
        int n2 = this.mAlwaysUseOption ? this.mListView.getCheckedItemPosition() : this.mAdapter.getFilteredPosition();
        boolean bl = n == 16909219;
        this.startSelected(n2, bl, this.mAlwaysUseOption);
        this.dismiss();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        Intent intent = this.makeMyIntent();
        Set<String> set = intent.getCategories();
        if ("android.intent.action.MAIN".equals(intent.getAction()) && set != null && set.size() == 1 && set.contains("android.intent.category.HOME")) {
            this.mResolvingHome = true;
        }
        this.setSafeForwardingMode(true);
        this.onCreate(bundle, intent, null, 0, null, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, int n, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        boolean bl2;
        int n2;
        this.setTheme(16974991);
        super.onCreate(bundle);
        try {
            this.mLaunchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
        }
        catch (RemoteException remoteException) {
            this.mLaunchedFromUid = -1;
        }
        this.mPm = this.getPackageManager();
        this.mUsm = (UsageStatsManager)this.getSystemService("usagestats");
        long l = System.currentTimeMillis() - 1209600000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(l, System.currentTimeMillis());
        Log.d(TAG, "sinceTime=" + l);
        this.mMaxColumns = this.getResources().getInteger(17694829);
        this.mPackageMonitor.register(this, this.getMainLooper(), false);
        this.mRegistered = true;
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = activityManager.getLauncherLargeIconDensity();
        this.mIconSize = activityManager.getLauncherLargeIconSize();
        this.mAdapter = new ResolveListAdapter(this, intent, intentArray, list, this.mLaunchedFromUid, bl);
        if (this.mAdapter.hasFilteredItem()) {
            n2 = 17367242;
            bl = false;
            bl2 = true;
        } else {
            n2 = 17367241;
            bl2 = false;
        }
        this.mAlwaysUseOption = bl;
        int n3 = this.mAdapter.mList.size();
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        } else {
            ResolverDrawerLayout resolverDrawerLayout;
            if (n3 > 1) {
                String string2;
                this.setContentView(n2);
                this.mListView = (ListView)this.findViewById(16909217);
                this.mListView.setAdapter(this.mAdapter);
                this.mListView.setOnItemClickListener(this);
                this.mListView.setOnItemLongClickListener(new ItemLongClickListener());
                if (bl) {
                    this.mListView.setChoiceMode(1);
                }
                if (bl2) {
                    this.mListView.addHeaderView(LayoutInflater.from(this).inflate(17367240, (ViewGroup)this.mListView, false));
                }
                if ((string2 = intent.getDataString()) != null && string2.startsWith("http://localhost") && string2.contains("octane")) {
                    this.startActivity(this.mAdapter.intentForPosition(0, false));
                    this.mPackageMonitor.unregister();
                    this.mRegistered = false;
                    this.finish();
                    return;
                }
            } else {
                if (n3 == 1) {
                    this.safelyStartActivity(this.mAdapter.intentForPosition(0, false));
                    this.mPackageMonitor.unregister();
                    this.mRegistered = false;
                    this.finish();
                    return;
                }
                this.setContentView(17367241);
                ((TextView)this.findViewById(16908292)).setVisibility(0);
                this.mListView = (ListView)this.findViewById(16909217);
                this.mListView.setVisibility(8);
            }
            if ((resolverDrawerLayout = (ResolverDrawerLayout)this.findViewById(16909017)) != null) {
                resolverDrawerLayout.setOnClickOutsideListener(new View.OnClickListener(){

                    @Override
                    public void onClick(View view) {
                        ResolverActivity.this.finish();
                    }
                });
            }
            if (charSequence == null) {
                charSequence = this.getTitleForAction(intent.getAction(), n);
            }
            if (!TextUtils.isEmpty(charSequence)) {
                TextView textView = (TextView)this.findViewById(16908310);
                if (textView != null) {
                    textView.setText(charSequence);
                }
                this.setTitle(charSequence);
            }
            ImageView imageView = (ImageView)this.findViewById(16908294);
            DisplayResolveInfo displayResolveInfo = this.mAdapter.getFilteredItem();
            if (imageView != null && displayResolveInfo != null) {
                new LoadIconIntoViewTask(imageView).execute(displayResolveInfo);
            }
            if (bl || this.mAdapter.hasFilteredItem()) {
                ViewGroup viewGroup = (ViewGroup)this.findViewById(16909031);
                if (viewGroup != null) {
                    viewGroup.setVisibility(0);
                    this.mAlwaysButton = (Button)viewGroup.findViewById(16909219);
                    this.mOnceButton = (Button)viewGroup.findViewById(16909218);
                } else {
                    this.mAlwaysUseOption = false;
                }
            }
            if (!this.mAdapter.hasFilteredItem()) return;
            this.setAlwaysButtonEnabled(true, this.mAdapter.getFilteredPosition(), false);
            this.mOnceButton.setEnabled(true);
            return;
        }
    }

    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        this.onCreate(bundle, intent, charSequence, 0, intentArray, list, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onIntentSelected(ResolveInfo resolveInfo, Intent intent, boolean bl) {
        if ((this.mAlwaysUseOption || this.mAdapter.hasFilteredItem()) && this.mAdapter.mOrigResolveList != null) {
            String string2;
            Set<String> set;
            IntentFilter intentFilter = new IntentFilter();
            if (intent.getAction() != null) {
                intentFilter.addAction(intent.getAction());
            }
            if ((set = intent.getCategories()) != null) {
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    intentFilter.addCategory(iterator.next());
                }
            }
            intentFilter.addCategory("android.intent.category.DEFAULT");
            int n = 0xFFF0000 & resolveInfo.match;
            Uri uri = intent.getData();
            if (n == 0x600000 && (string2 = intent.resolveType(this)) != null) {
                try {
                    intentFilter.addDataType(string2);
                }
                catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                    Log.w(TAG, malformedMimeTypeException);
                    intentFilter = null;
                }
            }
            if (uri != null && uri.getScheme() != null && (n != 0x600000 || !"file".equals(uri.getScheme()) && !"content".equals(uri.getScheme()))) {
                Iterator<PatternMatcher> iterator;
                Iterator<IntentFilter.AuthorityEntry> iterator2;
                intentFilter.addDataScheme(uri.getScheme());
                Iterator<PatternMatcher> iterator3 = resolveInfo.filter.schemeSpecificPartsIterator();
                if (iterator3 != null) {
                    String string3 = uri.getSchemeSpecificPart();
                    while (string3 != null && iterator3.hasNext()) {
                        PatternMatcher patternMatcher = iterator3.next();
                        if (!patternMatcher.match(string3)) continue;
                        intentFilter.addDataSchemeSpecificPart(patternMatcher.getPath(), patternMatcher.getType());
                        break;
                    }
                }
                if ((iterator2 = resolveInfo.filter.authoritiesIterator()) != null) {
                    while (iterator2.hasNext()) {
                        IntentFilter.AuthorityEntry authorityEntry = iterator2.next();
                        if (authorityEntry.match(uri) < 0) continue;
                        int n2 = authorityEntry.getPort();
                        String string4 = authorityEntry.getHost();
                        String string5 = n2 >= 0 ? Integer.toString(n2) : null;
                        intentFilter.addDataAuthority(string4, string5);
                        break;
                    }
                }
                if ((iterator = resolveInfo.filter.pathsIterator()) != null) {
                    String string6 = uri.getPath();
                    while (string6 != null && iterator.hasNext()) {
                        PatternMatcher patternMatcher = iterator.next();
                        if (!patternMatcher.match(string6)) continue;
                        intentFilter.addDataPath(patternMatcher.getPath(), patternMatcher.getType());
                        break;
                    }
                }
            }
            if (intentFilter != null) {
                int n3 = this.mAdapter.mOrigResolveList.size();
                ComponentName[] componentNameArray = new ComponentName[n3];
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    ResolveInfo resolveInfo2 = this.mAdapter.mOrigResolveList.get(i);
                    componentNameArray[i] = new ComponentName(resolveInfo2.activityInfo.packageName, resolveInfo2.activityInfo.name);
                    if (resolveInfo2.match <= n4) continue;
                    n4 = resolveInfo2.match;
                }
                if (bl) {
                    this.getPackageManager().addPreferredActivity(intentFilter, n4, componentNameArray, intent.getComponent());
                } else {
                    try {
                        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveTypeIfNeeded(this.getContentResolver()), 65536, intentFilter, n4, intent.getComponent());
                    }
                    catch (RemoteException remoteException) {
                        Log.d(TAG, "Error calling setLastChosenActivity\n" + remoteException);
                    }
                }
            }
        }
        if (intent != null) {
            this.safelyStartActivity(intent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        int n2 = n - this.mListView.getHeaderViewsCount();
        if (n2 < 0) {
            return;
        }
        ResolveInfo resolveInfo = this.mAdapter.resolveInfoForPosition(n2, true);
        if (this.mResolvingHome && this.hasManagedProfile() && !this.supportsManagedProfiles(resolveInfo)) {
            String string2 = this.getResources().getString(17040827);
            Object[] objectArray = new Object[]{resolveInfo.activityInfo.loadLabel(this.getPackageManager()).toString()};
            Toast.makeText((Context)this, String.format(string2, objectArray), 1).show();
            return;
        }
        int n3 = this.mListView.getCheckedItemPosition();
        boolean bl = n3 != -1;
        if (this.mAlwaysUseOption && (!bl || this.mLastSelected != n3)) {
            this.setAlwaysButtonEnabled(bl, n3, true);
            this.mOnceButton.setEnabled(bl);
            if (bl) {
                this.mListView.smoothScrollToPosition(n3);
            }
            this.mLastSelected = n3;
            return;
        }
        this.startSelected(n2, false, true);
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPackageMonitor.register(this, this.getMainLooper(), false);
            this.mRegistered = true;
        }
        this.mAdapter.handlePackagesChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        if (this.mAlwaysUseOption) {
            int n = this.mListView.getCheckedItemPosition();
            boolean bl = n != -1;
            this.mLastSelected = n;
            this.setAlwaysButtonEnabled(bl, n, true);
            this.mOnceButton.setEnabled(bl);
            if (bl) {
                this.mListView.setSelection(n);
            }
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mRegistered) {
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
        }
        if ((0x10000000 & this.getIntent().getFlags()) != 0 && !this.isChangingConfigurations()) {
            this.finish();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void safelyStartActivity(Intent intent) {
        if (!this.mSafeForwardingMode) {
            this.startActivity(intent);
            return;
        }
        try {
            this.startActivityAsCaller(intent, null, -10000);
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2;
            try {
                String string3;
                string2 = string3 = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
            }
            catch (RemoteException remoteException) {
                string2 = "??";
            }
            Slog.wtf(TAG, "Unable to launch as uid " + this.mLaunchedFromUid + " package " + string2 + ", while running in " + ActivityThread.currentProcessName(), runtimeException);
            return;
        }
    }

    public void setSafeForwardingMode(boolean bl) {
        this.mSafeForwardingMode = bl;
    }

    void showAppDetails(ResolveInfo resolveInfo) {
        this.startActivity(new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", resolveInfo.activityInfo.packageName, null)).addFlags(524288));
    }

    void startSelected(int n, boolean bl, boolean bl2) {
        if (this.isFinishing()) {
            return;
        }
        this.onIntentSelected(this.mAdapter.resolveInfoForPosition(n, bl2), this.mAdapter.intentForPosition(n, bl2), bl);
        this.finish();
    }

    private static final class ActionTitle
    extends Enum<ActionTitle> {
        private static final /* synthetic */ ActionTitle[] $VALUES;
        public static final /* enum */ ActionTitle DEFAULT;
        public static final /* enum */ ActionTitle EDIT;
        public static final /* enum */ ActionTitle HOME;
        public static final /* enum */ ActionTitle SEND;
        public static final /* enum */ ActionTitle SENDTO;
        public static final /* enum */ ActionTitle SEND_MULTIPLE;
        public static final /* enum */ ActionTitle VIEW;
        public final String action;
        public final int namedTitleRes;
        public final int titleRes;

        static {
            VIEW = new ActionTitle("android.intent.action.VIEW", 17040486, 17040487);
            EDIT = new ActionTitle("android.intent.action.EDIT", 17040488, 17040489);
            SEND = new ActionTitle("android.intent.action.SEND", 17040490, 17040491);
            SENDTO = new ActionTitle("android.intent.action.SENDTO", 17040490, 17040491);
            SEND_MULTIPLE = new ActionTitle("android.intent.action.SEND_MULTIPLE", 17040490, 17040491);
            DEFAULT = new ActionTitle(null, 17040484, 17040485);
            HOME = new ActionTitle("android.intent.action.MAIN", 17040492, 17040493);
            ActionTitle[] actionTitleArray = new ActionTitle[]{VIEW, EDIT, SEND, SENDTO, SEND_MULTIPLE, DEFAULT, HOME};
            $VALUES = actionTitleArray;
        }

        private ActionTitle(String string3, int n2, int n3) {
            this.action = string3;
            this.titleRes = n2;
            this.namedTitleRes = n3;
        }

        public static ActionTitle forAction(String string2) {
            for (ActionTitle actionTitle : ActionTitle.values()) {
                if (actionTitle == HOME || string2 == null || !string2.equals(actionTitle.action)) continue;
                return actionTitle;
            }
            return DEFAULT;
        }

        public static ActionTitle valueOf(String string2) {
            return Enum.valueOf(ActionTitle.class, string2);
        }

        public static ActionTitle[] values() {
            return (ActionTitle[])$VALUES.clone();
        }
    }

    private final class DisplayResolveInfo {
        Drawable displayIcon;
        CharSequence displayLabel;
        CharSequence extendedInfo;
        Intent origIntent;
        ResolveInfo ri;

        DisplayResolveInfo(ResolveInfo resolveInfo, CharSequence charSequence, CharSequence charSequence2, Intent intent) {
            this.ri = resolveInfo;
            this.displayLabel = charSequence;
            this.extendedInfo = charSequence2;
            this.origIntent = intent;
        }
    }

    class ItemLongClickListener
    implements AdapterView.OnItemLongClickListener {
        ItemLongClickListener() {
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
            int n2 = n - ResolverActivity.this.mListView.getHeaderViewsCount();
            if (n2 < 0) {
                return false;
            }
            ResolveInfo resolveInfo = ResolverActivity.this.mAdapter.resolveInfoForPosition(n2, true);
            ResolverActivity.this.showAppDetails(resolveInfo);
            return true;
        }
    }

    class LoadIconIntoViewTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        final ImageView mTargetView;

        public LoadIconIntoViewTask(ImageView imageView) {
            this.mTargetView = imageView;
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... displayResolveInfoArray) {
            DisplayResolveInfo displayResolveInfo = displayResolveInfoArray[0];
            if (displayResolveInfo.displayIcon == null) {
                displayResolveInfo.displayIcon = ResolverActivity.this.loadIconForResolveInfo(displayResolveInfo.ri);
            }
            return displayResolveInfo;
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo displayResolveInfo) {
            this.mTargetView.setImageDrawable(displayResolveInfo.displayIcon);
        }
    }

    class LoadIconTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        LoadIconTask() {
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... displayResolveInfoArray) {
            DisplayResolveInfo displayResolveInfo = displayResolveInfoArray[0];
            if (displayResolveInfo.displayIcon == null) {
                displayResolveInfo.displayIcon = ResolverActivity.this.loadIconForResolveInfo(displayResolveInfo.ri);
            }
            return displayResolveInfo;
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo displayResolveInfo) {
            ResolverActivity.this.mAdapter.notifyDataSetChanged();
        }
    }

    private final class ResolveListAdapter
    extends BaseAdapter {
        private final List<ResolveInfo> mBaseResolveList;
        private boolean mFilterLastUsed;
        private final LayoutInflater mInflater;
        private final Intent[] mInitialIntents;
        private final Intent mIntent;
        private ResolveInfo mLastChosen;
        private int mLastChosenPosition = -1;
        private final int mLaunchedFromUid;
        List<DisplayResolveInfo> mList;
        List<ResolveInfo> mOrigResolveList;

        public ResolveListAdapter(Context context, Intent intent, Intent[] intentArray, List<ResolveInfo> list, int n, boolean bl) {
            this.mIntent = new Intent(intent);
            this.mInitialIntents = intentArray;
            this.mBaseResolveList = list;
            this.mLaunchedFromUid = n;
            this.mInflater = LayoutInflater.from(context);
            this.mList = new ArrayList<DisplayResolveInfo>();
            this.mFilterLastUsed = bl;
            this.rebuildList();
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void bindView(View view, DisplayResolveInfo displayResolveInfo) {
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            viewHolder.text.setText(displayResolveInfo.displayLabel);
            if (ResolverActivity.this.mShowExtended) {
                viewHolder.text2.setVisibility(0);
                viewHolder.text2.setText(displayResolveInfo.extendedInfo);
            } else {
                viewHolder.text2.setVisibility(8);
            }
            if (displayResolveInfo.displayIcon == null) {
                new LoadIconTask().execute(displayResolveInfo);
            }
            viewHolder.icon.setImageDrawable(displayResolveInfo.displayIcon);
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private void processGroup(List<ResolveInfo> list, int n, int n2, ResolveInfo resolveInfo, CharSequence charSequence) {
            boolean bl;
            block11: {
                if (1 + (n2 - n) == 1) {
                    if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(resolveInfo.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(resolveInfo.activityInfo.name)) {
                        this.mLastChosenPosition = this.mList.size();
                    }
                    this.mList.add(new DisplayResolveInfo(resolveInfo, charSequence, null, null));
                    return;
                }
                ResolverActivity.access$202(ResolverActivity.this, true);
                CharSequence charSequence2 = resolveInfo.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                bl = false;
                if (charSequence2 == null) {
                    bl = true;
                }
                if (bl) break block11;
                HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
                hashSet.add(charSequence2);
                int n3 = n + 1;
                while (true) {
                    CharSequence charSequence3;
                    block13: {
                        block12: {
                            if (n3 > n2) break block12;
                            charSequence3 = list.get((int)n3).activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                            if (charSequence3 != null && !hashSet.contains(charSequence3)) break block13;
                            bl = true;
                        }
                        hashSet.clear();
                        break;
                    }
                    hashSet.add(charSequence3);
                    ++n3;
                }
            }
            int n4 = n;
            while (n4 <= n2) {
                ResolveInfo resolveInfo2 = list.get(n4);
                if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(resolveInfo2.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(resolveInfo2.activityInfo.name)) {
                    this.mLastChosenPosition = this.mList.size();
                }
                if (bl) {
                    this.mList.add(new DisplayResolveInfo(resolveInfo2, charSequence, resolveInfo2.activityInfo.packageName, null));
                } else {
                    this.mList.add(new DisplayResolveInfo(resolveInfo2, charSequence, resolveInfo2.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm), null));
                }
                ++n4;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void rebuildList() {
            int n;
            List<ResolveInfo> list;
            try {
                this.mLastChosen = AppGlobals.getPackageManager().getLastChosenActivity(this.mIntent, this.mIntent.resolveTypeIfNeeded(ResolverActivity.this.getContentResolver()), 65536);
            }
            catch (RemoteException remoteException) {
                Log.d(ResolverActivity.TAG, "Error calling setLastChosenActivity\n" + remoteException);
            }
            this.mList.clear();
            if (this.mBaseResolveList != null) {
                list = this.mBaseResolveList;
                this.mOrigResolveList = list;
            } else {
                PackageManager packageManager = ResolverActivity.this.mPm;
                Intent intent = this.mIntent;
                int n2 = this.mFilterLastUsed ? 64 : 0;
                list = packageManager.queryIntentActivities(intent, n2 | 0x10000);
                this.mOrigResolveList = list;
                if (list != null) {
                    for (int i = -1 + list.size(); i >= 0; --i) {
                        ActivityInfo activityInfo = list.get((int)i).activityInfo;
                        if (ActivityManager.checkComponentPermission(activityInfo.permission, this.mLaunchedFromUid, activityInfo.applicationInfo.uid, activityInfo.exported) == 0) continue;
                        if (this.mOrigResolveList == list) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        list.remove(i);
                    }
                }
            }
            if (list != null && (n = list.size()) > 0) {
                ResolveInfo resolveInfo = list.get(0);
                for (int i = 1; i < n; ++i) {
                    ResolveInfo resolveInfo2 = list.get(i);
                    if (resolveInfo.priority == resolveInfo2.priority && resolveInfo.isDefault == resolveInfo2.isDefault) continue;
                    while (i < n) {
                        if (this.mOrigResolveList == list) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        list.remove(i);
                        --n;
                    }
                }
                if (n > 1) {
                    ResolverComparator resolverComparator = new ResolverComparator(ResolverActivity.this);
                    Collections.sort(list, resolverComparator);
                }
                if (this.mInitialIntents != null) {
                    int n3;
                    for (int i = 0; i < (n3 = this.mInitialIntents.length); ++i) {
                        Intent intent = this.mInitialIntents[i];
                        if (intent == null) continue;
                        ActivityInfo activityInfo = intent.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (activityInfo == null) {
                            Log.w(ResolverActivity.TAG, "No activity found for " + intent);
                            continue;
                        }
                        ResolveInfo resolveInfo3 = new ResolveInfo();
                        resolveInfo3.activityInfo = activityInfo;
                        if (intent instanceof LabeledIntent) {
                            LabeledIntent labeledIntent = (LabeledIntent)intent;
                            resolveInfo3.resolvePackageName = labeledIntent.getSourcePackage();
                            resolveInfo3.labelRes = labeledIntent.getLabelResource();
                            resolveInfo3.nonLocalizedLabel = labeledIntent.getNonLocalizedLabel();
                            resolveInfo3.icon = labeledIntent.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(resolveInfo3, resolveInfo3.loadLabel(ResolverActivity.this.getPackageManager()), null, intent));
                    }
                }
                ResolveInfo resolveInfo4 = list.get(0);
                int n4 = 0;
                CharSequence charSequence = resolveInfo4.loadLabel(ResolverActivity.this.mPm);
                ResolverActivity.access$202(ResolverActivity.this, false);
                for (int i = 1; i < n; ++i) {
                    ResolveInfo resolveInfo5;
                    CharSequence charSequence2;
                    if (charSequence == null) {
                        charSequence = resolveInfo4.activityInfo.packageName;
                    }
                    if ((charSequence2 = (resolveInfo5 = list.get(i)).loadLabel(ResolverActivity.this.mPm)) == null) {
                        charSequence2 = resolveInfo5.activityInfo.packageName;
                    }
                    if (charSequence2.equals(charSequence)) continue;
                    this.processGroup(list, n4, i - 1, resolveInfo4, charSequence);
                    resolveInfo4 = resolveInfo5;
                    charSequence = charSequence2;
                    n4 = i;
                }
                this.processGroup(list, n4, n - 1, resolveInfo4, charSequence);
            }
        }

        @Override
        public int getCount() {
            int n = this.mList.size();
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                --n;
            }
            return n;
        }

        public DisplayResolveInfo getFilteredItem() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mList.get(this.mLastChosenPosition);
            }
            return null;
        }

        public int getFilteredPosition() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mLastChosenPosition;
            }
            return -1;
        }

        @Override
        public DisplayResolveInfo getItem(int n) {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && n >= this.mLastChosenPosition) {
                ++n;
            }
            return this.mList.get(n);
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = view;
            if (view2 == null) {
                view2 = this.mInflater.inflate(17367239, viewGroup, false);
                view2.setTag(new ViewHolder(view2));
            }
            this.bindView(view2, this.getItem(n));
            return view2;
        }

        public void handlePackagesChanged() {
            this.getCount();
            this.rebuildList();
            this.notifyDataSetChanged();
            if (this.getCount() == 0) {
                ResolverActivity.this.finish();
            }
        }

        public boolean hasFilteredItem() {
            return this.mFilterLastUsed && this.mLastChosenPosition >= 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Intent intentForPosition(int n, boolean bl) {
            DisplayResolveInfo displayResolveInfo = bl ? this.getItem(n) : this.mList.get(n);
            Intent intent = displayResolveInfo.origIntent != null ? displayResolveInfo.origIntent : ResolverActivity.this.getReplacementIntent(displayResolveInfo.ri.activityInfo.packageName, this.mIntent);
            Intent intent2 = new Intent(intent);
            intent2.addFlags(0x3000000);
            ActivityInfo activityInfo = displayResolveInfo.ri.activityInfo;
            intent2.setComponent(new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name));
            return intent2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ResolveInfo resolveInfoForPosition(int n, boolean bl) {
            DisplayResolveInfo displayResolveInfo;
            if (bl) {
                displayResolveInfo = this.getItem(n);
                return displayResolveInfo.ri;
            }
            displayResolveInfo = this.mList.get(n);
            return displayResolveInfo.ri;
        }
    }

    class ResolverComparator
    implements Comparator<ResolveInfo> {
        private final Collator mCollator;

        public ResolverComparator(Context context) {
            this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        }

        private long getPackageTimeSpent(String string2) {
            UsageStats usageStats;
            if (ResolverActivity.this.mStats != null && (usageStats = (UsageStats)ResolverActivity.this.mStats.get(string2)) != null) {
                return usageStats.getTotalTimeInForeground();
            }
            return 0L;
        }

        @Override
        public int compare(ResolveInfo resolveInfo, ResolveInfo resolveInfo2) {
            CharSequence charSequence;
            long l;
            if (resolveInfo.targetUserId != -2) {
                return 1;
            }
            if (resolveInfo.activityInfo != null && resolveInfo2.activityInfo != null) {
                ApplicationInfo applicationInfo = resolveInfo.activityInfo.applicationInfo;
                ApplicationInfo applicationInfo2 = resolveInfo2.activityInfo.applicationInfo;
                if ((4 & applicationInfo.flagsAsus) > 0 || (8 & applicationInfo.flagsAsus) > (8 & applicationInfo2.flagsAsus)) {
                    return -1;
                }
                if ((4 & applicationInfo2.flagsAsus) > 0 || (8 & applicationInfo.flagsAsus) < (8 & applicationInfo2.flagsAsus)) {
                    return 1;
                }
            }
            if (ResolverActivity.this.mStats != null && (l = this.getPackageTimeSpent(resolveInfo2.activityInfo.packageName) - this.getPackageTimeSpent(resolveInfo.activityInfo.packageName)) != 0L) {
                if (l > 0L) {
                    return 1;
                }
                return -1;
            }
            CharSequence charSequence2 = resolveInfo.loadLabel(ResolverActivity.this.mPm);
            if (charSequence2 == null) {
                charSequence2 = resolveInfo.activityInfo.name;
            }
            if ((charSequence = resolveInfo2.loadLabel(ResolverActivity.this.mPm)) == null) {
                charSequence = resolveInfo2.activityInfo.name;
            }
            return this.mCollator.compare(charSequence2.toString(), charSequence.toString());
        }
    }

    static class ViewHolder {
        public ImageView icon;
        public TextView text;
        public TextView text2;

        public ViewHolder(View view) {
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }
    }
}

