/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.os.Bundle;
import android.os.UserManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class RestrictionsPinActivity
extends AlertActivity
implements View.OnClickListener,
TextWatcher,
TextView.OnEditorActionListener {
    private Button mCancelButton;
    private Runnable mCountdownRunnable = new Runnable(){

        @Override
        public void run() {
            if (RestrictionsPinActivity.this.updatePinTimer(-1)) {
                RestrictionsPinActivity.this.mPinErrorMessage.setVisibility(4);
            }
        }
    };
    protected boolean mHasRestrictionsPin;
    private Button mOkButton;
    protected TextView mPinErrorMessage;
    protected EditText mPinText;
    protected UserManager mUserManager;

    /*
     * Enabled aggressive block sorting
     */
    private boolean updatePinTimer(int n) {
        boolean bl;
        if (n < 0) {
            n = this.mUserManager.checkRestrictionsChallenge(null);
        }
        if (n >= 200) {
            if (n <= 60000) {
                int n2 = (n + 200) / 1000;
                String string2 = this.getResources().getQuantityString(18087960, n2);
                TextView textView = this.mPinErrorMessage;
                Object[] objectArray = new Object[]{n2};
                textView.setText(String.format(string2, objectArray));
            } else {
                this.mPinErrorMessage.setText(17040995);
            }
            bl = false;
            this.mPinErrorMessage.setVisibility(0);
            this.mPinText.setText("");
            this.mPinText.postDelayed(this.mCountdownRunnable, Math.min(1000, n));
        } else {
            bl = true;
            this.mPinErrorMessage.setText(17040988);
        }
        this.mPinText.setEnabled(bl);
        this.setPositiveButtonState(bl);
        return bl;
    }

    @Override
    public void afterTextChanged(Editable editable) {
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    protected void initUi() {
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mTitle = this.getString(17040986);
        alertParams.mView = ((LayoutInflater)this.getSystemService("layout_inflater")).inflate(17367243, null);
        this.mPinErrorMessage = (TextView)alertParams.mView.findViewById(16909222);
        this.mPinText = (EditText)alertParams.mView.findViewById(16909221);
        this.mOkButton = (Button)alertParams.mView.findViewById(16909224);
        this.mCancelButton = (Button)alertParams.mView.findViewById(16909223);
        this.mPinText.addTextChangedListener(this);
        this.mOkButton.setOnClickListener(this);
        this.mCancelButton.setOnClickListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        if (view == this.mOkButton) {
            this.performPositiveButtonAction();
            return;
        } else {
            if (view != this.mCancelButton) return;
            this.setResult(0);
            this.finish();
            return;
        }
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mUserManager = (UserManager)this.getSystemService("user");
        this.mHasRestrictionsPin = this.mUserManager.hasRestrictionsChallenge();
        this.initUi();
        this.setupAlert();
    }

    @Override
    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
        this.performPositiveButtonAction();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onResume() {
        super.onResume();
        this.setPositiveButtonState(false);
        if (this.mUserManager.hasRestrictionsChallenge()) {
            this.mPinErrorMessage.setVisibility(4);
            this.mPinText.setOnEditorActionListener(this);
            this.updatePinTimer(-1);
            return;
        } else {
            if (!this.verifyingPin()) return;
            this.setResult(-1);
            this.finish();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        Editable editable = this.mPinText.getText();
        boolean bl = editable != null && editable.length() >= 4;
        this.setPositiveButtonState(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void performPositiveButtonAction() {
        int n = this.mUserManager.checkRestrictionsChallenge(this.mPinText.getText().toString());
        if (n == -1) {
            this.setResult(-1);
            this.finish();
            return;
        } else {
            if (n < 0) return;
            this.mPinErrorMessage.setText(17040988);
            this.mPinErrorMessage.setVisibility(0);
            this.updatePinTimer(n);
            this.mPinText.setText("");
            return;
        }
    }

    protected void setPositiveButtonState(boolean bl) {
        this.mOkButton.setEnabled(bl);
    }

    protected boolean verifyingPin() {
        return true;
    }
}

