/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;

public class SelectionBuilder {
    private StringBuilder mSelection = new StringBuilder();
    private ArrayList<String> mSelectionArgs = new ArrayList();

    public SelectionBuilder append(String string2, Object ... objectArray) {
        if (TextUtils.isEmpty(string2)) {
            if (objectArray != null && objectArray.length > 0) {
                throw new IllegalArgumentException("Valid selection required when including arguments");
            }
        } else {
            if (this.mSelection.length() > 0) {
                this.mSelection.append(" AND ");
            }
            this.mSelection.append("(").append(string2).append(")");
            if (objectArray != null) {
                for (Object object : objectArray) {
                    this.mSelectionArgs.add(String.valueOf(object));
                }
            }
        }
        return this;
    }

    public int delete(SQLiteDatabase sQLiteDatabase, String string2) {
        return sQLiteDatabase.delete(string2, this.getSelection(), this.getSelectionArgs());
    }

    public String getSelection() {
        return this.mSelection.toString();
    }

    public String[] getSelectionArgs() {
        return this.mSelectionArgs.toArray(new String[this.mSelectionArgs.size()]);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray, String string3) {
        return this.query(sQLiteDatabase, string2, stringArray, null, null, string3, null);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray, String string3, String string4, String string5, String string6) {
        return sQLiteDatabase.query(string2, stringArray, this.getSelection(), this.getSelectionArgs(), string3, string4, string5, string6);
    }

    public SelectionBuilder reset() {
        this.mSelection.setLength(0);
        this.mSelectionArgs.clear();
        return this;
    }

    public int update(SQLiteDatabase sQLiteDatabase, String string2, ContentValues contentValues) {
        return sQLiteDatabase.update(string2, contentValues, this.getSelection(), this.getSelectionArgs());
    }
}

