/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import java.io.PrintStream;

public abstract class BaseCommand {
    public static final String FATAL_ERROR_CODE = "Error type 1";
    public static final String NO_CLASS_ERROR_CODE = "Error type 3";
    public static final String NO_SYSTEM_ERROR_CODE = "Error type 2";
    protected String[] mArgs;
    private String mCurArgData;
    private int mNextArg;

    public String nextArg() {
        if (this.mCurArgData != null) {
            String string2 = this.mCurArgData;
            this.mCurArgData = null;
            return string2;
        }
        if (this.mNextArg < this.mArgs.length) {
            String[] stringArray = this.mArgs;
            int n = this.mNextArg;
            this.mNextArg = n + 1;
            return stringArray[n];
        }
        return null;
    }

    public String nextArgRequired() {
        String string2 = this.nextArg();
        if (string2 == null) {
            String string3 = this.mArgs[-1 + this.mNextArg];
            throw new IllegalArgumentException("Argument expected after \"" + string3 + "\"");
        }
        return string2;
    }

    public String nextOption() {
        if (this.mCurArgData != null) {
            String string2 = this.mArgs[-1 + this.mNextArg];
            throw new IllegalArgumentException("No argument expected after \"" + string2 + "\"");
        }
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String string3 = this.mArgs[this.mNextArg];
        if (!string3.startsWith("-")) {
            return null;
        }
        this.mNextArg = 1 + this.mNextArg;
        if (string3.equals("--")) {
            return null;
        }
        if (string3.length() > 1 && string3.charAt(1) != '-') {
            if (string3.length() > 2) {
                this.mCurArgData = string3.substring(2);
                return string3.substring(0, 2);
            }
            this.mCurArgData = null;
            return string3;
        }
        this.mCurArgData = null;
        return string3;
    }

    public abstract void onRun() throws Exception;

    public abstract void onShowUsage(PrintStream var1);

    public void run(String[] stringArray) {
        if (stringArray.length < 1) {
            this.onShowUsage(System.out);
            return;
        }
        this.mArgs = stringArray;
        this.mNextArg = 0;
        this.mCurArgData = null;
        try {
            this.onRun();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.onShowUsage(System.err);
            System.err.println();
            System.err.println("Error: " + illegalArgumentException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
            return;
        }
    }

    public void showError(String string2) {
        this.onShowUsage(System.err);
        System.err.println();
        System.err.println(string2);
    }

    public void showUsage() {
        this.onShowUsage(System.err);
    }
}

