/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.storage;

import android.app.ProgressDialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Environment;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.util.Log;
import android.widget.Toast;

public class ExternalStorageFormatter
extends Service
implements DialogInterface.OnCancelListener {
    public static final ComponentName COMPONENT_NAME = new ComponentName("android", ExternalStorageFormatter.class.getName());
    public static final String EXTRA_ALWAYS_RESET = "always_reset";
    public static final String FORMAT_AND_ASUS_FACTORY_RESET = "com.android.internal.os.storage.FORMAT_AND_ASUS_FACTORY_RESET";
    public static final String FORMAT_AND_FACTORY_RESET = "com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET";
    public static final String FORMAT_ONLY = "com.android.internal.os.storage.FORMAT_ONLY";
    static final String TAG = "ExternalStorageFormatter";
    private boolean mAlwaysReset = false;
    private boolean mAsusFactoryReset = false;
    private boolean mFactoryReset = false;
    private IMountService mMountService = null;
    private ProgressDialog mProgressDialog = null;
    private String mReason = null;
    StorageEventListener mStorageListener = new StorageEventListener(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onStorageStateChanged(String string2, String string3, String string4) {
            Log.i(ExternalStorageFormatter.TAG, "Received storage state changed notification that " + string2 + " changed state from " + string3 + " to " + string4);
            String string5 = ExternalStorageFormatter.this.mStorageVolume == null ? Environment.MOUNT_POINT_MICROSD : ExternalStorageFormatter.this.mStorageVolume.getPath();
            if (string5.equals(string2)) {
                ExternalStorageFormatter.this.updateProgressState();
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Ignore ").append(string2).append(" since it is not external storage path ");
            String string6 = ExternalStorageFormatter.this.mStorageVolume == null ? Environment.MOUNT_POINT_MICROSD : ExternalStorageFormatter.this.mStorageVolume.getPath();
            Log.i(ExternalStorageFormatter.TAG, stringBuilder.append(string6).toString());
        }
    };
    private StorageManager mStorageManager = null;
    private StorageVolume mStorageVolume;
    private PowerManager.WakeLock mWakeLock;

    void fail(int n) {
        Toast.makeText((Context)this, n, 1).show();
        if (this.mAlwaysReset) {
            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
            intent.addFlags(0x10000000);
            intent.putExtra("android.intent.extra.REASON", this.mReason);
            this.sendBroadcast(intent);
        }
        this.stopSelf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    IMountService getMountService() {
        block4: {
            block3: {
                if (this.mMountService != null) break block3;
                IBinder iBinder = ServiceManager.getService("mount");
                if (iBinder == null) break block4;
                this.mMountService = IMountService.Stub.asInterface(iBinder);
            }
            return this.mMountService;
        }
        Log.e(TAG, "Can't get mount service");
        return this.mMountService;
    }

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCancel(DialogInterface dialogInterface) {
        IMountService iMountService = this.getMountService();
        String string2 = this.mStorageVolume == null ? Environment.MOUNT_POINT_MICROSD : this.mStorageVolume.getPath();
        if (this.mStorageManager != null) {
            this.mStorageManager.unregisterListener(this.mStorageListener);
        }
        try {
            iMountService.mountVolume(string2);
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with mount service", remoteException);
        }
        this.stopSelf();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        if (this.mStorageManager == null) {
            this.mStorageManager = (StorageManager)this.getSystemService("storage");
            this.mStorageManager.registerListener(this.mStorageListener);
        }
        this.mWakeLock = ((PowerManager)this.getSystemService("power")).newWakeLock(1, TAG);
        this.mWakeLock.acquire();
    }

    @Override
    public void onDestroy() {
        if (this.mStorageManager != null) {
            this.mStorageManager.unregisterListener(this.mStorageListener);
        }
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
        this.mWakeLock.release();
        super.onDestroy();
    }

    @Override
    public int onStartCommand(Intent intent, int n, int n2) {
        if (FORMAT_AND_FACTORY_RESET.equals(intent.getAction())) {
            this.mFactoryReset = true;
        }
        if (intent.getBooleanExtra(EXTRA_ALWAYS_RESET, false)) {
            this.mAlwaysReset = true;
        }
        this.mReason = intent.getStringExtra("android.intent.extra.REASON");
        this.mStorageVolume = (StorageVolume)intent.getParcelableExtra("storage_volume");
        if (FORMAT_AND_ASUS_FACTORY_RESET.equals(intent.getAction())) {
            this.mAsusFactoryReset = true;
        }
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.getWindow().setType(2003);
            if (!this.mAlwaysReset) {
                this.mProgressDialog.setOnCancelListener(this);
            }
            this.updateProgressState();
            this.mProgressDialog.show();
        }
        return 3;
    }

    public void updateProgressDialog(int n) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.getWindow().setType(2003);
            this.mProgressDialog.show();
        }
        this.mProgressDialog.setMessage(this.getText(n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateProgressState() {
        boolean bl = true;
        String string2 = this.mStorageVolume == null ? Environment.getSecondaryExternalStorageState() : this.mStorageManager.getVolumeState(this.mStorageVolume.getPath());
        if ("mounted".equals(string2) || "mounted_ro".equals(string2)) {
            this.updateProgressDialog(17040724);
            IMountService iMountService = this.getMountService();
            String string3 = this.mStorageVolume == null ? Environment.MOUNT_POINT_MICROSD : this.mStorageVolume.getPath();
            try {
                if (!this.mFactoryReset && !this.mAsusFactoryReset) {
                    bl = false;
                }
                iMountService.unmountVolume(string3, true, bl);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with mount service", remoteException);
                return;
            }
        }
        if ("nofs".equals(string2) || "unmounted".equals(string2) || "unmountable".equals(string2)) {
            this.updateProgressDialog(17040725);
            final IMountService iMountService = this.getMountService();
            final String string4 = this.mStorageVolume == null ? Environment.MOUNT_POINT_MICROSD : this.mStorageVolume.getPath();
            if (iMountService != null) {
                new Thread(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        boolean bl;
                        try {
                            iMountService.formatVolume(string4);
                            bl = true;
                        }
                        catch (Exception exception) {
                            Toast.makeText((Context)ExternalStorageFormatter.this, 17040726, 1).show();
                            bl = false;
                        }
                        if (bl) {
                            if (ExternalStorageFormatter.this.mAsusFactoryReset) {
                                Log.d(ExternalStorageFormatter.TAG, "Run Asus Factory Reset Scripts!!");
                                ExternalStorageFormatter.this.stopSelf();
                                ((PowerManager)ExternalStorageFormatter.this.getSystemService("power")).reboot("factory reset for asus_init_exec");
                                return;
                            }
                            if (ExternalStorageFormatter.this.mFactoryReset) {
                                Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                                intent.addFlags(0x10000000);
                                intent.putExtra("android.intent.extra.REASON", ExternalStorageFormatter.this.mReason);
                                ExternalStorageFormatter.this.sendBroadcast(intent);
                                ExternalStorageFormatter.this.stopSelf();
                                return;
                            }
                        }
                        if (!bl && ExternalStorageFormatter.this.mAlwaysReset) {
                            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                            intent.addFlags(0x10000000);
                            intent.putExtra("android.intent.extra.REASON", ExternalStorageFormatter.this.mReason);
                            ExternalStorageFormatter.this.sendBroadcast(intent);
                        } else {
                            try {
                                iMountService.mountVolume(string4);
                            }
                            catch (RemoteException remoteException) {
                                Log.w(ExternalStorageFormatter.TAG, "Failed talking with mount service", remoteException);
                            }
                        }
                        ExternalStorageFormatter.this.stopSelf();
                    }
                }.start();
                return;
            }
            Log.w(TAG, "Unable to locate IMountService");
            return;
        }
        if ("bad_removal".equals(string2)) {
            this.fail(17040727);
            return;
        }
        if ("checking".equals(string2)) {
            this.fail(17040728);
            return;
        }
        if ("removed".equals(string2)) {
            this.fail(17040729);
            return;
        }
        if ("shared".equals(string2)) {
            this.fail(17040730);
            return;
        }
        this.fail(17040731);
        Log.w(TAG, "Unknown storage state: " + string2);
        this.stopSelf();
    }
}

