/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.location.Country;
import android.location.CountryDetector;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import com.android.internal.telephony.CallerInfoAsyncQuery;
import java.util.Locale;

public class CallerInfo {
    private static final String TAG = "CallerInfo";
    private static final boolean VDBG = Rlog.isLoggable("CallerInfo", 2);
    public Drawable cachedPhoto;
    public Bitmap cachedPhotoIcon;
    public String cnapName;
    public Uri contactDisplayPhotoUri;
    public boolean contactExists;
    public long contactIdOrZero;
    public Uri contactRefUri;
    public Uri contactRingtoneUri;
    public String geoDescription;
    public boolean isCachedPhotoCurrent;
    public String lookupKey;
    private boolean mIsEmergency = false;
    private boolean mIsVoiceMail = false;
    public String name;
    public int namePresentation;
    public boolean needUpdate;
    public String normalizedNumber;
    public String numberLabel;
    public int numberPresentation;
    public int numberType;
    public String phoneLabel;
    public String phoneNumber;
    public int photoResource;
    public boolean shouldSendToVoicemail;

    static CallerInfo doSecondaryLookupIfNecessary(Context context, String string2, CallerInfo callerInfo) {
        String string3;
        if (!callerInfo.contactExists && PhoneNumberUtils.isUriNumber(string2) && PhoneNumberUtils.isGlobalPhoneNumber(string3 = PhoneNumberUtils.getUsernameFromUriNumber(string2))) {
            callerInfo = CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI, Uri.encode(string3)));
        }
        return callerInfo;
    }

    public static CallerInfo getCallerInfo(Context context, Uri uri) {
        return CallerInfo.getCallerInfo(context, uri, CallerInfoAsyncQuery.getCurrentProfileContentResolver(context).query(uri, null, null, null, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CallerInfo getCallerInfo(Context context, Uri uri, Cursor cursor) {
        CallerInfo callerInfo;
        block8: {
            block9: {
                int n;
                int n2;
                block11: {
                    block10: {
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        int n7;
                        callerInfo = new CallerInfo();
                        callerInfo.photoResource = 0;
                        callerInfo.phoneLabel = null;
                        callerInfo.numberType = 0;
                        callerInfo.numberLabel = null;
                        callerInfo.cachedPhoto = null;
                        callerInfo.isCachedPhotoCurrent = false;
                        callerInfo.contactExists = false;
                        if (VDBG) {
                            Rlog.v(TAG, "getCallerInfo() based on cursor...");
                        }
                        if (cursor == null) break block8;
                        if (!cursor.moveToFirst()) break block9;
                        int n8 = cursor.getColumnIndex("display_name");
                        if (n8 != -1) {
                            callerInfo.name = cursor.getString(n8);
                        }
                        if ((n7 = cursor.getColumnIndex("number")) != -1) {
                            callerInfo.phoneNumber = cursor.getString(n7);
                        }
                        if ((n6 = cursor.getColumnIndex("normalized_number")) != -1) {
                            callerInfo.normalizedNumber = cursor.getString(n6);
                        }
                        if ((n5 = cursor.getColumnIndex("label")) != -1 && (n4 = cursor.getColumnIndex("type")) != -1) {
                            callerInfo.numberType = cursor.getInt(n4);
                            callerInfo.numberLabel = cursor.getString(n5);
                            callerInfo.phoneLabel = ContactsContract.CommonDataKinds.Phone.getDisplayLabel(context, callerInfo.numberType, callerInfo.numberLabel).toString();
                        }
                        if ((n3 = CallerInfo.getColumnIndexForPersonId(uri, cursor)) == -1) break block10;
                        long l = cursor.getLong(n3);
                        if (l != 0L && !ContactsContract.Contacts.isEnterpriseContactId(l)) {
                            callerInfo.contactIdOrZero = l;
                            if (VDBG) {
                                Rlog.v(TAG, "==> got info.contactIdOrZero: " + callerInfo.contactIdOrZero);
                            }
                        }
                        break block11;
                    }
                    Rlog.w(TAG, "Couldn't find contact_id column for " + uri);
                }
                if ((n2 = cursor.getColumnIndex("lookup")) != -1) {
                    callerInfo.lookupKey = cursor.getString(n2);
                }
                callerInfo.contactDisplayPhotoUri = (n = cursor.getColumnIndex("photo_uri")) != -1 && cursor.getString(n) != null ? Uri.parse(cursor.getString(n)) : null;
                int n9 = cursor.getColumnIndex("custom_ringtone");
                callerInfo.contactRingtoneUri = n9 != -1 && cursor.getString(n9) != null ? Uri.parse(cursor.getString(n9)) : null;
                int n10 = cursor.getColumnIndex("send_to_voicemail");
                boolean bl = n10 != -1 && cursor.getInt(n10) == 1;
                callerInfo.shouldSendToVoicemail = bl;
                callerInfo.contactExists = true;
            }
            cursor.close();
        }
        callerInfo.needUpdate = false;
        callerInfo.name = CallerInfo.normalize(callerInfo.name);
        callerInfo.contactRefUri = uri;
        return callerInfo;
    }

    public static CallerInfo getCallerInfo(Context context, String string2) {
        if (VDBG) {
            Rlog.v(TAG, "getCallerInfo() based on number...");
        }
        return CallerInfo.getCallerInfo(context, string2, SubscriptionManager.getDefaultSubId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallerInfo getCallerInfo(Context context, String string2, long l) {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(context, string2)) {
            return new CallerInfo().markAsEmergency(context);
        }
        if (PhoneNumberUtils.isVoiceMailNumber(l, string2)) {
            return new CallerInfo().markAsVoiceMail();
        }
        CallerInfo callerInfo = CallerInfo.doSecondaryLookupIfNecessary(context, string2, CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI, Uri.encode(string2))));
        if (!TextUtils.isEmpty(callerInfo.phoneNumber)) return callerInfo;
        callerInfo.phoneNumber = string2;
        return callerInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getColumnIndexForPersonId(Uri uri, Cursor cursor) {
        String string2;
        String string3;
        if (VDBG) {
            Rlog.v(TAG, "- getColumnIndexForPersonId: contactRef URI = '" + uri + "'...");
        }
        if ((string3 = uri.toString()).startsWith("content://com.android.contacts/data/phones")) {
            if (VDBG) {
                Rlog.v(TAG, "'data/phones' URI; using RawContacts.CONTACT_ID");
            }
            string2 = "contact_id";
        } else if (string3.startsWith("content://com.android.contacts/data")) {
            if (VDBG) {
                Rlog.v(TAG, "'data' URI; using Data.CONTACT_ID");
            }
            string2 = "contact_id";
        } else if (string3.startsWith("content://com.android.contacts/phone_lookup")) {
            if (VDBG) {
                Rlog.v(TAG, "'phone_lookup' URI; using PhoneLookup._ID");
            }
            string2 = "_id";
        } else {
            Rlog.w(TAG, "Unexpected prefix for contactRef '" + string3 + "'");
            string2 = null;
        }
        int n = string2 != null ? cursor.getColumnIndex(string2) : -1;
        if (VDBG) {
            Rlog.v(TAG, "==> Using column '" + string2 + "' (columnIndex = " + n + ") for person_id lookup...");
        }
        return n;
    }

    protected static String getCurrentCountryIso(Context context) {
        return CallerInfo.getCurrentCountryIso(context, Locale.getDefault());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getCurrentCountryIso(Context context, Locale locale) {
        CountryDetector countryDetector = (CountryDetector)context.getSystemService("country_detector");
        String string2 = null;
        if (countryDetector != null) {
            Country country = countryDetector.detectCountry();
            if (country != null) {
                string2 = country.getCountryIso();
            } else {
                Rlog.e(TAG, "CountryDetector.detectCountry() returned null.");
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = locale.getCountry();
            Rlog.w(TAG, "No CountryDetector; falling back to countryIso based on locale: " + string2);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getGeoDescription(Context context, String string2) {
        String string3;
        block10: {
            block9: {
                if (VDBG) {
                    Rlog.v(TAG, "getGeoDescription('" + string2 + "')...");
                }
                boolean bl = TextUtils.isEmpty(string2);
                string3 = null;
                if (bl) break block9;
                PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
                PhoneNumberOfflineGeocoder phoneNumberOfflineGeocoder = PhoneNumberOfflineGeocoder.getInstance();
                Locale locale = context.getResources().getConfiguration().locale;
                String string4 = CallerInfo.getCurrentCountryIso(context, locale);
                Phonenumber.PhoneNumber phoneNumber = null;
                try {
                    if (VDBG) {
                        Rlog.v(TAG, "parsing '" + string2 + "' for countryIso '" + string4 + "'...");
                    }
                    phoneNumber = phoneNumberUtil.parse(string2, string4);
                    if (VDBG) {
                        Rlog.v(TAG, "- parsed number: " + phoneNumber);
                    }
                }
                catch (NumberParseException numberParseException) {
                    Rlog.w(TAG, "getGeoDescription: NumberParseException for incoming number '" + string2 + "'");
                }
                string3 = null;
                if (phoneNumber == null) break block9;
                string3 = phoneNumberOfflineGeocoder.getDescriptionForNumber(phoneNumber, locale);
                if (VDBG) break block10;
            }
            return string3;
        }
        Rlog.v(TAG, "- got description: '" + string3 + "'");
        return string3;
    }

    private static String normalize(String string2) {
        if (string2 == null || string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public boolean isEmergencyNumber() {
        return this.mIsEmergency;
    }

    public boolean isVoiceMailNumber() {
        return this.mIsVoiceMail;
    }

    CallerInfo markAsEmergency(Context context) {
        this.phoneNumber = context.getString(17040239);
        this.photoResource = 17303078;
        this.mIsEmergency = true;
        return this;
    }

    CallerInfo markAsVoiceMail() {
        return this.markAsVoiceMail(SubscriptionManager.getDefaultSubId());
    }

    CallerInfo markAsVoiceMail(long l) {
        this.mIsVoiceMail = true;
        try {
            this.phoneNumber = TelephonyManager.getDefault().getVoiceMailAlphaTag(l);
            return this;
        }
        catch (SecurityException securityException) {
            Rlog.e(TAG, "Cannot access VoiceMail.", securityException);
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(128).append(super.toString() + " { ");
        StringBuilder stringBuilder2 = new StringBuilder().append("name ");
        String string3 = this.name == null ? "null" : "non-null";
        StringBuilder stringBuilder3 = stringBuilder.append(stringBuilder2.append(string3).toString());
        StringBuilder stringBuilder4 = new StringBuilder().append(", phoneNumber ");
        if (this.phoneNumber == null) {
            string2 = "null";
            return stringBuilder3.append(stringBuilder4.append(string2).toString()).append(" }").toString();
        }
        string2 = "non-null";
        return stringBuilder3.append(stringBuilder4.append(string2).toString()).append(" }").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateGeoDescription(Context context, String string2) {
        String string3 = TextUtils.isEmpty(this.phoneNumber) ? string2 : this.phoneNumber;
        this.geoDescription = CallerInfo.getGeoDescription(context, string3);
    }
}

