/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.FileUtils;
import com.android.internal.util.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class FileRotator {
    private static final boolean LOGD = false;
    private static final String SUFFIX_BACKUP = ".backup";
    private static final String SUFFIX_NO_BACKUP = ".no_backup";
    private static final String TAG = "FileRotator";
    private final File mBasePath;
    private final long mDeleteAgeMillis;
    private final String mPrefix;
    private final long mRotateAgeMillis;

    /*
     * Enabled aggressive block sorting
     */
    public FileRotator(File file, String string2, long l, long l2) {
        this.mBasePath = Preconditions.checkNotNull(file);
        this.mPrefix = Preconditions.checkNotNull(string2);
        this.mRotateAgeMillis = l;
        this.mDeleteAgeMillis = l2;
        this.mBasePath.mkdirs();
        String[] stringArray = this.mBasePath.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            if (string3.startsWith(this.mPrefix)) {
                if (string3.endsWith(SUFFIX_BACKUP)) {
                    new File(this.mBasePath, string3).renameTo(new File(this.mBasePath, string3.substring(0, string3.length() - SUFFIX_BACKUP.length())));
                } else if (string3.endsWith(SUFFIX_NO_BACKUP)) {
                    File file2 = new File(this.mBasePath, string3);
                    File file3 = new File(this.mBasePath, string3.substring(0, string3.length() - SUFFIX_NO_BACKUP.length()));
                    file2.delete();
                    file3.delete();
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getActiveName(long l) {
        String string2 = null;
        long l2 = Long.MAX_VALUE;
        FileInfo fileInfo = new FileInfo(this.mPrefix);
        for (String string3 : this.mBasePath.list()) {
            if (!fileInfo.parse(string3) || !fileInfo.isActive() || fileInfo.startMillis >= l || fileInfo.startMillis >= l2) continue;
            string2 = string3;
            l2 = fileInfo.startMillis;
        }
        if (string2 != null) {
            return string2;
        }
        fileInfo.startMillis = l;
        fileInfo.endMillis = Long.MAX_VALUE;
        return fileInfo.build();
    }

    private static void readFile(File file, Reader reader) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            reader.read(bufferedInputStream);
            return;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)bufferedInputStream);
        }
    }

    private static IOException rethrowAsIoException(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new IOException(throwable.getMessage(), throwable);
    }

    private void rewriteSingle(Rewriter rewriter, String string2) throws IOException {
        File file = new File(this.mBasePath, string2);
        rewriter.reset();
        if (file.exists()) {
            FileRotator.readFile(file, rewriter);
            if (!rewriter.shouldWrite()) {
                return;
            }
            File file2 = new File(this.mBasePath, string2 + SUFFIX_BACKUP);
            file.renameTo(file2);
            try {
                FileRotator.writeFile(file, rewriter);
                file2.delete();
                return;
            }
            catch (Throwable throwable) {
                file.delete();
                file2.renameTo(file);
                throw FileRotator.rethrowAsIoException(throwable);
            }
        }
        File file3 = new File(this.mBasePath, string2 + SUFFIX_NO_BACKUP);
        file3.createNewFile();
        try {
            FileRotator.writeFile(file, rewriter);
            file3.delete();
            return;
        }
        catch (Throwable throwable) {
            file.delete();
            file3.delete();
            throw FileRotator.rethrowAsIoException(throwable);
        }
    }

    private static void writeFile(File file, Writer writer) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            writer.write(bufferedOutputStream);
            bufferedOutputStream.flush();
            return;
        }
        finally {
            FileUtils.sync(fileOutputStream);
            IoUtils.closeQuietly((AutoCloseable)bufferedOutputStream);
        }
    }

    @Deprecated
    public void combineActive(final Reader reader, final Writer writer, long l) throws IOException {
        this.rewriteActive(new Rewriter(){

            @Override
            public void read(InputStream inputStream) throws IOException {
                reader.read(inputStream);
            }

            @Override
            public void reset() {
            }

            @Override
            public boolean shouldWrite() {
                return true;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                writer.write(outputStream);
            }
        }, l);
    }

    public void deleteAll() {
        FileInfo fileInfo = new FileInfo(this.mPrefix);
        for (String string2 : this.mBasePath.list()) {
            if (!fileInfo.parse(string2)) continue;
            new File(this.mBasePath, string2).delete();
        }
    }

    /*
     * Loose catch block
     */
    public void dumpAll(OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        FileInfo fileInfo = new FileInfo(this.mPrefix);
        String[] stringArray = this.mBasePath.list();
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block8: {
                block9: {
                    if (n2 >= n) break block9;
                    String string2 = stringArray[n2];
                    if (!fileInfo.parse(string2)) break block8;
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                    FileInputStream fileInputStream = new FileInputStream(new File(this.mBasePath, string2));
                    {
                        catch (Throwable throwable) {
                            IoUtils.closeQuietly((AutoCloseable)zipOutputStream);
                            throw throwable;
                        }
                    }
                    Streams.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                    IoUtils.closeQuietly((AutoCloseable)fileInputStream);
                    zipOutputStream.closeEntry();
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly((AutoCloseable)fileInputStream);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly((AutoCloseable)zipOutputStream);
                return;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void maybeRotate(long l) {
        long l2 = l - this.mRotateAgeMillis;
        long l3 = l - this.mDeleteAgeMillis;
        FileInfo fileInfo = new FileInfo(this.mPrefix);
        String[] stringArray = this.mBasePath.list();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!fileInfo.parse(string2)) continue;
                if (fileInfo.isActive()) {
                    if (fileInfo.startMillis > l2) continue;
                    fileInfo.endMillis = l;
                    new File(this.mBasePath, string2).renameTo(new File(this.mBasePath, fileInfo.build()));
                    continue;
                }
                if (fileInfo.endMillis > l3) continue;
                new File(this.mBasePath, string2).delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readMatching(Reader reader, long l, long l2) throws IOException {
        FileInfo fileInfo = new FileInfo(this.mPrefix);
        String[] stringArray = this.mBasePath.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (fileInfo.parse(string2) && fileInfo.startMillis <= l2 && l <= fileInfo.endMillis) {
                FileRotator.readFile(new File(this.mBasePath, string2), reader);
            }
            ++n2;
        }
        return;
    }

    public void rewriteActive(Rewriter rewriter, long l) throws IOException {
        this.rewriteSingle(rewriter, this.getActiveName(l));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void rewriteAll(Rewriter rewriter) throws IOException {
        FileInfo fileInfo = new FileInfo(this.mPrefix);
        String[] stringArray = this.mBasePath.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (fileInfo.parse(string2)) {
                this.rewriteSingle(rewriter, string2);
            }
            ++n2;
        }
        return;
    }

    private static class FileInfo {
        public long endMillis;
        public final String prefix;
        public long startMillis;

        public FileInfo(String string2) {
            this.prefix = Preconditions.checkNotNull(string2);
        }

        public String build() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.prefix).append('.').append(this.startMillis).append('-');
            if (this.endMillis != Long.MAX_VALUE) {
                stringBuilder.append(this.endMillis);
            }
            return stringBuilder.toString();
        }

        public boolean isActive() {
            return this.endMillis == Long.MAX_VALUE;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean parse(String string2) {
            this.endMillis = -1L;
            this.startMillis = -1L;
            int n = string2.lastIndexOf(46);
            int n2 = string2.lastIndexOf(45);
            if (n == -1) return false;
            if (n2 == -1) {
                return false;
            }
            if (!this.prefix.equals(string2.substring(0, n))) return false;
            int n3 = n + 1;
            try {
                this.startMillis = Long.parseLong(string2.substring(n3, n2));
                if (string2.length() - n2 == 1) {
                    this.endMillis = Long.MAX_VALUE;
                    return true;
                }
                this.endMillis = Long.parseLong(string2.substring(n2 + 1));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    public static interface Reader {
        public void read(InputStream var1) throws IOException;
    }

    public static interface Rewriter
    extends Reader,
    Writer {
        public void reset();

        public boolean shouldWrite();
    }

    public static interface Writer {
        public void write(OutputStream var1) throws IOException;
    }
}

