/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ImageUtils;
import java.util.Arrays;
import java.util.WeakHashMap;

public class NotificationColorUtil {
    private static final String TAG = "NotificationColorUtil";
    private static NotificationColorUtil sInstance;
    private static final Object sLock;
    private final WeakHashMap<Bitmap, Pair<Boolean, Integer>> mGrayscaleBitmapCache;
    private final int mGrayscaleIconMaxSize;
    private final ImageUtils mImageUtils = new ImageUtils();

    static {
        sLock = new Object();
    }

    private NotificationColorUtil(Context context) {
        this.mGrayscaleBitmapCache = new WeakHashMap();
        this.mGrayscaleIconMaxSize = context.getResources().getDimensionPixelSize(0x1050005);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NotificationColorUtil getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance != null) return sInstance;
            sInstance = new NotificationColorUtil(context);
            return sInstance;
        }
    }

    private int processColor(int n) {
        return Color.argb(Color.alpha(n), 255 - Color.red(n), 255 - Color.green(n), 255 - Color.blue(n));
    }

    private TextAppearanceSpan processTextAppearanceSpan(TextAppearanceSpan textAppearanceSpan) {
        ColorStateList colorStateList = textAppearanceSpan.getTextColor();
        if (colorStateList != null) {
            int[] nArray = colorStateList.getColors();
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (!ImageUtils.isGrayscale(nArray[i])) continue;
                if (!bl) {
                    nArray = Arrays.copyOf(nArray, nArray.length);
                }
                nArray[i] = this.processColor(nArray[i]);
                bl = true;
            }
            if (bl) {
                return new TextAppearanceSpan(textAppearanceSpan.getFamily(), textAppearanceSpan.getTextStyle(), textAppearanceSpan.getTextSize(), new ColorStateList(colorStateList.getStates(), nArray), textAppearanceSpan.getLinkTextColor());
            }
        }
        return textAppearanceSpan;
    }

    public CharSequence invertCharSequenceColors(CharSequence charSequence) {
        CharSequence charSequence2;
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(0, spanned.length(), Object.class);
            charSequence2 = new SpannableStringBuilder(spanned.toString());
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = object = objectArray[i];
                if (object instanceof TextAppearanceSpan) {
                    object2 = this.processTextAppearanceSpan((TextAppearanceSpan)object);
                }
                ((SpannableStringBuilder)charSequence2).setSpan(object2, spanned.getSpanStart(object), spanned.getSpanEnd(object), spanned.getSpanFlags(object));
            }
        } else {
            charSequence2 = charSequence;
        }
        return charSequence2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isGrayscaleIcon(Context context, int n) {
        boolean bl = false;
        if (n == 0) return bl;
        try {
            boolean bl2 = this.isGrayscaleIcon(context.getDrawable(n));
            return bl2;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e(TAG, "Drawable not found: " + n);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isGrayscaleIcon(Bitmap bitmap) {
        int n;
        boolean bl;
        if (bitmap.getWidth() > this.mGrayscaleIconMaxSize) return false;
        if (bitmap.getHeight() > this.mGrayscaleIconMaxSize) {
            return false;
        }
        Object object = sLock;
        synchronized (object) {
            Pair<Boolean, Integer> pair = this.mGrayscaleBitmapCache.get(bitmap);
            if (pair != null && ((Integer)pair.second).intValue() == bitmap.getGenerationId()) {
                return (Boolean)pair.first;
            }
        }
        ImageUtils imageUtils = this.mImageUtils;
        synchronized (imageUtils) {
            bl = this.mImageUtils.isGrayscale(bitmap);
            n = bitmap.getGenerationId();
        }
        Object object2 = sLock;
        synchronized (object2) {
            this.mGrayscaleBitmapCache.put(bitmap, Pair.create(bl, n));
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isGrayscaleIcon(Drawable drawable2) {
        boolean bl = true;
        if (drawable2 == null) {
            return false;
        }
        if (drawable2 instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            if (bitmapDrawable.getBitmap() == null) return false;
            if (this.isGrayscaleIcon(bitmapDrawable.getBitmap())) return bl;
            return false;
        }
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            if (animationDrawable.getNumberOfFrames() <= 0) return false;
            if (this.isGrayscaleIcon(animationDrawable.getFrame(0))) return bl;
            return false;
        }
        if (drawable2 instanceof VectorDrawable) return bl;
        return false;
    }
}

