/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.animation;

import android.animation.TimeInterpolator;
import android.view.Choreographer;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class FallbackLUTInterpolator
implements NativeInterpolatorFactory,
TimeInterpolator {
    private final float[] mLut;
    private TimeInterpolator mSourceInterpolator;

    public FallbackLUTInterpolator(TimeInterpolator timeInterpolator, long l) {
        this.mSourceInterpolator = timeInterpolator;
        this.mLut = FallbackLUTInterpolator.createLUT(timeInterpolator, l);
    }

    private static float[] createLUT(TimeInterpolator timeInterpolator, long l) {
        int n = (int)Math.ceil(l / (long)((int)(Choreographer.getInstance().getFrameIntervalNanos() / 1000000L)));
        float[] fArray = new float[n];
        float f = n - 1;
        for (int i = 0; i < n; ++i) {
            fArray[i] = timeInterpolator.getInterpolation((float)i / f);
        }
        return fArray;
    }

    public static long createNativeInterpolator(TimeInterpolator timeInterpolator, long l) {
        return NativeInterpolatorFactoryHelper.createLutInterpolator(FallbackLUTInterpolator.createLUT(timeInterpolator, l));
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createLutInterpolator(this.mLut);
    }

    @Override
    public float getInterpolation(float f) {
        return this.mSourceInterpolator.getInterpolation(f);
    }
}

