/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.IPackageManager;
import android.os.Build;
import android.os.DropBoxManager;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Downloads;
import android.util.Slog;
import java.io.File;
import java.io.IOException;

public class BootReceiver
extends BroadcastReceiver {
    private static final int LOG_SIZE = 0;
    private static final String OLD_UPDATER_CLASS = "com.google.android.systemupdater.SystemUpdateReceiver";
    private static final String OLD_UPDATER_PACKAGE = "com.google.android.systemupdater";
    private static final String TAG = "BootReceiver";
    private static final File TOMBSTONE_DIR;
    private static FileObserver sTombstoneObserver;

    /*
     * Enabled aggressive block sorting
     */
    static {
        int n = SystemProperties.getInt("ro.debuggable", 0) == 1 ? 98304 : 65536;
        LOG_SIZE = n;
        TOMBSTONE_DIR = new File("/data/tombstones");
        sTombstoneObserver = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addAuditErrorsToDropBox(DropBoxManager dropBoxManager, SharedPreferences sharedPreferences, String string2, int n, String string3) throws IOException {
        File file;
        block8: {
            long l;
            block9: {
                block7: {
                    if (dropBoxManager == null || !dropBoxManager.isTagEnabled(string3)) break block7;
                    Slog.i(TAG, "Copying audit failures to DropBox");
                    file = new File("/proc/last_kmsg");
                    l = file.lastModified();
                    if (l <= 0L) {
                        file = new File("/sys/fs/pstore/console-ramoops");
                        l = file.lastModified();
                    }
                    if (l <= 0L) break block7;
                    if (sharedPreferences == null) break block8;
                    if (sharedPreferences.getLong(string3, 0L) != l) break block9;
                }
                return;
            }
            sharedPreferences.edit().putLong(string3, l).apply();
        }
        String string4 = FileUtils.readTextFile(file, n, "[[TRUNCATED]]\n");
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string4.split("\n");
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                Slog.i(TAG, "Copied " + stringBuilder.toString().length() + " worth of audits to DropBox");
                dropBoxManager.addText(string3, string2 + stringBuilder.toString());
                return;
            }
            String string5 = stringArray[n3];
            if (string5.contains("audit")) {
                stringBuilder.append(string5 + "\n");
            }
            ++n3;
        }
    }

    private static void addFileToDropBox(DropBoxManager dropBoxManager, SharedPreferences sharedPreferences, String string2, String string3, int n, String string4) throws IOException {
        BootReceiver.addFileWithFootersToDropBox(dropBoxManager, sharedPreferences, string2, "", string3, n, string4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addFileWithFootersToDropBox(DropBoxManager dropBoxManager, SharedPreferences sharedPreferences, String string2, String string3, String string4, int n, String string5) throws IOException {
        File file;
        block3: {
            long l;
            block4: {
                block2: {
                    if (dropBoxManager == null || !dropBoxManager.isTagEnabled(string5) || (l = (file = new File(string4)).lastModified()) <= 0L) break block2;
                    if (sharedPreferences == null) break block3;
                    if (sharedPreferences.getLong(string4, 0L) != l) break block4;
                }
                return;
            }
            sharedPreferences.edit().putLong(string4, l).apply();
        }
        Slog.i(TAG, "Copying " + string4 + " to DropBox (" + string5 + ")");
        dropBoxManager.addText(string5, string2 + FileUtils.readTextFile(file, n, "[[TRUNCATED]]\n") + string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addFsckErrorsToDropBox(DropBoxManager dropBoxManager, SharedPreferences sharedPreferences, String string2, int n, String string3) throws IOException {
        File file;
        block9: {
            block8: {
                if (dropBoxManager == null || !dropBoxManager.isTagEnabled(string3)) break block8;
                Slog.i(TAG, "Checking for fsck errors");
                file = new File("/dev/fscklogs/log");
                if (file.lastModified() > 0L) break block9;
            }
            return;
        }
        String string4 = FileUtils.readTextFile(file, n, "[[TRUNCATED]]\n");
        new StringBuilder();
        String[] stringArray = string4.split("\n");
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            block11: {
                boolean bl;
                block10: {
                    bl = false;
                    if (n3 >= n2) break block10;
                    if (!stringArray[n3].contains("FILE SYSTEM WAS MODIFIED")) break block11;
                    bl = true;
                }
                if (bl) {
                    BootReceiver.addFileToDropBox(dropBoxManager, sharedPreferences, string2, "/dev/fscklogs/log", n, string3);
                }
                file.delete();
                return;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void logBootEvents(Context context) throws IOException {
        final DropBoxManager dropBoxManager = (DropBoxManager)context.getSystemService("dropbox");
        final SharedPreferences sharedPreferences = context.getSharedPreferences("log_files", 0);
        final String string2 = new StringBuilder(512).append("Build: ").append(Build.FINGERPRINT).append("\n").append("Hardware: ").append(Build.BOARD).append("\n").append("Revision: ").append(SystemProperties.get("ro.revision", "")).append("\n").append("Bootloader: ").append(Build.BOOTLOADER).append("\n").append("Radio: ").append(Build.RADIO).append("\n").append("Kernel: ").append(FileUtils.readTextFile(new File("/proc/version"), 1024, "...\n")).append("\n").toString();
        String string3 = SystemProperties.get("ro.boot.bootreason", null);
        String string4 = RecoverySystem.handleAftermath();
        if (string4 != null && dropBoxManager != null) {
            dropBoxManager.addText("SYSTEM_RECOVERY_LOG", string2 + string4);
        }
        String string5 = "";
        if (string3 != null) {
            string5 = new StringBuilder(512).append("\n").append("Boot info:\n").append("Last boot reason: ").append(string3).append("\n").toString();
        }
        if (SystemProperties.getLong("ro.runtime.firstboot", 0L) == 0L) {
            if (!"encrypted".equals(SystemProperties.get("ro.crypto.state")) || !"trigger_restart_min_framework".equals(SystemProperties.get("vold.decrypt"))) {
                SystemProperties.set("ro.runtime.firstboot", Long.toString(System.currentTimeMillis()));
            }
            if (dropBoxManager != null) {
                dropBoxManager.addText("SYSTEM_BOOT", string2);
            }
            BootReceiver.addFileWithFootersToDropBox(dropBoxManager, sharedPreferences, string2, string5, "/proc/last_kmsg", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileWithFootersToDropBox(dropBoxManager, sharedPreferences, string2, string5, "/sys/fs/pstore/console-ramoops", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileToDropBox(dropBoxManager, sharedPreferences, string2, "/cache/recovery/log", -LOG_SIZE, "SYSTEM_RECOVERY_LOG");
            BootReceiver.addFileToDropBox(dropBoxManager, sharedPreferences, string2, "/data/dontpanic/apanic_console", -LOG_SIZE, "APANIC_CONSOLE");
            BootReceiver.addFileToDropBox(dropBoxManager, sharedPreferences, string2, "/data/dontpanic/apanic_threads", -LOG_SIZE, "APANIC_THREADS");
            BootReceiver.addAuditErrorsToDropBox(dropBoxManager, sharedPreferences, string2, -LOG_SIZE, "SYSTEM_AUDIT");
            BootReceiver.addFsckErrorsToDropBox(dropBoxManager, sharedPreferences, string2, -LOG_SIZE, "SYSTEM_FSCK");
        } else if (dropBoxManager != null) {
            dropBoxManager.addText("SYSTEM_RESTART", string2);
        }
        File[] fileArray = TOMBSTONE_DIR.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            BootReceiver.addFileToDropBox(dropBoxManager, sharedPreferences, string2, fileArray[i].getPath(), LOG_SIZE, "SYSTEM_TOMBSTONE");
        }
        sTombstoneObserver = new FileObserver(TOMBSTONE_DIR.getPath(), 8){

            @Override
            public void onEvent(int n, String string22) {
                try {
                    File file = new File(TOMBSTONE_DIR, string22);
                    if (file.isFile()) {
                        BootReceiver.addFileToDropBox(dropBoxManager, sharedPreferences, string2, file.getPath(), LOG_SIZE, "SYSTEM_TOMBSTONE");
                    }
                    return;
                }
                catch (IOException iOException) {
                    Slog.e(BootReceiver.TAG, "Can't log tombstone", iOException);
                    return;
                }
            }
        };
        sTombstoneObserver.startWatching();
    }

    private void removeOldUpdatePackages(Context context) {
        Downloads.removeAllDownloadsByPackage(context, OLD_UPDATER_PACKAGE, OLD_UPDATER_CLASS);
    }

    @Override
    public void onReceive(final Context context, Intent intent) {
        new Thread(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean bl;
                block7: {
                    try {
                        BootReceiver.this.logBootEvents(context);
                    }
                    catch (Exception exception) {
                        Slog.e(BootReceiver.TAG, "Can't log boot events", exception);
                    }
                    try {
                        boolean bl2;
                        bl = bl2 = IPackageManager.Stub.asInterface(ServiceManager.getService("package")).isOnlyCoreApps();
                        break block7;
                    }
                    catch (Exception exception) {
                        Slog.e(BootReceiver.TAG, "Can't remove old update packages", exception);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        bl = false;
                    }
                }
                if (!bl) {
                    BootReceiver.this.removeOldUpdatePackages(context);
                }
            }
        }.start();
    }
}

