/*
 * Decompiled with CFR 0.152.
 */
package android.alsa;

import android.alsa.LineTokenizer;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class AlsaDevicesParser {
    private static final String TAG = "AlsaDevicesParser";
    private static final int kEndIndex_CardNum = 8;
    private static final int kEndIndex_DeviceNum = 11;
    private static final int kIndex_CardDeviceField = 5;
    private static final int kStartIndex_CardNum = 6;
    private static final int kStartIndex_DeviceNum = 9;
    private static final int kStartIndex_Type = 14;
    private static LineTokenizer mTokenizer = new LineTokenizer(" :[]-");
    private Vector<AlsaDeviceRecord> deviceRecords_ = new Vector();
    private boolean mHasCaptureDevices = false;
    private boolean mHasMIDIDevices = false;
    private boolean mHasPlaybackDevices = false;

    static /* synthetic */ boolean access$102(AlsaDevicesParser alsaDevicesParser, boolean bl) {
        alsaDevicesParser.mHasMIDIDevices = bl;
        return bl;
    }

    static /* synthetic */ boolean access$202(AlsaDevicesParser alsaDevicesParser, boolean bl) {
        alsaDevicesParser.mHasCaptureDevices = bl;
        return bl;
    }

    static /* synthetic */ boolean access$302(AlsaDevicesParser alsaDevicesParser, boolean bl) {
        alsaDevicesParser.mHasPlaybackDevices = bl;
        return bl;
    }

    private boolean isLineDeviceRecord(String string2) {
        return string2.charAt(5) == '[';
    }

    public void Log() {
        int n = this.getNumDeviceRecords();
        for (int i = 0; i < n; ++i) {
            Slog.w(TAG, "usb:" + this.getDeviceRecordAt(i).textFormat());
        }
    }

    public AlsaDeviceRecord getDeviceRecordAt(int n) {
        return this.deviceRecords_.get(n);
    }

    public int getNumDeviceRecords() {
        return this.deviceRecords_.size();
    }

    public boolean hasCaptureDevices() {
        return this.mHasCaptureDevices;
    }

    public boolean hasCaptureDevices(int n) {
        for (int i = 0; i < this.deviceRecords_.size(); ++i) {
            AlsaDeviceRecord alsaDeviceRecord = this.deviceRecords_.get(i);
            if (alsaDeviceRecord.mCardNum != n || alsaDeviceRecord.mDeviceType != 0 || alsaDeviceRecord.mDeviceDir != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasMIDIDevices() {
        return this.mHasMIDIDevices;
    }

    public boolean hasMIDIDevices(int n) {
        for (int i = 0; i < this.deviceRecords_.size(); ++i) {
            AlsaDeviceRecord alsaDeviceRecord = this.deviceRecords_.get(i);
            if (alsaDeviceRecord.mCardNum != n || alsaDeviceRecord.mDeviceType != 2) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlaybackDevices() {
        return this.mHasPlaybackDevices;
    }

    public boolean hasPlaybackDevices(int n) {
        for (int i = 0; i < this.deviceRecords_.size(); ++i) {
            AlsaDeviceRecord alsaDeviceRecord = this.deviceRecords_.get(i);
            if (alsaDeviceRecord.mCardNum != n || alsaDeviceRecord.mDeviceType != 0 || alsaDeviceRecord.mDeviceDir != 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan() {
        FileReader fileReader;
        this.deviceRecords_.clear();
        File file = new File("/proc/asound/devices");
        try {
            String string2;
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!this.isLineDeviceRecord(string2)) continue;
                AlsaDeviceRecord alsaDeviceRecord = new AlsaDeviceRecord();
                alsaDeviceRecord.parse(string2);
                this.deviceRecords_.add(alsaDeviceRecord);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        {
            fileReader.close();
            return;
        }
    }

    public class AlsaDeviceRecord {
        public static final int kDeviceDir_Capture = 0;
        public static final int kDeviceDir_Playback = 1;
        public static final int kDeviceDir_Unknown = -1;
        public static final int kDeviceType_Audio = 0;
        public static final int kDeviceType_Control = 1;
        public static final int kDeviceType_MIDI = 2;
        public static final int kDeviceType_Unknown = -1;
        int mCardNum = -1;
        int mDeviceDir = -1;
        int mDeviceNum = -1;
        int mDeviceType = -1;

        /*
         * Enabled aggressive block sorting
         */
        public boolean parse(String string2) {
            int n = 0;
            int n2 = 0;
            int n3;
            while ((n3 = mTokenizer.nextToken(string2, n)) != -1) {
                n = mTokenizer.nextDelimiter(string2, n3);
                if (n == -1) {
                    n = string2.length();
                }
                String string3 = string2.substring(n3, n);
                switch (n2) {
                    case 1: {
                        this.mCardNum = Integer.parseInt(string3);
                        if (string2.charAt(n) == '-') break;
                        ++n2;
                        break;
                    }
                    case 2: {
                        this.mDeviceNum = Integer.parseInt(string3);
                        break;
                    }
                    case 3: {
                        if (string3.equals("digital")) break;
                        if (string3.equals("control")) {
                            this.mDeviceType = 1;
                            break;
                        }
                        if (!string3.equals("raw")) break;
                        break;
                    }
                    case 4: {
                        if (string3.equals("audio")) {
                            this.mDeviceType = 0;
                            break;
                        }
                        if (!string3.equals("midi")) break;
                        this.mDeviceType = 2;
                        AlsaDevicesParser.access$102(AlsaDevicesParser.this, true);
                        break;
                    }
                    case 5: {
                        if (string3.equals("capture")) {
                            this.mDeviceDir = 0;
                            AlsaDevicesParser.access$202(AlsaDevicesParser.this, true);
                            break;
                        }
                        if (!string3.equals("playback")) break;
                        this.mDeviceDir = 1;
                        AlsaDevicesParser.access$302(AlsaDevicesParser.this, true);
                        break;
                    }
                }
                ++n2;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String textFormat() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[" + this.mCardNum + ":" + this.mDeviceNum + "]");
            switch (this.mDeviceType) {
                case -1: {
                    stringBuilder.append(" N/A");
                    break;
                }
                case 0: {
                    stringBuilder.append(" Audio");
                    break;
                }
                case 1: {
                    stringBuilder.append(" Control");
                    break;
                }
                case 2: {
                    stringBuilder.append(" MIDI");
                    break;
                }
            }
            switch (this.mDeviceDir) {
                case -1: {
                    stringBuilder.append(" N/A");
                    return stringBuilder.toString();
                }
                case 0: {
                    stringBuilder.append(" Capture");
                    return stringBuilder.toString();
                }
                case 1: {
                    stringBuilder.append(" Playback");
                    return stringBuilder.toString();
                }
            }
            return stringBuilder.toString();
        }
    }
}

