/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.TimeInterpolator;
import java.util.ArrayList;

class IntKeyframeSet
extends KeyframeSet
implements Keyframes.IntKeyframes {
    private int deltaValue;
    private boolean firstTime = true;
    private int firstValue;
    private int lastValue;

    public IntKeyframeSet(Keyframe.IntKeyframe ... intKeyframeArray) {
        super(intKeyframeArray);
    }

    @Override
    public IntKeyframeSet clone() {
        ArrayList arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[n];
        for (int i = 0; i < n; ++i) {
            intKeyframeArray[i] = (Keyframe.IntKeyframe)((Keyframe)arrayList.get(i)).clone();
        }
        return new IntKeyframeSet(intKeyframeArray);
    }

    @Override
    public int getIntValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(0)).getIntValue();
                this.lastValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(1)).getIntValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                f = this.mInterpolator.getInterpolation(f);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + (int)(f * (float)this.deltaValue);
            }
            return ((Number)this.mEvaluator.evaluate(f, this.firstValue, this.lastValue)).intValue();
        }
        if (f <= 0.0f) {
            Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe intKeyframe2 = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int n = intKeyframe.getIntValue();
            int n2 = intKeyframe2.getIntValue();
            float f2 = intKeyframe.getFraction();
            float f3 = intKeyframe2.getFraction();
            TimeInterpolator timeInterpolator = intKeyframe2.getInterpolator();
            if (timeInterpolator != null) {
                f = timeInterpolator.getInterpolation(f);
            }
            float f4 = (f - f2) / (f3 - f2);
            if (this.mEvaluator == null) {
                return n + (int)(f4 * (float)(n2 - n));
            }
            return ((Number)this.mEvaluator.evaluate(f4, n, n2)).intValue();
        }
        if (f >= 1.0f) {
            Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(-2 + this.mNumKeyframes);
            Keyframe.IntKeyframe intKeyframe3 = (Keyframe.IntKeyframe)this.mKeyframes.get(-1 + this.mNumKeyframes);
            int n = intKeyframe.getIntValue();
            int n3 = intKeyframe3.getIntValue();
            float f5 = intKeyframe.getFraction();
            float f6 = intKeyframe3.getFraction();
            TimeInterpolator timeInterpolator = intKeyframe3.getInterpolator();
            if (timeInterpolator != null) {
                f = timeInterpolator.getInterpolation(f);
            }
            float f7 = (f - f5) / (f6 - f5);
            if (this.mEvaluator == null) {
                return n + (int)(f7 * (float)(n3 - n));
            }
            return ((Number)this.mEvaluator.evaluate(f7, n, n3)).intValue();
        }
        Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.IntKeyframe intKeyframe4 = (Keyframe.IntKeyframe)this.mKeyframes.get(i);
            if (f < intKeyframe4.getFraction()) {
                TimeInterpolator timeInterpolator = intKeyframe4.getInterpolator();
                if (timeInterpolator != null) {
                    f = timeInterpolator.getInterpolation(f);
                }
                float f8 = (f - intKeyframe.getFraction()) / (intKeyframe4.getFraction() - intKeyframe.getFraction());
                int n = intKeyframe.getIntValue();
                int n4 = intKeyframe4.getIntValue();
                if (this.mEvaluator == null) {
                    return n + (int)(f8 * (float)(n4 - n));
                }
                return ((Number)this.mEvaluator.evaluate(f8, n, n4)).intValue();
            }
            intKeyframe = intKeyframe4;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(-1 + this.mNumKeyframes)).getValue()).intValue();
    }

    @Override
    public Class getType() {
        return Integer.class;
    }

    @Override
    public Object getValue(float f) {
        return this.getIntValue(f);
    }

    @Override
    public void invalidateCache() {
        this.firstTime = true;
    }
}

