/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.EnterTransitionCoordinator;
import android.app.ExitTransitionCoordinator;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class ActivityTransitionState {
    private static final String ENTERING_SHARED_ELEMENTS = "android:enteringSharedElements";
    private static final String EXITING_MAPPED_FROM = "android:exitingMappedFrom";
    private static final String EXITING_MAPPED_TO = "android:exitingMappedTo";
    private ExitTransitionCoordinator mCalledExitCoordinator;
    private ActivityOptions mEnterActivityOptions;
    private EnterTransitionCoordinator mEnterTransitionCoordinator;
    private ArrayList<String> mEnteringNames;
    private SparseArray<WeakReference<ExitTransitionCoordinator>> mExitTransitionCoordinators;
    private int mExitTransitionCoordinatorsKey = 1;
    private ArrayList<String> mExitingFrom;
    private ArrayList<String> mExitingTo;
    private ArrayList<View> mExitingToView;
    private boolean mHasExited;
    private boolean mIsEnterPostponed;
    private boolean mIsEnterTriggered;
    private ExitTransitionCoordinator mReturnExitCoordinator;

    private void restoreExitedViews() {
        if (this.mCalledExitCoordinator != null) {
            this.mCalledExitCoordinator.resetViews();
            this.mCalledExitCoordinator = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startEnter() {
        if (this.mEnterActivityOptions.isReturning()) {
            if (this.mExitingToView != null) {
                this.mEnterTransitionCoordinator.viewInstancesReady(this.mExitingFrom, this.mExitingTo, this.mExitingToView);
            } else {
                this.mEnterTransitionCoordinator.namedViewsReady(this.mExitingFrom, this.mExitingTo);
            }
        } else {
            this.mEnterTransitionCoordinator.namedViewsReady(null, null);
            this.mEnteringNames = this.mEnterTransitionCoordinator.getAllSharedElementNames();
        }
        this.mExitingFrom = null;
        this.mExitingTo = null;
        this.mExitingToView = null;
        this.mEnterActivityOptions = null;
    }

    public int addExitTransitionCoordinator(ExitTransitionCoordinator exitTransitionCoordinator) {
        if (this.mExitTransitionCoordinators == null) {
            this.mExitTransitionCoordinators = new SparseArray();
        }
        WeakReference<ExitTransitionCoordinator> weakReference = new WeakReference<ExitTransitionCoordinator>(exitTransitionCoordinator);
        for (int i = -1 + this.mExitTransitionCoordinators.size(); i >= 0; --i) {
            if (this.mExitTransitionCoordinators.valueAt(i).get() != null) continue;
            this.mExitTransitionCoordinators.removeAt(i);
        }
        int n = this.mExitTransitionCoordinatorsKey;
        this.mExitTransitionCoordinatorsKey = n + 1;
        this.mExitTransitionCoordinators.append(n, weakReference);
        return n;
    }

    public void clear() {
        this.mEnteringNames = null;
        this.mExitingFrom = null;
        this.mExitingTo = null;
        this.mExitingToView = null;
        this.mCalledExitCoordinator = null;
        this.mEnterTransitionCoordinator = null;
        this.mEnterActivityOptions = null;
        this.mExitTransitionCoordinators = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enterReady(Activity activity) {
        block5: {
            block4: {
                if (this.mEnterActivityOptions == null || this.mIsEnterTriggered) break block4;
                this.mIsEnterTriggered = true;
                this.mHasExited = false;
                ArrayList<String> arrayList = this.mEnterActivityOptions.getSharedElementNames();
                ResultReceiver resultReceiver = this.mEnterActivityOptions.getResultReceiver();
                if (this.mEnterActivityOptions.isReturning()) {
                    this.restoreExitedViews();
                    activity.getWindow().getDecorView().setVisibility(0);
                }
                this.mEnterTransitionCoordinator = new EnterTransitionCoordinator(activity, resultReceiver, arrayList, this.mEnterActivityOptions.isReturning());
                if (!this.mIsEnterPostponed) break block5;
            }
            return;
        }
        this.startEnter();
    }

    public void onResume() {
        this.restoreExitedViews();
    }

    public void onStop() {
        this.restoreExitedViews();
        if (this.mEnterTransitionCoordinator != null) {
            this.mEnterTransitionCoordinator.stop();
            this.mEnterTransitionCoordinator = null;
        }
        if (this.mReturnExitCoordinator != null) {
            this.mReturnExitCoordinator.stop();
            this.mReturnExitCoordinator = null;
        }
    }

    public void postponeEnterTransition() {
        this.mIsEnterPostponed = true;
    }

    public void readState(Bundle bundle) {
        if (bundle != null) {
            if (this.mEnterTransitionCoordinator == null || this.mEnterTransitionCoordinator.isReturning()) {
                this.mEnteringNames = bundle.getStringArrayList(ENTERING_SHARED_ELEMENTS);
            }
            if (this.mEnterTransitionCoordinator == null) {
                this.mExitingFrom = bundle.getStringArrayList(EXITING_MAPPED_FROM);
                this.mExitingTo = bundle.getStringArrayList(EXITING_MAPPED_TO);
            }
        }
    }

    public void saveState(Bundle bundle) {
        if (this.mEnteringNames != null) {
            bundle.putStringArrayList(ENTERING_SHARED_ELEMENTS, this.mEnteringNames);
        }
        if (this.mExitingFrom != null) {
            bundle.putStringArrayList(EXITING_MAPPED_FROM, this.mExitingFrom);
            bundle.putStringArrayList(EXITING_MAPPED_TO, this.mExitingTo);
        }
    }

    public void setEnterActivityOptions(Activity activity, ActivityOptions activityOptions) {
        if (activity.getWindow().hasFeature(13) && activityOptions != null && this.mEnterActivityOptions == null && this.mEnterTransitionCoordinator == null && activityOptions.getAnimationType() == 5) {
            this.mEnterActivityOptions = activityOptions;
            this.mIsEnterTriggered = false;
            if (this.mEnterActivityOptions.isReturning()) {
                this.restoreExitedViews();
                int n = this.mEnterActivityOptions.getResultCode();
                if (n != 0) {
                    activity.onActivityReenter(n, this.mEnterActivityOptions.getResultData());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startExitBackTransition(Activity activity) {
        boolean bl = true;
        if (this.mEnteringNames == null) {
            return false;
        }
        if (this.mHasExited) return bl;
        this.mHasExited = bl;
        EnterTransitionCoordinator enterTransitionCoordinator = this.mEnterTransitionCoordinator;
        ViewGroup viewGroup = null;
        Transition transition2 = null;
        if (enterTransitionCoordinator != null) {
            transition2 = this.mEnterTransitionCoordinator.getEnterViewsTransition();
            viewGroup = this.mEnterTransitionCoordinator.getDecor();
            this.mEnterTransitionCoordinator.cancelEnter();
            this.mEnterTransitionCoordinator = null;
            if (transition2 != null && viewGroup != null) {
                transition2.pause(viewGroup);
            }
        }
        this.mReturnExitCoordinator = new ExitTransitionCoordinator(activity, this.mEnteringNames, null, null, bl);
        if (transition2 != null && viewGroup != null) {
            transition2.resume(viewGroup);
        }
        this.mReturnExitCoordinator.startExit(activity.mResultCode, activity.mResultData);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startExitOutTransition(Activity activity, Bundle bundle) {
        block3: {
            block2: {
                int n;
                int n2;
                if (!activity.getWindow().hasFeature(13)) break block2;
                ActivityOptions activityOptions = new ActivityOptions(bundle);
                this.mEnterTransitionCoordinator = null;
                if (activityOptions.getAnimationType() != 5 || (n2 = this.mExitTransitionCoordinators.indexOfKey(n = activityOptions.getExitCoordinatorKey())) < 0) break block2;
                this.mCalledExitCoordinator = (ExitTransitionCoordinator)this.mExitTransitionCoordinators.valueAt(n2).get();
                this.mExitTransitionCoordinators.removeAt(n2);
                if (this.mCalledExitCoordinator != null) break block3;
            }
            return;
        }
        this.mExitingFrom = this.mCalledExitCoordinator.getAcceptedNames();
        this.mExitingTo = this.mCalledExitCoordinator.getMappedNames();
        this.mExitingToView = this.mCalledExitCoordinator.copyMappedViews();
        this.mCalledExitCoordinator.startExit();
    }

    public void startPostponedEnterTransition() {
        if (this.mIsEnterPostponed) {
            this.mIsEnterPostponed = false;
            if (this.mEnterTransitionCoordinator != null) {
                this.startEnter();
            }
        }
    }
}

