/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IProcessObserver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.SparseArray;
import java.util.List;

public class AppImportanceMonitor {
    static final int MSG_UPDATE = 1;
    final SparseArray<AppEntry> mApps = new SparseArray();
    final Context mContext;
    final Handler mHandler;
    final IProcessObserver mProcessObserver = new IProcessObserver.Stub(){

        @Override
        public void onForegroundActivitiesChanged(int n, int n2, boolean bl) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onProcessDied(int n, int n2) {
            SparseArray<AppEntry> sparseArray = AppImportanceMonitor.this.mApps;
            synchronized (sparseArray) {
                AppImportanceMonitor.this.updateImportanceLocked(n, n2, 1000, true);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onProcessStateChanged(int n, int n2, int n3) {
            SparseArray<AppEntry> sparseArray = AppImportanceMonitor.this.mApps;
            synchronized (sparseArray) {
                AppImportanceMonitor.this.updateImportanceLocked(n, n2, ActivityManager.RunningAppProcessInfo.procStateToImportance(n3), true);
                return;
            }
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppImportanceMonitor(Context context, Looper looper) {
        List<ActivityManager.RunningAppProcessInfo> list;
        this.mContext = context;
        this.mHandler = new Handler(looper){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        super.handleMessage(message);
                        return;
                    }
                    case 1: 
                }
                AppImportanceMonitor.this.onImportanceChanged(message.arg1, 0xFFFF & message.arg2, message.arg2 >> 16);
            }
        };
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        try {
            ActivityManagerNative.getDefault().registerProcessObserver(this.mProcessObserver);
        }
        catch (RemoteException remoteException) {}
        if ((list = activityManager.getRunningAppProcesses()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = list.get(i);
                this.updateImportanceLocked(runningAppProcessInfo.uid, runningAppProcessInfo.pid, runningAppProcessInfo.importance, false);
            }
        }
    }

    public int getImportance(int n) {
        AppEntry appEntry = this.mApps.get(n);
        if (appEntry == null) {
            return 1000;
        }
        return appEntry.importance;
    }

    public void onImportanceChanged(int n, int n2, int n3) {
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateImportanceLocked(int n, int n2, int n3, boolean bl) {
        AppEntry appEntry = this.mApps.get(n);
        if (appEntry == null) {
            appEntry = new AppEntry(n);
            this.mApps.put(n, appEntry);
        }
        if (n3 >= 1000) {
            appEntry.procs.remove(n2);
        } else {
            appEntry.procs.put(n2, n3);
        }
        this.updateImportanceLocked(appEntry, bl);
    }

    void updateImportanceLocked(AppEntry appEntry, boolean bl) {
        int n = 1000;
        for (int i = 0; i < appEntry.procs.size(); ++i) {
            int n2 = appEntry.procs.valueAt(i);
            if (n2 >= n) continue;
            n = n2;
        }
        if (n != appEntry.importance) {
            int n3 = n | appEntry.importance << 16;
            appEntry.importance = n;
            if (n >= 1000) {
                this.mApps.remove(appEntry.uid);
            }
            if (bl) {
                this.mHandler.obtainMessage(1, appEntry.uid, n3).sendToTarget();
            }
        }
    }

    static class AppEntry {
        int importance = 1000;
        final SparseArray<Integer> procs = new SparseArray(1);
        final int uid;

        AppEntry(int n) {
            this.uid = n;
        }
    }
}

