/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ContextImpl;
import android.app.LoadedApk;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.os.Bundle;
import java.util.ArrayList;

public class Application
extends ContextWrapper
implements ComponentCallbacks2 {
    private ArrayList<ActivityLifecycleCallbacks> mActivityLifecycleCallbacks;
    private ArrayList<OnProvideAssistDataListener> mAssistCallbacks = null;
    private ArrayList<ComponentCallbacks> mComponentCallbacks = new ArrayList();
    private int mFlipfont = 0;
    public LoadedApk mLoadedApk;

    public Application() {
        super(null);
        this.mActivityLifecycleCallbacks = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] collectActivityLifecycleCallbacks() {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            int n = this.mActivityLifecycleCallbacks.size();
            Object[] objectArray = null;
            if (n <= 0) return objectArray;
            return this.mActivityLifecycleCallbacks.toArray();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] collectComponentCallbacks() {
        ArrayList<ComponentCallbacks> arrayList = this.mComponentCallbacks;
        synchronized (arrayList) {
            int n = this.mComponentCallbacks.size();
            Object[] objectArray = null;
            if (n <= 0) return objectArray;
            return this.mComponentCallbacks.toArray();
        }
    }

    final void attach(Context context) {
        this.attachBaseContext(context);
        this.mLoadedApk = ContextImpl.getImpl((Context)context).mPackageInfo;
    }

    void dispatchActivityCreated(Activity activity, Bundle bundle) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivityCreated(activity, bundle);
            }
        }
    }

    void dispatchActivityDestroyed(Activity activity) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivityDestroyed(activity);
            }
        }
    }

    void dispatchActivityPaused(Activity activity) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivityPaused(activity);
            }
        }
    }

    void dispatchActivityResumed(Activity activity) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivityResumed(activity);
            }
        }
    }

    void dispatchActivitySaveInstanceState(Activity activity, Bundle bundle) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivitySaveInstanceState(activity, bundle);
            }
        }
    }

    void dispatchActivityStarted(Activity activity) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivityStarted(activity);
            }
        }
    }

    void dispatchActivityStopped(Activity activity) {
        Object[] objectArray = this.collectActivityLifecycleCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ActivityLifecycleCallbacks)objectArray[i]).onActivityStopped(activity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void dispatchOnProvideAssistData(Activity activity, Bundle bundle) {
        // MONITORENTER : this
        if (this.mAssistCallbacks == null) {
            // MONITOREXIT : this
            return;
        }
        Object[] objectArray = this.mAssistCallbacks.toArray();
        // MONITOREXIT : this
        if (objectArray == null) return;
        int n = 0;
        while (n < objectArray.length) {
            ((OnProvideAssistDataListener)objectArray[n]).onProvideAssistData(activity, bundle);
            ++n;
        }
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        Object[] objectArray;
        if (configuration != null && configuration.FlipFont > 0 && this.mFlipfont != configuration.FlipFont) {
            Typeface.SetAppTypeFace(this.getApplicationContext(), this.getPackageName());
            this.mFlipfont = configuration.FlipFont;
        }
        if ((objectArray = this.collectComponentCallbacks()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ComponentCallbacks)objectArray[i]).onConfigurationChanged(configuration);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onCreate() {
        Context context;
        try {
            Context context2;
            context = context2 = this.getApplicationContext();
        }
        catch (Exception exception) {
            context = null;
        }
        Typeface.SetAppTypeFace(context, this.getPackageName());
    }

    @Override
    public void onLowMemory() {
        Object[] objectArray = this.collectComponentCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ComponentCallbacks)objectArray[i]).onLowMemory();
            }
        }
    }

    public void onTerminate() {
    }

    @Override
    public void onTrimMemory(int n) {
        Object[] objectArray = this.collectComponentCallbacks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof ComponentCallbacks2)) continue;
                ((ComponentCallbacks2)object).onTrimMemory(n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacks activityLifecycleCallbacks) {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.add(activityLifecycleCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerComponentCallbacks(ComponentCallbacks componentCallbacks) {
        ArrayList<ComponentCallbacks> arrayList = this.mComponentCallbacks;
        synchronized (arrayList) {
            this.mComponentCallbacks.add(componentCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerOnProvideAssistDataListener(OnProvideAssistDataListener onProvideAssistDataListener) {
        synchronized (this) {
            if (this.mAssistCallbacks == null) {
                this.mAssistCallbacks = new ArrayList();
            }
            this.mAssistCallbacks.add(onProvideAssistDataListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacks activityLifecycleCallbacks) {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.remove(activityLifecycleCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterComponentCallbacks(ComponentCallbacks componentCallbacks) {
        ArrayList<ComponentCallbacks> arrayList = this.mComponentCallbacks;
        synchronized (arrayList) {
            this.mComponentCallbacks.remove(componentCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterOnProvideAssistDataListener(OnProvideAssistDataListener onProvideAssistDataListener) {
        synchronized (this) {
            if (this.mAssistCallbacks != null) {
                this.mAssistCallbacks.remove(onProvideAssistDataListener);
            }
            return;
        }
    }

    public static interface ActivityLifecycleCallbacks {
        public void onActivityCreated(Activity var1, Bundle var2);

        public void onActivityDestroyed(Activity var1);

        public void onActivityPaused(Activity var1);

        public void onActivityResumed(Activity var1);

        public void onActivitySaveInstanceState(Activity var1, Bundle var2);

        public void onActivityStarted(Activity var1);

        public void onActivityStopped(Activity var1);
    }

    public static interface OnProvideAssistDataListener {
        public void onProvideAssistData(Activity var1, Bundle var2);
    }
}

