/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.INotificationManager;
import android.app.Notification;
import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.UserHandle;
import android.util.Log;

public class NotificationManager {
    public static final String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    private static String TAG = "NotificationManager";
    private static boolean localLOGV = false;
    private static INotificationManager sService;
    private Context mContext;

    NotificationManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public static NotificationManager from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    public static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        sService = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        return sService;
    }

    public void cancel(int n) {
        this.cancel(null, n);
    }

    public void cancel(String string2, int n) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string3 = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, string3 + ": cancel(" + n + ")");
        }
        try {
            iNotificationManager.cancelNotificationWithTag(string3, string2, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void cancelAll() {
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string2 = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, string2 + ": cancelAll()");
        }
        try {
            iNotificationManager.cancelAllNotifications(string2, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void cancelAsUser(String string2, int n, UserHandle userHandle) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string3 = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, string3 + ": cancel(" + n + ")");
        }
        try {
            iNotificationManager.cancelNotificationWithTag(string3, string2, n, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public ComponentName getEffectsSuppressor() {
        INotificationManager iNotificationManager = NotificationManager.getService();
        try {
            ComponentName componentName = iNotificationManager.getEffectsSuppressor();
            return componentName;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean matchesCallFilter(Bundle bundle) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        try {
            boolean bl = iNotificationManager.matchesCallFilter(bundle);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void notify(int n, Notification notification) {
        this.notify(null, n, notification);
    }

    public void notify(String string2, int n, Notification notification) {
        int[] nArray = new int[1];
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string3 = this.mContext.getPackageName();
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        if (localLOGV) {
            Log.v(TAG, string3 + ": notify(" + n + ", " + notification + ")");
        }
        Notification notification2 = notification.clone();
        Notification.Builder.stripForDelivery(notification2);
        try {
            iNotificationManager.enqueueNotificationWithTag(string3, this.mContext.getOpPackageName(), string2, n, notification2, nArray, UserHandle.myUserId());
            if (n != nArray[0]) {
                Log.w(TAG, "notify: id corrupted: sent " + n + ", got back " + nArray[0]);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void notifyAsUser(String string2, int n, Notification notification, UserHandle userHandle) {
        int[] nArray = new int[1];
        INotificationManager iNotificationManager = NotificationManager.getService();
        String string3 = this.mContext.getPackageName();
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        if (localLOGV) {
            Log.v(TAG, string3 + ": notify(" + n + ", " + notification + ")");
        }
        Notification notification2 = notification.clone();
        Notification.Builder.stripForDelivery(notification2);
        try {
            iNotificationManager.enqueueNotificationWithTag(string3, this.mContext.getOpPackageName(), string2, n, notification2, nArray, userHandle.getIdentifier());
            if (n != nArray[0]) {
                Log.w(TAG, "notify: id corrupted: sent " + n + ", got back " + nArray[0]);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

