/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ISearchManager;
import android.app.SearchDialog;
import android.app.SearchableInfo;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import java.util.List;

public class SearchManager
implements DialogInterface.OnDismissListener,
DialogInterface.OnCancelListener {
    public static final String ACTION_KEY = "action_key";
    public static final String ACTION_MSG = "action_msg";
    public static final String APP_DATA = "app_data";
    public static final String CONTEXT_IS_VOICE = "android.search.CONTEXT_IS_VOICE";
    public static final String CURSOR_EXTRA_KEY_IN_PROGRESS = "in_progress";
    private static final boolean DBG = false;
    public static final String DISABLE_VOICE_SEARCH = "android.search.DISABLE_VOICE_SEARCH";
    public static final String EXTRA_DATA_KEY = "intent_extra_data_key";
    public static final String EXTRA_NEW_SEARCH = "new_search";
    public static final String EXTRA_SELECT_QUERY = "select_query";
    public static final String EXTRA_WEB_SEARCH_PENDINGINTENT = "web_search_pendingintent";
    public static final int FLAG_QUERY_REFINEMENT = 1;
    public static final String INTENT_ACTION_GLOBAL_SEARCH = "android.search.action.GLOBAL_SEARCH";
    public static final String INTENT_ACTION_SEARCHABLES_CHANGED = "android.search.action.SEARCHABLES_CHANGED";
    public static final String INTENT_ACTION_SEARCH_SETTINGS = "android.search.action.SEARCH_SETTINGS";
    public static final String INTENT_ACTION_SEARCH_SETTINGS_CHANGED = "android.search.action.SETTINGS_CHANGED";
    public static final String INTENT_ACTION_WEB_SEARCH_SETTINGS = "android.search.action.WEB_SEARCH_SETTINGS";
    public static final String INTENT_GLOBAL_SEARCH_ACTIVITY_CHANGED = "android.search.action.GLOBAL_SEARCH_ACTIVITY_CHANGED";
    public static final char MENU_KEY = 's';
    public static final int MENU_KEYCODE = 47;
    public static final String QUERY = "query";
    public static final String SEARCH_MODE = "search_mode";
    public static final String SHORTCUT_MIME_TYPE = "vnd.android.cursor.item/vnd.android.search.suggest";
    public static final String SUGGEST_COLUMN_AUDIO_CHANNEL_CONFIG = "suggest_audio_channel_config";
    public static final String SUGGEST_COLUMN_CONTENT_TYPE = "suggest_content_type";
    public static final String SUGGEST_COLUMN_DURATION = "suggest_duration";
    public static final String SUGGEST_COLUMN_FLAGS = "suggest_flags";
    public static final String SUGGEST_COLUMN_FORMAT = "suggest_format";
    public static final String SUGGEST_COLUMN_ICON_1 = "suggest_icon_1";
    public static final String SUGGEST_COLUMN_ICON_2 = "suggest_icon_2";
    public static final String SUGGEST_COLUMN_INTENT_ACTION = "suggest_intent_action";
    public static final String SUGGEST_COLUMN_INTENT_DATA = "suggest_intent_data";
    public static final String SUGGEST_COLUMN_INTENT_DATA_ID = "suggest_intent_data_id";
    public static final String SUGGEST_COLUMN_INTENT_EXTRA_DATA = "suggest_intent_extra_data";
    public static final String SUGGEST_COLUMN_IS_LIVE = "suggest_is_live";
    public static final String SUGGEST_COLUMN_LAST_ACCESS_HINT = "suggest_last_access_hint";
    public static final String SUGGEST_COLUMN_PRODUCTION_YEAR = "suggest_production_year";
    public static final String SUGGEST_COLUMN_PURCHASE_PRICE = "suggest_purchase_price";
    public static final String SUGGEST_COLUMN_QUERY = "suggest_intent_query";
    public static final String SUGGEST_COLUMN_RATING_SCORE = "suggest_rating_score";
    public static final String SUGGEST_COLUMN_RATING_STYLE = "suggest_rating_style";
    public static final String SUGGEST_COLUMN_RENTAL_PRICE = "suggest_rental_price";
    public static final String SUGGEST_COLUMN_RESULT_CARD_IMAGE = "suggest_result_card_image";
    public static final String SUGGEST_COLUMN_SHORTCUT_ID = "suggest_shortcut_id";
    public static final String SUGGEST_COLUMN_SPINNER_WHILE_REFRESHING = "suggest_spinner_while_refreshing";
    public static final String SUGGEST_COLUMN_TEXT_1 = "suggest_text_1";
    public static final String SUGGEST_COLUMN_TEXT_2 = "suggest_text_2";
    public static final String SUGGEST_COLUMN_TEXT_2_URL = "suggest_text_2_url";
    public static final String SUGGEST_COLUMN_VIDEO_HEIGHT = "suggest_video_height";
    public static final String SUGGEST_COLUMN_VIDEO_WIDTH = "suggest_video_width";
    public static final String SUGGEST_MIME_TYPE = "vnd.android.cursor.dir/vnd.android.search.suggest";
    public static final String SUGGEST_NEVER_MAKE_SHORTCUT = "_-1";
    public static final String SUGGEST_PARAMETER_LIMIT = "limit";
    public static final String SUGGEST_URI_PATH_QUERY = "search_suggest_query";
    public static final String SUGGEST_URI_PATH_SHORTCUT = "search_suggest_shortcut";
    private static final String TAG = "SearchManager";
    public static final String USER_QUERY = "user_query";
    private static ISearchManager mService;
    private String mAssociatedPackage;
    OnCancelListener mCancelListener = null;
    private final Context mContext;
    OnDismissListener mDismissListener = null;
    final Handler mHandler;
    private SearchDialog mSearchDialog;

    SearchManager(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
        mService = ISearchManager.Stub.asInterface(ServiceManager.getService("search"));
    }

    private void ensureSearchDialog() {
        if (this.mSearchDialog == null) {
            this.mSearchDialog = new SearchDialog(this.mContext, this);
            this.mSearchDialog.setOnCancelListener(this);
            this.mSearchDialog.setOnDismissListener(this);
        }
    }

    public Intent getAssistIntent(Context context, boolean bl) {
        return this.getAssistIntent(context, bl, UserHandle.myUserId());
    }

    public Intent getAssistIntent(Context context, boolean bl, int n) {
        Intent intent;
        block8: {
            ComponentName componentName;
            block7: {
                block6: {
                    if (mService != null) break block6;
                    return null;
                }
                componentName = mService.getAssistIntent(n);
                if (componentName != null) break block7;
                return null;
            }
            intent = new Intent("android.intent.action.ASSIST");
            intent.setComponent(componentName);
            if (!bl) break block8;
            Bundle bundle = ActivityManagerNative.getDefault().getAssistContextExtras(0);
            if (bundle == null) break block8;
            try {
                intent.replaceExtras(bundle);
                return intent;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getAssistIntent() failed: " + remoteException);
                intent = null;
            }
        }
        return intent;
    }

    public List<ResolveInfo> getGlobalSearchActivities() {
        try {
            List<ResolveInfo> list = mService.getGlobalSearchActivities();
            return list;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getGlobalSearchActivities() failed: " + remoteException);
            return null;
        }
    }

    public ComponentName getGlobalSearchActivity() {
        try {
            ComponentName componentName = mService.getGlobalSearchActivity();
            return componentName;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getGlobalSearchActivity() failed: " + remoteException);
            return null;
        }
    }

    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        try {
            SearchableInfo searchableInfo = mService.getSearchableInfo(componentName);
            return searchableInfo;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getSearchableInfo() failed: " + remoteException);
            return null;
        }
    }

    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        try {
            List<SearchableInfo> list = mService.getSearchablesInGlobalSearch();
            return list;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getSearchablesInGlobalSearch() failed: " + remoteException);
            return null;
        }
    }

    public Cursor getSuggestions(SearchableInfo searchableInfo, String string2) {
        return this.getSuggestions(searchableInfo, string2, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getSuggestions(SearchableInfo searchableInfo, String string2, int n) {
        String[] stringArray;
        String string3;
        if (searchableInfo == null || (string3 = searchableInfo.getSuggestAuthority()) == null) {
            return null;
        }
        Uri.Builder builder = new Uri.Builder().scheme("content").authority(string3).query("").fragment("");
        String string4 = searchableInfo.getSuggestPath();
        if (string4 != null) {
            builder.appendEncodedPath(string4);
        }
        builder.appendPath(SUGGEST_URI_PATH_QUERY);
        String string5 = searchableInfo.getSuggestSelection();
        if (string5 != null) {
            stringArray = new String[]{string2};
        } else {
            builder.appendPath(string2);
            stringArray = null;
        }
        if (n > 0) {
            builder.appendQueryParameter(SUGGEST_PARAMETER_LIMIT, String.valueOf(n));
        }
        Uri uri = builder.build();
        return this.mContext.getContentResolver().query(uri, null, string5, stringArray, null);
    }

    public ComponentName getWebSearchActivity() {
        try {
            ComponentName componentName = mService.getWebSearchActivity();
            return componentName;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getWebSearchActivity() failed: " + remoteException);
            return null;
        }
    }

    public boolean isVisible() {
        if (this.mSearchDialog == null) {
            return false;
        }
        return this.mSearchDialog.isShowing();
    }

    public boolean launchAssistAction(int n, String string2, int n2) {
        block3: {
            try {
                if (mService != null) break block3;
                return false;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "launchAssistAction() failed: " + remoteException);
                return false;
            }
        }
        boolean bl = mService.launchAssistAction(n, string2, n2);
        return bl;
    }

    @Override
    @Deprecated
    public void onCancel(DialogInterface dialogInterface) {
        if (this.mCancelListener != null) {
            this.mCancelListener.onCancel();
        }
    }

    @Override
    @Deprecated
    public void onDismiss(DialogInterface dialogInterface) {
        if (this.mDismissListener != null) {
            this.mDismissListener.onDismiss();
        }
    }

    public void setOnCancelListener(OnCancelListener onCancelListener) {
        this.mCancelListener = onCancelListener;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startGlobalSearch(String string2, boolean bl, Bundle bundle, Rect rect) {
        ComponentName componentName = this.getGlobalSearchActivity();
        if (componentName == null) {
            Log.w(TAG, "No global search activity found.");
            return;
        }
        Intent intent = new Intent(INTENT_ACTION_GLOBAL_SEARCH);
        intent.addFlags(0x10000000);
        intent.setComponent(componentName);
        Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        if (!bundle2.containsKey("source")) {
            bundle2.putString("source", this.mContext.getPackageName());
        }
        intent.putExtra(APP_DATA, bundle2);
        if (!TextUtils.isEmpty(string2)) {
            intent.putExtra(QUERY, string2);
        }
        if (bl) {
            intent.putExtra(EXTRA_SELECT_QUERY, bl);
        }
        intent.setSourceBounds(rect);
        try {
            this.mContext.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.e(TAG, "Global search activity not found: " + componentName);
            return;
        }
    }

    public void startSearch(String string2, boolean bl, ComponentName componentName, Bundle bundle, boolean bl2) {
        this.startSearch(string2, bl, componentName, bundle, bl2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startSearch(String string2, boolean bl, ComponentName componentName, Bundle bundle, boolean bl2, Rect rect) {
        if (bl2) {
            this.startGlobalSearch(string2, bl, bundle, rect);
            return;
        } else {
            if (new UiModeManager().getCurrentModeType() == 4) return;
            this.ensureSearchDialog();
            this.mSearchDialog.show(string2, bl, componentName, bundle);
            return;
        }
    }

    public void stopSearch() {
        if (this.mSearchDialog != null) {
            this.mSearchDialog.cancel();
        }
    }

    public void triggerSearch(String string2, ComponentName componentName, Bundle bundle) {
        if (!this.mAssociatedPackage.equals(componentName.getPackageName())) {
            throw new IllegalArgumentException("invoking app search on a different package not associated with this search manager");
        }
        if (string2 == null || TextUtils.getTrimmedLength(string2) == 0) {
            Log.w(TAG, "triggerSearch called with empty query, ignoring.");
            return;
        }
        this.startSearch(string2, false, componentName, bundle, false);
        this.mSearchDialog.launchQuerySearch();
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

