/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.util.HashMap;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;

public final class SearchableInfo
implements Parcelable {
    public static final Parcelable.Creator<SearchableInfo> CREATOR = new Parcelable.Creator<SearchableInfo>(){

        @Override
        public SearchableInfo createFromParcel(Parcel parcel) {
            return new SearchableInfo(parcel);
        }

        public SearchableInfo[] newArray(int n) {
            return new SearchableInfo[n];
        }
    };
    private static final boolean DBG = false;
    private static final String LOG_TAG = "SearchableInfo";
    private static final String MD_LABEL_SEARCHABLE = "android.app.searchable";
    private static final String MD_XML_ELEMENT_SEARCHABLE = "searchable";
    private static final String MD_XML_ELEMENT_SEARCHABLE_ACTION_KEY = "actionkey";
    private static final int SEARCH_MODE_BADGE_ICON = 8;
    private static final int SEARCH_MODE_BADGE_LABEL = 4;
    private static final int SEARCH_MODE_QUERY_REWRITE_FROM_DATA = 16;
    private static final int SEARCH_MODE_QUERY_REWRITE_FROM_TEXT = 32;
    private static final int VOICE_SEARCH_LAUNCH_RECOGNIZER = 4;
    private static final int VOICE_SEARCH_LAUNCH_WEB_SEARCH = 2;
    private static final int VOICE_SEARCH_SHOW_BUTTON = 1;
    private HashMap<Integer, ActionKeyInfo> mActionKeys;
    private final boolean mAutoUrlDetect;
    private final int mHintId;
    private final int mIconId;
    private final boolean mIncludeInGlobalSearch;
    private final int mLabelId;
    private final boolean mQueryAfterZeroResults;
    private final ComponentName mSearchActivity;
    private final int mSearchButtonText;
    private final int mSearchImeOptions;
    private final int mSearchInputType;
    private final int mSearchMode;
    private final int mSettingsDescriptionId;
    private final String mSuggestAuthority;
    private final String mSuggestIntentAction;
    private final String mSuggestIntentData;
    private final String mSuggestPath;
    private final String mSuggestProviderPackage;
    private final String mSuggestSelection;
    private final int mSuggestThreshold;
    private final int mVoiceLanguageId;
    private final int mVoiceLanguageModeId;
    private final int mVoiceMaxResults;
    private final int mVoicePromptTextId;
    private final int mVoiceSearchMode;

    private SearchableInfo(Context context, AttributeSet attributeSet, ComponentName componentName) {
        this.mActionKeys = null;
        this.mSearchActivity = componentName;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Searchable);
        this.mSearchMode = typedArray.getInt(3, 0);
        this.mLabelId = typedArray.getResourceId(0, 0);
        this.mHintId = typedArray.getResourceId(2, 0);
        this.mIconId = typedArray.getResourceId(1, 0);
        this.mSearchButtonText = typedArray.getResourceId(9, 0);
        this.mSearchInputType = typedArray.getInt(10, 1);
        this.mSearchImeOptions = typedArray.getInt(16, 2);
        this.mIncludeInGlobalSearch = typedArray.getBoolean(18, false);
        this.mQueryAfterZeroResults = typedArray.getBoolean(19, false);
        this.mAutoUrlDetect = typedArray.getBoolean(21, false);
        this.mSettingsDescriptionId = typedArray.getResourceId(20, 0);
        this.mSuggestAuthority = typedArray.getString(4);
        this.mSuggestPath = typedArray.getString(5);
        this.mSuggestSelection = typedArray.getString(6);
        this.mSuggestIntentAction = typedArray.getString(7);
        this.mSuggestIntentData = typedArray.getString(8);
        this.mSuggestThreshold = typedArray.getInt(17, 0);
        this.mVoiceSearchMode = typedArray.getInt(11, 0);
        this.mVoiceLanguageModeId = typedArray.getResourceId(12, 0);
        this.mVoicePromptTextId = typedArray.getResourceId(13, 0);
        this.mVoiceLanguageId = typedArray.getResourceId(14, 0);
        this.mVoiceMaxResults = typedArray.getInt(15, 0);
        typedArray.recycle();
        String string2 = this.mSuggestAuthority;
        String string3 = null;
        if (string2 != null) {
            ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(this.mSuggestAuthority, 0);
            string3 = null;
            if (providerInfo != null) {
                string3 = providerInfo.packageName;
            }
        }
        this.mSuggestProviderPackage = string3;
        if (this.mLabelId == 0) {
            throw new IllegalArgumentException("Search label must be a resource reference.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    SearchableInfo(Parcel parcel) {
        boolean bl = true;
        this.mActionKeys = null;
        this.mLabelId = parcel.readInt();
        this.mSearchActivity = ComponentName.readFromParcel(parcel);
        this.mHintId = parcel.readInt();
        this.mSearchMode = parcel.readInt();
        this.mIconId = parcel.readInt();
        this.mSearchButtonText = parcel.readInt();
        this.mSearchInputType = parcel.readInt();
        this.mSearchImeOptions = parcel.readInt();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.mIncludeInGlobalSearch = bl2;
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.mQueryAfterZeroResults = bl3;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.mAutoUrlDetect = bl;
        this.mSettingsDescriptionId = parcel.readInt();
        this.mSuggestAuthority = parcel.readString();
        this.mSuggestPath = parcel.readString();
        this.mSuggestSelection = parcel.readString();
        this.mSuggestIntentAction = parcel.readString();
        this.mSuggestIntentData = parcel.readString();
        this.mSuggestThreshold = parcel.readInt();
        int n = parcel.readInt();
        while (true) {
            if (n <= 0) {
                this.mSuggestProviderPackage = parcel.readString();
                this.mVoiceSearchMode = parcel.readInt();
                this.mVoiceLanguageModeId = parcel.readInt();
                this.mVoicePromptTextId = parcel.readInt();
                this.mVoiceLanguageId = parcel.readInt();
                this.mVoiceMaxResults = parcel.readInt();
                return;
            }
            this.addActionKey(new ActionKeyInfo(parcel));
            --n;
        }
    }

    private void addActionKey(ActionKeyInfo actionKeyInfo) {
        if (this.mActionKeys == null) {
            this.mActionKeys = new HashMap();
        }
        this.mActionKeys.put(actionKeyInfo.getKeyCode(), actionKeyInfo);
    }

    private static Context createActivityContext(Context context, ComponentName componentName) {
        try {
            Context context2 = context.createPackageContext(componentName.getPackageName(), 0);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(LOG_TAG, "Package not found " + componentName.getPackageName());
            return null;
        }
        catch (SecurityException securityException) {
            Log.e(LOG_TAG, "Can't make context for " + componentName.getPackageName(), securityException);
            return null;
        }
    }

    public static SearchableInfo getActivityMetaData(Context context, ActivityInfo activityInfo, int n) {
        Context context2;
        try {
            context2 = context.createPackageContextAsUser("system", 0, new UserHandle(n));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(LOG_TAG, "Couldn't create package context for user " + n);
            return null;
        }
        XmlResourceParser xmlResourceParser = activityInfo.loadXmlMetaData(context2.getPackageManager(), MD_LABEL_SEARCHABLE);
        if (xmlResourceParser == null) {
            return null;
        }
        SearchableInfo searchableInfo = SearchableInfo.getActivityMetaData(context2, xmlResourceParser, new ComponentName(activityInfo.packageName, activityInfo.name));
        xmlResourceParser.close();
        return searchableInfo;
    }

    /*
     * Exception decompiling
     */
    private static SearchableInfo getActivityMetaData(Context var0, XmlPullParser var1_1, ComponentName var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean autoUrlDetect() {
        return this.mAutoUrlDetect;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ActionKeyInfo findActionKey(int n) {
        if (this.mActionKeys == null) {
            return null;
        }
        return this.mActionKeys.get(n);
    }

    public Context getActivityContext(Context context) {
        return SearchableInfo.createActivityContext(context, this.mSearchActivity);
    }

    public int getHintId() {
        return this.mHintId;
    }

    public int getIconId() {
        return this.mIconId;
    }

    public int getImeOptions() {
        return this.mSearchImeOptions;
    }

    public int getInputType() {
        return this.mSearchInputType;
    }

    public int getLabelId() {
        return this.mLabelId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Context getProviderContext(Context context, Context context2) {
        if (this.mSearchActivity.getPackageName().equals(this.mSuggestProviderPackage)) {
            return context2;
        }
        String string2 = this.mSuggestProviderPackage;
        Context context3 = null;
        if (string2 == null) return context3;
        try {
            Context context4 = context.createPackageContext(this.mSuggestProviderPackage, 0);
            return context4;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public ComponentName getSearchActivity() {
        return this.mSearchActivity;
    }

    public int getSearchButtonText() {
        return this.mSearchButtonText;
    }

    public int getSettingsDescriptionId() {
        return this.mSettingsDescriptionId;
    }

    public String getSuggestAuthority() {
        return this.mSuggestAuthority;
    }

    public String getSuggestIntentAction() {
        return this.mSuggestIntentAction;
    }

    public String getSuggestIntentData() {
        return this.mSuggestIntentData;
    }

    public String getSuggestPackage() {
        return this.mSuggestProviderPackage;
    }

    public String getSuggestPath() {
        return this.mSuggestPath;
    }

    public String getSuggestSelection() {
        return this.mSuggestSelection;
    }

    public int getSuggestThreshold() {
        return this.mSuggestThreshold;
    }

    public int getVoiceLanguageId() {
        return this.mVoiceLanguageId;
    }

    public int getVoiceLanguageModeId() {
        return this.mVoiceLanguageModeId;
    }

    public int getVoiceMaxResults() {
        return this.mVoiceMaxResults;
    }

    public int getVoicePromptTextId() {
        return this.mVoicePromptTextId;
    }

    public boolean getVoiceSearchEnabled() {
        return (1 & this.mVoiceSearchMode) != 0;
    }

    public boolean getVoiceSearchLaunchRecognizer() {
        return (4 & this.mVoiceSearchMode) != 0;
    }

    public boolean getVoiceSearchLaunchWebSearch() {
        return (2 & this.mVoiceSearchMode) != 0;
    }

    public boolean queryAfterZeroResults() {
        return this.mQueryAfterZeroResults;
    }

    public boolean shouldIncludeInGlobalSearch() {
        return this.mIncludeInGlobalSearch;
    }

    public boolean shouldRewriteQueryFromData() {
        return (0x10 & this.mSearchMode) != 0;
    }

    public boolean shouldRewriteQueryFromText() {
        return (0x20 & this.mSearchMode) != 0;
    }

    public boolean useBadgeIcon() {
        return (8 & this.mSearchMode) != 0 && this.mIconId != 0;
    }

    public boolean useBadgeLabel() {
        return (4 & this.mSearchMode) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mLabelId);
        this.mSearchActivity.writeToParcel(parcel, n);
        parcel.writeInt(this.mHintId);
        parcel.writeInt(this.mSearchMode);
        parcel.writeInt(this.mIconId);
        parcel.writeInt(this.mSearchButtonText);
        parcel.writeInt(this.mSearchInputType);
        parcel.writeInt(this.mSearchImeOptions);
        int n3 = this.mIncludeInGlobalSearch ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mQueryAfterZeroResults ? n2 : 0;
        parcel.writeInt(n4);
        if (!this.mAutoUrlDetect) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeInt(this.mSettingsDescriptionId);
        parcel.writeString(this.mSuggestAuthority);
        parcel.writeString(this.mSuggestPath);
        parcel.writeString(this.mSuggestSelection);
        parcel.writeString(this.mSuggestIntentAction);
        parcel.writeString(this.mSuggestIntentData);
        parcel.writeInt(this.mSuggestThreshold);
        if (this.mActionKeys == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(this.mActionKeys.size());
            Iterator<ActionKeyInfo> iterator = this.mActionKeys.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().writeToParcel(parcel, n);
            }
        }
        parcel.writeString(this.mSuggestProviderPackage);
        parcel.writeInt(this.mVoiceSearchMode);
        parcel.writeInt(this.mVoiceLanguageModeId);
        parcel.writeInt(this.mVoicePromptTextId);
        parcel.writeInt(this.mVoiceLanguageId);
        parcel.writeInt(this.mVoiceMaxResults);
    }

    public static class ActionKeyInfo
    implements Parcelable {
        private final int mKeyCode;
        private final String mQueryActionMsg;
        private final String mSuggestActionMsg;
        private final String mSuggestActionMsgColumn;

        ActionKeyInfo(Context context, AttributeSet attributeSet) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SearchableActionKey);
            this.mKeyCode = typedArray.getInt(0, 0);
            this.mQueryActionMsg = typedArray.getString(1);
            this.mSuggestActionMsg = typedArray.getString(2);
            this.mSuggestActionMsgColumn = typedArray.getString(3);
            typedArray.recycle();
            if (this.mKeyCode == 0) {
                throw new IllegalArgumentException("No keycode.");
            }
            if (this.mQueryActionMsg == null && this.mSuggestActionMsg == null && this.mSuggestActionMsgColumn == null) {
                throw new IllegalArgumentException("No message information.");
            }
        }

        private ActionKeyInfo(Parcel parcel) {
            this.mKeyCode = parcel.readInt();
            this.mQueryActionMsg = parcel.readString();
            this.mSuggestActionMsg = parcel.readString();
            this.mSuggestActionMsgColumn = parcel.readString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int getKeyCode() {
            return this.mKeyCode;
        }

        public String getQueryActionMsg() {
            return this.mQueryActionMsg;
        }

        public String getSuggestActionMsg() {
            return this.mSuggestActionMsg;
        }

        public String getSuggestActionMsgColumn() {
            return this.mSuggestActionMsgColumn;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mKeyCode);
            parcel.writeString(this.mQueryActionMsg);
            parcel.writeString(this.mSuggestActionMsg);
            parcel.writeString(this.mSuggestActionMsgColumn);
        }
    }
}

