/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;

public class JobInfo
implements Parcelable {
    public static final int BACKOFF_POLICY_EXPONENTIAL = 1;
    public static final int BACKOFF_POLICY_LINEAR = 0;
    public static final Parcelable.Creator<JobInfo> CREATOR = new Parcelable.Creator<JobInfo>(){

        @Override
        public JobInfo createFromParcel(Parcel parcel) {
            return new JobInfo(parcel);
        }

        public JobInfo[] newArray(int n) {
            return new JobInfo[n];
        }
    };
    public static final int DEFAULT_BACKOFF_POLICY = 1;
    public static final long DEFAULT_INITIAL_BACKOFF_MILLIS = 30000L;
    public static final long MAX_BACKOFF_DELAY_MILLIS = 18000000L;
    public static final int NETWORK_TYPE_ANY = 1;
    public static final int NETWORK_TYPE_NONE = 0;
    public static final int NETWORK_TYPE_UNMETERED = 2;
    private final int backoffPolicy;
    private final PersistableBundle extras;
    private final boolean hasEarlyConstraint;
    private final boolean hasLateConstraint;
    private final long initialBackoffMillis;
    private final long intervalMillis;
    private final boolean isPeriodic;
    private final boolean isPersisted;
    private final int jobId;
    private final long maxExecutionDelayMillis;
    private final long minLatencyMillis;
    private final int networkType;
    private final boolean requireCharging;
    private final boolean requireDeviceIdle;
    private final ComponentName service;

    private JobInfo(Builder builder) {
        this.jobId = builder.mJobId;
        this.extras = builder.mExtras;
        this.service = builder.mJobService;
        this.requireCharging = builder.mRequiresCharging;
        this.requireDeviceIdle = builder.mRequiresDeviceIdle;
        this.networkType = builder.mNetworkType;
        this.minLatencyMillis = builder.mMinLatencyMillis;
        this.maxExecutionDelayMillis = builder.mMaxExecutionDelayMillis;
        this.isPeriodic = builder.mIsPeriodic;
        this.isPersisted = builder.mIsPersisted;
        this.intervalMillis = builder.mIntervalMillis;
        this.initialBackoffMillis = builder.mInitialBackoffMillis;
        this.backoffPolicy = builder.mBackoffPolicy;
        this.hasEarlyConstraint = builder.mHasEarlyConstraint;
        this.hasLateConstraint = builder.mHasLateConstraint;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JobInfo(Parcel parcel) {
        int n = 1;
        this.jobId = parcel.readInt();
        this.extras = parcel.readPersistableBundle();
        this.service = (ComponentName)parcel.readParcelable(null);
        int n2 = parcel.readInt() == n ? n : 0;
        this.requireCharging = n2;
        int n3 = parcel.readInt() == n ? n : 0;
        this.requireDeviceIdle = n3;
        this.networkType = parcel.readInt();
        this.minLatencyMillis = parcel.readLong();
        this.maxExecutionDelayMillis = parcel.readLong();
        int n4 = parcel.readInt() == n ? n : 0;
        this.isPeriodic = n4;
        int n5 = parcel.readInt() == n ? n : 0;
        this.isPersisted = n5;
        this.intervalMillis = parcel.readLong();
        this.initialBackoffMillis = parcel.readLong();
        this.backoffPolicy = parcel.readInt();
        int n6 = parcel.readInt() == n ? n : 0;
        this.hasEarlyConstraint = n6;
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.hasLateConstraint = n;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public PersistableBundle getExtras() {
        return this.extras;
    }

    public int getId() {
        return this.jobId;
    }

    public long getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public long getMaxExecutionDelayMillis() {
        return this.maxExecutionDelayMillis;
    }

    public long getMinLatencyMillis() {
        return this.minLatencyMillis;
    }

    public int getNetworkType() {
        return this.networkType;
    }

    public ComponentName getService() {
        return this.service;
    }

    public boolean hasEarlyConstraint() {
        return this.hasEarlyConstraint;
    }

    public boolean hasLateConstraint() {
        return this.hasLateConstraint;
    }

    public boolean isPeriodic() {
        return this.isPeriodic;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public boolean isRequireCharging() {
        return this.requireCharging;
    }

    public boolean isRequireDeviceIdle() {
        return this.requireDeviceIdle;
    }

    public String toString() {
        return "(job:" + this.jobId + "/" + this.service.flattenToShortString() + ")";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.jobId);
        parcel.writePersistableBundle(this.extras);
        parcel.writeParcelable(this.service, n);
        int n3 = this.requireCharging ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.requireDeviceIdle ? n2 : 0;
        parcel.writeInt(n4);
        parcel.writeInt(this.networkType);
        parcel.writeLong(this.minLatencyMillis);
        parcel.writeLong(this.maxExecutionDelayMillis);
        int n5 = this.isPeriodic ? n2 : 0;
        parcel.writeInt(n5);
        int n6 = this.isPersisted ? n2 : 0;
        parcel.writeInt(n6);
        parcel.writeLong(this.intervalMillis);
        parcel.writeLong(this.initialBackoffMillis);
        parcel.writeInt(this.backoffPolicy);
        int n7 = this.hasEarlyConstraint ? n2 : 0;
        parcel.writeInt(n7);
        if (!this.hasLateConstraint) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }

    public static final class Builder {
        private int mBackoffPolicy = 1;
        private boolean mBackoffPolicySet = false;
        private PersistableBundle mExtras = PersistableBundle.EMPTY;
        private boolean mHasEarlyConstraint;
        private boolean mHasLateConstraint;
        private long mInitialBackoffMillis = 30000L;
        private long mIntervalMillis;
        private boolean mIsPeriodic;
        private boolean mIsPersisted;
        private int mJobId;
        private ComponentName mJobService;
        private long mMaxExecutionDelayMillis;
        private long mMinLatencyMillis;
        private int mNetworkType;
        private boolean mRequiresCharging;
        private boolean mRequiresDeviceIdle;

        public Builder(int n, ComponentName componentName) {
            this.mJobService = componentName;
            this.mJobId = n;
        }

        public JobInfo build() {
            if (!(this.mHasEarlyConstraint || this.mHasLateConstraint || this.mRequiresCharging || this.mRequiresDeviceIdle || this.mNetworkType != 0)) {
                throw new IllegalArgumentException("You're trying to build a job with no constraints, this is not allowed.");
            }
            this.mExtras = new PersistableBundle(this.mExtras);
            if (this.mIsPeriodic && this.mMaxExecutionDelayMillis != 0L) {
                throw new IllegalArgumentException("Can't call setOverrideDeadline() on a periodic job.");
            }
            if (this.mIsPeriodic && this.mMinLatencyMillis != 0L) {
                throw new IllegalArgumentException("Can't call setMinimumLatency() on a periodic job");
            }
            if (this.mBackoffPolicySet && this.mRequiresDeviceIdle) {
                throw new IllegalArgumentException("An idle mode job will not respect any back-off policy, so calling setBackoffCriteria with setRequiresDeviceIdle is an error.");
            }
            return new JobInfo(this);
        }

        public Builder setBackoffCriteria(long l, int n) {
            this.mBackoffPolicySet = true;
            this.mInitialBackoffMillis = l;
            this.mBackoffPolicy = n;
            return this;
        }

        public Builder setExtras(PersistableBundle persistableBundle) {
            this.mExtras = persistableBundle;
            return this;
        }

        public Builder setMinimumLatency(long l) {
            this.mMinLatencyMillis = l;
            this.mHasEarlyConstraint = true;
            return this;
        }

        public Builder setOverrideDeadline(long l) {
            this.mMaxExecutionDelayMillis = l;
            this.mHasLateConstraint = true;
            return this;
        }

        public Builder setPeriodic(long l) {
            this.mIsPeriodic = true;
            this.mIntervalMillis = l;
            this.mHasLateConstraint = true;
            this.mHasEarlyConstraint = true;
            return this;
        }

        public Builder setPersisted(boolean bl) {
            this.mIsPersisted = bl;
            return this;
        }

        public Builder setRequiredNetworkType(int n) {
            this.mNetworkType = n;
            return this;
        }

        public Builder setRequiresCharging(boolean bl) {
            this.mRequiresCharging = bl;
            return this;
        }

        public Builder setRequiresDeviceIdle(boolean bl) {
            this.mRequiresDeviceIdle = bl;
            return this;
        }
    }
}

