/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.List;

public final class UsageEvents
implements Parcelable {
    public static final Parcelable.Creator<UsageEvents> CREATOR = new Parcelable.Creator<UsageEvents>(){

        @Override
        public UsageEvents createFromParcel(Parcel parcel) {
            return new UsageEvents(parcel);
        }

        public UsageEvents[] newArray(int n) {
            return new UsageEvents[n];
        }
    };
    private final int mEventCount;
    private List<Event> mEventsToWrite = null;
    private int mIndex = 0;
    private Parcel mParcel = null;
    private String[] mStringPool;

    UsageEvents() {
        this.mEventCount = 0;
    }

    public UsageEvents(Parcel parcel) {
        this.mEventCount = parcel.readInt();
        this.mIndex = parcel.readInt();
        if (this.mEventCount > 0) {
            this.mStringPool = parcel.createStringArray();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            this.mParcel = Parcel.obtain();
            this.mParcel.setDataPosition(0);
            this.mParcel.appendFrom(parcel, parcel.dataPosition(), n);
            this.mParcel.setDataSize(this.mParcel.dataPosition());
            this.mParcel.setDataPosition(n2);
        }
    }

    public UsageEvents(List<Event> list, String[] stringArray) {
        this.mStringPool = stringArray;
        this.mEventCount = list.size();
        this.mEventsToWrite = list;
    }

    private int findStringIndex(String string2) {
        int n = Arrays.binarySearch(this.mStringPool, string2);
        if (n < 0) {
            throw new IllegalStateException("String '" + string2 + "' is not in the string pool");
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readEventFromParcel(Parcel parcel, Event event) {
        int n = parcel.readInt();
        event.mPackage = n >= 0 ? this.mStringPool[n] : null;
        int n2 = parcel.readInt();
        event.mClass = n2 >= 0 ? this.mStringPool[n2] : null;
        event.mEventType = parcel.readInt();
        event.mTimeStamp = parcel.readLong();
        if (event.mEventType == 5) {
            event.mConfiguration = Configuration.CREATOR.createFromParcel(parcel);
            return;
        }
        event.mConfiguration = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeEventToParcel(Event event, Parcel parcel, int n) {
        int n2 = event.mPackage != null ? this.findStringIndex(event.mPackage) : -1;
        int n3 = event.mClass != null ? this.findStringIndex(event.mClass) : -1;
        parcel.writeInt(n2);
        parcel.writeInt(n3);
        parcel.writeInt(event.mEventType);
        parcel.writeLong(event.mTimeStamp);
        if (event.mEventType == 5) {
            event.mConfiguration.writeToParcel(parcel, n);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mParcel != null) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
    }

    public boolean getNextEvent(Event event) {
        if (this.mIndex >= this.mEventCount) {
            return false;
        }
        this.readEventFromParcel(this.mParcel, event);
        this.mIndex = 1 + this.mIndex;
        if (this.mIndex >= this.mEventCount) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
        return true;
    }

    public boolean hasNextEvent() {
        return this.mIndex < this.mEventCount;
    }

    public void resetToStart() {
        this.mIndex = 0;
        if (this.mParcel != null) {
            this.mParcel.setDataPosition(0);
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        block11: {
            block10: {
                parcel.writeInt(this.mEventCount);
                parcel.writeInt(this.mIndex);
                if (this.mEventCount <= 0) break block10;
                parcel.writeStringArray(this.mStringPool);
                if (this.mEventsToWrite == null) break block11;
                Parcel parcel2 = Parcel.obtain();
                parcel2.setDataPosition(0);
                int n2 = 0;
                while (true) {
                    if (n2 >= this.mEventCount) break;
                    this.writeEventToParcel(this.mEventsToWrite.get(n2), parcel2, n);
                    ++n2;
                    continue;
                    break;
                }
                try {
                    int n3 = parcel2.dataPosition();
                    parcel.writeInt(n3);
                    parcel.writeInt(0);
                    parcel.appendFrom(parcel2, 0, n3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    parcel2.recycle();
                }
            }
            return;
        }
        if (this.mParcel != null) {
            parcel.writeInt(this.mParcel.dataSize());
            parcel.writeInt(this.mParcel.dataPosition());
            parcel.appendFrom(this.mParcel, 0, this.mParcel.dataSize());
            return;
        }
        throw new IllegalStateException("Either mParcel or mEventsToWrite must not be null");
    }

    public static final class Event {
        public static final int CONFIGURATION_CHANGE = 5;
        public static final int CONTINUE_PREVIOUS_DAY = 4;
        public static final int END_OF_DAY = 3;
        public static final int MOVE_TO_BACKGROUND = 2;
        public static final int MOVE_TO_FOREGROUND = 1;
        public static final int NONE;
        public String mClass;
        public Configuration mConfiguration;
        public int mEventType;
        public String mPackage;
        public long mTimeStamp;

        public String getClassName() {
            return this.mClass;
        }

        public Configuration getConfiguration() {
            return this.mConfiguration;
        }

        public int getEventType() {
            return this.mEventType;
        }

        public String getPackageName() {
            return this.mPackage;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }
    }
}

