/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGattService {
    public static final int SERVICE_TYPE_PRIMARY = 0;
    public static final int SERVICE_TYPE_SECONDARY = 1;
    private boolean mAdvertisePreferred;
    protected List<BluetoothGattCharacteristic> mCharacteristics;
    protected BluetoothDevice mDevice;
    protected int mHandles = 0;
    protected List<BluetoothGattService> mIncludedServices;
    protected int mInstanceId;
    protected int mServiceType;
    protected UUID mUuid;

    BluetoothGattService(BluetoothDevice bluetoothDevice, UUID uUID, int n, int n2) {
        this.mDevice = bluetoothDevice;
        this.mUuid = uUID;
        this.mInstanceId = n;
        this.mServiceType = n2;
        this.mCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
        this.mIncludedServices = new ArrayList<BluetoothGattService>();
    }

    public BluetoothGattService(UUID uUID, int n) {
        this.mDevice = null;
        this.mUuid = uUID;
        this.mInstanceId = 0;
        this.mServiceType = n;
        this.mCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
        this.mIncludedServices = new ArrayList<BluetoothGattService>();
    }

    public boolean addCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        this.mCharacteristics.add(bluetoothGattCharacteristic);
        bluetoothGattCharacteristic.setService(this);
        return true;
    }

    void addIncludedService(BluetoothGattService bluetoothGattService) {
        this.mIncludedServices.add(bluetoothGattService);
    }

    public boolean addService(BluetoothGattService bluetoothGattService) {
        this.mIncludedServices.add(bluetoothGattService);
        return true;
    }

    public BluetoothGattCharacteristic getCharacteristic(UUID uUID) {
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic : this.mCharacteristics) {
            if (!uUID.equals(bluetoothGattCharacteristic.getUuid())) continue;
            return bluetoothGattCharacteristic;
        }
        return null;
    }

    BluetoothGattCharacteristic getCharacteristic(UUID uUID, int n) {
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic : this.mCharacteristics) {
            if (!uUID.equals(bluetoothGattCharacteristic.getUuid()) || bluetoothGattCharacteristic.getInstanceId() != n) continue;
            return bluetoothGattCharacteristic;
        }
        return null;
    }

    public List<BluetoothGattCharacteristic> getCharacteristics() {
        return this.mCharacteristics;
    }

    BluetoothDevice getDevice() {
        return this.mDevice;
    }

    int getHandles() {
        return this.mHandles;
    }

    public List<BluetoothGattService> getIncludedServices() {
        return this.mIncludedServices;
    }

    public int getInstanceId() {
        return this.mInstanceId;
    }

    public int getType() {
        return this.mServiceType;
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public boolean isAdvertisePreferred() {
        return this.mAdvertisePreferred;
    }

    public void setAdvertisePreferred(boolean bl) {
        this.mAdvertisePreferred = bl;
    }

    public void setHandles(int n) {
        this.mHandles = n;
    }

    public void setInstanceId(int n) {
        this.mInstanceId = n;
    }
}

