/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadsetClientCall;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHeadsetClient;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothHeadsetClient
implements BluetoothProfile {
    public static final String ACTION_AG_EVENT = "android.bluetooth.headsetclient.profile.action.AG_EVENT";
    public static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headsetclient.profile.action.AUDIO_STATE_CHANGED";
    public static final String ACTION_CALL_CHANGED = "android.bluetooth.headsetclient.profile.action.AG_CALL_CHANGED";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headsetclient.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_LAST_VTAG = "android.bluetooth.headsetclient.profile.action.LAST_VTAG";
    public static final String ACTION_RESULT = "android.bluetooth.headsetclient.profile.action.RESULT";
    public static final int ACTION_RESULT_ERROR = 1;
    public static final int ACTION_RESULT_ERROR_BLACKLISTED = 6;
    public static final int ACTION_RESULT_ERROR_BUSY = 3;
    public static final int ACTION_RESULT_ERROR_CME = 7;
    public static final int ACTION_RESULT_ERROR_DELAYED = 5;
    public static final int ACTION_RESULT_ERROR_NO_ANSWER = 4;
    public static final int ACTION_RESULT_ERROR_NO_CARRIER = 2;
    public static final int ACTION_RESULT_OK = 0;
    public static final int CALL_ACCEPT_HOLD = 1;
    public static final int CALL_ACCEPT_NONE = 0;
    public static final int CALL_ACCEPT_TERMINATE = 2;
    public static final int CME_CORPORATE_PERSONALIZATION_PIN_REQUIRED = 46;
    public static final int CME_CORPORATE_PERSONALIZATION_PUK_REQUIRED = 47;
    public static final int CME_DIAL_STRING_TOO_LONG = 26;
    public static final int CME_EAP_NOT_SUPPORTED = 49;
    public static final int CME_EMERGENCY_SERVICE_ONLY = 32;
    public static final int CME_HIDDEN_KEY_REQUIRED = 48;
    public static final int CME_INCORRECT_PARAMETERS = 50;
    public static final int CME_INCORRECT_PASSWORD = 16;
    public static final int CME_INVALID_CHARACTER_IN_DIAL_STRING = 27;
    public static final int CME_INVALID_CHARACTER_IN_TEXT_STRING = 25;
    public static final int CME_INVALID_INDEX = 21;
    public static final int CME_MEMORY_FAILURE = 23;
    public static final int CME_MEMORY_FULL = 20;
    public static final int CME_NETWORK_PERSONALIZATION_PIN_REQUIRED = 40;
    public static final int CME_NETWORK_PERSONALIZATION_PUK_REQUIRED = 41;
    public static final int CME_NETWORK_SUBSET_PERSONALIZATION_PIN_REQUIRED = 42;
    public static final int CME_NETWORK_SUBSET_PERSONALIZATION_PUK_REQUIRED = 43;
    public static final int CME_NETWORK_TIMEOUT = 31;
    public static final int CME_NOT_FOUND = 22;
    public static final int CME_NOT_SUPPORTED_FOR_VOIP = 34;
    public static final int CME_NO_CONNECTION_TO_PHONE = 1;
    public static final int CME_NO_NETWORK_SERVICE = 30;
    public static final int CME_NO_SIMULTANOUS_VOIP_CS_CALLS = 33;
    public static final int CME_OPERATION_NOT_ALLOWED = 3;
    public static final int CME_OPERATION_NOT_SUPPORTED = 4;
    public static final int CME_PHFSIM_PIN_REQUIRED = 6;
    public static final int CME_PHFSIM_PUK_REQUIRED = 7;
    public static final int CME_PHONE_FAILURE = 0;
    public static final int CME_PHSIM_PIN_REQUIRED = 5;
    public static final int CME_SERVICE_PROVIDER_PERSONALIZATION_PIN_REQUIRED = 44;
    public static final int CME_SERVICE_PROVIDER_PERSONALIZATION_PUK_REQUIRED = 45;
    public static final int CME_SIM_BUSY = 14;
    public static final int CME_SIM_FAILURE = 13;
    public static final int CME_SIM_NOT_INSERTED = 10;
    public static final int CME_SIM_PIN2_REQUIRED = 17;
    public static final int CME_SIM_PIN_REQUIRED = 11;
    public static final int CME_SIM_PUK2_REQUIRED = 18;
    public static final int CME_SIM_PUK_REQUIRED = 12;
    public static final int CME_SIM_WRONG = 15;
    public static final int CME_SIP_RESPONSE_CODE = 35;
    public static final int CME_TEXT_STRING_TOO_LONG = 24;
    private static final boolean DBG = true;
    public static final String EXTRA_AG_FEATURE_3WAY_CALLING = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_3WAY_CALLING";
    public static final String EXTRA_AG_FEATURE_ACCEPT_HELD_OR_WAITING_CALL = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_ACCEPT_HELD_OR_WAITING_CALL";
    public static final String EXTRA_AG_FEATURE_ATTACH_NUMBER_TO_VT = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_ATTACH_NUMBER_TO_VT";
    public static final String EXTRA_AG_FEATURE_ECC = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_ECC";
    public static final String EXTRA_AG_FEATURE_MERGE = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_MERGE";
    public static final String EXTRA_AG_FEATURE_MERGE_AND_DETACH = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_MERGE_AND_DETACH";
    public static final String EXTRA_AG_FEATURE_REJECT_CALL = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_REJECT_CALL";
    public static final String EXTRA_AG_FEATURE_RELEASE_AND_ACCEPT = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_RELEASE_AND_ACCEPT";
    public static final String EXTRA_AG_FEATURE_RELEASE_HELD_OR_WAITING_CALL = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_RELEASE_HELD_OR_WAITING_CALL";
    public static final String EXTRA_AG_FEATURE_RESPONSE_AND_HOLD = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_RESPONSE_AND_HOLD";
    public static final String EXTRA_AG_FEATURE_VOICE_RECOGNITION = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_VOICE_RECOGNITION";
    public static final String EXTRA_AUDIO_WBS = "android.bluetooth.headsetclient.extra.AUDIO_WBS";
    public static final String EXTRA_BATTERY_LEVEL = "android.bluetooth.headsetclient.extra.BATTERY_LEVEL";
    public static final String EXTRA_CALL = "android.bluetooth.headsetclient.extra.CALL";
    public static final String EXTRA_CME_CODE = "android.bluetooth.headsetclient.extra.CME_CODE";
    public static final String EXTRA_IN_BAND_RING = "android.bluetooth.headsetclient.extra.IN_BAND_RING";
    public static final String EXTRA_NETWORK_ROAMING = "android.bluetooth.headsetclient.extra.NETWORK_ROAMING";
    public static final String EXTRA_NETWORK_SIGNAL_STRENGTH = "android.bluetooth.headsetclient.extra.NETWORK_SIGNAL_STRENGTH";
    public static final String EXTRA_NETWORK_STATUS = "android.bluetooth.headsetclient.extra.NETWORK_STATUS";
    public static final String EXTRA_NUMBER = "android.bluetooth.headsetclient.extra.NUMBER";
    public static final String EXTRA_OPERATOR_NAME = "android.bluetooth.headsetclient.extra.OPERATOR_NAME";
    public static final String EXTRA_RESULT_CODE = "android.bluetooth.headsetclient.extra.RESULT_CODE";
    public static final String EXTRA_SUBSCRIBER_INFO = "android.bluetooth.headsetclient.extra.SUBSCRIBER_INFO";
    public static final String EXTRA_VOICE_RECOGNITION = "android.bluetooth.headsetclient.extra.VOICE_RECOGNITION";
    public static final int STATE_AUDIO_CONNECTED = 2;
    public static final int STATE_AUDIO_CONNECTING = 1;
    public static final int STATE_AUDIO_DISCONNECTED = 0;
    private static final String TAG = "BluetoothHeadsetClient";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothHeadsetClient.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothHeadsetClient.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothHeadsetClient.access$102(BluetoothHeadsetClient.this, null);
                        BluetoothHeadsetClient.this.mContext.unbindService(BluetoothHeadsetClient.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothHeadsetClient.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothHeadsetClient.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothHeadsetClient.this.mService == null) {
                        new Intent(IBluetoothHeadsetClient.class.getName());
                        BluetoothHeadsetClient.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothHeadsetClient.TAG, "", exception);
                }
                return;
            }
        }
    };
    private ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d(BluetoothHeadsetClient.TAG, "Proxy object connected");
            BluetoothHeadsetClient.access$102(BluetoothHeadsetClient.this, IBluetoothHeadsetClient.Stub.asInterface(iBinder));
            if (BluetoothHeadsetClient.this.mServiceListener != null) {
                BluetoothHeadsetClient.this.mServiceListener.onServiceConnected(16, BluetoothHeadsetClient.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.d(BluetoothHeadsetClient.TAG, "Proxy object disconnected");
            BluetoothHeadsetClient.access$102(BluetoothHeadsetClient.this, null);
            if (BluetoothHeadsetClient.this.mServiceListener != null) {
                BluetoothHeadsetClient.this.mServiceListener.onServiceDisconnected(16);
            }
        }
    };
    private Context mContext;
    private IBluetoothHeadsetClient mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothHeadsetClient(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothHeadsetClient access$102(BluetoothHeadsetClient bluetoothHeadsetClient, IBluetoothHeadsetClient iBluetoothHeadsetClient) {
        bluetoothHeadsetClient.mService = iBluetoothHeadsetClient;
        return iBluetoothHeadsetClient;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    public boolean acceptCall(BluetoothDevice bluetoothDevice, int n) {
        BluetoothHeadsetClient.log("acceptCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.acceptCall(bluetoothDevice, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acceptIncomingConnect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("acceptIncomingConnect");
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.acceptIncomingConnect(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothHeadsetClient iBluetoothHeadsetClient = this.mService;
            if (iBluetoothHeadsetClient != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
        }
        this.mServiceListener = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("connect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.connect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothHeadsetClient iBluetoothHeadsetClient = this.mService;
        boolean bl = false;
        if (iBluetoothHeadsetClient != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.connectAudio();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public boolean dial(BluetoothDevice bluetoothDevice, String string2) {
        BluetoothHeadsetClient.log("dial()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.dial(bluetoothDevice, string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean dialMemory(BluetoothDevice bluetoothDevice, int n) {
        BluetoothHeadsetClient.log("dialMemory()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.dialMemory(bluetoothDevice, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("disconnect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.disconnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothHeadsetClient iBluetoothHeadsetClient = this.mService;
        boolean bl = false;
        if (iBluetoothHeadsetClient != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.disconnectAudio();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothHeadsetClient.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth Headset Client Service with " + intent);
            return false;
        }
        return true;
    }

    public boolean enterPrivateMode(BluetoothDevice bluetoothDevice, int n) {
        BluetoothHeadsetClient.log("enterPrivateMode()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.enterPrivateMode(bluetoothDevice, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean explicitCallTransfer(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("explicitCallTransfer()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.explicitCallTransfer(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAudioState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getAudioState(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return 0;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return 0;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothHeadsetClient iBluetoothHeadsetClient = this.mService;
        int n = 0;
        if (iBluetoothHeadsetClient != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    public Bundle getCurrentAgEvents(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("getCurrentCalls()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                Bundle bundle = this.mService.getCurrentAgEvents(bluetoothDevice);
                return bundle;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bundle getCurrentAgFeatures(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getCurrentAgFeatures(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return null;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return null;
    }

    public List<BluetoothHeadsetClientCall> getCurrentCalls(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("getCurrentCalls()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                List<BluetoothHeadsetClientCall> list = this.mService.getCurrentCalls(bluetoothDevice);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return null;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    public boolean getLastVoiceTagNumber(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("getLastVoiceTagNumber()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.getLastVoiceTagNumber(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getPriority(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothHeadsetClient iBluetoothHeadsetClient = this.mService;
        int n = 0;
        if (iBluetoothHeadsetClient != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    public boolean holdCall(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("holdCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.holdCall(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean redial(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("redial()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.redial(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean rejectCall(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("rejectCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.rejectCall(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rejectIncomingConnect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("rejectIncomingConnect");
        if (this.mService != null) {
            try {
                return this.mService.rejectIncomingConnect(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public boolean sendDTMF(BluetoothDevice bluetoothDevice, byte by) {
        BluetoothHeadsetClient.log("sendDTMF()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.sendDTMF(bluetoothDevice, by);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        BluetoothHeadsetClient.log("setPriority(" + bluetoothDevice + ", " + n + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            if (n != 0 && n != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(bluetoothDevice, n);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService != null) return false;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    public boolean startVoiceRecognition(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("startVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.startVoiceRecognition(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean stopVoiceRecognition(BluetoothDevice bluetoothDevice) {
        BluetoothHeadsetClient.log("stopVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.stopVoiceRecognition(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean terminateCall(BluetoothDevice bluetoothDevice, int n) {
        BluetoothHeadsetClient.log("terminateCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.terminateCall(bluetoothDevice, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }
}

