/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothMap;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothMap
implements BluetoothProfile {
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.map.profile.action.CONNECTION_STATE_CHANGED";
    private static final boolean DBG = true;
    public static final int RESULT_CANCELED = 2;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int STATE_ERROR = -1;
    private static final String TAG = "BluetoothMap";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothMap.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothMap.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothMap.access$102(BluetoothMap.this, null);
                        BluetoothMap.this.mContext.unbindService(BluetoothMap.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothMap.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothMap.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothMap.this.mService == null) {
                        BluetoothMap.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothMap.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            BluetoothMap.log("Proxy object connected");
            BluetoothMap.access$102(BluetoothMap.this, IBluetoothMap.Stub.asInterface(iBinder));
            if (BluetoothMap.this.mServiceListener != null) {
                BluetoothMap.this.mServiceListener.onServiceConnected(9, BluetoothMap.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            BluetoothMap.log("Proxy object disconnected");
            BluetoothMap.access$102(BluetoothMap.this, null);
            if (BluetoothMap.this.mServiceListener != null) {
                BluetoothMap.this.mServiceListener.onServiceDisconnected(9);
            }
        }
    };
    private final Context mContext;
    private IBluetoothMap mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothMap(Context context, BluetoothProfile.ServiceListener serviceListener) {
        Log.d(TAG, "Create BluetoothMap proxy object");
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothMap access$102(BluetoothMap bluetoothMap, IBluetoothMap iBluetoothMap) {
        bluetoothMap.mService = iBluetoothMap;
        return iBluetoothMap;
    }

    public static boolean doesClassMatchSink(BluetoothClass bluetoothClass) {
        switch (bluetoothClass.getDeviceClass()) {
            default: {
                return false;
            }
            case 256: 
            case 260: 
            case 264: 
            case 268: 
        }
        return true;
    }

    private boolean isEnabled() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null && bluetoothAdapter.getState() == 12) {
            return true;
        }
        BluetoothMap.log("Bluetooth is Not enabled");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
            if (iBluetoothManager != null) {
                try {
                    iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
            ServiceConnection serviceConnection = this.mConnection;
            synchronized (serviceConnection) {
                IBluetoothMap iBluetoothMap = this.mService;
                if (iBluetoothMap != null) {
                    try {
                        this.mService = null;
                        this.mContext.unbindService(this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(TAG, "", exception);
                    }
                }
            }
            this.mServiceListener = null;
            return;
        }
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        BluetoothMap.log("connect(" + bluetoothDevice + ")" + "not supported for MAPS");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        BluetoothMap.log("disconnect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.disconnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothMap iBluetoothMap = this.mService;
        boolean bl = false;
        if (iBluetoothMap != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothMap.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth MAP Service with " + intent);
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothDevice getClient() {
        if (this.mService != null) {
            try {
                return this.mService.getClient();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return null;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        return null;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothMap.log("getConnectedDevices()");
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        BluetoothMap.log("getConnectionState(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothMap iBluetoothMap = this.mService;
        int n = 0;
        if (iBluetoothMap != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        BluetoothMap.log("getDevicesMatchingStates()");
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getPriority(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothMap iBluetoothMap = this.mService;
        int n = 0;
        if (iBluetoothMap != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        if (this.mService != null) {
            try {
                return this.mService.getState();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return -1;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                return this.mService.isConnected(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        BluetoothMap.log("setPriority(" + bluetoothDevice + ", " + n + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            if (n != 0 && n != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(bluetoothDevice, n);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService != null) return false;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }
}

