/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothInputStream;
import android.bluetooth.BluetoothOutputStream;
import android.bluetooth.IBluetooth;
import android.net.LocalSocket;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.UUID;

public final class BluetoothSocket
implements Closeable {
    private static final boolean DBG = false;
    static final int EADDRINUSE = 98;
    static final int EBADFD = 77;
    public static final int MAX_RFCOMM_CHANNEL = 30;
    private static int PROXY_CONNECTION_TIMEOUT = 0;
    static final int SEC_FLAG_AUTH = 2;
    static final int SEC_FLAG_ENCRYPT = 1;
    private static int SOCK_SIGNAL_SIZE = 0;
    private static final String TAG = "BluetoothSocket";
    static final int TYPE_L2CAP = 3;
    static final int TYPE_RFCOMM = 1;
    static final int TYPE_SCO = 2;
    static final int TYPE_VENDOR_HCI = 4;
    private static final boolean VDBG;
    private String mAddress;
    private final boolean mAuth;
    private BluetoothDevice mDevice;
    private final boolean mEncrypt;
    private int mFd;
    private final BluetoothInputStream mInputStream;
    private final BluetoothOutputStream mOutputStream;
    private ParcelFileDescriptor mPfd;
    private int mPort;
    private String mServiceName;
    private LocalSocket mSocket;
    private InputStream mSocketIS;
    private OutputStream mSocketOS;
    private volatile SocketState mSocketState;
    private final int mType;
    private final ParcelUuid mUuid;

    static {
        DBG = Log.isLoggable(TAG, 3);
        VDBG = Log.isLoggable(TAG, 2);
        PROXY_CONNECTION_TIMEOUT = 5000;
        SOCK_SIGNAL_SIZE = 16;
    }

    /*
     * Enabled aggressive block sorting
     */
    BluetoothSocket(int n, int n2, boolean bl, boolean bl2, BluetoothDevice bluetoothDevice, int n3, ParcelUuid parcelUuid) throws IOException {
        if (n == 1 && parcelUuid == null && n2 == -1 && (n3 < 1 || n3 > 30)) {
            throw new IOException("Invalid RFCOMM channel: " + n3);
        }
        this.mUuid = parcelUuid != null ? parcelUuid : new ParcelUuid(new UUID(0L, 0L));
        this.mType = n;
        this.mAuth = bl;
        this.mEncrypt = bl2;
        this.mDevice = bluetoothDevice;
        this.mPort = n3;
        this.mFd = n2;
        this.mSocketState = SocketState.INIT;
        this.mAddress = bluetoothDevice == null ? BluetoothAdapter.getDefaultAdapter().getAddress() : bluetoothDevice.getAddress();
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
    }

    private BluetoothSocket(int n, int n2, boolean bl, boolean bl2, String string2, int n3) throws IOException {
        this(n, n2, bl, bl2, new BluetoothDevice(string2), n3, null);
    }

    private BluetoothSocket(BluetoothSocket bluetoothSocket) {
        this.mUuid = bluetoothSocket.mUuid;
        this.mType = bluetoothSocket.mType;
        this.mAuth = bluetoothSocket.mAuth;
        this.mEncrypt = bluetoothSocket.mEncrypt;
        this.mPort = bluetoothSocket.mPort;
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mServiceName = bluetoothSocket.mServiceName;
    }

    private BluetoothSocket acceptSocket(String string2) throws IOException {
        BluetoothSocket bluetoothSocket = new BluetoothSocket(this);
        bluetoothSocket.mSocketState = SocketState.CONNECTED;
        FileDescriptor[] fileDescriptorArray = this.mSocket.getAncillaryFileDescriptors();
        if (DBG) {
            Log.d(TAG, "socket fd passed by stack  fds: " + fileDescriptorArray);
        }
        if (fileDescriptorArray == null || fileDescriptorArray.length != 1) {
            Log.e(TAG, "socket fd passed from stack failed, fds: " + fileDescriptorArray);
            bluetoothSocket.close();
            throw new IOException("bt socket acept failed");
        }
        bluetoothSocket.mSocket = new LocalSocket(fileDescriptorArray[0]);
        bluetoothSocket.mSocketIS = bluetoothSocket.mSocket.getInputStream();
        bluetoothSocket.mSocketOS = bluetoothSocket.mSocket.getOutputStream();
        bluetoothSocket.mAddress = string2;
        bluetoothSocket.mDevice = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(string2);
        return bluetoothSocket;
    }

    private String convertAddr(byte[] byArray) {
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5]};
        return String.format(locale, "%02X:%02X:%02X:%02X:%02X:%02X", objectArray);
    }

    private int getSecurityFlags() {
        boolean bl = this.mAuth;
        int n = 0;
        if (bl) {
            n = 0 | 2;
        }
        if (this.mEncrypt) {
            n |= 1;
        }
        return n;
    }

    private int readAll(InputStream inputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        while (n > 0) {
            int n2 = inputStream.read(byArray, byArray.length - n, n);
            if (n2 <= 0) {
                throw new IOException("read failed, socket might closed or timeout, read ret: " + n2);
            }
            if ((n -= n2) == 0) continue;
            Log.w(TAG, "readAll() looping, read partial size: " + (byArray.length - n) + ", expect size: " + byArray.length);
        }
        return byArray.length;
    }

    private int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = this.readAll(inputStream, byArray);
        if (VDBG) {
            Log.d(TAG, "inputStream.read ret: " + n);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.getInt();
    }

    private String waitSocketSignal(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[SOCK_SIGNAL_SIZE];
        int n = this.readAll(inputStream, byArray);
        if (VDBG) {
            Log.d(TAG, "waitSocketSignal read 16 bytes signal ret: " + n);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.nativeOrder());
        short s = byteBuffer.getShort();
        if (s != SOCK_SIGNAL_SIZE) {
            throw new IOException("Connection failure, wrong signal size: " + s);
        }
        byte[] byArray2 = new byte[6];
        byteBuffer.get(byArray2);
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        String string2 = this.convertAddr(byArray2);
        if (VDBG) {
            Log.d(TAG, "waitSocketSignal: sig size: " + s + ", remote addr: " + string2 + ", channel: " + n2 + ", status: " + n3);
        }
        if (n3 != 0) {
            throw new IOException("Connection failure, status: " + n3);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothSocket accept(int n) throws IOException {
        if (this.mSocketState != SocketState.LISTENING) {
            throw new IOException("bt socket is not in listen state");
        }
        if (n > 0) {
            Log.d(TAG, "accept() set timeout (ms):" + n);
            this.mSocket.setSoTimeout(n);
        }
        String string2 = this.waitSocketSignal(this.mSocketIS);
        if (n > 0) {
            this.mSocket.setSoTimeout(0);
        }
        synchronized (this) {
            if (this.mSocketState == SocketState.LISTENING) return this.acceptSocket(string2);
            throw new IOException("bt socket is not in listen state");
        }
    }

    int available() throws IOException {
        if (VDBG) {
            Log.d(TAG, "available: " + this.mSocketIS);
        }
        return this.mSocketIS.available();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int bindListen() {
        int n;
        block26: {
            block25: {
                if (this.mSocketState == SocketState.CLOSED) {
                    return 77;
                }
                IBluetooth iBluetooth = BluetoothAdapter.getDefaultAdapter().getBluetoothService(null);
                if (iBluetooth == null) {
                    Log.e(TAG, "bindListen fail, reason: bluetooth is off");
                    return -1;
                }
                try {
                    this.mPfd = iBluetooth.createSocketChannel(this.mType, this.mServiceName, this.mUuid, this.mPort, this.getSecurityFlags());
                    if (!DBG) break block25;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, Log.getStackTraceString(new Throwable()));
                    return -1;
                }
                Log.d(TAG, "bindListen(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
            }
            if (this.mSocketState != SocketState.INIT) {
                // MONITOREXIT : this
                return 77;
            }
            if (this.mPfd == null) {
                // MONITOREXIT : this
                return -1;
            }
            FileDescriptor fileDescriptor = this.mPfd.getFileDescriptor();
            if (DBG) {
                Log.d(TAG, "bindListen(), new LocalSocket ");
            }
            this.mSocket = new LocalSocket(fileDescriptor);
            if (DBG) {
                Log.d(TAG, "bindListen(), new LocalSocket.getInputStream() ");
            }
            this.mSocketIS = this.mSocket.getInputStream();
            this.mSocketOS = this.mSocket.getOutputStream();
            // MONITOREXIT : this
            try {
                if (DBG) {
                    Log.d(TAG, "bindListen(), readInt mSocketIS: " + this.mSocketIS);
                }
                n = this.readInt(this.mSocketIS);
                // MONITORENTER : this
                if (this.mSocketState != SocketState.INIT) break block26;
                this.mSocketState = SocketState.LISTENING;
            }
            catch (IOException iOException) {
                if (this.mPfd != null) {
                    try {
                        this.mPfd.close();
                    }
                    catch (IOException iOException2) {
                        Log.e(TAG, "bindListen, close mPfd: " + iOException2);
                    }
                    this.mPfd = null;
                }
                Log.e(TAG, "bindListen, fail to get port number, exception: " + iOException);
                return -1;
            }
        }
        // MONITOREXIT : this
        if (DBG) {
            Log.d(TAG, "channel: " + n);
        }
        if (this.mPort != -1) return 0;
        this.mPort = n;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (DBG) {
            Log.d(TAG, "close() in, this: " + this + ", channel: " + this.mPort + ", state: " + (Object)((Object)this.mSocketState));
        }
        if (this.mSocketState == SocketState.CLOSED) {
            return;
        }
        synchronized (this) {
            if (this.mSocketState == SocketState.CLOSED) {
                return;
            }
            this.mSocketState = SocketState.CLOSED;
            if (DBG) {
                Log.d(TAG, "close() this: " + this + ", channel: " + this.mPort + ", mSocketIS: " + this.mSocketIS + ", mSocketOS: " + this.mSocketOS + "mSocket: " + this.mSocket);
            }
            if (this.mSocket != null) {
                if (DBG) {
                    Log.d(TAG, "Closing mSocket: " + this.mSocket);
                }
                this.mSocket.shutdownInput();
                this.mSocket.shutdownOutput();
                this.mSocket.close();
                this.mSocket = null;
            }
            if (this.mPfd != null) {
                this.mPfd.close();
                this.mPfd = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws IOException {
        if (this.mDevice == null) {
            throw new IOException("Connect is called on null device");
        }
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            IBluetooth iBluetooth = BluetoothAdapter.getDefaultAdapter().getBluetoothService(null);
            if (iBluetooth == null) {
                throw new IOException("Bluetooth is off");
            }
            this.mPfd = iBluetooth.connectSocket(this.mDevice, this.mType, this.mUuid, this.mPort, this.getSecurityFlags());
            synchronized (this) {
                if (!DBG) break block19;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + remoteException.getMessage());
        }
        {
            block19: {
                Log.d(TAG, "connect(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
            }
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            if (this.mPfd == null) {
                throw new IOException("bt socket connect failed");
            }
            this.mSocket = new LocalSocket(this.mPfd.getFileDescriptor());
            this.mSocketIS = this.mSocket.getInputStream();
            this.mSocketOS = this.mSocket.getOutputStream();
        }
        int n = this.readInt(this.mSocketIS);
        if (n <= 0) {
            throw new IOException("bt socket connect failed");
        }
        this.mPort = n;
        this.waitSocketSignal(this.mSocketIS);
        synchronized (this) {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("bt socket closed");
            }
            this.mSocketState = SocketState.CONNECTED;
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    void flush() throws IOException {
        if (this.mSocketOS == null) {
            throw new IOException("flush is called on null OutputStream");
        }
        if (VDBG) {
            Log.d(TAG, "flush: " + this.mSocketOS);
        }
        this.mSocketOS.flush();
    }

    public InputStream getInputStream() throws IOException {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mOutputStream;
    }

    int getPort() {
        return this.mPort;
    }

    public BluetoothDevice getRemoteDevice() {
        return this.mDevice;
    }

    public boolean isConnected() {
        return this.mSocketState == SocketState.CONNECTED;
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.mSocketIS == null) {
            throw new IOException("read is called on null InputStream");
        }
        if (VDBG) {
            Log.d(TAG, "read in:  " + this.mSocketIS + " len: " + n2);
        }
        if ((n3 = this.mSocketIS.read(byArray, n, n2)) < 0) {
            throw new IOException("bt socket closed, read return: " + n3);
        }
        if (VDBG) {
            Log.d(TAG, "read out:  " + this.mSocketIS + " ret: " + n3);
        }
        return n3;
    }

    void removeChannel() {
    }

    void setServiceName(String string2) {
        this.mServiceName = string2;
    }

    int write(byte[] byArray, int n, int n2) throws IOException {
        if (this.mSocketOS == null) {
            throw new IOException("write is called on null OutputStream");
        }
        if (VDBG) {
            Log.d(TAG, "write: " + this.mSocketOS + " length: " + n2);
        }
        this.mSocketOS.write(byArray, n, n2);
        if (VDBG) {
            Log.d(TAG, "write out: " + this.mSocketOS + " length: " + n2);
        }
        return n2;
    }

    private static final class SocketState
    extends Enum<SocketState> {
        private static final /* synthetic */ SocketState[] $VALUES;
        public static final /* enum */ SocketState CLOSED;
        public static final /* enum */ SocketState CONNECTED;
        public static final /* enum */ SocketState INIT;
        public static final /* enum */ SocketState LISTENING;

        static {
            INIT = new SocketState();
            CONNECTED = new SocketState();
            LISTENING = new SocketState();
            CLOSED = new SocketState();
            SocketState[] socketStateArray = new SocketState[]{INIT, CONNECTED, LISTENING, CLOSED};
            $VALUES = socketStateArray;
        }

        public static SocketState valueOf(String string2) {
            return Enum.valueOf(SocketState.class, string2);
        }

        public static SocketState[] values() {
            return (SocketState[])$VALUES.clone();
        }
    }
}

