/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.ScanResult;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import java.util.List;

public interface IBluetoothGattCallback
extends IInterface {
    public void onBatchScanResults(List<ScanResult> var1) throws RemoteException;

    public void onCharacteristicRead(String var1, int var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, byte[] var8) throws RemoteException;

    public void onCharacteristicWrite(String var1, int var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7) throws RemoteException;

    public void onClientConnectionState(int var1, int var2, boolean var3, String var4) throws RemoteException;

    public void onClientRegistered(int var1, int var2) throws RemoteException;

    public void onConfigureMTU(String var1, int var2, int var3) throws RemoteException;

    public void onDescriptorRead(String var1, int var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, ParcelUuid var9, byte[] var10) throws RemoteException;

    public void onDescriptorWrite(String var1, int var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, ParcelUuid var9) throws RemoteException;

    public void onExecuteWrite(String var1, int var2) throws RemoteException;

    public void onFoundOrLost(boolean var1, ScanResult var2) throws RemoteException;

    public void onGetCharacteristic(String var1, int var2, int var3, ParcelUuid var4, int var5, ParcelUuid var6, int var7) throws RemoteException;

    public void onGetDescriptor(String var1, int var2, int var3, ParcelUuid var4, int var5, ParcelUuid var6, int var7, ParcelUuid var8) throws RemoteException;

    public void onGetIncludedService(String var1, int var2, int var3, ParcelUuid var4, int var5, int var6, ParcelUuid var7) throws RemoteException;

    public void onGetService(String var1, int var2, int var3, ParcelUuid var4) throws RemoteException;

    public void onMultiAdvertiseCallback(int var1, boolean var2, AdvertiseSettings var3) throws RemoteException;

    public void onNotify(String var1, int var2, int var3, ParcelUuid var4, int var5, ParcelUuid var6, byte[] var7) throws RemoteException;

    public void onReadRemoteRssi(String var1, int var2, int var3) throws RemoteException;

    public void onScanResult(ScanResult var1) throws RemoteException;

    public void onSearchComplete(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGattCallback {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetoothGattCallback";
        static final int TRANSACTION_onBatchScanResults = 4;
        static final int TRANSACTION_onCharacteristicRead = 10;
        static final int TRANSACTION_onCharacteristicWrite = 11;
        static final int TRANSACTION_onClientConnectionState = 2;
        static final int TRANSACTION_onClientRegistered = 1;
        static final int TRANSACTION_onConfigureMTU = 18;
        static final int TRANSACTION_onDescriptorRead = 13;
        static final int TRANSACTION_onDescriptorWrite = 14;
        static final int TRANSACTION_onExecuteWrite = 12;
        static final int TRANSACTION_onFoundOrLost = 19;
        static final int TRANSACTION_onGetCharacteristic = 7;
        static final int TRANSACTION_onGetDescriptor = 8;
        static final int TRANSACTION_onGetIncludedService = 6;
        static final int TRANSACTION_onGetService = 5;
        static final int TRANSACTION_onMultiAdvertiseCallback = 17;
        static final int TRANSACTION_onNotify = 15;
        static final int TRANSACTION_onReadRemoteRssi = 16;
        static final int TRANSACTION_onScanResult = 3;
        static final int TRANSACTION_onSearchComplete = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothGattCallback asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IBluetoothGattCallback) {
                return (IBluetoothGattCallback)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onClientRegistered(parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.onClientConnectionState(n3, n4, bl, parcel.readString());
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ScanResult scanResult = parcel.readInt() != 0 ? ScanResult.CREATOR.createFromParcel(parcel) : null;
                    this.onScanResult(scanResult);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onBatchScanResults(parcel.createTypedArrayList(ScanResult.CREATOR));
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onGetService(string2, n5, n6, parcelUuid);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n9 = parcel.readInt();
                    int n10 = parcel.readInt();
                    ParcelUuid parcelUuid2 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onGetIncludedService(string3, n7, n8, parcelUuid, n9, n10, parcelUuid2);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    int n11 = parcel.readInt();
                    int n12 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n13 = parcel.readInt();
                    ParcelUuid parcelUuid3 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onGetCharacteristic(string4, n11, n12, parcelUuid, n13, parcelUuid3, parcel.readInt());
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    int n14 = parcel.readInt();
                    int n15 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n16 = parcel.readInt();
                    ParcelUuid parcelUuid4 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n17 = parcel.readInt();
                    ParcelUuid parcelUuid5 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onGetDescriptor(string5, n14, n15, parcelUuid, n16, parcelUuid4, n17, parcelUuid5);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onSearchComplete(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    int n18 = parcel.readInt();
                    int n19 = parcel.readInt();
                    int n20 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n21 = parcel.readInt();
                    ParcelUuid parcelUuid6 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onCharacteristicRead(string6, n18, n19, n20, parcelUuid, n21, parcelUuid6, parcel.createByteArray());
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = parcel.readString();
                    int n22 = parcel.readInt();
                    int n23 = parcel.readInt();
                    int n24 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n25 = parcel.readInt();
                    ParcelUuid parcelUuid7 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onCharacteristicWrite(string7, n22, n23, n24, parcelUuid, n25, parcelUuid7);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onExecuteWrite(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = parcel.readString();
                    int n26 = parcel.readInt();
                    int n27 = parcel.readInt();
                    int n28 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n29 = parcel.readInt();
                    ParcelUuid parcelUuid8 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n30 = parcel.readInt();
                    ParcelUuid parcelUuid9 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onDescriptorRead(string8, n26, n27, n28, parcelUuid, n29, parcelUuid8, n30, parcelUuid9, parcel.createByteArray());
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = parcel.readString();
                    int n31 = parcel.readInt();
                    int n32 = parcel.readInt();
                    int n33 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n34 = parcel.readInt();
                    ParcelUuid parcelUuid10 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n35 = parcel.readInt();
                    ParcelUuid parcelUuid11 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onDescriptorWrite(string9, n31, n32, n33, parcelUuid, n34, parcelUuid10, n35, parcelUuid11);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string10 = parcel.readString();
                    int n36 = parcel.readInt();
                    int n37 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n38 = parcel.readInt();
                    ParcelUuid parcelUuid12 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.onNotify(string10, n36, n37, parcelUuid, n38, parcelUuid12, parcel.createByteArray());
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onReadRemoteRssi(parcel.readString(), parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n39 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    AdvertiseSettings advertiseSettings = parcel.readInt() != 0 ? AdvertiseSettings.CREATOR.createFromParcel(parcel) : null;
                    this.onMultiAdvertiseCallback(n39, bl, advertiseSettings);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onConfigureMTU(parcel.readString(), parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 19: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = parcel.readInt() != 0;
            ScanResult scanResult = parcel.readInt() != 0 ? ScanResult.CREATOR.createFromParcel(parcel) : null;
            this.onFoundOrLost(bl, scanResult);
            return true;
        }

        private static class Proxy
        implements IBluetoothGattCallback {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onBatchScanResults(List<ScanResult> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedList(list);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCharacteristicRead(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCharacteristicWrite(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onClientConnectionState(int n, int n2, boolean bl, String string2) throws RemoteException {
                int n3 = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    if (!bl) {
                        n3 = 0;
                    }
                    parcel.writeInt(n3);
                    parcel.writeString(string2);
                    this.mRemote.transact(2, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void onClientRegistered(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onConfigureMTU(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(18, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDescriptorRead(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n5);
                    if (parcelUuid3 != null) {
                        parcel.writeInt(1);
                        parcelUuid3.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(13, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDescriptorWrite(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n5);
                    if (parcelUuid3 != null) {
                        parcel.writeInt(1);
                        parcelUuid3.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(14, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onExecuteWrite(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onFoundOrLost(boolean bl, ScanResult scanResult) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    if (scanResult != null) {
                        parcel.writeInt(1);
                        scanResult.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(19, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onGetCharacteristic(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, int n4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n3);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onGetDescriptor(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, int n4, ParcelUuid parcelUuid3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n3);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid3 != null) {
                        parcel.writeInt(1);
                        parcelUuid3.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onGetIncludedService(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, int n4, ParcelUuid parcelUuid2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onGetService(String string2, int n, int n2, ParcelUuid parcelUuid) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onMultiAdvertiseCallback(int n, boolean bl, AdvertiseSettings advertiseSettings) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    if (advertiseSettings != null) {
                        parcel.writeInt(1);
                        advertiseSettings.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(17, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onNotify(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n3);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(15, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onReadRemoteRssi(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(16, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onScanResult(ScanResult scanResult) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (scanResult != null) {
                        parcel.writeInt(1);
                        scanResult.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onSearchComplete(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

