/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattCallbackWrapper;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.ResultStorageDescriptor;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.bluetooth.le.TruncatedFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class BluetoothLeScanner {
    private static final boolean DBG = true;
    private static final String TAG = "BluetoothLeScanner";
    private BluetoothAdapter mBluetoothAdapter;
    private final IBluetoothManager mBluetoothManager;
    private final Handler mHandler;
    private final Map<ScanCallback, BleScanCallbackWrapper> mLeScanClients;

    public BluetoothLeScanner(IBluetoothManager iBluetoothManager) {
        this.mBluetoothManager = iBluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mLeScanClients = new HashMap<ScanCallback, BleScanCallbackWrapper>();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSettingsConfigAllowedForScan(ScanSettings scanSettings) {
        return this.mBluetoothAdapter.isOffloadedFilteringSupported() || scanSettings.getCallbackType() == 1 && scanSettings.getReportDelayMillis() == 0L;
    }

    private void postCallbackError(final ScanCallback scanCallback, final int n) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                scanCallback.onScanFailed(n);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startScan(List<ScanFilter> list, ScanSettings scanSettings, ScanCallback scanCallback, List<List<ResultStorageDescriptor>> list2) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (scanSettings == null || scanCallback == null) {
            throw new IllegalArgumentException("settings or callback is null");
        }
        Map<ScanCallback, BleScanCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            IBluetoothGatt iBluetoothGatt;
            if (this.mLeScanClients.containsKey(scanCallback)) {
                this.postCallbackError(scanCallback, 1);
                return;
            }
            try {
                IBluetoothGatt iBluetoothGatt2;
                iBluetoothGatt = iBluetoothGatt2 = this.mBluetoothManager.getBluetoothGatt();
            }
            catch (RemoteException remoteException) {
                iBluetoothGatt = null;
            }
            if (iBluetoothGatt == null) {
                this.postCallbackError(scanCallback, 3);
                return;
            }
            if (!this.isSettingsConfigAllowedForScan(scanSettings)) {
                this.postCallbackError(scanCallback, 4);
                return;
            }
            new BleScanCallbackWrapper(iBluetoothGatt, list, scanSettings, scanCallback, list2).startRegisteration();
            return;
        }
    }

    public void cleanup() {
        this.mLeScanClients.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushPendingScanResults(ScanCallback scanCallback) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (scanCallback == null) {
            throw new IllegalArgumentException("callback cannot be null!");
        }
        Map<ScanCallback, BleScanCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            BleScanCallbackWrapper bleScanCallbackWrapper = this.mLeScanClients.get(scanCallback);
            if (bleScanCallbackWrapper == null) {
                return;
            }
            bleScanCallbackWrapper.flushPendingBatchResults();
            return;
        }
    }

    public void startScan(ScanCallback scanCallback) {
        if (scanCallback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        this.startScan(null, new ScanSettings.Builder().build(), scanCallback);
    }

    public void startScan(List<ScanFilter> list, ScanSettings scanSettings, ScanCallback scanCallback) {
        this.startScan(list, scanSettings, scanCallback, null);
    }

    public void startTruncatedScan(List<TruncatedFilter> list, ScanSettings scanSettings, ScanCallback scanCallback) {
        int n = list.size();
        ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>(n);
        ArrayList<List<ResultStorageDescriptor>> arrayList2 = new ArrayList<List<ResultStorageDescriptor>>(n);
        for (TruncatedFilter truncatedFilter : list) {
            arrayList.add(truncatedFilter.getFilter());
            arrayList2.add(truncatedFilter.getStorageDescriptors());
        }
        this.startScan(arrayList, scanSettings, scanCallback, arrayList2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopScan(ScanCallback scanCallback) {
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        Map<ScanCallback, BleScanCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            BleScanCallbackWrapper bleScanCallbackWrapper = this.mLeScanClients.remove(scanCallback);
            if (bleScanCallbackWrapper == null) {
                Log.d(TAG, "could not find callback wrapper");
                return;
            }
            bleScanCallbackWrapper.stopLeScan();
            return;
        }
    }

    private class BleScanCallbackWrapper
    extends BluetoothGattCallbackWrapper {
        private static final int REGISTRATION_CALLBACK_TIMEOUT_MILLIS = 2000;
        private IBluetoothGatt mBluetoothGatt;
        private int mClientIf;
        private final List<ScanFilter> mFilters;
        private List<List<ResultStorageDescriptor>> mResultStorages;
        private final ScanCallback mScanCallback;
        private ScanSettings mSettings;

        public BleScanCallbackWrapper(IBluetoothGatt iBluetoothGatt, List<ScanFilter> list, ScanSettings scanSettings, ScanCallback scanCallback, List<List<ResultStorageDescriptor>> list2) {
            this.mBluetoothGatt = iBluetoothGatt;
            this.mFilters = list;
            this.mSettings = scanSettings;
            this.mScanCallback = scanCallback;
            this.mClientIf = 0;
            this.mResultStorages = list2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void flushPendingBatchResults() {
            synchronized (this) {
                if (this.mClientIf <= 0) {
                    Log.e(BluetoothLeScanner.TAG, "Error state, mLeHandle: " + this.mClientIf);
                    return;
                }
                try {
                    this.mBluetoothGatt.flushPendingBatchResults(this.mClientIf, false);
                }
                catch (RemoteException remoteException) {
                    Log.e(BluetoothLeScanner.TAG, "Failed to get pending scan results", remoteException);
                }
                return;
            }
        }

        @Override
        public void onBatchScanResults(final List<ScanResult> list) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    BleScanCallbackWrapper.this.mScanCallback.onBatchScanResults(list);
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onClientRegistered(int n, int n2) {
            Log.d(BluetoothLeScanner.TAG, "onClientRegistered() - status=" + n + " clientIf=" + n2);
            synchronized (this) {
                if (this.mClientIf == -1) {
                    Log.d(BluetoothLeScanner.TAG, "onClientRegistered LE scan canceled");
                }
                if (n == 0) {
                    this.mClientIf = n2;
                    try {
                        this.mBluetoothGatt.startScan(this.mClientIf, false, this.mSettings, this.mFilters, this.mResultStorages);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothLeScanner.TAG, "fail to start le scan: " + remoteException);
                        this.mClientIf = -1;
                    }
                } else {
                    this.mClientIf = -1;
                }
                this.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFoundOrLost(final boolean bl, final ScanResult scanResult) {
            Log.d(BluetoothLeScanner.TAG, "onFoundOrLost() - onFound = " + bl + " " + scanResult.toString());
            synchronized (this) {
                if (this.mClientIf <= 0) {
                    return;
                }
            }
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        BleScanCallbackWrapper.this.mScanCallback.onScanResult(2, scanResult);
                        return;
                    }
                    BleScanCallbackWrapper.this.mScanCallback.onScanResult(4, scanResult);
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onScanResult(final ScanResult scanResult) {
            Log.d(BluetoothLeScanner.TAG, "onScanResult() - " + scanResult.toString());
            synchronized (this) {
                if (this.mClientIf <= 0) {
                    return;
                }
            }
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    BleScanCallbackWrapper.this.mScanCallback.onScanResult(1, scanResult);
                }
            });
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void startRegisteration() {
            synchronized (this) {
                if (this.mClientIf == -1) {
                    return;
                }
                try {
                    UUID uUID = UUID.randomUUID();
                    this.mBluetoothGatt.registerClient(new ParcelUuid(uUID), this);
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    Exception exception;
                    block9: {
                        exception = interruptedException;
                        break block9;
                        catch (RemoteException remoteException) {
                            exception = remoteException;
                        }
                    }
                    Log.e(BluetoothLeScanner.TAG, "application registeration exception", exception);
                    BluetoothLeScanner.this.postCallbackError(this.mScanCallback, 3);
                }
                if (this.mClientIf > 0) {
                    BluetoothLeScanner.this.mLeScanClients.put(this.mScanCallback, this);
                } else {
                    BluetoothLeScanner.this.postCallbackError(this.mScanCallback, 2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void stopLeScan() {
            synchronized (this) {
                if (this.mClientIf <= 0) {
                    Log.e(BluetoothLeScanner.TAG, "Error state, mLeHandle: " + this.mClientIf);
                    return;
                }
                try {
                    this.mBluetoothGatt.stopScan(this.mClientIf, false);
                    this.mBluetoothGatt.unregisterClient(this.mClientIf);
                }
                catch (RemoteException remoteException) {
                    Log.e(BluetoothLeScanner.TAG, "Failed to stop scan and unregister", remoteException);
                }
                this.mClientIf = -1;
                return;
            }
        }
    }
}

