/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class AssetFileDescriptor
implements Parcelable,
Closeable {
    public static final Parcelable.Creator<AssetFileDescriptor> CREATOR = new Parcelable.Creator<AssetFileDescriptor>(){

        @Override
        public AssetFileDescriptor createFromParcel(Parcel parcel) {
            return new AssetFileDescriptor(parcel);
        }

        public AssetFileDescriptor[] newArray(int n) {
            return new AssetFileDescriptor[n];
        }
    };
    public static final long UNKNOWN_LENGTH = -1L;
    private final Bundle mExtras;
    private final ParcelFileDescriptor mFd;
    private final long mLength;
    private final long mStartOffset;

    AssetFileDescriptor(Parcel parcel) {
        this.mFd = ParcelFileDescriptor.CREATOR.createFromParcel(parcel);
        this.mStartOffset = parcel.readLong();
        this.mLength = parcel.readLong();
        if (parcel.readInt() != 0) {
            this.mExtras = parcel.readBundle();
            return;
        }
        this.mExtras = null;
    }

    public AssetFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, long l, long l2) {
        this(parcelFileDescriptor, l, l2, null);
    }

    public AssetFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, long l, long l2, Bundle bundle) {
        if (parcelFileDescriptor == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (l2 < 0L && l != 0L) {
            throw new IllegalArgumentException("startOffset must be 0 when using UNKNOWN_LENGTH");
        }
        this.mFd = parcelFileDescriptor;
        this.mStartOffset = l;
        this.mLength = l2;
        this.mExtras = bundle;
    }

    @Override
    public void close() throws IOException {
        this.mFd.close();
    }

    public FileInputStream createInputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseInputStream(this.mFd);
        }
        return new AutoCloseInputStream(this);
    }

    public FileOutputStream createOutputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseOutputStream(this.mFd);
        }
        return new AutoCloseOutputStream(this);
    }

    @Override
    public int describeContents() {
        return this.mFd.describeContents();
    }

    public long getDeclaredLength() {
        return this.mLength;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFd.getFileDescriptor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.mLength >= 0L) {
            return this.mLength;
        }
        long l = this.mFd.getStatSize();
        if (l >= 0L) return l;
        return -1L;
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mFd;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public String toString() {
        return "{AssetFileDescriptor: " + this.mFd + " start=" + this.mStartOffset + " len=" + this.mLength + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.mFd.writeToParcel(parcel, n);
        parcel.writeLong(this.mStartOffset);
        parcel.writeLong(this.mLength);
        if (this.mExtras != null) {
            parcel.writeInt(1);
            parcel.writeBundle(this.mExtras);
            return;
        }
        parcel.writeInt(0);
    }

    public static class AutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream {
        private long mRemaining;

        public AutoCloseInputStream(AssetFileDescriptor assetFileDescriptor) throws IOException {
            super(assetFileDescriptor.getParcelFileDescriptor());
            super.skip(assetFileDescriptor.getStartOffset());
            this.mRemaining = (int)assetFileDescriptor.getLength();
        }

        @Override
        public int available() throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining < Integer.MAX_VALUE) {
                    return (int)this.mRemaining;
                }
                return Integer.MAX_VALUE;
            }
            return super.available();
        }

        @Override
        public void mark(int n) {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.mark(n);
        }

        @Override
        public boolean markSupported() {
            if (this.mRemaining >= 0L) {
                return false;
            }
            return super.markSupported();
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == -1) {
                return -1;
            }
            return 0xFF & byArray[0];
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.mRemaining < 0L) return super.read(byArray, n, n2);
            if (this.mRemaining == 0L) {
                return -1;
            }
            if ((long)n2 > this.mRemaining) {
                n2 = (int)this.mRemaining;
            }
            if ((n3 = super.read(byArray, n, n2)) < 0) return n3;
            this.mRemaining -= (long)n3;
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void reset() throws IOException {
            synchronized (this) {
                block6: {
                    long l = this.mRemaining;
                    if (l < 0L) break block6;
                    return;
                }
                super.reset();
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long skip(long l) throws IOException {
            long l2;
            if (this.mRemaining < 0L) return super.skip(l);
            if (this.mRemaining == 0L) {
                return -1L;
            }
            if (l > this.mRemaining) {
                l = this.mRemaining;
            }
            if ((l2 = super.skip(l)) < 0L) return l2;
            this.mRemaining -= l2;
            return l2;
        }
    }

    public static class AutoCloseOutputStream
    extends ParcelFileDescriptor.AutoCloseOutputStream {
        private long mRemaining;

        public AutoCloseOutputStream(AssetFileDescriptor assetFileDescriptor) throws IOException {
            super(assetFileDescriptor.getParcelFileDescriptor());
            if (assetFileDescriptor.getParcelFileDescriptor().seekTo(assetFileDescriptor.getStartOffset()) < 0L) {
                throw new IOException("Unable to seek");
            }
            this.mRemaining = (int)assetFileDescriptor.getLength();
        }

        @Override
        public void write(int n) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                super.write(n);
                --this.mRemaining;
                return;
            }
            super.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                int n = byArray.length;
                if ((long)n > this.mRemaining) {
                    n = (int)this.mRemaining;
                }
                super.write(byArray);
                this.mRemaining -= (long)n;
                return;
            }
            super.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                if ((long)n2 > this.mRemaining) {
                    n2 = (int)this.mRemaining;
                }
                super.write(byArray, n, n2);
                this.mRemaining -= (long)n2;
                return;
            }
            super.write(byArray, n, n2);
        }
    }
}

