/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.util.SparseArray;
import android.util.StateSet;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorStateList
implements Parcelable {
    public static final Parcelable.Creator<ColorStateList> CREATOR;
    private static final int[][] EMPTY;
    private static final SparseArray<WeakReference<ColorStateList>> sCache;
    private int[] mColors;
    private int mDefaultColor = -65536;
    private int[][] mStateSpecs;

    static {
        EMPTY = new int[][]{new int[0]};
        sCache = new SparseArray();
        CREATOR = new Parcelable.Creator<ColorStateList>(){

            @Override
            public ColorStateList createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                int[][] nArrayArray = new int[n][];
                for (int i = 0; i < n; ++i) {
                    nArrayArray[i] = parcel.createIntArray();
                }
                return new ColorStateList(nArrayArray, parcel.createIntArray());
            }

            public ColorStateList[] newArray(int n) {
                return new ColorStateList[n];
            }
        };
    }

    private ColorStateList() {
    }

    public ColorStateList(int[][] nArray, int[] nArray2) {
        this.mStateSpecs = nArray;
        this.mColors = nArray2;
        if (nArray.length > 0) {
            this.mDefaultColor = nArray2[0];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i].length != 0) continue;
                this.mDefaultColor = nArray2[i];
            }
        }
    }

    public static ColorStateList addFirstIfMissing(ColorStateList colorStateList, int n, int n2) {
        int[][] nArray = colorStateList.getStates();
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] != n) continue;
                return colorStateList;
            }
        }
        int[][] nArrayArray = new int[1 + nArray.length][];
        System.arraycopy(nArray, 0, nArrayArray, 1, nArray.length);
        nArrayArray[0] = new int[]{n};
        int[] nArray3 = colorStateList.getColors();
        int[] nArray4 = new int[1 + nArray3.length];
        System.arraycopy((int[])nArray3, (int)0, (int[])nArray4, (int)1, (int)nArray3.length);
        nArray4[0] = n2;
        return new ColorStateList(nArrayArray, nArray4);
    }

    public static ColorStateList createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
        while ((n = xmlPullParser.next()) != 2 && n != 1) {
        }
        if (n != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return ColorStateList.createFromXmlInner(resources, xmlPullParser, attributeSet);
    }

    private static ColorStateList createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        String string2 = xmlPullParser.getName();
        if (string2.equals("selector")) {
            ColorStateList colorStateList = new ColorStateList();
            colorStateList.inflate(resources, xmlPullParser, attributeSet);
            return colorStateList;
        }
        throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": invalid drawable tag " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n = 1 + xmlPullParser.getDepth();
        int[][] nArray = ArrayUtils.newUnpaddedArray(int[].class, 20);
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        block0: while (true) {
            int n3;
            int n4;
            if ((n4 = xmlPullParser.next()) != 1 && ((n3 = xmlPullParser.getDepth()) >= n || n4 != 3)) {
                if (n4 != 2 || n3 > n || !xmlPullParser.getName().equals("item")) continue;
            } else {
                this.mColors = new int[n2];
                this.mStateSpecs = new int[n2][];
                System.arraycopy((int[])nArray2, (int)0, (int[])this.mColors, (int)0, (int)n2);
                int[][] nArray3 = this.mStateSpecs;
                System.arraycopy(nArray, 0, nArray3, 0, n2);
                return;
            }
            int n5 = 0;
            float f = 1.0f;
            int n6 = 0;
            int n7 = -65536;
            boolean bl = false;
            int n8 = attributeSet.getAttributeCount();
            int[] nArray4 = new int[n8];
            int n9 = 0;
            int n10 = 0;
            while (true) {
                int n11;
                block13: {
                    block12: {
                        int n12;
                        block14: {
                            block11: {
                                if (n9 >= n8 || (n12 = attributeSet.getAttributeNameResource(n9)) == 0) {
                                    int[] nArray5 = StateSet.trimStateSet(nArray4, n10);
                                    if (n6 != 0) {
                                        n7 = resources.getColor(n6);
                                    } else if (!bl) {
                                        throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'android:color' attribute.");
                                    }
                                    if (n5 != 0) {
                                        f = resources.getFloat(n5);
                                    }
                                    int n13 = MathUtils.constrain((int)(f * (float)Color.alpha(n7)), 0, 255);
                                    int n14 = 0xFFFFFF & n7 | n13 << 24;
                                    if (n2 == 0 || nArray5.length == 0) {
                                        this.mDefaultColor = n14;
                                    }
                                    nArray2 = GrowingArrayUtils.append(nArray2, n2, n14);
                                    nArray = GrowingArrayUtils.append(nArray, n2, nArray5);
                                    ++n2;
                                    continue block0;
                                }
                                if (n12 != 16843551) break block11;
                                n5 = attributeSet.getAttributeResourceValue(n9, 0);
                                if (n5 != 0) break block12;
                                f = attributeSet.getAttributeFloatValue(n9, 1.0f);
                                n11 = n10;
                                break block13;
                            }
                            if (n12 != 16843173) break block14;
                            n6 = attributeSet.getAttributeResourceValue(n9, 0);
                            if (n6 != 0) break block12;
                            n7 = attributeSet.getAttributeIntValue(n9, n7);
                            bl = true;
                            n11 = n10;
                            break block13;
                        }
                        n11 = n10 + 1;
                        if (!attributeSet.getAttributeBooleanValue(n9, false)) {
                            n12 = -n12;
                        }
                        nArray4[n10] = n12;
                        break block13;
                    }
                    n11 = n10;
                }
                ++n9;
                n10 = n11;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColorStateList valueOf(int n) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            WeakReference<ColorStateList> weakReference = sCache.get(n);
            ColorStateList colorStateList = weakReference != null ? (ColorStateList)weakReference.get() : null;
            if (colorStateList != null) {
                return colorStateList;
            }
            ColorStateList colorStateList2 = new ColorStateList(EMPTY, new int[]{n});
            sCache.put(n, new WeakReference<ColorStateList>(colorStateList2));
            return colorStateList2;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getColorForState(int[] nArray, int n) {
        int n2 = this.mStateSpecs.length;
        int n3 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n3 >= n2) break block3;
                    if (!StateSet.stateSetMatches(this.mStateSpecs[n3], nArray)) break block4;
                    n = this.mColors[n3];
                }
                return n;
            }
            ++n3;
        }
    }

    public int[] getColors() {
        return this.mColors;
    }

    public int getDefaultColor() {
        return this.mDefaultColor;
    }

    public int[][] getStates() {
        return this.mStateSpecs;
    }

    public boolean isOpaque() {
        int n = this.mColors.length;
        for (int i = 0; i < n; ++i) {
            if (Color.alpha(this.mColors[i]) == 255) continue;
            return false;
        }
        return true;
    }

    public boolean isStateful() {
        return this.mStateSpecs.length > 1;
    }

    public String toString() {
        return "ColorStateList{mStateSpecs=" + Arrays.deepToString((Object[])this.mStateSpecs) + "mColors=" + Arrays.toString(this.mColors) + "mDefaultColor=" + this.mDefaultColor + '}';
    }

    public ColorStateList withAlpha(int n) {
        int[] nArray = new int[this.mColors.length];
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = 0xFFFFFF & this.mColors[i] | n << 24;
        }
        return new ColorStateList(this.mStateSpecs, nArray);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mStateSpecs.length;
        parcel.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            parcel.writeIntArray(this.mStateSpecs[i]);
        }
        parcel.writeIntArray(this.mColors);
    }
}

