/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Annotation;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.LineHeightSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseArray;

final class StringBlock {
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV;
    private final long mNative;
    private final boolean mOwnsNative;
    private SparseArray<CharSequence> mSparseStrings;
    private CharSequence[] mStrings;
    StyleIDs mStyleIDs = null;
    private final boolean mUseSparse;

    StringBlock(long l, boolean bl) {
        this.mNative = l;
        this.mUseSparse = bl;
        this.mOwnsNative = false;
    }

    public StringBlock(byte[] byArray, int n, int n2, boolean bl) {
        this.mNative = StringBlock.nativeCreate(byArray, n, n2);
        this.mUseSparse = bl;
        this.mOwnsNative = true;
    }

    public StringBlock(byte[] byArray, boolean bl) {
        this.mNative = StringBlock.nativeCreate(byArray, 0, byArray.length);
        this.mUseSparse = bl;
        this.mOwnsNative = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addParagraphSpan(Spannable spannable, Object object, int n, int n2) {
        int n3 = spannable.length();
        if (n != 0 && n != n3 && spannable.charAt(n - 1) != '\n') {
            --n;
            while (n > 0 && spannable.charAt(n - 1) != '\n') {
                --n;
            }
        }
        if (n2 != 0 && n2 != n3 && spannable.charAt(n2 - 1) != '\n') {
            ++n2;
            while (n2 < n3 && spannable.charAt(n2 - 1) != '\n') {
                ++n2;
            }
        }
        spannable.setSpan(object, n, n2, 51);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence applyStyles(String string2, int[] nArray, StyleIDs styleIDs) {
        if (nArray.length == 0) {
            return string2;
        }
        SpannableString spannableString = new SpannableString(string2);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 == styleIDs.boldId) {
                spannableString.setSpan(new StyleSpan(1), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.italicId) {
                spannableString.setSpan(new StyleSpan(2), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.underlineId) {
                spannableString.setSpan(new UnderlineSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.ttId) {
                spannableString.setSpan(new TypefaceSpan("monospace"), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.bigId) {
                spannableString.setSpan(new RelativeSizeSpan(1.25f), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.smallId) {
                spannableString.setSpan(new RelativeSizeSpan(0.8f), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.subId) {
                spannableString.setSpan(new SubscriptSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.supId) {
                spannableString.setSpan(new SuperscriptSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.strikeId) {
                spannableString.setSpan(new StrikethroughSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n2 == styleIDs.listItemId) {
                StringBlock.addParagraphSpan(spannableString, new BulletSpan(10), nArray[n + 1], 1 + nArray[n + 2]);
            } else if (n2 == styleIDs.marqueeId) {
                spannableString.setSpan((Object)TextUtils.TruncateAt.MARQUEE, nArray[n + 1], 1 + nArray[n + 2], 18);
            } else {
                String string3 = StringBlock.nativeGetString(this.mNative, n2);
                if (string3.startsWith("font;")) {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    String string9 = StringBlock.subtag(string3, ";height=");
                    if (string9 != null) {
                        StringBlock.addParagraphSpan(spannableString, new Height(Integer.parseInt(string9)), nArray[n + 1], 1 + nArray[n + 2]);
                    }
                    if ((string8 = StringBlock.subtag(string3, ";size=")) != null) {
                        spannableString.setSpan(new AbsoluteSizeSpan(Integer.parseInt(string8), true), nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                    if ((string7 = StringBlock.subtag(string3, ";fgcolor=")) != null) {
                        spannableString.setSpan(StringBlock.getColor(string7, true), nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                    if ((string6 = StringBlock.subtag(string3, ";color=")) != null) {
                        spannableString.setSpan(StringBlock.getColor(string6, true), nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                    if ((string5 = StringBlock.subtag(string3, ";bgcolor=")) != null) {
                        spannableString.setSpan(StringBlock.getColor(string5, false), nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                    if ((string4 = StringBlock.subtag(string3, ";face=")) != null) {
                        spannableString.setSpan(new TypefaceSpan(string4), nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                } else if (string3.startsWith("a;")) {
                    String string10 = StringBlock.subtag(string3, ";href=");
                    if (string10 != null) {
                        spannableString.setSpan(new URLSpan(string10), nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                } else if (string3.startsWith("annotation;")) {
                    int n3;
                    int n4 = string3.length();
                    int n5 = string3.indexOf(59);
                    while (n5 < n4 && (n3 = string3.indexOf(61, n5)) >= 0) {
                        int n6 = string3.indexOf(59, n3);
                        if (n6 < 0) {
                            n6 = n4;
                        }
                        spannableString.setSpan(new Annotation(string3.substring(n5 + 1, n3), string3.substring(n3 + 1, n6)), nArray[n + 1], 1 + nArray[n + 2], 33);
                        n5 = n6;
                    }
                }
            }
            n += 3;
        }
        return new SpannedString(spannableString);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CharacterStyle getColor(String string2, boolean bl) {
        int n = -16777216;
        if (!TextUtils.isEmpty(string2)) {
            if (string2.startsWith("@")) {
                Resources resources = Resources.getSystem();
                int n2 = resources.getIdentifier(string2.substring(1), "color", "android");
                if (n2 != 0) {
                    ColorStateList colorStateList = resources.getColorStateList(n2);
                    if (bl) {
                        return new TextAppearanceSpan(null, 0, 0, colorStateList, null);
                    }
                    n = colorStateList.getDefaultColor();
                }
            } else {
                n = Color.getHtmlColor(string2);
            }
        }
        if (bl) {
            return new ForegroundColorSpan(n);
        }
        return new BackgroundColorSpan(n);
    }

    private static native long nativeCreate(byte[] var0, int var1, int var2);

    private static native void nativeDestroy(long var0);

    private static native int nativeGetSize(long var0);

    private static native String nativeGetString(long var0, int var2);

    private static native int[] nativeGetStyle(long var0, int var2);

    private static String subtag(String string2, String string3) {
        int n = string2.indexOf(string3);
        if (n < 0) {
            return null;
        }
        int n2 = n + string3.length();
        int n3 = string2.indexOf(59, n2);
        if (n3 < 0) {
            return string2.substring(n2);
        }
        return string2.substring(n2, n3);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            return;
        }
        finally {
            if (this.mOwnsNative) {
                StringBlock.nativeDestroy(this.mNative);
            }
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharSequence get(int n) {
        synchronized (this) {
            String string2;
            if (this.mStrings != null) {
                CharSequence charSequence = this.mStrings[n];
                if (charSequence != null) {
                    return charSequence;
                }
            } else if (this.mSparseStrings != null) {
                CharSequence charSequence = this.mSparseStrings.get(n);
                if (charSequence != null) {
                    return charSequence;
                }
            } else {
                int n2 = StringBlock.nativeGetSize(this.mNative);
                if (this.mUseSparse && n2 > 250) {
                    this.mSparseStrings = new SparseArray();
                } else {
                    this.mStrings = new CharSequence[n2];
                }
            }
            CharSequence charSequence = string2 = StringBlock.nativeGetString(this.mNative, n);
            boolean bl = true;
            while (true) {
                block21: {
                    block19: {
                        int[] nArray;
                        block20: {
                            String string3;
                            int n3;
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block25: {
                                                    block24: {
                                                        block23: {
                                                            block22: {
                                                                int n4;
                                                                block18: {
                                                                    if (!bl || (bl = false)) break block18;
                                                                    nArray = StringBlock.nativeGetStyle(this.mNative, n);
                                                                    if (nArray == null) break block19;
                                                                    if (this.mStyleIDs == null) {
                                                                        this.mStyleIDs = new StyleIDs();
                                                                    }
                                                                    n4 = 0;
                                                                }
                                                                if (n4 >= nArray.length) break block20;
                                                                n3 = nArray[n4];
                                                                if (n3 == this.mStyleIDs.boldId || n3 == this.mStyleIDs.italicId || n3 == this.mStyleIDs.underlineId || n3 == this.mStyleIDs.ttId || n3 == this.mStyleIDs.bigId || n3 == this.mStyleIDs.smallId || n3 == this.mStyleIDs.subId || n3 == this.mStyleIDs.supId || n3 == this.mStyleIDs.strikeId || n3 == this.mStyleIDs.listItemId || n3 == this.mStyleIDs.marqueeId) break block21;
                                                                string3 = StringBlock.nativeGetString(this.mNative, n3);
                                                                if (!string3.equals("b")) break block22;
                                                                StyleIDs.access$002(this.mStyleIDs, n3);
                                                                break block21;
                                                            }
                                                            if (!string3.equals("i")) break block23;
                                                            StyleIDs.access$102(this.mStyleIDs, n3);
                                                            break block21;
                                                        }
                                                        if (!string3.equals("u")) break block24;
                                                        StyleIDs.access$202(this.mStyleIDs, n3);
                                                        break block21;
                                                    }
                                                    if (!string3.equals("tt")) break block25;
                                                    StyleIDs.access$302(this.mStyleIDs, n3);
                                                    break block21;
                                                }
                                                if (!string3.equals("big")) break block26;
                                                StyleIDs.access$402(this.mStyleIDs, n3);
                                                break block21;
                                            }
                                            if (!string3.equals("small")) break block27;
                                            StyleIDs.access$502(this.mStyleIDs, n3);
                                            break block21;
                                        }
                                        if (!string3.equals("sup")) break block28;
                                        StyleIDs.access$702(this.mStyleIDs, n3);
                                        break block21;
                                    }
                                    if (!string3.equals("sub")) break block29;
                                    StyleIDs.access$602(this.mStyleIDs, n3);
                                    break block21;
                                }
                                if (!string3.equals("strike")) break block30;
                                StyleIDs.access$802(this.mStyleIDs, n3);
                                break block21;
                            }
                            if (string3.equals("li")) {
                                StyleIDs.access$902(this.mStyleIDs, n3);
                                break block21;
                            } else if (string3.equals("marquee")) {
                                StyleIDs.access$1002(this.mStyleIDs, n3);
                            }
                            break block21;
                        }
                        charSequence = this.applyStyles(string2, nArray, this.mStyleIDs);
                    }
                    if (this.mStrings != null) {
                        this.mStrings[n] = charSequence;
                    } else {
                        this.mSparseStrings.put(n, charSequence);
                    }
                    return charSequence;
                }
                n4 += 3;
            }
        }
    }

    private static class Height
    implements LineHeightSpan.WithDensity {
        private static float sProportion = 0.0f;
        private int mSize;

        public Height(int n) {
            this.mSize = n;
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
            this.chooseHeight(charSequence, n, n2, n3, n4, fontMetricsInt, null);
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt, TextPaint textPaint) {
            int n5;
            int n6;
            int n7 = this.mSize;
            if (textPaint != null) {
                n7 = (int)((float)n7 * textPaint.density);
            }
            if (fontMetricsInt.bottom - fontMetricsInt.top < n7) {
                fontMetricsInt.top = fontMetricsInt.bottom - n7;
                fontMetricsInt.ascent -= n7;
                return;
            }
            if (sProportion == 0.0f) {
                Paint paint = new Paint();
                paint.setTextSize(100.0f);
                Rect rect = new Rect();
                paint.getTextBounds("ABCDEFG", 0, 7, rect);
                sProportion = (float)rect.top / paint.ascent();
            }
            if (n7 - fontMetricsInt.descent >= (n6 = (int)Math.ceil((float)(-fontMetricsInt.top) * sProportion))) {
                fontMetricsInt.top = fontMetricsInt.bottom - n7;
                fontMetricsInt.ascent = fontMetricsInt.descent - n7;
                return;
            }
            if (n7 >= n6) {
                int n8;
                int n9;
                fontMetricsInt.ascent = n9 = -n6;
                fontMetricsInt.top = n9;
                fontMetricsInt.descent = n8 = n7 + fontMetricsInt.top;
                fontMetricsInt.bottom = n8;
                return;
            }
            fontMetricsInt.ascent = n5 = -n7;
            fontMetricsInt.top = n5;
            fontMetricsInt.descent = 0;
            fontMetricsInt.bottom = 0;
        }
    }

    static final class StyleIDs {
        private int bigId = -1;
        private int boldId = -1;
        private int italicId = -1;
        private int listItemId = -1;
        private int marqueeId = -1;
        private int smallId = -1;
        private int strikeId = -1;
        private int subId = -1;
        private int supId = -1;
        private int ttId = -1;
        private int underlineId = -1;

        StyleIDs() {
        }

        static /* synthetic */ int access$002(StyleIDs styleIDs, int n) {
            styleIDs.boldId = n;
            return n;
        }

        static /* synthetic */ int access$1002(StyleIDs styleIDs, int n) {
            styleIDs.marqueeId = n;
            return n;
        }

        static /* synthetic */ int access$102(StyleIDs styleIDs, int n) {
            styleIDs.italicId = n;
            return n;
        }

        static /* synthetic */ int access$202(StyleIDs styleIDs, int n) {
            styleIDs.underlineId = n;
            return n;
        }

        static /* synthetic */ int access$302(StyleIDs styleIDs, int n) {
            styleIDs.ttId = n;
            return n;
        }

        static /* synthetic */ int access$402(StyleIDs styleIDs, int n) {
            styleIDs.bigId = n;
            return n;
        }

        static /* synthetic */ int access$502(StyleIDs styleIDs, int n) {
            styleIDs.smallId = n;
            return n;
        }

        static /* synthetic */ int access$602(StyleIDs styleIDs, int n) {
            styleIDs.subId = n;
            return n;
        }

        static /* synthetic */ int access$702(StyleIDs styleIDs, int n) {
            styleIDs.supId = n;
            return n;
        }

        static /* synthetic */ int access$802(StyleIDs styleIDs, int n) {
            styleIDs.strikeId = n;
            return n;
        }

        static /* synthetic */ int access$902(StyleIDs styleIDs, int n) {
            styleIDs.listItemId = n;
            return n;
        }
    }
}

