/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternScanner {
    private Pattern mIgnorePattern;
    private String mInput;
    private int mLineNo = 0;
    private int mOffset = 0;
    private int mStartOfLine = 0;

    public PatternScanner(String string2) {
        this.mInput = string2;
    }

    public PatternScanner(String string2, Pattern pattern) {
        this.mInput = string2;
        this.mIgnorePattern = pattern;
        this.skip(this.mIgnorePattern);
    }

    public boolean atEnd() {
        return this.mOffset >= this.mInput.length();
    }

    public String eat(Pattern pattern, String string2) {
        String string3 = this.tryEat(pattern);
        if (string3 == null) {
            throw new RuntimeException(this.unexpectedTokenMessage(string2));
        }
        return string3;
    }

    public int lineNo() {
        return this.mLineNo;
    }

    public boolean peek(Pattern pattern) {
        if (this.mIgnorePattern != null) {
            this.skip(this.mIgnorePattern);
        }
        Matcher matcher = pattern.matcher(this.mInput);
        matcher.region(this.mOffset, this.mInput.length());
        return matcher.lookingAt();
    }

    public void skip(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.mInput);
        matcher.region(this.mOffset, this.mInput.length());
        if (matcher.lookingAt()) {
            this.updateLineCount(this.mOffset, matcher.end());
            this.mOffset = matcher.end();
        }
    }

    public String tryEat(Pattern pattern) {
        if (this.mIgnorePattern != null) {
            this.skip(this.mIgnorePattern);
        }
        Matcher matcher = pattern.matcher(this.mInput);
        matcher.region(this.mOffset, this.mInput.length());
        boolean bl = matcher.lookingAt();
        String string2 = null;
        if (bl) {
            this.updateLineCount(this.mOffset, matcher.end());
            this.mOffset = matcher.end();
            string2 = this.mInput.substring(matcher.start(), matcher.end());
        }
        if (string2 != null && this.mIgnorePattern != null) {
            this.skip(this.mIgnorePattern);
        }
        return string2;
    }

    public String unexpectedTokenMessage(String string2) {
        String string3 = this.mInput.substring(this.mStartOfLine, this.mOffset);
        return "Unexpected token on line " + (1 + this.mLineNo) + " after '" + string3 + "' <- Expected " + string2 + "!";
    }

    public void updateLineCount(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.mInput.charAt(i) != '\n') continue;
            this.mLineNo = 1 + this.mLineNo;
            this.mStartOfLine = i + 1;
        }
    }
}

