/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;

public class StraightenFilter
extends Filter {
    private static final float DEGREE_TO_RADIAN = (float)Math.PI / 180;
    @GenerateFieldPort(hasDefault=true, name="angle")
    private float mAngle = 0.0f;
    private int mHeight = 0;
    @GenerateFieldPort(hasDefault=true, name="maxAngle")
    private float mMaxAngle = 45.0f;
    private Program mProgram;
    private int mTarget = 0;
    @GenerateFieldPort(hasDefault=true, name="tile_size")
    private int mTileSize = 640;
    private int mWidth = 0;

    public StraightenFilter(String string2) {
        super(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateParameters() {
        float f = (float)Math.cos((float)Math.PI / 180 * this.mAngle);
        float f2 = (float)Math.sin((float)Math.PI / 180 * this.mAngle);
        if (this.mMaxAngle <= 0.0f) {
            throw new RuntimeException("Max angle is out of range (0-180).");
        }
        float f3 = this.mMaxAngle > 90.0f ? 90.0f : this.mMaxAngle;
        this.mMaxAngle = f3;
        Point point = new Point(-f * (float)this.mWidth + f2 * (float)this.mHeight, -f2 * (float)this.mWidth - f * (float)this.mHeight);
        Point point2 = new Point(f * (float)this.mWidth + f2 * (float)this.mHeight, f2 * (float)this.mWidth - f * (float)this.mHeight);
        Point point3 = new Point(-f * (float)this.mWidth - f2 * (float)this.mHeight, -f2 * (float)this.mWidth + f * (float)this.mHeight);
        Point point4 = new Point(f * (float)this.mWidth - f2 * (float)this.mHeight, f2 * (float)this.mWidth + f * (float)this.mHeight);
        float f4 = Math.max(Math.abs(point.x), Math.abs(point2.x));
        float f5 = Math.max(Math.abs(point.y), Math.abs(point2.y));
        float f6 = 0.5f * Math.min((float)this.mWidth / f4, (float)this.mHeight / f5);
        point.set(0.5f + f6 * point.x / (float)this.mWidth, 0.5f + f6 * point.y / (float)this.mHeight);
        point2.set(0.5f + f6 * point2.x / (float)this.mWidth, 0.5f + f6 * point2.y / (float)this.mHeight);
        point3.set(0.5f + f6 * point3.x / (float)this.mWidth, 0.5f + f6 * point3.y / (float)this.mHeight);
        point4.set(0.5f + f6 * point4.x / (float)this.mWidth, 0.5f + f6 * point4.y / (float)this.mHeight);
        Quad quad = new Quad(point, point2, point3, point4);
        ((ShaderProgram)this.mProgram).setSourceRegion(quad);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    public void initProgram(FilterContext filterContext, int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + n + "!");
            }
            case 3: 
        }
        ShaderProgram shaderProgram = ShaderProgram.createIdentity(filterContext);
        shaderProgram.setMaximumTileSize(this.mTileSize);
        this.mProgram = shaderProgram;
        this.mTarget = n;
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        if (this.mProgram == null || frameFormat.getTarget() != this.mTarget) {
            this.initProgram(filterContext, frameFormat.getTarget());
        }
        if (frameFormat.getWidth() != this.mWidth || frameFormat.getHeight() != this.mHeight) {
            this.mWidth = frameFormat.getWidth();
            this.mHeight = frameFormat.getHeight();
            this.updateParameters();
        }
        Frame frame2 = filterContext.getFrameManager().newFrame(frameFormat);
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }
}

