/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class ToPackedGrayFilter
extends Filter {
    private final String mColorToPackedGrayShader;
    @GenerateFieldPort(hasDefault=true, name="keepAspectRatio")
    private boolean mKeepAspectRatio = false;
    @GenerateFieldPort(hasDefault=true, name="oheight")
    private int mOHeight = 0;
    @GenerateFieldPort(hasDefault=true, name="owidth")
    private int mOWidth = 0;
    private Program mProgram;

    public ToPackedGrayFilter(String string2) {
        super(string2);
        this.mColorToPackedGrayShader = "precision mediump float;\nconst vec4 coeff_y = vec4(0.299, 0.587, 0.114, 0);\nuniform sampler2D tex_sampler_0;\nuniform float pix_stride;\nvarying vec2 v_texcoord;\nvoid main() {\n  for (int i = 0; i < 4; ++i) {\n    vec4 p = texture2D(tex_sampler_0,\n                       v_texcoord + vec2(pix_stride * float(i), 0.0));\n    gl_FragColor[i] = dot(p, coeff_y);\n  }\n}\n";
    }

    private void checkOutputDimensions(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RuntimeException("Invalid output dimensions: " + n + " " + n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private FrameFormat convertInputFormat(FrameFormat frameFormat) {
        int n;
        int n2 = this.mOWidth;
        int n3 = this.mOHeight;
        int n4 = frameFormat.getWidth();
        int n5 = frameFormat.getHeight();
        if (this.mOWidth == 0) {
            n2 = n4;
        }
        if (this.mOHeight == 0) {
            n3 = n5;
        }
        if (this.mKeepAspectRatio) {
            if (n4 > n5) {
                n2 = Math.max(n2, n3);
                n3 = n2 * n5 / n4;
            } else {
                n3 = Math.max(n2, n3);
                n2 = n3 * n4 / n5;
            }
        }
        if (n2 > 0 && n2 < 4) {
            n = 4;
            return ImageFormat.create(n, n3, 1, 2);
        }
        n = 4 * (n2 / 4);
        return ImageFormat.create(n, n3, 1, 2);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return this.convertInputFormat(frameFormat);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        this.mProgram = new ShaderProgram(filterContext, "precision mediump float;\nconst vec4 coeff_y = vec4(0.299, 0.587, 0.114, 0);\nuniform sampler2D tex_sampler_0;\nuniform float pix_stride;\nvarying vec2 v_texcoord;\nvoid main() {\n  for (int i = 0; i < 4; ++i) {\n    vec4 p = texture2D(tex_sampler_0,\n                       v_texcoord + vec2(pix_stride * float(i), 0.0));\n    gl_FragColor[i] = dot(p, coeff_y);\n  }\n}\n");
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        FrameFormat frameFormat2 = this.convertInputFormat(frameFormat);
        int n = frameFormat2.getWidth();
        int n2 = frameFormat2.getHeight();
        this.checkOutputDimensions(n, n2);
        this.mProgram.setHostValue("pix_stride", Float.valueOf(1.0f / (float)n));
        MutableFrameFormat mutableFrameFormat = frameFormat.mutableCopy();
        mutableFrameFormat.setDimensions(n / 4, n2);
        Frame frame2 = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        this.mProgram.process(frame, frame2);
        Frame frame3 = filterContext.getFrameManager().newFrame(frameFormat2);
        frame3.setDataFromFrame(frame2);
        frame2.release();
        this.pushOutput("image", frame3);
        frame3.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }
}

