/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontListParser {
    public static Config parse(InputStream inputStream) throws XmlPullParserException, IOException {
        try {
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput(inputStream, null);
            xmlPullParser.nextTag();
            Config config = FontListParser.readFamilies(xmlPullParser);
            return config;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Alias readAlias(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        Alias alias = new Alias();
        alias.name = xmlPullParser.getAttributeValue(null, "name");
        alias.toName = xmlPullParser.getAttributeValue(null, "to");
        String string2 = xmlPullParser.getAttributeValue(null, "weight");
        alias.weight = string2 == null ? 400 : Integer.parseInt(string2);
        FontListParser.skip(xmlPullParser);
        return alias;
    }

    private static Config readFamilies(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        Config config = new Config();
        xmlPullParser.require(2, null, "familyset");
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals("family")) {
                config.families.add(FontListParser.readFamily(xmlPullParser));
                continue;
            }
            if (xmlPullParser.getName().equals("alias")) {
                config.aliases.add(FontListParser.readAlias(xmlPullParser));
                continue;
            }
            FontListParser.skip(xmlPullParser);
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Family readFamily(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string2 = xmlPullParser.getAttributeValue(null, "name");
        String string3 = xmlPullParser.getAttributeValue(null, "lang");
        String string4 = xmlPullParser.getAttributeValue(null, "variant");
        ArrayList<Font> arrayList = new ArrayList<Font>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals("font")) {
                String string5 = xmlPullParser.getAttributeValue(null, "weight");
                int n = string5 == null ? 400 : Integer.parseInt(string5);
                boolean bl = "italic".equals(xmlPullParser.getAttributeValue(null, "style"));
                String string6 = xmlPullParser.nextText();
                arrayList.add(new Font("/system/fonts/" + string6, n, bl));
                continue;
            }
            FontListParser.skip(xmlPullParser);
        }
        return new Family(string2, arrayList, string3, string4);
    }

    private static void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = 1;
        block4: while (n > 0) {
            switch (xmlPullParser.next()) {
                default: {
                    continue block4;
                }
                case 2: {
                    ++n;
                    continue block4;
                }
                case 3: 
            }
            --n;
        }
    }

    public static class Alias {
        public String name;
        public String toName;
        public int weight;
    }

    public static class Config {
        public List<Alias> aliases;
        public List<Family> families = new ArrayList<Family>();

        Config() {
            this.aliases = new ArrayList<Alias>();
        }
    }

    public static class Family {
        public List<Font> fonts;
        public String lang;
        public String name;
        public String variant;

        public Family(String string2, List<Font> list, String string3, String string4) {
            this.name = string2;
            this.fonts = list;
            this.lang = string3;
            this.variant = string4;
        }
    }

    public static class Font {
        public String fontName;
        public boolean isItalic;
        public int weight;

        Font(String string2, int n, boolean bl) {
            this.fontName = string2;
            this.weight = n;
            this.isItalic = bl;
        }
    }
}

