/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.FloatMath;
import com.android.internal.util.FastMath;
import java.io.PrintWriter;

public class RectF
implements Parcelable {
    public static final Parcelable.Creator<RectF> CREATOR = new Parcelable.Creator<RectF>(){

        @Override
        public RectF createFromParcel(Parcel parcel) {
            RectF rectF = new RectF();
            rectF.readFromParcel(parcel);
            return rectF;
        }

        public RectF[] newArray(int n) {
            return new RectF[n];
        }
    };
    public float bottom;
    public float left;
    public float right;
    public float top;

    public RectF() {
    }

    public RectF(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public RectF(Rect rect) {
        if (rect == null) {
            this.bottom = 0.0f;
            this.right = 0.0f;
            this.top = 0.0f;
            this.left = 0.0f;
            return;
        }
        this.left = rect.left;
        this.top = rect.top;
        this.right = rect.right;
        this.bottom = rect.bottom;
    }

    public RectF(RectF rectF) {
        if (rectF == null) {
            this.bottom = 0.0f;
            this.right = 0.0f;
            this.top = 0.0f;
            this.left = 0.0f;
            return;
        }
        this.left = rectF.left;
        this.top = rectF.top;
        this.right = rectF.right;
        this.bottom = rectF.bottom;
    }

    public static boolean intersects(RectF rectF, RectF rectF2) {
        return rectF.left < rectF2.right && rectF2.left < rectF.right && rectF.top < rectF2.bottom && rectF2.top < rectF.bottom;
    }

    public final float centerX() {
        return 0.5f * (this.left + this.right);
    }

    public final float centerY() {
        return 0.5f * (this.top + this.bottom);
    }

    public boolean contains(float f, float f2) {
        return this.left < this.right && this.top < this.bottom && f >= this.left && f < this.right && f2 >= this.top && f2 < this.bottom;
    }

    public boolean contains(float f, float f2, float f3, float f4) {
        return this.left < this.right && this.top < this.bottom && this.left <= f && this.top <= f2 && this.right >= f3 && this.bottom >= f4;
    }

    public boolean contains(RectF rectF) {
        return this.left < this.right && this.top < this.bottom && this.left <= rectF.left && this.top <= rectF.top && this.right >= rectF.right && this.bottom >= rectF.bottom;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                RectF rectF = (RectF)object;
                if (this.left != rectF.left || this.top != rectF.top || this.right != rectF.right || this.bottom != rectF.bottom) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.left != 0.0f ? Float.floatToIntBits(this.left) : 0;
        int n2 = n * 31;
        int n3 = this.top != 0.0f ? Float.floatToIntBits(this.top) : 0;
        int n4 = 31 * (n2 + n3);
        int n5 = this.right != 0.0f ? Float.floatToIntBits(this.right) : 0;
        int n6 = 31 * (n4 + n5);
        float f = this.bottom - 0.0f;
        float f2 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        int n7 = 0;
        if (f2 != false) {
            n7 = Float.floatToIntBits(this.bottom);
        }
        return n6 + n7;
    }

    public final float height() {
        return this.bottom - this.top;
    }

    public void inset(float f, float f2) {
        this.left = f + this.left;
        this.top = f2 + this.top;
        this.right -= f;
        this.bottom -= f2;
    }

    public boolean intersect(float f, float f2, float f3, float f4) {
        if (this.left < f3 && f < this.right && this.top < f4 && f2 < this.bottom) {
            if (this.left < f) {
                this.left = f;
            }
            if (this.top < f2) {
                this.top = f2;
            }
            if (this.right > f3) {
                this.right = f3;
            }
            if (this.bottom > f4) {
                this.bottom = f4;
            }
            return true;
        }
        return false;
    }

    public boolean intersect(RectF rectF) {
        return this.intersect(rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    public boolean intersects(float f, float f2, float f3, float f4) {
        return this.left < f3 && f < this.right && this.top < f4 && f2 < this.bottom;
    }

    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    public void offset(float f, float f2) {
        this.left = f + this.left;
        this.top = f2 + this.top;
        this.right = f + this.right;
        this.bottom = f2 + this.bottom;
    }

    public void offsetTo(float f, float f2) {
        this.right += f - this.left;
        this.bottom += f2 - this.top;
        this.left = f;
        this.top = f2;
    }

    public void printShortString(PrintWriter printWriter) {
        printWriter.print('[');
        printWriter.print(this.left);
        printWriter.print(',');
        printWriter.print(this.top);
        printWriter.print("][");
        printWriter.print(this.right);
        printWriter.print(',');
        printWriter.print(this.bottom);
        printWriter.print(']');
    }

    public void readFromParcel(Parcel parcel) {
        this.left = parcel.readFloat();
        this.top = parcel.readFloat();
        this.right = parcel.readFloat();
        this.bottom = parcel.readFloat();
    }

    public void round(Rect rect) {
        rect.set(FastMath.round(this.left), FastMath.round(this.top), FastMath.round(this.right), FastMath.round(this.bottom));
    }

    public void roundOut(Rect rect) {
        rect.set((int)FloatMath.floor(this.left), (int)FloatMath.floor(this.top), (int)FloatMath.ceil(this.right), (int)FloatMath.ceil(this.bottom));
    }

    public void set(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public void set(Rect rect) {
        this.left = rect.left;
        this.top = rect.top;
        this.right = rect.right;
        this.bottom = rect.bottom;
    }

    public void set(RectF rectF) {
        this.left = rectF.left;
        this.top = rectF.top;
        this.right = rectF.right;
        this.bottom = rectF.bottom;
    }

    public void setEmpty() {
        this.bottom = 0.0f;
        this.top = 0.0f;
        this.right = 0.0f;
        this.left = 0.0f;
    }

    public boolean setIntersect(RectF rectF, RectF rectF2) {
        if (rectF.left < rectF2.right && rectF2.left < rectF.right && rectF.top < rectF2.bottom && rectF2.top < rectF.bottom) {
            this.left = Math.max(rectF.left, rectF2.left);
            this.top = Math.max(rectF.top, rectF2.top);
            this.right = Math.min(rectF.right, rectF2.right);
            this.bottom = Math.min(rectF.bottom, rectF2.bottom);
            return true;
        }
        return false;
    }

    public void sort() {
        if (this.left > this.right) {
            float f = this.left;
            this.left = this.right;
            this.right = f;
        }
        if (this.top > this.bottom) {
            float f = this.top;
            this.top = this.bottom;
            this.bottom = f;
        }
    }

    public String toShortString() {
        return this.toShortString(new StringBuilder(32));
    }

    public String toShortString(StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        stringBuilder.append('[');
        stringBuilder.append(this.left);
        stringBuilder.append(',');
        stringBuilder.append(this.top);
        stringBuilder.append("][");
        stringBuilder.append(this.right);
        stringBuilder.append(',');
        stringBuilder.append(this.bottom);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString() {
        return "RectF(" + this.left + ", " + this.top + ", " + this.right + ", " + this.bottom + ")";
    }

    /*
     * Enabled aggressive block sorting
     */
    public void union(float f, float f2) {
        if (f < this.left) {
            this.left = f;
        } else if (f > this.right) {
            this.right = f;
        }
        if (f2 < this.top) {
            this.top = f2;
            return;
        } else {
            if (!(f2 > this.bottom)) return;
            this.bottom = f2;
            return;
        }
    }

    public void union(float f, float f2, float f3, float f4) {
        block8: {
            block7: {
                if (!(f < f3) || !(f2 < f4)) break block7;
                if (!(this.left < this.right) || !(this.top < this.bottom)) break block8;
                if (this.left > f) {
                    this.left = f;
                }
                if (this.top > f2) {
                    this.top = f2;
                }
                if (this.right < f3) {
                    this.right = f3;
                }
                if (this.bottom < f4) {
                    this.bottom = f4;
                }
            }
            return;
        }
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public void union(RectF rectF) {
        this.union(rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    public final float width() {
        return this.right - this.left;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeFloat(this.left);
        parcel.writeFloat(this.top);
        parcel.writeFloat(this.right);
        parcel.writeFloat(this.bottom);
    }
}

