/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawable
extends Drawable {
    private static final float DEFAULT_INNER_RADIUS_RATIO = 3.0f;
    private static final float DEFAULT_THICKNESS_RATIO = 9.0f;
    public static final int LINE = 2;
    public static final int LINEAR_GRADIENT = 0;
    public static final int OVAL = 1;
    public static final int RADIAL_GRADIENT = 1;
    private static final int RADIUS_TYPE_FRACTION = 1;
    private static final int RADIUS_TYPE_FRACTION_PARENT = 2;
    private static final int RADIUS_TYPE_PIXELS = 0;
    public static final int RECTANGLE = 0;
    public static final int RING = 3;
    public static final int SWEEP_GRADIENT = 2;
    private int mAlpha = 255;
    private ColorFilter mColorFilter;
    private final Paint mFillPaint = new Paint(1);
    private boolean mGradientIsDirty;
    private float mGradientRadius;
    private GradientState mGradientState;
    private Paint mLayerPaint;
    private boolean mMutated;
    private Rect mPadding;
    private final Path mPath = new Path();
    private boolean mPathIsDirty = true;
    private final RectF mRect = new RectF();
    private Path mRingPath;
    private Paint mStrokePaint;

    public GradientDrawable() {
        this(new GradientState(Orientation.TOP_BOTTOM, null), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private GradientDrawable(GradientState gradientState, Resources.Theme theme) {
        if (theme != null && gradientState.canApplyTheme()) {
            this.mGradientState = new GradientState(gradientState);
            this.applyTheme(theme);
        } else {
            this.mGradientState = gradientState;
        }
        this.initializeWithState(gradientState);
        this.mGradientIsDirty = true;
        this.mMutated = false;
    }

    public GradientDrawable(Orientation orientation, int[] nArray) {
        this(new GradientState(orientation, nArray), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyThemeChildElements(Resources.Theme theme) {
        TypedArray typedArray;
        GradientState gradientState = this.mGradientState;
        if (gradientState.mAttrSize != null) {
            TypedArray typedArray2 = theme.resolveAttributes(gradientState.mAttrSize, R.styleable.GradientDrawableSize);
            this.updateGradientDrawableSize(typedArray2);
            typedArray2.recycle();
        }
        if (gradientState.mAttrGradient != null) {
            typedArray = theme.resolveAttributes(gradientState.mAttrGradient, R.styleable.GradientDrawableGradient);
            try {
                this.updateGradientDrawableGradient(theme.getResources(), typedArray);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new RuntimeException(xmlPullParserException);
            }
        }
        if (gradientState.mAttrSolid != null) {
            TypedArray typedArray3 = theme.resolveAttributes(gradientState.mAttrSolid, R.styleable.GradientDrawableSolid);
            this.updateGradientDrawableSolid(typedArray3);
            typedArray3.recycle();
        }
        if (gradientState.mAttrStroke != null) {
            TypedArray typedArray4 = theme.resolveAttributes(gradientState.mAttrStroke, R.styleable.GradientDrawableStroke);
            this.updateGradientDrawableStroke(typedArray4);
            typedArray4.recycle();
        }
        if (gradientState.mAttrCorners != null) {
            TypedArray typedArray5 = theme.resolveAttributes(gradientState.mAttrCorners, R.styleable.DrawableCorners);
            this.updateDrawableCorners(typedArray5);
            typedArray5.recycle();
        }
        if (gradientState.mAttrPadding != null) {
            TypedArray typedArray6 = theme.resolveAttributes(gradientState.mAttrPadding, R.styleable.GradientDrawablePadding);
            this.updateGradientDrawablePadding(typedArray6);
            typedArray6.recycle();
        }
        return;
        finally {
            typedArray.recycle();
        }
    }

    private void buildPathIfDirty() {
        GradientState gradientState = this.mGradientState;
        if (this.mPathIsDirty) {
            this.ensureValidRect();
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, gradientState.mRadiusArray, Path.Direction.CW);
            this.mPathIsDirty = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Path buildRing(GradientState gradientState) {
        if (!(this.mRingPath == null || gradientState.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float f = gradientState.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF rectF = new RectF(this.mRect);
        float f2 = rectF.width() / 2.0f;
        float f3 = rectF.height() / 2.0f;
        float f4 = gradientState.mThickness != -1 ? (float)gradientState.mThickness : rectF.width() / gradientState.mThicknessRatio;
        float f5 = gradientState.mInnerRadius != -1 ? (float)gradientState.mInnerRadius : rectF.width() / gradientState.mInnerRadiusRatio;
        RectF rectF2 = new RectF(rectF);
        rectF2.inset(f2 - f5, f3 - f5);
        RectF rectF3 = new RectF(rectF2);
        rectF3.inset(-f4, -f4);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path path = this.mRingPath;
        if (f < 360.0f && f > -360.0f) {
            path.setFillType(Path.FillType.EVEN_ODD);
            path.moveTo(f2 + f5, f3);
            path.lineTo(f4 + (f2 + f5), f3);
            path.arcTo(rectF3, 0.0f, f, false);
            path.arcTo(rectF2, f, -f, false);
            path.close();
            return path;
        }
        path.addOval(rectF3, Path.Direction.CW);
        path.addOval(rectF2, Path.Direction.CCW);
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean ensureValidRect() {
        if (this.mGradientIsDirty) {
            this.mGradientIsDirty = false;
            Rect rect = this.getBounds();
            Paint paint = this.mStrokePaint;
            float f = 0.0f;
            if (paint != null) {
                f = 0.5f * this.mStrokePaint.getStrokeWidth();
            }
            GradientState gradientState = this.mGradientState;
            this.mRect.set(f + (float)rect.left, f + (float)rect.top, (float)rect.right - f, (float)rect.bottom - f);
            int[] nArray = gradientState.mColors;
            if (nArray != null) {
                RectF rectF = this.mRect;
                if (gradientState.mGradient == 0) {
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    float f6 = gradientState.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (1.$SwitchMap$android$graphics$drawable$GradientDrawable$Orientation[gradientState.mOrientation.ordinal()]) {
                        default: {
                            f5 = rectF.left;
                            f4 = rectF.top;
                            f3 = f6 * rectF.right;
                            f2 = f6 * rectF.bottom;
                            break;
                        }
                        case 1: {
                            f5 = rectF.left;
                            f4 = rectF.top;
                            f3 = f5;
                            f2 = f6 * rectF.bottom;
                            break;
                        }
                        case 2: {
                            f5 = rectF.right;
                            f4 = rectF.top;
                            f3 = f6 * rectF.left;
                            f2 = f6 * rectF.bottom;
                            break;
                        }
                        case 3: {
                            f5 = rectF.right;
                            f4 = rectF.top;
                            f3 = f6 * rectF.left;
                            f2 = f4;
                            break;
                        }
                        case 4: {
                            f5 = rectF.right;
                            f4 = rectF.bottom;
                            f3 = f6 * rectF.left;
                            f2 = f6 * rectF.top;
                            break;
                        }
                        case 5: {
                            f5 = rectF.left;
                            f4 = rectF.bottom;
                            f3 = f5;
                            f2 = f6 * rectF.top;
                            break;
                        }
                        case 6: {
                            f5 = rectF.left;
                            f4 = rectF.bottom;
                            f3 = f6 * rectF.right;
                            f2 = f6 * rectF.top;
                            break;
                        }
                        case 7: {
                            f5 = rectF.left;
                            f4 = rectF.top;
                            f3 = f6 * rectF.right;
                            f2 = f4;
                            break;
                        }
                    }
                    this.mFillPaint.setShader(new LinearGradient(f5, f4, f3, f2, nArray, gradientState.mPositions, Shader.TileMode.CLAMP));
                } else if (gradientState.mGradient == 1) {
                    float f7 = rectF.left + (rectF.right - rectF.left) * gradientState.mCenterX;
                    float f8 = rectF.top + (rectF.bottom - rectF.top) * gradientState.mCenterY;
                    float f9 = gradientState.mGradientRadius;
                    if (gradientState.mGradientRadiusType == 1) {
                        f9 *= (float)Math.min(gradientState.mWidth, gradientState.mHeight);
                    } else if (gradientState.mGradientRadiusType == 2) {
                        f9 *= Math.min(rectF.width(), rectF.height());
                    }
                    if (gradientState.mUseLevel) {
                        f9 *= (float)this.getLevel() / 10000.0f;
                    }
                    this.mGradientRadius = f9;
                    if (f9 == 0.0f) {
                        f9 = 0.001f;
                    }
                    this.mFillPaint.setShader(new RadialGradient(f7, f8, f9, nArray, null, Shader.TileMode.CLAMP));
                } else if (gradientState.mGradient == 2) {
                    float f10 = rectF.left + (rectF.right - rectF.left) * gradientState.mCenterX;
                    float f11 = rectF.top + (rectF.bottom - rectF.top) * gradientState.mCenterY;
                    int[] nArray2 = nArray;
                    boolean bl = gradientState.mUseLevel;
                    float[] fArray = null;
                    if (bl) {
                        nArray2 = gradientState.mTempColors;
                        int n = nArray.length;
                        if (nArray2 == null || nArray2.length != n + 1) {
                            nArray2 = new int[n + 1];
                            gradientState.mTempColors = nArray2;
                        }
                        System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)n);
                        nArray2[n] = nArray[n - 1];
                        fArray = gradientState.mTempPositions;
                        float f12 = 1.0f / (float)(n - 1);
                        if (fArray == null || fArray.length != n + 1) {
                            gradientState.mTempPositions = fArray = new float[n + 1];
                        }
                        float f13 = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < n; ++i) {
                            fArray[i] = f13 * (f12 * (float)i);
                        }
                        fArray[n] = 1.0f;
                    }
                    this.mFillPaint.setShader(new SweepGradient(f10, f11, nArray2, fArray));
                }
                if (gradientState.mColorStateList == null) {
                    this.mFillPaint.setColor(-16777216);
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float getFloatOrFraction(TypedArray typedArray, int n, float f) {
        TypedValue typedValue = typedArray.peekValue(n);
        float f2 = f;
        if (typedValue == null) return f2;
        boolean bl = typedValue.type == 6;
        if (bl) return typedValue.getFraction(1.0f, 1.0f);
        return typedValue.getFloat();
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        int n2;
        int n3 = 1 + xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            if (n2 != 2 || n > n3) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("size")) {
                TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.GradientDrawableSize);
                this.updateGradientDrawableSize(typedArray);
                typedArray.recycle();
                continue;
            }
            if (string2.equals("gradient")) {
                TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.GradientDrawableGradient);
                this.updateGradientDrawableGradient(resources, typedArray);
                typedArray.recycle();
                continue;
            }
            if (string2.equals("solid")) {
                TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.GradientDrawableSolid);
                this.updateGradientDrawableSolid(typedArray);
                typedArray.recycle();
                continue;
            }
            if (string2.equals("stroke")) {
                TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.GradientDrawableStroke);
                this.updateGradientDrawableStroke(typedArray);
                typedArray.recycle();
                continue;
            }
            if (string2.equals("corners")) {
                TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.DrawableCorners);
                this.updateDrawableCorners(typedArray);
                typedArray.recycle();
                continue;
            }
            if (string2.equals("padding")) {
                TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.GradientDrawablePadding);
                this.updateGradientDrawablePadding(typedArray);
                typedArray.recycle();
                continue;
            }
            Log.w("drawable", "Bad element under <shape>: " + string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeWithState(GradientState gradientState) {
        if (gradientState.mColorStateList != null) {
            int[] nArray = this.getState();
            int n = gradientState.mColorStateList.getColorForState(nArray, 0);
            this.mFillPaint.setColor(n);
        } else if (gradientState.mColors == null) {
            this.mFillPaint.setColor(0);
        } else {
            this.mFillPaint.setColor(-16777216);
        }
        this.mPadding = gradientState.mPadding;
        if (gradientState.mStrokeWidth >= 0) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            this.mStrokePaint.setStrokeWidth(gradientState.mStrokeWidth);
            if (gradientState.mStrokeColorStateList != null) {
                int[] nArray = this.getState();
                int n = gradientState.mStrokeColorStateList.getColorForState(nArray, 0);
                this.mStrokePaint.setColor(n);
            }
            if (gradientState.mStrokeDashWidth != 0.0f) {
                float[] fArray = new float[]{gradientState.mStrokeDashWidth, gradientState.mStrokeDashGap};
                DashPathEffect dashPathEffect = new DashPathEffect(fArray, 0.0f);
                this.mStrokePaint.setPathEffect(dashPathEffect);
            }
        }
    }

    static boolean isOpaque(int n) {
        return (0xFF & n >> 24) == 255;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isOpaqueForState() {
        return (this.mGradientState.mStrokeWidth < 0 || this.mStrokePaint == null || GradientDrawable.isOpaque(this.mStrokePaint.getColor())) && GradientDrawable.isOpaque(this.mFillPaint.getColor());
    }

    private int modulateAlpha(int n) {
        return n * (this.mAlpha + (this.mAlpha >> 7)) >> 8;
    }

    private void setStrokeInternal(int n, int n2, float f, float f2) {
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
        }
        this.mStrokePaint.setStrokeWidth(n);
        this.mStrokePaint.setColor(n2);
        float f3 = f - 0.0f;
        float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
        DashPathEffect dashPathEffect = null;
        if (f4 > 0) {
            dashPathEffect = new DashPathEffect(new float[]{f, f2}, 0.0f);
        }
        this.mStrokePaint.setPathEffect(dashPathEffect);
        this.invalidateSelf();
    }

    private void updateDrawableCorners(TypedArray typedArray) {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mAttrCorners = typedArray.extractThemeAttrs();
        int n = typedArray.getDimensionPixelSize(0, (int)gradientState.mRadius);
        this.setCornerRadius(n);
        int n2 = typedArray.getDimensionPixelSize(1, n);
        int n3 = typedArray.getDimensionPixelSize(2, n);
        int n4 = typedArray.getDimensionPixelSize(3, n);
        int n5 = typedArray.getDimensionPixelSize(4, n);
        if (n2 != n || n3 != n || n4 != n || n5 != n) {
            float[] fArray = new float[]{n2, n2, n3, n3, n5, n5, n4, n4};
            this.setCornerRadii(fArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateGradientDrawableGradient(Resources resources, TypedArray typedArray) throws XmlPullParserException {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mAttrGradient = typedArray.extractThemeAttrs();
        GradientState.access$302(gradientState, GradientDrawable.getFloatOrFraction(typedArray, 5, gradientState.mCenterX));
        GradientState.access$402(gradientState, GradientDrawable.getFloatOrFraction(typedArray, 6, gradientState.mCenterY));
        GradientState.access$002(gradientState, typedArray.getBoolean(2, gradientState.mUseLevel));
        gradientState.mGradient = typedArray.getInt(4, gradientState.mGradient);
        int n = typedArray.getColor(0, 0);
        boolean bl = typedArray.hasValue(8);
        int n2 = typedArray.getColor(8, 0);
        int n3 = typedArray.getColor(1, 0);
        if (bl) {
            gradientState.mColors = new int[3];
            gradientState.mColors[0] = n;
            gradientState.mColors[1] = n2;
            gradientState.mColors[2] = n3;
            gradientState.mPositions = new float[3];
            gradientState.mPositions[0] = 0.0f;
            float[] fArray = gradientState.mPositions;
            float f = gradientState.mCenterX != 0.5f ? gradientState.mCenterX : gradientState.mCenterY;
            fArray[1] = f;
            gradientState.mPositions[2] = 1.0f;
        } else {
            gradientState.mColors = new int[2];
            gradientState.mColors[0] = n;
            gradientState.mColors[1] = n3;
        }
        if (gradientState.mGradient == 0) {
            int n4 = (int)typedArray.getFloat(3, gradientState.mAngle) % 360;
            if (n4 % 45 != 0) {
                throw new XmlPullParserException(typedArray.getPositionDescription() + "<gradient> tag requires 'angle' attribute to " + "be a multiple of 45");
            }
            gradientState.mAngle = n4;
            switch (n4) {
                default: {
                    return;
                }
                case 0: {
                    gradientState.mOrientation = Orientation.LEFT_RIGHT;
                    return;
                }
                case 45: {
                    gradientState.mOrientation = Orientation.BL_TR;
                    return;
                }
                case 90: {
                    gradientState.mOrientation = Orientation.BOTTOM_TOP;
                    return;
                }
                case 135: {
                    gradientState.mOrientation = Orientation.BR_TL;
                    return;
                }
                case 180: {
                    gradientState.mOrientation = Orientation.RIGHT_LEFT;
                    return;
                }
                case 225: {
                    gradientState.mOrientation = Orientation.TR_BL;
                    return;
                }
                case 270: {
                    gradientState.mOrientation = Orientation.TOP_BOTTOM;
                    return;
                }
                case 315: {
                    gradientState.mOrientation = Orientation.TL_BR;
                    return;
                }
            }
        }
        TypedValue typedValue = typedArray.peekValue(7);
        if (typedValue != null) {
            int n5;
            float f;
            if (typedValue.type == 6) {
                f = typedValue.getFraction(1.0f, 1.0f);
                n5 = (0xF & typedValue.data >> 0) == 1 ? 2 : 1;
            } else {
                f = typedValue.getDimension(resources.getDisplayMetrics());
                n5 = 0;
            }
            GradientState.access$502(gradientState, f);
            GradientState.access$602(gradientState, n5);
            return;
        }
        if (gradientState.mGradient != 1) return;
        throw new XmlPullParserException(typedArray.getPositionDescription() + "<gradient> tag requires 'gradientRadius' " + "attribute with radial type");
    }

    private void updateGradientDrawablePadding(TypedArray typedArray) {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mAttrPadding = typedArray.extractThemeAttrs();
        if (gradientState.mPadding == null) {
            gradientState.mPadding = new Rect();
        }
        Rect rect = gradientState.mPadding;
        rect.set(typedArray.getDimensionPixelOffset(0, rect.left), typedArray.getDimensionPixelOffset(1, rect.top), typedArray.getDimensionPixelOffset(2, rect.right), typedArray.getDimensionPixelOffset(3, rect.bottom));
        this.mPadding = rect;
    }

    private void updateGradientDrawableSize(TypedArray typedArray) {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mAttrSize = typedArray.extractThemeAttrs();
        gradientState.mWidth = typedArray.getDimensionPixelSize(1, gradientState.mWidth);
        gradientState.mHeight = typedArray.getDimensionPixelSize(0, gradientState.mHeight);
    }

    private void updateGradientDrawableSolid(TypedArray typedArray) {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mAttrSolid = typedArray.extractThemeAttrs();
        ColorStateList colorStateList = typedArray.getColorStateList(0);
        if (colorStateList != null) {
            this.setColor(colorStateList);
        }
    }

    private void updateGradientDrawableStroke(TypedArray typedArray) {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mAttrStroke = typedArray.extractThemeAttrs();
        int n = typedArray.getDimensionPixelSize(0, Math.max(0, gradientState.mStrokeWidth));
        float f = typedArray.getDimension(2, gradientState.mStrokeDashWidth);
        ColorStateList colorStateList = typedArray.getColorStateList(1);
        if (colorStateList == null) {
            colorStateList = gradientState.mStrokeColorStateList;
        }
        if (f != 0.0f) {
            this.setStroke(n, colorStateList, f, typedArray.getDimension(3, gradientState.mStrokeDashGap));
            return;
        }
        this.setStroke(n, colorStateList);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        gradientState.mThemeAttrs = typedArray.extractThemeAttrs();
        gradientState.mShape = typedArray.getInt(2, gradientState.mShape);
        gradientState.mDither = typedArray.getBoolean(0, gradientState.mDither);
        if (gradientState.mShape == 3) {
            gradientState.mInnerRadius = typedArray.getDimensionPixelSize(6, gradientState.mInnerRadius);
            if (gradientState.mInnerRadius == -1) {
                gradientState.mInnerRadiusRatio = typedArray.getFloat(3, gradientState.mInnerRadiusRatio);
            }
            gradientState.mThickness = typedArray.getDimensionPixelSize(7, gradientState.mThickness);
            if (gradientState.mThickness == -1) {
                gradientState.mThicknessRatio = typedArray.getFloat(4, gradientState.mThicknessRatio);
            }
            GradientState.access$102(gradientState, typedArray.getBoolean(5, gradientState.mUseLevelForShape));
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        GradientState gradientState = this.mGradientState;
        if (gradientState == null || gradientState.mThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(gradientState.mThemeAttrs, R.styleable.GradientDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        this.applyThemeChildElements(theme);
        gradientState.computeOpacity();
    }

    @Override
    public boolean canApplyTheme() {
        GradientState gradientState = this.mGradientState;
        return gradientState != null && (gradientState.mThemeAttrs != null || gradientState.mAttrSize != null || gradientState.mAttrGradient != null || gradientState.mAttrSolid != null || gradientState.mAttrStroke != null || gradientState.mAttrCorners != null || gradientState.mAttrPadding != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        int n;
        block19: {
            block18: {
                if (!this.ensureValidRect()) break block18;
                int n2 = this.mFillPaint.getAlpha();
                n = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
                int n3 = this.modulateAlpha(n2);
                int n4 = this.modulateAlpha(n);
                boolean bl = n4 > 0 && this.mStrokePaint != null && this.mStrokePaint.getStrokeWidth() > 0.0f;
                boolean bl2 = n3 > 0;
                GradientState gradientState = this.mGradientState;
                boolean bl3 = bl && bl2 && gradientState.mShape != 2 && n4 < 255 && (this.mAlpha < 255 || this.mColorFilter != null);
                if (bl3) {
                    if (this.mLayerPaint == null) {
                        this.mLayerPaint = new Paint();
                    }
                    this.mLayerPaint.setDither(gradientState.mDither);
                    this.mLayerPaint.setAlpha(this.mAlpha);
                    this.mLayerPaint.setColorFilter(this.mColorFilter);
                    float f = this.mStrokePaint.getStrokeWidth();
                    canvas.saveLayer(this.mRect.left - f, this.mRect.top - f, f + this.mRect.right, f + this.mRect.bottom, this.mLayerPaint, 4);
                    this.mFillPaint.setColorFilter(null);
                    this.mStrokePaint.setColorFilter(null);
                } else {
                    this.mFillPaint.setAlpha(n3);
                    this.mFillPaint.setDither(gradientState.mDither);
                    this.mFillPaint.setColorFilter(this.mColorFilter);
                    if (this.mColorFilter != null && gradientState.mColorStateList == null) {
                        this.mFillPaint.setColor(this.mAlpha << 24);
                    }
                    if (bl) {
                        this.mStrokePaint.setAlpha(n4);
                        this.mStrokePaint.setDither(gradientState.mDither);
                        this.mStrokePaint.setColorFilter(this.mColorFilter);
                    }
                }
                switch (gradientState.mShape) {
                    case 0: {
                        if (gradientState.mRadiusArray != null) {
                            this.buildPathIfDirty();
                            canvas.drawPath(this.mPath, this.mFillPaint);
                            if (!bl) break;
                            canvas.drawPath(this.mPath, this.mStrokePaint);
                            break;
                        }
                        if (gradientState.mRadius > 0.0f) {
                            float f = Math.min(gradientState.mRadius, 0.5f * Math.min(this.mRect.width(), this.mRect.height()));
                            canvas.drawRoundRect(this.mRect, f, f, this.mFillPaint);
                            if (!bl) break;
                            canvas.drawRoundRect(this.mRect, f, f, this.mStrokePaint);
                            break;
                        }
                        if (this.mFillPaint.getColor() != 0 || this.mColorFilter != null || this.mFillPaint.getShader() != null) {
                            canvas.drawRect(this.mRect, this.mFillPaint);
                        }
                        if (!bl) break;
                        canvas.drawRect(this.mRect, this.mStrokePaint);
                        break;
                    }
                    case 1: {
                        canvas.drawOval(this.mRect, this.mFillPaint);
                        if (!bl) break;
                        canvas.drawOval(this.mRect, this.mStrokePaint);
                        break;
                    }
                    case 2: {
                        RectF rectF = this.mRect;
                        float f = rectF.centerY();
                        if (!bl) break;
                        canvas.drawLine(rectF.left, f, rectF.right, f, this.mStrokePaint);
                        break;
                    }
                    case 3: {
                        Path path = this.buildRing(gradientState);
                        canvas.drawPath(path, this.mFillPaint);
                        if (!bl) break;
                        canvas.drawPath(path, this.mStrokePaint);
                    }
                }
                if (bl3) {
                    canvas.restore();
                    return;
                }
                this.mFillPaint.setAlpha(n2);
                if (bl) break block19;
            }
            return;
        }
        this.mStrokePaint.setAlpha(n);
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mGradientState.mChangingConfigurations;
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mGradientState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mGradientState;
    }

    public float getGradientRadius() {
        if (this.mGradientState.mGradient != 1) {
            return 0.0f;
        }
        this.ensureValidRect();
        return this.mGradientRadius;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mGradientState.mHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mGradientState.mWidth;
    }

    @Override
    public int getOpacity() {
        if (this.mAlpha == 255 && this.mGradientState.mOpaqueOverBounds && this.isOpaqueForState()) {
            return -1;
        }
        return -3;
    }

    public Orientation getOrientation() {
        return this.mGradientState.mOrientation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void getOutline(Outline outline) {
        GradientState gradientState = this.mGradientState;
        Rect rect = this.getBounds();
        float f = gradientState.mOpaqueOverShape && this.isOpaqueForState() ? (float)this.mAlpha / 255.0f : 0.0f;
        outline.setAlpha(f);
        switch (gradientState.mShape) {
            default: {
                return;
            }
            case 0: {
                if (gradientState.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    outline.setConvexPath(this.mPath);
                    return;
                }
                float f2 = gradientState.mRadius - 0.0f;
                float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
                float f4 = 0.0f;
                if (f3 > 0) {
                    f4 = Math.min(gradientState.mRadius, 0.5f * (float)Math.min(rect.width(), rect.height()));
                }
                outline.setRoundRect(rect, f4);
                return;
            }
            case 1: {
                outline.setOval(rect);
                return;
            }
            case 2: 
        }
        float f5 = this.mStrokePaint == null ? 1.0E-4f : 0.5f * this.mStrokePaint.getStrokeWidth();
        float f6 = rect.centerY();
        int n = (int)Math.floor(f6 - f5);
        int n2 = (int)Math.ceil(f6 + f5);
        outline.setRect(rect.left, n, rect.right, n2);
    }

    @Override
    public boolean getPadding(Rect rect) {
        if (this.mPadding != null) {
            rect.set(this.mPadding);
            return true;
        }
        return super.getPadding(rect);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray typedArray = GradientDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.GradientDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 1);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        this.inflateChildElements(resources, xmlPullParser, attributeSet, theme);
        this.mGradientState.computeOpacity();
    }

    @Override
    public boolean isStateful() {
        GradientState gradientState = this.mGradientState;
        return super.isStateful() || gradientState.mColorStateList != null && gradientState.mColorStateList.isStateful() || gradientState.mStrokeColorStateList != null && gradientState.mStrokeColorStateList.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mGradientState = new GradientState(this.mGradientState);
            this.initializeWithState(this.mGradientState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientIsDirty = true;
    }

    @Override
    protected boolean onLevelChange(int n) {
        super.onLevelChange(n);
        this.mGradientIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        ColorStateList colorStateList;
        Paint paint;
        GradientState gradientState = this.mGradientState;
        ColorStateList colorStateList2 = gradientState.mColorStateList;
        boolean bl = false;
        if (colorStateList2 != null) {
            int n = colorStateList2.getColorForState(nArray, 0);
            int n2 = this.mFillPaint.getColor();
            bl = false;
            if (n2 != n) {
                this.mFillPaint.setColor(n);
                bl = true;
            }
        }
        if ((paint = this.mStrokePaint) != null && (colorStateList = gradientState.mStrokeColorStateList) != null) {
            int n = colorStateList.getColorForState(nArray, 0);
            if (paint.getColor() != n) {
                paint.setColor(n);
                bl = true;
            }
        }
        boolean bl2 = false;
        if (bl) {
            this.invalidateSelf();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void setAlpha(int n) {
        if (n != this.mAlpha) {
            this.mAlpha = n;
            this.invalidateSelf();
        }
    }

    public void setColor(int n) {
        this.mGradientState.setColorStateList(ColorStateList.valueOf(n));
        this.mFillPaint.setColor(n);
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setColor(ColorStateList colorStateList) {
        this.mGradientState.setColorStateList(colorStateList);
        int n = colorStateList == null ? 0 : colorStateList.getColorForState(this.getState(), 0);
        this.mFillPaint.setColor(n);
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (colorFilter != this.mColorFilter) {
            this.mColorFilter = colorFilter;
            this.invalidateSelf();
        }
    }

    public void setColors(int[] nArray) {
        this.mGradientState.setColors(nArray);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setCornerRadii(float[] fArray) {
        this.mGradientState.setCornerRadii(fArray);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setCornerRadius(float f) {
        this.mGradientState.setCornerRadius(f);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    @Override
    public void setDither(boolean bl) {
        if (bl != this.mGradientState.mDither) {
            this.mGradientState.mDither = bl;
            this.invalidateSelf();
        }
    }

    public void setGradientCenter(float f, float f2) {
        this.mGradientState.setGradientCenter(f, f2);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setGradientRadius(float f) {
        this.mGradientState.setGradientRadius(f, 0);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setGradientType(int n) {
        this.mGradientState.setGradientType(n);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setOrientation(Orientation orientation) {
        this.mGradientState.mOrientation = orientation;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setShape(int n) {
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientState.setShape(n);
        this.invalidateSelf();
    }

    public void setSize(int n, int n2) {
        this.mGradientState.setSize(n, n2);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setStroke(int n, int n2) {
        this.setStroke(n, n2, 0.0f, 0.0f);
    }

    public void setStroke(int n, int n2, float f, float f2) {
        this.mGradientState.setStroke(n, ColorStateList.valueOf(n2), f, f2);
        this.setStrokeInternal(n, n2, f, f2);
    }

    public void setStroke(int n, ColorStateList colorStateList) {
        this.setStroke(n, colorStateList, 0.0f, 0.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStroke(int n, ColorStateList colorStateList, float f, float f2) {
        this.mGradientState.setStroke(n, colorStateList, f, f2);
        int n2 = colorStateList == null ? 0 : colorStateList.getColorForState(this.getState(), 0);
        this.setStrokeInternal(n, n2, f, f2);
    }

    public void setUseLevel(boolean bl) {
        GradientState.access$002(this.mGradientState, bl);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    static final class GradientState
    extends Drawable.ConstantState {
        public int mAngle = 0;
        int[] mAttrCorners;
        int[] mAttrGradient;
        int[] mAttrPadding;
        int[] mAttrSize;
        int[] mAttrSolid;
        int[] mAttrStroke;
        private float mCenterX = 0.5f;
        private float mCenterY = 0.5f;
        public int mChangingConfigurations;
        public ColorStateList mColorStateList;
        public int[] mColors;
        public boolean mDither = false;
        public int mGradient = 0;
        private float mGradientRadius = 0.5f;
        private int mGradientRadiusType = 0;
        public int mHeight = -1;
        public int mInnerRadius = -1;
        public float mInnerRadiusRatio = 3.0f;
        private boolean mOpaqueOverBounds;
        private boolean mOpaqueOverShape;
        public Orientation mOrientation;
        public Rect mPadding = null;
        public float[] mPositions;
        public float mRadius = 0.0f;
        public float[] mRadiusArray = null;
        public int mShape = 0;
        public ColorStateList mStrokeColorStateList;
        public float mStrokeDashGap = 0.0f;
        public float mStrokeDashWidth = 0.0f;
        public int mStrokeWidth = -1;
        public int[] mTempColors;
        public float[] mTempPositions;
        int[] mThemeAttrs;
        public int mThickness = -1;
        public float mThicknessRatio = 9.0f;
        private boolean mUseLevel;
        private boolean mUseLevelForShape;
        public int mWidth = -1;

        public GradientState(GradientState gradientState) {
            this.mChangingConfigurations = gradientState.mChangingConfigurations;
            this.mShape = gradientState.mShape;
            this.mGradient = gradientState.mGradient;
            this.mAngle = gradientState.mAngle;
            this.mOrientation = gradientState.mOrientation;
            this.mColorStateList = gradientState.mColorStateList;
            if (gradientState.mColors != null) {
                this.mColors = (int[])gradientState.mColors.clone();
            }
            if (gradientState.mPositions != null) {
                this.mPositions = (float[])gradientState.mPositions.clone();
            }
            this.mStrokeColorStateList = gradientState.mStrokeColorStateList;
            this.mStrokeWidth = gradientState.mStrokeWidth;
            this.mStrokeDashWidth = gradientState.mStrokeDashWidth;
            this.mStrokeDashGap = gradientState.mStrokeDashGap;
            this.mRadius = gradientState.mRadius;
            if (gradientState.mRadiusArray != null) {
                this.mRadiusArray = (float[])gradientState.mRadiusArray.clone();
            }
            if (gradientState.mPadding != null) {
                this.mPadding = new Rect(gradientState.mPadding);
            }
            this.mWidth = gradientState.mWidth;
            this.mHeight = gradientState.mHeight;
            this.mInnerRadiusRatio = gradientState.mInnerRadiusRatio;
            this.mThicknessRatio = gradientState.mThicknessRatio;
            this.mInnerRadius = gradientState.mInnerRadius;
            this.mThickness = gradientState.mThickness;
            this.mDither = gradientState.mDither;
            this.mCenterX = gradientState.mCenterX;
            this.mCenterY = gradientState.mCenterY;
            this.mGradientRadius = gradientState.mGradientRadius;
            this.mGradientRadiusType = gradientState.mGradientRadiusType;
            this.mUseLevel = gradientState.mUseLevel;
            this.mUseLevelForShape = gradientState.mUseLevelForShape;
            this.mOpaqueOverBounds = gradientState.mOpaqueOverBounds;
            this.mOpaqueOverShape = gradientState.mOpaqueOverShape;
            this.mThemeAttrs = gradientState.mThemeAttrs;
            this.mAttrSize = gradientState.mAttrSize;
            this.mAttrGradient = gradientState.mAttrGradient;
            this.mAttrSolid = gradientState.mAttrSolid;
            this.mAttrStroke = gradientState.mAttrStroke;
            this.mAttrCorners = gradientState.mAttrCorners;
            this.mAttrPadding = gradientState.mAttrPadding;
        }

        GradientState(Orientation orientation, int[] nArray) {
            this.mOrientation = orientation;
            this.setColors(nArray);
        }

        static /* synthetic */ boolean access$002(GradientState gradientState, boolean bl) {
            gradientState.mUseLevel = bl;
            return bl;
        }

        static /* synthetic */ boolean access$102(GradientState gradientState, boolean bl) {
            gradientState.mUseLevelForShape = bl;
            return bl;
        }

        static /* synthetic */ float access$302(GradientState gradientState, float f) {
            gradientState.mCenterX = f;
            return f;
        }

        static /* synthetic */ float access$402(GradientState gradientState, float f) {
            gradientState.mCenterY = f;
            return f;
        }

        static /* synthetic */ float access$502(GradientState gradientState, float f) {
            gradientState.mGradientRadius = f;
            return f;
        }

        static /* synthetic */ int access$602(GradientState gradientState, int n) {
            gradientState.mGradientRadiusType = n;
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeOpacity() {
            boolean bl = true;
            this.mOpaqueOverBounds = false;
            this.mOpaqueOverShape = false;
            if (this.mColors != null) {
                for (int i = 0; i < this.mColors.length; ++i) {
                    if (!GradientDrawable.isOpaque(this.mColors[i])) return;
                }
            }
            if (this.mColors == null && this.mColorStateList == null) {
                return;
            }
            this.mOpaqueOverShape = bl;
            if (this.mShape != 0 || !(this.mRadius <= 0.0f) || this.mRadiusArray != null) {
                bl = false;
            }
            this.mOpaqueOverBounds = bl;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new GradientDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new GradientDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new GradientDrawable(this, theme);
        }

        public void setColorStateList(ColorStateList colorStateList) {
            this.mColors = null;
            this.mColorStateList = colorStateList;
            this.computeOpacity();
        }

        public void setColors(int[] nArray) {
            this.mColors = nArray;
            this.mColorStateList = null;
            this.computeOpacity();
        }

        public void setCornerRadii(float[] fArray) {
            this.mRadiusArray = fArray;
            if (fArray == null) {
                this.mRadius = 0.0f;
            }
        }

        public void setCornerRadius(float f) {
            if (f < 0.0f) {
                f = 0.0f;
            }
            this.mRadius = f;
            this.mRadiusArray = null;
        }

        public void setGradientCenter(float f, float f2) {
            this.mCenterX = f;
            this.mCenterY = f2;
        }

        public void setGradientRadius(float f, int n) {
            this.mGradientRadius = f;
            this.mGradientRadiusType = n;
        }

        public void setGradientType(int n) {
            this.mGradient = n;
        }

        public void setShape(int n) {
            this.mShape = n;
            this.computeOpacity();
        }

        public void setSize(int n, int n2) {
            this.mWidth = n;
            this.mHeight = n2;
        }

        public void setStroke(int n, ColorStateList colorStateList, float f, float f2) {
            this.mStrokeWidth = n;
            this.mStrokeColorStateList = colorStateList;
            this.mStrokeDashWidth = f;
            this.mStrokeDashGap = f2;
            this.computeOpacity();
        }
    }

    public static final class Orientation
    extends Enum<Orientation> {
        private static final /* synthetic */ Orientation[] $VALUES;
        public static final /* enum */ Orientation BL_TR;
        public static final /* enum */ Orientation BOTTOM_TOP;
        public static final /* enum */ Orientation BR_TL;
        public static final /* enum */ Orientation LEFT_RIGHT;
        public static final /* enum */ Orientation RIGHT_LEFT;
        public static final /* enum */ Orientation TL_BR;
        public static final /* enum */ Orientation TOP_BOTTOM;
        public static final /* enum */ Orientation TR_BL;

        static {
            TOP_BOTTOM = new Orientation();
            TR_BL = new Orientation();
            RIGHT_LEFT = new Orientation();
            BR_TL = new Orientation();
            BOTTOM_TOP = new Orientation();
            BL_TR = new Orientation();
            LEFT_RIGHT = new Orientation();
            TL_BR = new Orientation();
            Orientation[] orientationArray = new Orientation[]{TOP_BOTTOM, TR_BL, RIGHT_LEFT, BR_TL, BOTTOM_TOP, BL_TR, LEFT_RIGHT, TL_BR};
            $VALUES = orientationArray;
        }

        public static Orientation valueOf(String string2) {
            return Enum.valueOf(Orientation.class, string2);
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }
    }
}

