/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.NinePatch;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NinePatchDrawable
extends Drawable {
    private static final boolean DEFAULT_DITHER;
    private int mBitmapHeight = -1;
    private int mBitmapWidth = -1;
    private boolean mMutated;
    private NinePatch mNinePatch;
    private NinePatchState mNinePatchState;
    private Insets mOpticalInsets = Insets.NONE;
    private Rect mPadding;
    private Paint mPaint;
    private int mTargetDensity = 160;
    private PorterDuffColorFilter mTintFilter;

    NinePatchDrawable() {
        this.mNinePatchState = new NinePatchState();
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect, rect2), resources, null);
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect), resources, null);
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    public NinePatchDrawable(Resources resources, NinePatch ninePatch) {
        this(new NinePatchState(ninePatch, new Rect()), resources, null);
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    public NinePatchDrawable(Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect), null, null);
    }

    @Deprecated
    public NinePatchDrawable(NinePatch ninePatch) {
        this(new NinePatchState(ninePatch, new Rect()), null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private NinePatchDrawable(NinePatchState ninePatchState, Resources resources, Resources.Theme theme) {
        if (theme != null && ninePatchState.canApplyTheme()) {
            this.mNinePatchState = new NinePatchState(ninePatchState);
            this.applyTheme(theme);
        } else {
            this.mNinePatchState = ninePatchState;
        }
        this.initializeWithState(ninePatchState, resources);
    }

    private void computeBitmapSize() {
        int n;
        int n2 = this.mNinePatch.getDensity();
        if (n2 == (n = this.mTargetDensity)) {
            this.mBitmapWidth = this.mNinePatch.getWidth();
            this.mBitmapHeight = this.mNinePatch.getHeight();
            this.mOpticalInsets = this.mNinePatchState.mOpticalInsets;
            return;
        }
        this.mBitmapWidth = Bitmap.scaleFromDensity(this.mNinePatch.getWidth(), n2, n);
        this.mBitmapHeight = Bitmap.scaleFromDensity(this.mNinePatch.getHeight(), n2, n);
        if (this.mNinePatchState.mPadding != null && this.mPadding != null) {
            Rect rect = this.mPadding;
            Rect rect2 = this.mNinePatchState.mPadding;
            if (rect == rect2) {
                this.mPadding = rect = new Rect(rect2);
            }
            rect.left = Bitmap.scaleFromDensity(rect2.left, n2, n);
            rect.top = Bitmap.scaleFromDensity(rect2.top, n2, n);
            rect.right = Bitmap.scaleFromDensity(rect2.right, n2, n);
            rect.bottom = Bitmap.scaleFromDensity(rect2.bottom, n2, n);
        }
        this.mOpticalInsets = NinePatchDrawable.scaleFromDensity(this.mNinePatchState.mOpticalInsets, n2, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeWithState(NinePatchState ninePatchState, Resources resources) {
        this.mTargetDensity = resources != null ? resources.getDisplayMetrics().densityDpi : ninePatchState.mTargetDensity;
        if (ninePatchState.mDither) {
            this.setDither(ninePatchState.mDither);
        }
        if (ninePatchState.mPadding != null) {
            this.mPadding = new Rect(ninePatchState.mPadding);
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, ninePatchState.mTint, ninePatchState.mTintMode);
        this.setNinePatch(ninePatchState.mNinePatch);
    }

    private boolean needsMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private static Insets scaleFromDensity(Insets insets, int n, int n2) {
        return Insets.of(Bitmap.scaleFromDensity(insets.left, n, n2), Bitmap.scaleFromDensity(insets.top, n, n2), Bitmap.scaleFromDensity(insets.right, n, n2), Bitmap.scaleFromDensity(insets.bottom, n, n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setNinePatch(NinePatch ninePatch) {
        if (this.mNinePatch != ninePatch) {
            this.mNinePatch = ninePatch;
            if (ninePatch != null) {
                this.computeBitmapSize();
            } else {
                this.mBitmapHeight = -1;
                this.mBitmapWidth = -1;
                this.mOpticalInsets = Insets.NONE;
            }
            this.invalidateSelf();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        ColorStateList colorStateList;
        Resources resources = typedArray.getResources();
        NinePatchState ninePatchState = this.mNinePatchState;
        ninePatchState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        ninePatchState.mThemeAttrs = typedArray.extractThemeAttrs();
        ninePatchState.mDither = typedArray.getBoolean(1, ninePatchState.mDither);
        int n = typedArray.getResourceId(0, 0);
        if (n != 0) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            boolean bl = !ninePatchState.mDither;
            options.inDither = bl;
            options.inScreenDensity = resources.getDisplayMetrics().noncompatDensityDpi;
            Rect rect = new Rect();
            Rect rect2 = new Rect();
            Bitmap bitmap = null;
            try {
                TypedValue typedValue = new TypedValue();
                InputStream inputStream = resources.openRawResource(n, typedValue);
                bitmap = BitmapFactory.decodeResourceStream(resources, typedValue, inputStream, rect, options);
                inputStream.close();
            }
            catch (IOException iOException) {}
            if (bitmap == null) {
                throw new XmlPullParserException(typedArray.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
            }
            if (bitmap.getNinePatchChunk() == null) {
                throw new XmlPullParserException(typedArray.getPositionDescription() + ": <nine-patch> requires a valid 9-patch source image");
            }
            bitmap.getOpticalInsets(rect2);
            ninePatchState.mNinePatch = new NinePatch(bitmap, bitmap.getNinePatchChunk());
            ninePatchState.mPadding = rect;
            ninePatchState.mOpticalInsets = Insets.of(rect2);
        }
        ninePatchState.mAutoMirrored = typedArray.getBoolean(4, ninePatchState.mAutoMirrored);
        ninePatchState.mBaseAlpha = typedArray.getFloat(3, ninePatchState.mBaseAlpha);
        int n2 = typedArray.getInt(5, -1);
        if (n2 != -1) {
            ninePatchState.mTintMode = Drawable.parseTintMode(n2, PorterDuff.Mode.SRC_IN);
        }
        if ((colorStateList = typedArray.getColorStateList(2)) != null) {
            ninePatchState.mTint = colorStateList;
        }
        this.initializeWithState(ninePatchState, resources);
        ninePatchState.mTargetDensity = this.mTargetDensity;
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        NinePatchState ninePatchState = this.mNinePatchState;
        if (ninePatchState == null || ninePatchState.mThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(ninePatchState.mThemeAttrs, R.styleable.NinePatchDrawable);
        try {
            this.updateStateFromTypedArray(typedArray);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mNinePatchState != null && this.mNinePatchState.mThemeAttrs != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        int n;
        boolean bl;
        Rect rect = this.getBounds();
        if (this.mTintFilter != null && this.getPaint().getColorFilter() == null) {
            this.mPaint.setColorFilter(this.mTintFilter);
            bl = true;
        } else {
            bl = false;
        }
        if (this.needsMirroring()) {
            canvas.translate(rect.right - rect.left, 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        if (this.mNinePatchState.mBaseAlpha != 1.0f) {
            n = this.mPaint.getAlpha();
            this.mPaint.setAlpha((int)(0.5f + (float)n * this.mNinePatchState.mBaseAlpha));
        } else {
            n = -1;
        }
        this.mNinePatch.draw(canvas, rect, this.mPaint);
        if (bl) {
            this.mPaint.setColorFilter(null);
        }
        if (n >= 0) {
            this.mPaint.setAlpha(n);
        }
    }

    @Override
    public int getAlpha() {
        if (this.mPaint == null) {
            return 255;
        }
        return this.getPaint().getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mNinePatchState.mChangingConfigurations;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mNinePatchState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mNinePatchState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    @Override
    public int getMinimumHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getMinimumWidth() {
        return this.mBitmapWidth;
    }

    @Override
    public int getOpacity() {
        if (this.mNinePatch.hasAlpha() || this.mPaint != null && this.mPaint.getAlpha() < 255) {
            return -3;
        }
        return -1;
    }

    @Override
    public Insets getOpticalInsets() {
        if (this.needsMirroring()) {
            return Insets.of(this.mOpticalInsets.right, this.mOpticalInsets.top, this.mOpticalInsets.left, this.mOpticalInsets.bottom);
        }
        return this.mOpticalInsets;
    }

    @Override
    public void getOutline(Outline outline) {
        NinePatch.InsetStruct insetStruct;
        Rect rect = this.getBounds();
        if (rect.isEmpty()) {
            return;
        }
        if (this.mNinePatchState != null && (insetStruct = this.mNinePatchState.getBitmap().getNinePatchInsets()) != null) {
            Rect rect2 = insetStruct.outlineRect;
            outline.setRoundRect(rect.left + rect2.left, rect.top + rect2.top, rect.right - rect2.right, rect.bottom - rect2.bottom, insetStruct.outlineRadius);
            outline.setAlpha(insetStruct.outlineAlpha * ((float)this.getAlpha() / 255.0f));
            return;
        }
        super.getOutline(outline);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getPadding(Rect rect) {
        Rect rect2 = this.mPadding;
        boolean bl = false;
        if (rect2 == null) return bl;
        if (this.needsMirroring()) {
            rect.set(rect2.right, rect2.top, rect2.left, rect2.bottom);
        } else {
            rect.set(rect2);
        }
        int n = rect.left | rect.top | rect.right | rect.bottom;
        bl = false;
        if (n == 0) return bl;
        return true;
    }

    public Paint getPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setDither(false);
        }
        return this.mPaint;
    }

    @Override
    public Region getTransparentRegion() {
        return this.mNinePatch.getTransparentRegion(this.getBounds());
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = NinePatchDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.NinePatchDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mNinePatchState.mAutoMirrored;
    }

    @Override
    public boolean isStateful() {
        NinePatchState ninePatchState = this.mNinePatchState;
        return super.isStateful() || ninePatchState.mTint != null && ninePatchState.mTint.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mNinePatchState = new NinePatchState(this.mNinePatchState);
            this.mNinePatch = this.mNinePatchState.mNinePatch;
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        NinePatchState ninePatchState = this.mNinePatchState;
        if (ninePatchState.mTint != null && ninePatchState.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, ninePatchState.mTint, ninePatchState.mTintMode);
            return true;
        }
        return false;
    }

    @Override
    public void setAlpha(int n) {
        if (this.mPaint == null && n == 255) {
            return;
        }
        this.getPaint().setAlpha(n);
        this.invalidateSelf();
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        this.mNinePatchState.mAutoMirrored = bl;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mPaint == null && colorFilter == null) {
            return;
        }
        this.getPaint().setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    public void setDither(boolean bl) {
        if (this.mPaint == null && !bl) {
            return;
        }
        this.getPaint().setDither(bl);
        this.invalidateSelf();
    }

    @Override
    public void setFilterBitmap(boolean bl) {
        this.getPaint().setFilterBitmap(bl);
        this.invalidateSelf();
    }

    public void setTargetDensity(int n) {
        if (n != this.mTargetDensity) {
            if (n == 0) {
                n = 160;
            }
            this.mTargetDensity = n;
            if (this.mNinePatch != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        this.setTargetDensity(displayMetrics.densityDpi);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mNinePatchState.mTint = colorStateList;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorStateList, this.mNinePatchState.mTintMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mNinePatchState.mTintMode = mode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mNinePatchState.mTint, mode);
        this.invalidateSelf();
    }

    static final class NinePatchState
    extends Drawable.ConstantState {
        boolean mAutoMirrored = false;
        float mBaseAlpha = 1.0f;
        int mChangingConfigurations;
        boolean mDither = false;
        NinePatch mNinePatch = null;
        Insets mOpticalInsets;
        Rect mPadding = null;
        int mTargetDensity = 160;
        int[] mThemeAttrs = null;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;

        NinePatchState() {
            this.mOpticalInsets = Insets.NONE;
        }

        NinePatchState(NinePatch ninePatch, Rect rect) {
            this(ninePatch, rect, null, false, false);
        }

        NinePatchState(NinePatch ninePatch, Rect rect, Rect rect2) {
            this(ninePatch, rect, rect2, false, false);
        }

        NinePatchState(NinePatch ninePatch, Rect rect, Rect rect2, boolean bl, boolean bl2) {
            this.mOpticalInsets = Insets.NONE;
            this.mNinePatch = ninePatch;
            this.mPadding = rect;
            this.mOpticalInsets = Insets.of(rect2);
            this.mDither = bl;
            this.mAutoMirrored = bl2;
        }

        NinePatchState(NinePatchState ninePatchState) {
            this.mOpticalInsets = Insets.NONE;
            this.mNinePatch = ninePatchState.mNinePatch;
            this.mTint = ninePatchState.mTint;
            this.mTintMode = ninePatchState.mTintMode;
            this.mThemeAttrs = ninePatchState.mThemeAttrs;
            this.mPadding = ninePatchState.mPadding;
            this.mOpticalInsets = ninePatchState.mOpticalInsets;
            this.mBaseAlpha = ninePatchState.mBaseAlpha;
            this.mDither = ninePatchState.mDither;
            this.mChangingConfigurations = ninePatchState.mChangingConfigurations;
            this.mTargetDensity = ninePatchState.mTargetDensity;
            this.mAutoMirrored = ninePatchState.mAutoMirrored;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        @Override
        public Bitmap getBitmap() {
            return this.mNinePatch.getBitmap();
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new NinePatchDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new NinePatchDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new NinePatchDrawable(this, resources, theme);
        }
    }
}

