/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.util.AttributeSet;
import com.android.internal.R;
import org.xmlpull.v1.XmlPullParser;

public class PaintDrawable
extends ShapeDrawable {
    public PaintDrawable() {
    }

    public PaintDrawable(int n) {
        this.getPaint().setColor(n);
    }

    @Override
    protected boolean inflateTag(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) {
        if (string2.equals("corners")) {
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.DrawableCorners);
            int n = typedArray.getDimensionPixelSize(0, 0);
            this.setCornerRadius(n);
            int n2 = typedArray.getDimensionPixelSize(1, n);
            int n3 = typedArray.getDimensionPixelSize(2, n);
            int n4 = typedArray.getDimensionPixelSize(3, n);
            int n5 = typedArray.getDimensionPixelSize(4, n);
            if (n2 != n || n3 != n || n4 != n || n5 != n) {
                float[] fArray = new float[]{n2, n2, n3, n3, n4, n4, n5, n5};
                this.setCornerRadii(fArray);
            }
            typedArray.recycle();
            return true;
        }
        return super.inflateTag(string2, resources, xmlPullParser, attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCornerRadii(float[] fArray) {
        if (fArray == null) {
            if (this.getShape() != null) {
                this.setShape(null);
            }
        } else {
            this.setShape(new RoundRectShape(fArray, null, null));
        }
        this.invalidateSelf();
    }

    public void setCornerRadius(float f) {
        float f2 = f - 0.0f;
        float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
        float[] fArray = null;
        if (f3 > 0) {
            fArray = new float[8];
            for (int i = 0; i < 8; ++i) {
                fArray[i] = f;
            }
        }
        this.setCornerRadii(fArray);
    }
}

