/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.Ripple;
import android.graphics.drawable.RippleBackground;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawable
extends LayerDrawable {
    private static final PorterDuffXfermode DST_IN = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private static final int MAX_RIPPLES = 10;
    public static final int RADIUS_AUTO = -1;
    private static final PorterDuffXfermode SRC_ATOP = new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP);
    private static final PorterDuffXfermode SRC_OVER = new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER);
    private RippleBackground mBackground;
    private boolean mBackgroundActive;
    private float mDensity = 1.0f;
    private final Rect mDirtyBounds;
    private final Rect mDrawingBounds;
    private Ripple[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private boolean mHasPending;
    private final Rect mHotspotBounds;
    private Drawable mMask;
    private Paint mMaskingPaint;
    private boolean mNeedsDraw;
    private boolean mOverrideBounds;
    private float mPendingX;
    private float mPendingY;
    private Ripple mRipple;
    private boolean mRippleActive;
    private Paint mRipplePaint;
    private RippleState mState;
    private final Rect mTempRect = new Rect();

    RippleDrawable() {
        this(new RippleState(null, null, null), null, null);
    }

    public RippleDrawable(ColorStateList colorStateList, Drawable drawable2, Drawable drawable3) {
        this(new RippleState(null, null, null), null, null);
        if (colorStateList == null) {
            throw new IllegalArgumentException("RippleDrawable requires a non-null color");
        }
        if (drawable2 != null) {
            this.addLayer(drawable2, null, 0, 0, 0, 0, 0);
        }
        if (drawable3 != null) {
            this.addLayer(drawable3, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(colorStateList);
        this.ensurePadding();
        this.initializeFromState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private RippleDrawable(RippleState rippleState, Resources resources, Resources.Theme theme) {
        boolean bl;
        RippleState rippleState2;
        this.mHotspotBounds = new Rect();
        this.mDrawingBounds = new Rect();
        this.mDirtyBounds = new Rect();
        if (theme != null && rippleState != null && rippleState.canApplyTheme()) {
            rippleState2 = new RippleState((LayerDrawable.LayerState)rippleState, this, resources);
            bl = true;
        } else if (rippleState == null) {
            rippleState2 = new RippleState(null, this, resources);
            bl = false;
        } else {
            rippleState2 = new RippleState((LayerDrawable.LayerState)rippleState, this, resources);
            bl = false;
        }
        if (resources != null) {
            this.mDensity = resources.getDisplayMetrics().density;
        }
        this.mState = rippleState2;
        this.mLayerState = rippleState2;
        if (rippleState2.mNum > 0) {
            this.ensurePadding();
        }
        if (bl) {
            this.applyTheme(theme);
        }
        this.initializeFromState();
    }

    private boolean cancelExitingRipples() {
        boolean bl = false;
        int n = this.mExitingRipplesCount;
        Object[] objectArray = this.mExitingRipples;
        for (int i = 0; i < n; ++i) {
            bl |= objectArray[i].isHardwareAnimating();
            ((Ripple)objectArray[i]).cancel();
        }
        if (objectArray != null) {
            Arrays.fill(objectArray, 0, n, null);
        }
        this.mExitingRipplesCount = 0;
        return bl;
    }

    private void clearHotspots() {
        Ripple ripple = this.mRipple;
        boolean bl = false;
        if (ripple != null) {
            bl = false | this.mRipple.isHardwareAnimating();
            this.mRipple.cancel();
            this.mRipple = null;
        }
        if (this.mBackground != null) {
            bl |= this.mBackground.isHardwareAnimating();
            this.mBackground.cancel();
            this.mBackground = null;
        }
        this.mNeedsDraw = bl | this.cancelExitingRipples();
        this.invalidateSelf();
    }

    private int drawBackgroundLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode, boolean bl) {
        int n = -1;
        if (this.mBackground != null && this.mBackground.shouldDraw()) {
            if (bl || porterDuffXfermode != SRC_OVER) {
                n = canvas.saveLayer(rect.left, rect.top, rect.right, rect.bottom, this.getMaskingPaint(porterDuffXfermode));
            }
            float f = this.mHotspotBounds.exactCenterX();
            float f2 = this.mHotspotBounds.exactCenterY();
            canvas.translate(f, f2);
            this.mBackground.draw(canvas, this.getRipplePaint());
            canvas.translate(-f, -f2);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int drawContentLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode) {
        boolean bl;
        int n;
        LayerDrawable.ChildDrawable[] childDrawableArray;
        int n2;
        block11: {
            block10: {
                n2 = -1;
                childDrawableArray = this.mLayerState.mChildren;
                n = this.mLayerState.mNum;
                if (this.mExitingRipplesCount > 0) break block10;
                RippleBackground rippleBackground = this.mBackground;
                bl = false;
                if (rippleBackground == null) break block11;
            }
            Drawable drawable2 = this.mMask;
            bl = false;
            if (drawable2 == null) {
                int n3 = 0;
                while (true) {
                    bl = false;
                    if (n3 >= n) break;
                    if (childDrawableArray[n3].mId != 16908334 && childDrawableArray[n3].mDrawable.getOpacity() != n2) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
        }
        Paint paint = this.getMaskingPaint(porterDuffXfermode);
        if (bl) {
            n2 = canvas.saveLayer(rect.left, rect.top, rect.right, rect.bottom, paint);
        }
        int n4 = 0;
        while (n4 < n) {
            if (childDrawableArray[n4].mId != 16908334) {
                childDrawableArray[n4].mDrawable.draw(canvas);
            }
            ++n4;
        }
        return n2;
    }

    private int drawMaskingLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode) {
        int n = canvas.saveLayer(rect.left, rect.top, rect.right, rect.bottom, this.getMaskingPaint(porterDuffXfermode));
        canvas.drawColor(0);
        this.mMask.draw(canvas);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int drawRippleLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        int n3 = this.mExitingRipplesCount;
        Ripple[] rippleArray = this.mExitingRipples;
        for (int i = 0; i <= n3; ++i) {
            Ripple ripple;
            if (i < n3) {
                ripple = rippleArray[i];
            } else {
                if (this.mRipple == null) continue;
                ripple = this.mRipple;
            }
            if (n < 0) {
                Paint paint = this.getMaskingPaint(porterDuffXfermode);
                paint.setAlpha(Color.alpha(this.mState.mColor.getColorForState(this.getState(), 0)) / 2);
                n = canvas.saveLayer(rect.left, rect.top, rect.right, rect.bottom, paint);
                n2 = canvas.save();
                canvas.translate(this.mHotspotBounds.exactCenterX(), this.mHotspotBounds.exactCenterY());
            }
            bl |= ripple.draw(canvas, this.getRipplePaint());
        }
        if (n2 >= 0) {
            canvas.restoreToCount(n2);
        }
        if (n < 0) return n;
        if (bl) return n;
        canvas.restoreToCount(n);
        return -1;
    }

    private Paint getMaskingPaint(PorterDuffXfermode porterDuffXfermode) {
        if (this.mMaskingPaint == null) {
            this.mMaskingPaint = new Paint();
        }
        this.mMaskingPaint.setXfermode(porterDuffXfermode);
        this.mMaskingPaint.setAlpha(255);
        return this.mMaskingPaint;
    }

    private int getRippleIndex(Ripple ripple) {
        Ripple[] rippleArray = this.mExitingRipples;
        int n = this.mExitingRipplesCount;
        for (int i = 0; i < n; ++i) {
            if (rippleArray[i] != ripple) continue;
            return i;
        }
        return -1;
    }

    private Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
        }
        return this.mRipplePaint;
    }

    private void initializeFromState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    private void onHotspotBoundsChanged() {
        int n = this.mExitingRipplesCount;
        Ripple[] rippleArray = this.mExitingRipples;
        for (int i = 0; i < n; ++i) {
            rippleArray[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    private void setBackgroundActive(boolean bl) {
        block3: {
            block2: {
                if (this.mBackgroundActive == bl) break block2;
                this.mBackgroundActive = bl;
                if (!bl) break block3;
                this.tryBackgroundEnter();
            }
            return;
        }
        this.tryBackgroundExit();
    }

    private void setRippleActive(boolean bl) {
        block3: {
            block2: {
                if (this.mRippleActive == bl) break block2;
                this.mRippleActive = bl;
                if (!bl) break block3;
                this.tryRippleEnter();
            }
            return;
        }
        this.tryRippleExit();
    }

    private void setTargetDensity(DisplayMetrics displayMetrics) {
        if (this.mDensity != displayMetrics.density) {
            this.mDensity = displayMetrics.density;
            this.invalidateSelf();
        }
    }

    private void tryBackgroundEnter() {
        if (this.mBackground == null) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds);
        }
        int n = this.mState.mColor.getColorForState(this.getState(), 0);
        this.mBackground.setup(this.mState.mMaxRadius, n, this.mDensity);
        this.mBackground.enter();
    }

    private void tryBackgroundExit() {
        if (this.mBackground != null) {
            this.mBackground.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float f;
            float f2;
            if (this.mHasPending) {
                this.mHasPending = false;
                f2 = this.mPendingX;
                f = this.mPendingY;
            } else {
                f2 = this.mHotspotBounds.exactCenterX();
                f = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new Ripple(this, this.mHotspotBounds, f2, f);
        }
        int n = this.mState.mColor.getColorForState(this.getState(), 0);
        this.mRipple.setup(this.mState.mMaxRadius, n, this.mDensity);
        this.mRipple.enter();
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new Ripple[10];
            }
            Ripple[] rippleArray = this.mExitingRipples;
            int n = this.mExitingRipplesCount;
            this.mExitingRipplesCount = n + 1;
            rippleArray[n] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        RippleState rippleState = this.mState;
        rippleState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        rippleState.mTouchThemeAttrs = typedArray.extractThemeAttrs();
        ColorStateList colorStateList = typedArray.getColorStateList(0);
        if (colorStateList != null) {
            this.mState.mColor = colorStateList;
        }
        this.verifyRequiredAttributes(typedArray);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        RippleState rippleState = this.mState;
        if (rippleState == null || rippleState.mTouchThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(rippleState.mTouchThemeAttrs, R.styleable.RippleDrawable);
        try {
            this.updateStateFromTypedArray(typedArray);
            this.initializeFromState();
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mState != null && this.mState.mTouchThemeAttrs != null;
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState layerState, Resources resources) {
        return new RippleState(layerState, this, resources);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        int n;
        boolean bl = this.mMask != null;
        int n2 = this.mLayerState.mNum;
        int n3 = bl ? 1 : 0;
        boolean bl2 = n2 > n3;
        boolean bl3 = bl && this.mMask.getOpacity() != -1;
        Rect rect = this.getDirtyBounds();
        int n4 = canvas.save(2);
        canvas.clipRect(rect);
        int n5 = bl2 ? this.drawContentLayer(canvas, rect, SRC_OVER) : -1;
        PorterDuffXfermode porterDuffXfermode = bl || !bl2 ? SRC_OVER : SRC_ATOP;
        int n6 = this.drawBackgroundLayer(canvas, rect, porterDuffXfermode, bl3);
        if (n6 >= 0) {
            if (bl3) {
                this.drawMaskingLayer(canvas, rect, DST_IN);
            }
            canvas.restoreToCount(n6);
        }
        if ((n = this.drawRippleLayer(canvas, rect, porterDuffXfermode)) >= 0) {
            if (bl3) {
                this.drawMaskingLayer(canvas, rect, DST_IN);
            }
            canvas.restoreToCount(n);
        }
        if (n5 < 0 && n6 < 0 && n < 0 && this.mNeedsDraw) {
            canvas.drawColor(0);
            this.invalidateSelf();
        }
        this.mNeedsDraw = false;
        canvas.restoreToCount(n4);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    public Rect getDirtyBounds() {
        if (this.isProjected()) {
            Rect rect = this.mDrawingBounds;
            Rect rect2 = this.mDirtyBounds;
            rect2.set(rect);
            rect.setEmpty();
            int n = (int)this.mHotspotBounds.exactCenterX();
            int n2 = (int)this.mHotspotBounds.exactCenterY();
            Rect rect3 = this.mTempRect;
            Ripple[] rippleArray = this.mExitingRipples;
            int n3 = this.mExitingRipplesCount;
            for (int i = 0; i < n3; ++i) {
                rippleArray[i].getBounds(rect3);
                rect3.offset(n, n2);
                rect.union(rect3);
            }
            RippleBackground rippleBackground = this.mBackground;
            if (rippleBackground != null) {
                rippleBackground.getBounds(rect3);
                rect3.offset(n, n2);
                rect.union(rect3);
            }
            rect2.union(rect);
            rect2.union(super.getDirtyBounds());
            return rect2;
        }
        return this.getBounds();
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        rect.set(this.mHotspotBounds);
    }

    public int getMaxRadius() {
        return this.mState.mMaxRadius;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public void getOutline(Outline outline) {
        LayerDrawable.LayerState layerState = this.mLayerState;
        LayerDrawable.ChildDrawable[] childDrawableArray = layerState.mChildren;
        int n = layerState.mNum;
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= n) break block3;
                    if (childDrawableArray[n2].mId == 16908334) break block4;
                    childDrawableArray[n2].mDrawable.getOutline(outline);
                    if (outline.isEmpty()) break block4;
                }
                return;
            }
            ++n2;
        }
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray typedArray = RippleDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.RippleDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        this.setPaddingMode(1);
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        this.setTargetDensity(resources.getDisplayMetrics());
        this.initializeFromState();
    }

    @Override
    public boolean isProjected() {
        return this.getNumberOfLayers() == 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        Ripple ripple = this.mRipple;
        boolean bl = false;
        if (ripple != null) {
            bl = false | this.mRipple.isHardwareAnimating();
            this.mRipple.jump();
        }
        if (this.mBackground != null) {
            bl |= this.mBackground.isHardwareAnimating();
            this.mBackground.jump();
        }
        this.mNeedsDraw = bl | this.cancelExitingRipples();
        this.invalidateSelf();
    }

    @Override
    public Drawable mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(rect);
            this.onHotspotBoundsChanged();
        }
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl;
        boolean bl2;
        block7: {
            block6: {
                bl2 = super.onStateChange(nArray);
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                for (int n : nArray) {
                    if (n == 16842910) {
                        bl3 = true;
                    }
                    if (n == 16842908) {
                        bl5 = true;
                    }
                    if (n != 16842919) continue;
                    bl4 = true;
                }
                boolean bl6 = bl3 && bl4;
                this.setRippleActive(bl6);
                if (bl5) break block6;
                bl = false;
                if (!bl3) break block7;
                bl = false;
                if (!bl4) break block7;
            }
            bl = true;
        }
        this.setBackgroundActive(bl);
        return bl2;
    }

    void removeRipple(Ripple ripple) {
        Ripple[] rippleArray = this.mExitingRipples;
        int n = this.mExitingRipplesCount;
        int n2 = this.getRippleIndex(ripple);
        if (n2 >= 0) {
            System.arraycopy(rippleArray, n2 + 1, rippleArray, n2, n - (n2 + 1));
            rippleArray[n - 1] = null;
            this.mExitingRipplesCount = -1 + this.mExitingRipplesCount;
            this.invalidateSelf();
        }
    }

    @Override
    public void setAlpha(int n) {
        super.setAlpha(n);
    }

    public void setColor(ColorStateList colorStateList) {
        this.mState.mColor = colorStateList;
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        super.setColorFilter(colorFilter);
    }

    @Override
    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        if (super.setDrawableByLayerId(n, drawable2)) {
            if (n == 16908334) {
                this.mMask = drawable2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setHotspot(float f, float f2) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = f;
            this.mPendingY = f2;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(f, f2);
        }
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(n, n2, n3, n4);
        this.onHotspotBoundsChanged();
    }

    public void setMaxRadius(int n) {
        if (n != -1 && n < 0) {
            throw new IllegalArgumentException("maxRadius must be RADIUS_AUTO or >= 0");
        }
        this.mState.mMaxRadius = n;
    }

    @Override
    public void setPaddingMode(int n) {
        super.setPaddingMode(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        if (!bl) {
            this.clearHotspots();
            return bl3;
        } else {
            if (!bl3) return bl3;
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            if (!this.mBackgroundActive) return bl3;
            this.tryBackgroundEnter();
            return bl3;
        }
    }

    static class RippleState
    extends LayerDrawable.LayerState {
        ColorStateList mColor = ColorStateList.valueOf(-65281);
        int mMaxRadius = -1;
        int[] mTouchThemeAttrs;

        public RippleState(LayerDrawable.LayerState layerState, RippleDrawable rippleDrawable, Resources resources) {
            super(layerState, rippleDrawable, resources);
            if (layerState != null && layerState instanceof RippleState) {
                RippleState rippleState = (RippleState)layerState;
                this.mTouchThemeAttrs = rippleState.mTouchThemeAttrs;
                this.mColor = rippleState.mColor;
                this.mMaxRadius = rippleState.mMaxRadius;
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mTouchThemeAttrs != null || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new RippleDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new RippleDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new RippleDrawable(this, resources, theme);
        }
    }
}

