/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScaleDrawable
extends Drawable
implements Drawable.Callback {
    private boolean mMutated;
    private ScaleState mScaleState;
    private final Rect mTmpRect = new Rect();

    ScaleDrawable() {
        this(null, null);
    }

    public ScaleDrawable(Drawable drawable2, int n, float f, float f2) {
        this(null, null);
        this.mScaleState.mDrawable = drawable2;
        this.mScaleState.mGravity = n;
        this.mScaleState.mScaleWidth = f;
        this.mScaleState.mScaleHeight = f2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    private ScaleDrawable(ScaleState scaleState, Resources resources) {
        this.mScaleState = new ScaleState(scaleState, this, resources);
    }

    private static float getPercent(TypedArray typedArray, int n) {
        String string2 = typedArray.getString(n);
        if (string2 != null && string2.endsWith("%")) {
            return Float.parseFloat(string2.substring(0, -1 + string2.length())) / 100.0f;
        }
        return -1.0f;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mScaleState.mDrawable.getLevel() != 0) {
            this.mScaleState.mDrawable.draw(canvas);
        }
    }

    @Override
    public int getAlpha() {
        return this.mScaleState.mDrawable.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mScaleState.mChangingConfigurations | this.mScaleState.mDrawable.getChangingConfigurations();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mScaleState.canConstantState()) {
            this.mScaleState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mScaleState;
        }
        return null;
    }

    public Drawable getDrawable() {
        return this.mScaleState.mDrawable;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mScaleState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mScaleState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mScaleState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mScaleState.mDrawable.getPadding(rect);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = ScaleDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.ScaleDrawable);
        float f = ScaleDrawable.getPercent(typedArray, 1);
        float f2 = ScaleDrawable.getPercent(typedArray, 2);
        int n2 = typedArray.getInt(3, 3);
        boolean bl = typedArray.getBoolean(4, false);
        Drawable drawable2 = typedArray.getDrawable(0);
        typedArray.recycle();
        int n3 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n3)) {
            if (n != 2) continue;
            drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
        }
        if (drawable2 == null) {
            throw new IllegalArgumentException("No drawable specified for <scale>");
        }
        this.mScaleState.mDrawable = drawable2;
        this.mScaleState.mScaleWidth = f;
        this.mScaleState.mScaleHeight = f2;
        this.mScaleState.mGravity = n2;
        this.mScaleState.mUseIntrinsicSizeAsMin = bl;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    @Override
    public boolean isStateful() {
        return this.mScaleState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mScaleState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onBoundsChange(Rect rect) {
        Rect rect2 = this.mTmpRect;
        boolean bl = this.mScaleState.mUseIntrinsicSizeAsMin;
        int n = this.getLevel();
        int n2 = rect.width();
        if (this.mScaleState.mScaleWidth > 0.0f) {
            int n3 = bl ? this.mScaleState.mDrawable.getIntrinsicWidth() : 0;
            n2 -= (int)((float)((n2 - n3) * (10000 - n)) * this.mScaleState.mScaleWidth / 10000.0f);
        }
        int n4 = rect.height();
        if (this.mScaleState.mScaleHeight > 0.0f) {
            int n5 = bl ? this.mScaleState.mDrawable.getIntrinsicHeight() : 0;
            n4 -= (int)((float)((n4 - n5) * (10000 - n)) * this.mScaleState.mScaleHeight / 10000.0f);
        }
        int n6 = this.getLayoutDirection();
        Gravity.apply(this.mScaleState.mGravity, n2, n4, rect, rect2, n6);
        if (n2 > 0 && n4 > 0) {
            this.mScaleState.mDrawable.setBounds(rect2.left, rect2.top, rect2.right, rect2.bottom);
        }
    }

    @Override
    protected boolean onLevelChange(int n) {
        this.mScaleState.mDrawable.setLevel(n);
        this.onBoundsChange(this.getBounds());
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = this.mScaleState.mDrawable.setState(nArray);
        this.onBoundsChange(this.getBounds());
        return bl;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, runnable, l);
        }
    }

    @Override
    public void setAlpha(int n) {
        this.mScaleState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mScaleState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mScaleState.mDrawable.setTintList(colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mScaleState.mDrawable.setTintMode(mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        this.mScaleState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, runnable);
        }
    }

    static final class ScaleState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        Drawable mDrawable;
        int mGravity;
        float mScaleHeight;
        float mScaleWidth;
        boolean mUseIntrinsicSizeAsMin;

        /*
         * Enabled aggressive block sorting
         */
        ScaleState(ScaleState scaleState, ScaleDrawable scaleDrawable, Resources resources) {
            if (scaleState != null) {
                this.mDrawable = resources != null ? scaleState.mDrawable.getConstantState().newDrawable(resources) : scaleState.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(scaleDrawable);
                this.mDrawable.setLayoutDirection(scaleState.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(scaleState.mDrawable.getBounds());
                this.mDrawable.setLevel(scaleState.mDrawable.getLevel());
                this.mScaleWidth = scaleState.mScaleWidth;
                this.mScaleHeight = scaleState.mScaleHeight;
                this.mGravity = scaleState.mGravity;
                this.mUseIntrinsicSizeAsMin = scaleState.mUseIntrinsicSizeAsMin;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ScaleDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ScaleDrawable(this, resources);
        }
    }
}

