/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import java.util.HashMap;
import java.util.Iterator;

final class LegacySensorManager {
    private static boolean sInitialized;
    private static int sRotation;
    private static IWindowManager sWindowManager;
    private final HashMap<SensorListener, LegacyListener> mLegacyListenersMap = new HashMap();
    private final SensorManager mSensorManager;

    static {
        sRotation = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LegacySensorManager(SensorManager sensorManager) {
        this.mSensorManager = sensorManager;
        synchronized (SensorManager.class) {
            IWindowManager iWindowManager;
            if (!sInitialized && (iWindowManager = (sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window")))) != null) {
                try {
                    sRotation = sWindowManager.watchRotation(new IRotationWatcher.Stub(){

                        @Override
                        public void onRotationChanged(int n) {
                            LegacySensorManager.onRotationChanged(n);
                        }
                    });
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getRotation() {
        synchronized (SensorManager.class) {
            return sRotation;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void onRotationChanged(int n) {
        synchronized (SensorManager.class) {
            sRotation = n;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean registerLegacyListener(int n, int n2, SensorListener sensorListener, int n3, int n4) {
        if ((n3 & n) == 0) return false;
        Sensor sensor = this.mSensorManager.getDefaultSensor(n2);
        if (sensor == null) return false;
        HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
        synchronized (hashMap) {
            LegacyListener legacyListener = this.mLegacyListenersMap.get(sensorListener);
            if (legacyListener == null) {
                legacyListener = new LegacyListener(sensorListener);
                this.mLegacyListenersMap.put(sensorListener, legacyListener);
            }
            if (!legacyListener.registerSensor(n)) return true;
            return this.mSensorManager.registerListener(legacyListener, sensor, n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unregisterLegacyListener(int n, int n2, SensorListener sensorListener, int n3) {
        Sensor sensor;
        if ((n3 & n) != 0 && (sensor = this.mSensorManager.getDefaultSensor(n2)) != null) {
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                LegacyListener legacyListener = this.mLegacyListenersMap.get(sensorListener);
                if (legacyListener != null && legacyListener.unregisterSensor(n)) {
                    this.mSensorManager.unregisterListener(legacyListener, sensor);
                    if (!legacyListener.hasSensors()) {
                        this.mLegacyListenersMap.remove(sensorListener);
                    }
                }
                return;
            }
        }
    }

    public int getSensors() {
        int n = 0;
        Iterator<Sensor> iterator = this.mSensorManager.getFullSensorList().iterator();
        block5: while (iterator.hasNext()) {
            switch (iterator.next().getType()) {
                default: {
                    continue block5;
                }
                case 1: {
                    n |= 2;
                    continue block5;
                }
                case 2: {
                    n |= 8;
                    continue block5;
                }
                case 3: 
            }
            n |= 0x81;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean registerListener(SensorListener sensorListener, int n, int n2) {
        if (sensorListener == null) {
            return false;
        }
        boolean bl = this.registerLegacyListener(2, 1, sensorListener, n, n2);
        boolean bl2 = this.registerLegacyListener(8, 2, sensorListener, n, n2) || bl;
        boolean bl3 = this.registerLegacyListener(128, 3, sensorListener, n, n2) || bl2;
        boolean bl4 = this.registerLegacyListener(1, 3, sensorListener, n, n2) || bl3;
        if (this.registerLegacyListener(4, 7, sensorListener, n, n2)) return true;
        if (bl4) return true;
        return false;
    }

    public void unregisterListener(SensorListener sensorListener, int n) {
        if (sensorListener == null) {
            return;
        }
        this.unregisterLegacyListener(2, 1, sensorListener, n);
        this.unregisterLegacyListener(8, 2, sensorListener, n);
        this.unregisterLegacyListener(128, 3, sensorListener, n);
        this.unregisterLegacyListener(1, 3, sensorListener, n);
        this.unregisterLegacyListener(4, 7, sensorListener, n);
    }

    private static final class LegacyListener
    implements SensorEventListener {
        private int mSensors;
        private SensorListener mTarget;
        private float[] mValues = new float[6];
        private final LmsFilter mYawfilter = new LmsFilter();

        LegacyListener(SensorListener sensorListener) {
            this.mTarget = sensorListener;
            this.mSensors = 0;
        }

        private static int getLegacySensorType(int n) {
            switch (n) {
                default: {
                    return 0;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 8;
                }
                case 3: {
                    return 128;
                }
                case 7: 
            }
            return 4;
        }

        private static boolean hasOrientationSensor(int n) {
            return (n & 0x81) != 0;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        private void mapSensorDataToWindow(int var1_1, float[] var2_2, int var3_3) {
            block14: {
                var4_4 = var2_2[0];
                var5_5 = var2_2[1];
                var6_6 = var2_2[2];
                switch (var1_1) {
                    case 1: 
                    case 128: {
                        var6_6 = -var6_6;
                        ** break;
                    }
                    case 2: {
                        var4_4 = -var4_4;
                        var5_5 = -var5_5;
                        var6_6 = -var6_6;
                    }
lbl12:
                    // 3 sources

                    default: {
                        break block14;
                    }
                    case 8: 
                }
                var4_4 = -var4_4;
                var5_5 = -var5_5;
            }
            var2_2[0] = var4_4;
            var2_2[1] = var5_5;
            var2_2[2] = var6_6;
            var2_2[3] = var4_4;
            var2_2[4] = var5_5;
            var2_2[5] = var6_6;
            if ((var3_3 & 1) != 0) {
                switch (var1_1) {
                    case 2: 
                    case 8: {
                        var2_2[0] = -var5_5;
                        var2_2[1] = var4_4;
                        var2_2[2] = var6_6;
                    }
                    default: {
                        break;
                    }
                    case 1: 
                    case 128: {
                        var11_10 = var4_4 < 270.0f ? 90 : -270;
                        var2_2[0] = var4_4 + (float)var11_10;
                        var2_2[1] = var6_6;
                        var2_2[2] = var5_5;
                    }
                }
            }
            if ((var3_3 & 2) == 0) ** GOTO lbl-1000
            var7_7 = var2_2[0];
            var8_8 = var2_2[1];
            var9_9 = var2_2[2];
            switch (var1_1) {
                default: lbl-1000:
                // 2 sources

                {
                    return;
                }
                case 2: 
                case 8: {
                    var2_2[0] = -var7_7;
                    var2_2[1] = -var8_8;
                    var2_2[2] = var9_9;
                    return;
                }
                case 1: 
                case 128: 
            }
            var10_11 = var7_7 >= 180.0f ? var7_7 - 180.0f : var7_7 + 180.0f;
            var2_2[0] = var10_11;
            var2_2[1] = -var8_8;
            var2_2[2] = -var9_9;
        }

        boolean hasSensors() {
            return this.mSensors != 0;
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
            try {
                this.mTarget.onAccuracyChanged(LegacyListener.getLegacySensorType(sensor.getType()), n);
                return;
            }
            catch (AbstractMethodError abstractMethodError) {
                return;
            }
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            float[] fArray = this.mValues;
            fArray[0] = sensorEvent.values[0];
            fArray[1] = sensorEvent.values[1];
            fArray[2] = sensorEvent.values[2];
            int n = sensorEvent.sensor.getType();
            int n2 = LegacyListener.getLegacySensorType(n);
            this.mapSensorDataToWindow(n2, fArray, LegacySensorManager.getRotation());
            if (n == 3) {
                if ((0x80 & this.mSensors) != 0) {
                    this.mTarget.onSensorChanged(128, fArray);
                }
                if ((1 & this.mSensors) != 0) {
                    fArray[0] = this.mYawfilter.filter(sensorEvent.timestamp, fArray[0]);
                    this.mTarget.onSensorChanged(1, fArray);
                }
                return;
            }
            this.mTarget.onSensorChanged(n2, fArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean registerSensor(int n) {
            block3: {
                block2: {
                    if ((n & this.mSensors) != 0) break block2;
                    boolean bl = LegacyListener.hasOrientationSensor(this.mSensors);
                    this.mSensors = n | this.mSensors;
                    if (!bl || !LegacyListener.hasOrientationSensor(n)) break block3;
                }
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean unregisterSensor(int n) {
            block3: {
                block2: {
                    if ((n & this.mSensors) == 0) break block2;
                    this.mSensors &= ~n;
                    if (!LegacyListener.hasOrientationSensor(n) || !LegacyListener.hasOrientationSensor(this.mSensors)) break block3;
                }
                return false;
            }
            return true;
        }
    }

    private static final class LmsFilter {
        private static final int COUNT = 12;
        private static final float PREDICTION_RATIO = 0.33333334f;
        private static final float PREDICTION_TIME = 0.08f;
        private static final int SENSORS_RATE_MS = 20;
        private int mIndex = 12;
        private long[] mT;
        private float[] mV = new float[24];

        public LmsFilter() {
            this.mT = new long[24];
        }

        /*
         * Enabled aggressive block sorting
         */
        public float filter(long l, float f) {
            float f2;
            float f3;
            float f4;
            float f5 = f;
            float f6 = this.mV[this.mIndex];
            if (f5 - f6 > 180.0f) {
                f5 -= 360.0f;
            } else if (f6 - f5 > 180.0f) {
                f5 += 360.0f;
            }
            this.mIndex = 1 + this.mIndex;
            if (this.mIndex >= 24) {
                this.mIndex = 12;
            }
            this.mV[this.mIndex] = f5;
            this.mT[this.mIndex] = l;
            this.mV[-12 + this.mIndex] = f5;
            this.mT[-12 + this.mIndex] = l;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            for (int i = 0; i < 11; f11 += f4 * f3, f10 += f2 * (f2 * f3), f9 += f2 * f3, f8 += f4 * (f2 * f3), f7 += f3, ++i) {
                int n = -1 + this.mIndex - i;
                f4 = this.mV[n];
                f2 = 1.0E-9f * (float)(this.mT[n] / 2L + this.mT[n + 1] / 2L - l);
                float f12 = 1.0E-9f * (float)(this.mT[n] - this.mT[n + 1]);
                f3 = f12 * f12;
            }
            float f13 = (f11 * f10 + f9 * f8) / (f7 * f10 + f9 * f9);
            float f14 = 0.0027777778f * (f13 + 0.08f * ((f7 * f13 - f11) / f9));
            float f15 = f14 >= 0.0f ? f14 : -f14;
            if (f15 >= 0.5f) {
                f14 = 1.0f + (f14 - (float)Math.ceil(0.5f + f14));
            }
            if (f14 < 0.0f) {
                f14 += 1.0f;
            }
            return f14 * 360.0f;
        }
    }
}

