/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.LongParcelable;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public interface ICameraDeviceUser
extends IInterface {
    public int beginConfigure() throws RemoteException;

    public int cancelRequest(int var1, LongParcelable var2) throws RemoteException;

    public int createDefaultRequest(int var1, CameraMetadataNative var2) throws RemoteException;

    public int createStream(int var1, int var2, int var3, Surface var4) throws RemoteException;

    public int deleteStream(int var1) throws RemoteException;

    public void disconnect() throws RemoteException;

    public int endConfigure() throws RemoteException;

    public int flush(LongParcelable var1) throws RemoteException;

    public int getCameraInfo(CameraMetadataNative var1) throws RemoteException;

    public int submitRequest(CaptureRequest var1, boolean var2, LongParcelable var3) throws RemoteException;

    public int submitRequestList(List<CaptureRequest> var1, boolean var2, LongParcelable var3) throws RemoteException;

    public int waitUntilIdle() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraDeviceUser {
        private static final String DESCRIPTOR = "android.hardware.camera2.ICameraDeviceUser";
        static final int TRANSACTION_beginConfigure = 5;
        static final int TRANSACTION_cancelRequest = 4;
        static final int TRANSACTION_createDefaultRequest = 9;
        static final int TRANSACTION_createStream = 8;
        static final int TRANSACTION_deleteStream = 7;
        static final int TRANSACTION_disconnect = 1;
        static final int TRANSACTION_endConfigure = 6;
        static final int TRANSACTION_flush = 12;
        static final int TRANSACTION_getCameraInfo = 10;
        static final int TRANSACTION_submitRequest = 2;
        static final int TRANSACTION_submitRequestList = 3;
        static final int TRANSACTION_waitUntilIdle = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraDeviceUser asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ICameraDeviceUser) {
                return (ICameraDeviceUser)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disconnect();
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CaptureRequest captureRequest = parcel.readInt() != 0 ? CaptureRequest.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    LongParcelable longParcelable = new LongParcelable();
                    int n3 = this.submitRequest(captureRequest, bl, longParcelable);
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    if (longParcelable != null) {
                        parcel2.writeInt(1);
                        longParcelable.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ArrayList<CaptureRequest> arrayList = parcel.createTypedArrayList(CaptureRequest.CREATOR);
                    boolean bl = parcel.readInt() != 0;
                    LongParcelable longParcelable = new LongParcelable();
                    int n4 = this.submitRequestList(arrayList, bl, longParcelable);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    if (longParcelable != null) {
                        parcel2.writeInt(1);
                        longParcelable.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    LongParcelable longParcelable = new LongParcelable();
                    int n6 = this.cancelRequest(n5, longParcelable);
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    if (longParcelable != null) {
                        parcel2.writeInt(1);
                        longParcelable.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.beginConfigure();
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.endConfigure();
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.deleteStream(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = parcel.readInt();
                    int n11 = parcel.readInt();
                    int n12 = parcel.readInt();
                    Surface surface = parcel.readInt() != 0 ? Surface.CREATOR.createFromParcel(parcel) : null;
                    int n13 = this.createStream(n10, n11, n12, surface);
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = parcel.readInt();
                    CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
                    int n15 = this.createDefaultRequest(n14, cameraMetadataNative);
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    if (cameraMetadataNative != null) {
                        parcel2.writeInt(1);
                        cameraMetadataNative.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
                    int n16 = this.getCameraInfo(cameraMetadataNative);
                    parcel2.writeNoException();
                    parcel2.writeInt(n16);
                    if (cameraMetadataNative != null) {
                        parcel2.writeInt(1);
                        cameraMetadataNative.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n17 = this.waitUntilIdle();
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 12: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            LongParcelable longParcelable = new LongParcelable();
            int n18 = this.flush(longParcelable);
            parcel2.writeNoException();
            parcel2.writeInt(n18);
            if (longParcelable != null) {
                parcel2.writeInt(1);
                longParcelable.writeToParcel(parcel2, 1);
                return true;
            }
            parcel2.writeInt(0);
            return true;
        }

        private static class Proxy
        implements ICameraDeviceUser {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public int beginConfigure() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int cancelRequest(int n, LongParcelable longParcelable) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        longParcelable.readFromParcel(parcel2);
                    }
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int createDefaultRequest(int n, CameraMetadataNative cameraMetadataNative) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        cameraMetadataNative.readFromParcel(parcel2);
                    }
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int createStream(int n, int n2, int n3, Surface surface) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (surface != null) {
                        parcel.writeInt(1);
                        surface.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    return n4;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int deleteStream(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void disconnect() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int endConfigure() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int flush(LongParcelable longParcelable) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        longParcelable.readFromParcel(parcel2);
                    }
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCameraInfo(CameraMetadataNative cameraMetadataNative) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        cameraMetadataNative.readFromParcel(parcel2);
                    }
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int submitRequest(CaptureRequest captureRequest, boolean bl, LongParcelable longParcelable) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (captureRequest != null) {
                        parcel.writeInt(1);
                        captureRequest.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                if (!bl) {
                    n = 0;
                }
                parcel.writeInt(n);
                this.mRemote.transact(2, parcel, parcel2, 0);
                parcel2.readException();
                int n2 = parcel2.readInt();
                if (parcel2.readInt() != 0) {
                    longParcelable.readFromParcel(parcel2);
                }
                parcel2.recycle();
                parcel.recycle();
                return n2;
            }

            @Override
            public int submitRequestList(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block5: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeTypedList(list);
                    n = 0;
                    if (!bl) break block5;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(3, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        longParcelable.readFromParcel(parcel);
                    }
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int waitUntilIdle() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

