/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.dispatch;

import android.hardware.camera2.dispatch.Dispatchable;
import android.hardware.camera2.utils.UncheckedThrow;
import android.os.Handler;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HandlerDispatcher<T>
implements Dispatchable<T> {
    private static final String TAG = "HandlerDispatcher";
    private final Dispatchable<T> mDispatchTarget;
    private final Handler mHandler;

    public HandlerDispatcher(Dispatchable<T> dispatchable, Handler handler) {
        this.mDispatchTarget = Preconditions.checkNotNull(dispatchable, "dispatchTarget must not be null");
        this.mHandler = Preconditions.checkNotNull(handler, "handler must not be null");
    }

    @Override
    public Object dispatch(final Method method, final Object[] objectArray) throws Throwable {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    HandlerDispatcher.this.mDispatchTarget.dispatch(method, objectArray);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    UncheckedThrow.throwAnyException(invocationTargetException.getTargetException());
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.wtf(HandlerDispatcher.TAG, "IllegalAccessException while invoking " + method, illegalAccessException);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.wtf(HandlerDispatcher.TAG, "IllegalArgumentException while invoking " + method, illegalArgumentException);
                    return;
                }
                catch (Throwable throwable) {
                    UncheckedThrow.throwAnyException(throwable);
                    return;
                }
            }
        });
        return null;
    }
}

