/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.dispatch;

import android.hardware.camera2.dispatch.Dispatchable;
import android.hardware.camera2.utils.UncheckedThrow;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvokeDispatcher<T>
implements Dispatchable<T> {
    private static final String TAG = "InvocationSink";
    private final T mTarget;

    public InvokeDispatcher(T t) {
        this.mTarget = Preconditions.checkNotNull(t, "target must not be null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object dispatch(Method method, Object[] objectArray) {
        try {
            return method.invoke(this.mTarget, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            UncheckedThrow.throwAnyException(invocationTargetException.getTargetException());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.wtf(TAG, "IllegalAccessException while invoking " + method, illegalAccessException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.wtf(TAG, "IllegalArgumentException while invoking " + method, illegalArgumentException);
            return null;
        }
    }
}

