/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.LegacyRequestMapper;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import android.util.Size;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LegacyResultMapper {
    private static final String TAG = "LegacyResultMapper";
    private static final boolean VERBOSE = Log.isLoggable("LegacyResultMapper", 2);
    private LegacyRequest mCachedRequest = null;
    private CameraMetadataNative mCachedResult = null;

    /*
     * Enabled aggressive block sorting
     */
    private static int convertLegacyAfMode(String string2) {
        if (string2 == null) {
            Log.w(TAG, "convertLegacyAfMode - no AF mode, default to OFF");
            return 0;
        }
        int n = -1;
        switch (string2.hashCode()) {
            case 3005871: {
                if (!string2.equals("auto")) break;
                n = 0;
                break;
            }
            case 910005312: {
                if (!string2.equals("continuous-picture")) break;
                n = 1;
                break;
            }
            case -194628547: {
                if (!string2.equals("continuous-video")) break;
                n = 2;
                break;
            }
            case 3108534: {
                if (!string2.equals("edof")) break;
                n = 3;
                break;
            }
            case 103652300: {
                if (!string2.equals("macro")) break;
                n = 4;
                break;
            }
            case 97445748: {
                if (!string2.equals("fixed")) break;
                n = 5;
                break;
            }
            case 173173288: {
                if (!string2.equals("infinity")) break;
                n = 6;
                break;
            }
        }
        switch (n) {
            case 5: 
            case 6: {
                return 0;
            }
            default: {
                Log.w(TAG, "convertLegacyAfMode - unknown mode " + string2 + " , ignoring");
                return 0;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: 
        }
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int convertLegacyAwbMode(String string2) {
        if (string2 == null) {
            return 1;
        }
        int n = -1;
        switch (string2.hashCode()) {
            case 3005871: {
                if (!string2.equals("auto")) break;
                n = 0;
                break;
            }
            case -939299377: {
                if (!string2.equals("incandescent")) break;
                n = 1;
                break;
            }
            case 1902580840: {
                if (!string2.equals("fluorescent")) break;
                n = 2;
                break;
            }
            case -719316704: {
                if (!string2.equals("warm-fluorescent")) break;
                n = 3;
                break;
            }
            case 1942983418: {
                if (!string2.equals("daylight")) break;
                n = 4;
                break;
            }
            case 474934723: {
                if (!string2.equals("cloudy-daylight")) break;
                n = 5;
                break;
            }
            case 1650323088: {
                if (!string2.equals("twilight")) break;
                n = 6;
                break;
            }
            case 109399597: {
                if (!string2.equals("shade")) break;
                n = 7;
                break;
            }
        }
        switch (n) {
            case 0: {
                return 1;
            }
            default: {
                Log.w(TAG, "convertAwbMode - unrecognized WB mode " + string2);
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: 
        }
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CameraMetadataNative convertResultMetadata(LegacyRequest legacyRequest) {
        String string2;
        int n;
        String string3;
        int n2;
        CameraCharacteristics cameraCharacteristics = legacyRequest.characteristics;
        CaptureRequest captureRequest = legacyRequest.captureRequest;
        Size size = legacyRequest.previewSize;
        Camera.Parameters parameters = legacyRequest.parameters;
        CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
        Rect rect = cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        ParameterUtils.ZoomData zoomData = ParameterUtils.convertScalerCropRegion(rect, captureRequest.get(CaptureRequest.SCALER_CROP_REGION), size, parameters);
        cameraMetadataNative.set(CaptureResult.COLOR_CORRECTION_ABERRATION_MODE, Integer.valueOf(1));
        LegacyResultMapper.mapAe(cameraMetadataNative, cameraCharacteristics, captureRequest, rect, zoomData, parameters);
        LegacyResultMapper.mapAf(cameraMetadataNative, rect, zoomData, parameters);
        LegacyResultMapper.mapAwb(cameraMetadataNative, parameters);
        int n3 = LegacyRequestMapper.filterSupportedCaptureIntent(ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_CAPTURE_INTENT, 1));
        cameraMetadataNative.set(CaptureResult.CONTROL_CAPTURE_INTENT, Integer.valueOf(n3));
        if (ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_MODE, 1) == 2) {
            cameraMetadataNative.set(CaptureResult.CONTROL_MODE, Integer.valueOf(2));
        } else {
            cameraMetadataNative.set(CaptureResult.CONTROL_MODE, Integer.valueOf(1));
        }
        if ((n2 = LegacyMetadataMapper.convertSceneModeFromLegacy(string3 = parameters.getSceneMode())) != -1) {
            cameraMetadataNative.set(CaptureResult.CONTROL_SCENE_MODE, Integer.valueOf(n2));
        } else {
            Log.w(TAG, "Unknown scene mode " + string3 + " returned by camera HAL, setting to disabled.");
            cameraMetadataNative.set(CaptureResult.CONTROL_SCENE_MODE, Integer.valueOf(0));
        }
        if ((n = LegacyMetadataMapper.convertEffectModeFromLegacy(string2 = parameters.getColorEffect())) != -1) {
            cameraMetadataNative.set(CaptureResult.CONTROL_EFFECT_MODE, Integer.valueOf(n));
        } else {
            Log.w(TAG, "Unknown effect mode " + string2 + " returned by camera HAL, setting to off.");
            cameraMetadataNative.set(CaptureResult.CONTROL_EFFECT_MODE, Integer.valueOf(0));
        }
        int n4 = parameters.isVideoStabilizationSupported() && parameters.getVideoStabilization() ? 1 : 0;
        cameraMetadataNative.set(CaptureResult.CONTROL_VIDEO_STABILIZATION_MODE, Integer.valueOf(n4));
        if ("infinity".equals(parameters.getFocusMode())) {
            cameraMetadataNative.set(CaptureResult.LENS_FOCUS_DISTANCE, Float.valueOf(0.0f));
        }
        cameraMetadataNative.set(CaptureResult.LENS_FOCAL_LENGTH, Float.valueOf(parameters.getFocalLength()));
        cameraMetadataNative.set(CaptureResult.REQUEST_PIPELINE_DEPTH, cameraCharacteristics.get(CameraCharacteristics.REQUEST_PIPELINE_MAX_DEPTH));
        LegacyResultMapper.mapScaler(cameraMetadataNative, zoomData, parameters);
        cameraMetadataNative.set(CaptureResult.SENSOR_TEST_PATTERN_MODE, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureResult.JPEG_GPS_LOCATION, captureRequest.get(CaptureRequest.JPEG_GPS_LOCATION));
        cameraMetadataNative.set(CaptureResult.JPEG_ORIENTATION, captureRequest.get(CaptureRequest.JPEG_ORIENTATION));
        cameraMetadataNative.set(CaptureResult.JPEG_QUALITY, Byte.valueOf((byte)parameters.getJpegQuality()));
        cameraMetadataNative.set(CaptureResult.JPEG_THUMBNAIL_QUALITY, Byte.valueOf((byte)parameters.getJpegThumbnailQuality()));
        Camera.Size size2 = parameters.getJpegThumbnailSize();
        if (size2 != null) {
            cameraMetadataNative.set(CaptureResult.JPEG_THUMBNAIL_SIZE, ParameterUtils.convertSize(size2));
        } else {
            Log.w(TAG, "Null thumbnail size received from parameters.");
        }
        cameraMetadataNative.set(CaptureResult.NOISE_REDUCTION_MODE, Integer.valueOf(1));
        return cameraMetadataNative;
    }

    private static MeteringRectangle[] getMeteringRectangles(Rect rect, ParameterUtils.ZoomData zoomData, List<Camera.Area> list, String string2) {
        ArrayList<MeteringRectangle> arrayList = new ArrayList<MeteringRectangle>();
        if (list != null) {
            Iterator<Camera.Area> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(ParameterUtils.convertCameraAreaToActiveArrayRectangle(rect, zoomData, iterator.next()).toMetering());
            }
        }
        if (VERBOSE) {
            Log.v(TAG, "Metering rectangles for " + string2 + ": " + ListUtils.listToString(arrayList));
        }
        return arrayList.toArray(new MeteringRectangle[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapAe(CameraMetadataNative cameraMetadataNative, CameraCharacteristics cameraCharacteristics, CaptureRequest captureRequest, Rect rect, ParameterUtils.ZoomData zoomData, Camera.Parameters parameters) {
        Boolean bl;
        int n = LegacyMetadataMapper.convertAntiBandingModeOrDefault(parameters.getAntibanding());
        cameraMetadataNative.set(CaptureResult.CONTROL_AE_ANTIBANDING_MODE, Integer.valueOf(n));
        cameraMetadataNative.set(CaptureResult.CONTROL_AE_EXPOSURE_COMPENSATION, Integer.valueOf(parameters.getExposureCompensation()));
        boolean bl2 = parameters.isAutoExposureLockSupported() ? parameters.getAutoExposureLock() : false;
        cameraMetadataNative.set(CaptureResult.CONTROL_AE_LOCK, Boolean.valueOf(bl2));
        if (VERBOSE) {
            Log.v(TAG, "mapAe - android.control.aeLock = " + bl2 + ", supported = " + parameters.isAutoExposureLockSupported());
        }
        if ((bl = captureRequest.get(CaptureRequest.CONTROL_AE_LOCK)) != null && bl != bl2) {
            Log.w(TAG, "mapAe - android.control.aeLock was requested to " + bl + " but resulted in " + bl2);
        }
        LegacyResultMapper.mapAeAndFlashMode(cameraMetadataNative, cameraCharacteristics, parameters);
        if (parameters.getMaxNumMeteringAreas() > 0) {
            if (VERBOSE) {
                String string2 = parameters.get("metering-areas");
                Log.v(TAG, "mapAe - parameter dump; metering-areas: " + string2);
            }
            MeteringRectangle[] meteringRectangleArray = LegacyResultMapper.getMeteringRectangles(rect, zoomData, parameters.getMeteringAreas(), "AE");
            cameraMetadataNative.set(CaptureResult.CONTROL_AE_REGIONS, meteringRectangleArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapAeAndFlashMode(CameraMetadataNative cameraMetadataNative, CameraCharacteristics cameraCharacteristics, Camera.Parameters parameters) {
        Integer n = cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE) != false ? null : Integer.valueOf(0);
        int n2 = 1;
        String string2 = parameters.getFlashMode();
        int n3 = 0;
        if (string2 != null) {
            int n4 = -1;
            switch (string2.hashCode()) {
                case 109935: {
                    if (!string2.equals("off")) break;
                    n4 = 0;
                    break;
                }
                case 3005871: {
                    if (!string2.equals("auto")) break;
                    n4 = 1;
                    break;
                }
                case 3551: {
                    if (!string2.equals("on")) break;
                    n4 = 2;
                    break;
                }
                case 1081542389: {
                    if (!string2.equals("red-eye")) break;
                    n4 = 3;
                    break;
                }
                case 110547964: {
                    if (!string2.equals("torch")) break;
                    n4 = 4;
                    break;
                }
            }
            n3 = 0;
            switch (n4) {
                default: {
                    Log.w(TAG, "mapAeAndFlashMode - Ignoring unknown flash mode " + parameters.getFlashMode());
                    break;
                }
                case 1: {
                    n2 = 2;
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 1;
                    n2 = 3;
                    n = 3;
                    break;
                }
                case 3: {
                    n2 = 4;
                    n3 = 0;
                }
                case 0: {
                    break;
                }
                case 4: {
                    n3 = 2;
                    n = 3;
                }
            }
        }
        cameraMetadataNative.set(CaptureResult.FLASH_STATE, n);
        cameraMetadataNative.set(CaptureResult.FLASH_MODE, Integer.valueOf(n3));
        cameraMetadataNative.set(CaptureResult.CONTROL_AE_MODE, Integer.valueOf(n2));
    }

    private static void mapAf(CameraMetadataNative cameraMetadataNative, Rect rect, ParameterUtils.ZoomData zoomData, Camera.Parameters parameters) {
        cameraMetadataNative.set(CaptureResult.CONTROL_AF_MODE, Integer.valueOf(LegacyResultMapper.convertLegacyAfMode(parameters.getFocusMode())));
        if (parameters.getMaxNumFocusAreas() > 0) {
            if (VERBOSE) {
                String string2 = parameters.get("focus-areas");
                Log.v(TAG, "mapAe - parameter dump; focus-areas: " + string2);
            }
            MeteringRectangle[] meteringRectangleArray = LegacyResultMapper.getMeteringRectangles(rect, zoomData, parameters.getFocusAreas(), "AF");
            cameraMetadataNative.set(CaptureResult.CONTROL_AF_REGIONS, meteringRectangleArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapAwb(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        boolean bl = parameters.isAutoWhiteBalanceLockSupported() ? parameters.getAutoWhiteBalanceLock() : false;
        cameraMetadataNative.set(CaptureResult.CONTROL_AWB_LOCK, Boolean.valueOf(bl));
        int n = LegacyResultMapper.convertLegacyAwbMode(parameters.getWhiteBalance());
        cameraMetadataNative.set(CaptureResult.CONTROL_AWB_MODE, Integer.valueOf(n));
    }

    private static void mapScaler(CameraMetadataNative cameraMetadataNative, ParameterUtils.ZoomData zoomData, Camera.Parameters parameters) {
        cameraMetadataNative.set(CaptureResult.SCALER_CROP_REGION, zoomData.reportedCrop);
    }

    /*
     * Enabled aggressive block sorting
     */
    public CameraMetadataNative cachedConvertResultMetadata(LegacyRequest legacyRequest, long l) {
        boolean bl;
        CameraMetadataNative cameraMetadataNative;
        if (this.mCachedRequest != null && legacyRequest.parameters.same(this.mCachedRequest.parameters)) {
            cameraMetadataNative = new CameraMetadataNative(this.mCachedResult);
            bl = true;
        } else {
            cameraMetadataNative = LegacyResultMapper.convertResultMetadata(legacyRequest);
            this.mCachedRequest = legacyRequest;
            this.mCachedResult = new CameraMetadataNative(cameraMetadataNative);
            bl = false;
        }
        cameraMetadataNative.set(CaptureResult.SENSOR_TIMESTAMP, Long.valueOf(l));
        if (VERBOSE) {
            Log.v(TAG, "cachedConvertResultMetadata - cached? " + bl + " timestamp = " + l);
            Log.v(TAG, "----- beginning of result dump ------");
            cameraMetadataNative.dumpToLog();
            Log.v(TAG, "----- end of result dump ------");
        }
        return cameraMetadataNative;
    }
}

