/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal;

import android.util.Rational;
import com.android.internal.util.Preconditions;

public final class MarshalHelpers {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT32 = 4;
    public static final int SIZEOF_INT64 = 8;
    public static final int SIZEOF_RATIONAL = 8;

    private MarshalHelpers() {
        throw new AssertionError();
    }

    public static int checkNativeType(int n) {
        switch (n) {
            default: {
                throw new UnsupportedOperationException("Unknown nativeType " + n);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
        }
        return n;
    }

    public static int checkNativeTypeEquals(int n, int n2) {
        if (n != n2) {
            Object[] objectArray = new Object[]{n, n2};
            throw new UnsupportedOperationException(String.format("Expected native type %d, but got %d", objectArray));
        }
        return n2;
    }

    public static <T> Class<T> checkPrimitiveClass(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "klass must not be null");
        if (MarshalHelpers.isPrimitiveClass(clazz)) {
            return clazz;
        }
        throw new UnsupportedOperationException("Unsupported class '" + clazz + "'; expected a metadata primitive class");
    }

    public static int getPrimitiveTypeSize(int n) {
        int n2 = 4;
        switch (n) {
            default: {
                throw new UnsupportedOperationException("Unknown type, can't get size for " + n);
            }
            case 0: {
                n2 = 1;
            }
            case 1: 
            case 2: {
                return n2;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 8;
            }
            case 5: 
        }
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> boolean isPrimitiveClass(Class<T> clazz) {
        block9: {
            block8: {
                if (clazz == null) break block8;
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return true;
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return true;
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    return true;
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return true;
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return true;
                }
                if (clazz == Rational.class) break block9;
            }
            return false;
        }
        return true;
    }

    public static String toStringNativeType(int n) {
        switch (n) {
            default: {
                return "UNKNOWN(" + n + ")";
            }
            case 0: {
                return "TYPE_BYTE";
            }
            case 1: {
                return "TYPE_INT32";
            }
            case 2: {
                return "TYPE_FLOAT";
            }
            case 3: {
                return "TYPE_INT64";
            }
            case 4: {
                return "TYPE_DOUBLE";
            }
            case 5: 
        }
        return "TYPE_RATIONAL";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static <T> Class<T> wrapClassIfPrimitive(Class<T> clazz) {
        void var0_2;
        if (clazz == Byte.TYPE) {
            return var0_2;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz != Double.TYPE) {
            return var0_2;
        }
        return Double.class;
    }
}

